/*
 * Decompiled with CFR 0.152.
 */
package org.apache.archiva.transaction;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.archiva.transaction.TransactionEvent;
import org.apache.commons.io.FileUtils;
import org.codehaus.plexus.digest.Digester;
import org.codehaus.plexus.digest.DigesterException;

public abstract class AbstractTransactionEvent
implements TransactionEvent {
    private Map<File, File> backups = new HashMap<File, File>();
    private List<File> createdDirs = new ArrayList<File>();
    private List<File> createdFiles = new ArrayList<File>();
    private List<? extends Digester> digesters;

    protected AbstractTransactionEvent() {
        this(new ArrayList(0));
    }

    protected AbstractTransactionEvent(List<? extends Digester> digesters) {
        this.digesters = digesters;
    }

    protected List<? extends Digester> getDigesters() {
        return this.digesters;
    }

    protected void mkDirs(File dir) throws IOException {
        ArrayList<File> createDirs = new ArrayList<File>();
        File parent = dir;
        while (!parent.exists() || !parent.isDirectory()) {
            createDirs.add(parent);
            parent = parent.getParentFile();
        }
        while (!createDirs.isEmpty()) {
            File directory = (File)createDirs.remove(createDirs.size() - 1);
            if (directory.mkdir()) {
                this.createdDirs.add(directory);
                continue;
            }
            throw new IOException("Failed to create directory: " + directory.getAbsolutePath());
        }
    }

    protected void revertMkDirs() throws IOException {
        if (this.createdDirs != null) {
            File dir;
            Collections.reverse(this.createdDirs);
            while (!this.createdDirs.isEmpty() && (dir = this.createdDirs.remove(0)).isDirectory() && dir.list().length == 0) {
                FileUtils.deleteDirectory((File)dir);
            }
        }
    }

    protected void revertFilesCreated() throws IOException {
        Iterator<File> it = this.createdFiles.iterator();
        while (it.hasNext()) {
            File file = it.next();
            file.delete();
            it.remove();
        }
    }

    protected void createBackup(File file) throws IOException {
        if (file.exists() && file.isFile()) {
            File backup = File.createTempFile("temp-", ".backup");
            FileUtils.copyFile((File)file, (File)backup);
            backup.deleteOnExit();
            this.backups.put(file, backup);
        }
    }

    protected void restoreBackups() throws IOException {
        for (Map.Entry<File, File> entry : this.backups.entrySet()) {
            FileUtils.copyFile((File)entry.getValue(), (File)entry.getKey());
        }
    }

    protected void restoreBackup(File file) throws IOException {
        File backup = this.backups.get(file);
        if (backup != null) {
            FileUtils.copyFile((File)backup, (File)file);
        }
    }

    protected void createChecksums(File file, boolean force) throws IOException {
        for (Digester digester : this.getDigesters()) {
            File checksumFile = new File(file.getAbsolutePath() + "." + this.getDigesterFileExtension(digester));
            if (checksumFile.exists()) {
                if (!force) continue;
                this.createBackup(checksumFile);
            } else {
                this.createdFiles.add(checksumFile);
            }
            try {
                this.writeStringToFile(checksumFile, digester.calc(file));
            }
            catch (DigesterException e) {
                throw (IOException)e.getCause();
            }
        }
    }

    protected void writeStringToFile(File file, String content) throws IOException {
        FileUtils.writeStringToFile((File)file, (String)content);
    }

    protected String getDigesterFileExtension(Digester digester) {
        return digester.getAlgorithm().toLowerCase().replaceAll("-", "");
    }
}

