/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.archiva.transaction;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.maven.archiva.transaction.AbstractTransactionEvent;
import org.codehaus.plexus.digest.Digester;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CreateFileEvent
extends AbstractTransactionEvent {
    private final File destination;
    private final String content;

    public CreateFileEvent(String content, File destination, List<Digester> digesters) {
        super(digesters);
        this.content = content;
        this.destination = destination;
    }

    @Override
    public void commit() throws IOException {
        this.createBackup(this.destination);
        this.mkDirs(this.destination.getParentFile());
        if (!this.destination.exists() && !this.destination.createNewFile()) {
            throw new IOException("Unable to create new file");
        }
        this.writeStringToFile(this.destination, this.content);
        this.createChecksums(this.destination, true);
    }

    @Override
    public void rollback() throws IOException {
        this.destination.delete();
        this.revertFilesCreated();
        this.revertMkDirs();
        this.restoreBackups();
    }
}

