/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.archiva.transaction;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.maven.archiva.transaction.AbstractTransactionEvent;
import org.codehaus.plexus.digest.Digester;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CopyFileEvent
extends AbstractTransactionEvent {
    private final File source;
    private final File destination;

    public CopyFileEvent(File source, File destination, List<Digester> digesters) {
        super(digesters);
        this.source = source;
        this.destination = destination;
    }

    @Override
    public void commit() throws IOException {
        this.createBackup(this.destination);
        this.mkDirs(this.destination.getParentFile());
        FileUtils.copyFile((File)this.source, (File)this.destination);
        this.createChecksums(this.destination, true);
        this.copyChecksums();
        this.copyChecksum("asc");
    }

    private void copyChecksums() throws IOException {
        for (Digester digester : this.getDigesters()) {
            this.copyChecksum(this.getDigesterFileExtension(digester));
        }
    }

    private boolean copyChecksum(String extension) throws IOException {
        File checksumSource = new File(this.source.getAbsolutePath() + "." + extension);
        if (checksumSource.exists()) {
            File checksumDestination = new File(this.destination.getAbsolutePath() + "." + extension);
            FileUtils.copyFile((File)checksumSource, (File)checksumDestination);
            return true;
        }
        return false;
    }

    @Override
    public void rollback() throws IOException {
        this.destination.delete();
        this.revertFilesCreated();
        this.revertMkDirs();
        this.restoreBackups();
    }
}

