/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.archiva.transaction;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.archiva.transaction.CopyFileEvent;
import org.apache.maven.archiva.transaction.CreateFileEvent;
import org.apache.maven.archiva.transaction.TransactionEvent;
import org.apache.maven.archiva.transaction.TransactionException;

public class FileTransaction {
    private List events = new ArrayList();

    public void commit() throws TransactionException {
        ArrayList<TransactionEvent> toRollback = new ArrayList<TransactionEvent>(this.events.size());
        for (TransactionEvent event : this.events) {
            try {
                event.commit();
                toRollback.add(event);
            }
            catch (IOException e) {
                try {
                    this.rollback(toRollback);
                    throw new TransactionException("Unable to commit file transaction", e);
                }
                catch (IOException ioe) {
                    throw new TransactionException("Unable to commit file transaction, and rollback failed with error: '" + ioe.getMessage() + "'", e);
                }
            }
        }
    }

    private void rollback(List toRollback) throws IOException {
        for (TransactionEvent event : toRollback) {
            event.rollback();
        }
    }

    public void copyFile(File source, File destination, List digesters) {
        this.events.add(new CopyFileEvent(source, destination, digesters));
    }

    public void createFile(String content, File destination, List digesters) {
        this.events.add(new CreateFileEvent(content, destination, digesters));
    }
}

