/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.archiva.transaction;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.maven.archiva.transaction.AbstractTransactionEvent;

public class CreateFileEvent
extends AbstractTransactionEvent {
    private final File destination;
    private final String content;

    public CreateFileEvent(String content, File destination, List digesters) {
        super(digesters);
        this.content = content;
        this.destination = destination;
    }

    public void commit() throws IOException {
        this.createBackup(this.destination);
        this.mkDirs(this.destination.getParentFile());
        if (!this.destination.exists() && !this.destination.createNewFile()) {
            throw new IOException("Unable to create new file");
        }
        this.writeStringToFile(this.destination, this.content);
        this.createChecksums(this.destination, true);
    }

    public void rollback() throws IOException {
        this.destination.delete();
        this.revertFilesCreated();
        this.revertMkDirs();
        this.restoreBackups();
    }
}

