/*
 * Decompiled with CFR 0.152.
 */
package org.apache.any23.plugin.officescraper;

import java.io.IOException;
import java.io.InputStream;
import org.apache.any23.extractor.ExtractionContext;
import org.apache.any23.extractor.ExtractionException;
import org.apache.any23.extractor.ExtractionParameters;
import org.apache.any23.extractor.ExtractionResult;
import org.apache.any23.extractor.Extractor;
import org.apache.any23.extractor.ExtractorDescription;
import org.apache.any23.plugin.officescraper.ExcelExtractorFactory;
import org.apache.any23.rdf.RDFUtils;
import org.apache.any23.vocab.Excel;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.vocabulary.RDF;

public class ExcelExtractor
implements Extractor.ContentExtractor {
    private static final Excel excel = Excel.getInstance();
    private boolean stopAtFirstError = false;

    public boolean isStopAtFirstError() {
        return this.stopAtFirstError;
    }

    public void setStopAtFirstError(boolean f) {
        this.stopAtFirstError = f;
    }

    public ExtractorDescription getDescription() {
        return ExcelExtractorFactory.getDescriptionInstance();
    }

    public void run(ExtractionParameters extractionParameters, ExtractionContext context, InputStream in, ExtractionResult er) throws IOException, ExtractionException {
        try {
            URI documentURI = context.getDocumentURI();
            Workbook workbook = this.createWorkbook(documentURI, in);
            this.processWorkbook(documentURI, workbook, er);
        }
        catch (Exception e) {
            throw new ExtractionException("An error occurred while extracting MS Excel content.", (Throwable)e);
        }
    }

    private Workbook createWorkbook(URI document, InputStream is) throws IOException {
        String documentURI = document.toString();
        if (documentURI.endsWith(".xlsx")) {
            return new XSSFWorkbook(is);
        }
        if (documentURI.endsWith("xls")) {
            return new HSSFWorkbook(is);
        }
        throw new IllegalArgumentException("Unsupported extension for resource [" + documentURI + "]");
    }

    private void processWorkbook(URI documentURI, Workbook wb, ExtractionResult er) {
        for (int sheetIndex = 0; sheetIndex < wb.getNumberOfSheets(); ++sheetIndex) {
            Sheet sheet = wb.getSheetAt(sheetIndex);
            URI sheetURI = this.getSheetURI(documentURI, sheet);
            er.writeTriple((Resource)documentURI, ExcelExtractor.excel.containsSheet, (Value)sheetURI);
            er.writeTriple((Resource)sheetURI, RDF.TYPE, (Value)ExcelExtractor.excel.sheet);
            this.writeSheetMetadata(sheetURI, sheet, er);
            for (Row row : sheet) {
                URI rowURI = this.getRowURI(sheetURI, row);
                er.writeTriple((Resource)sheetURI, ExcelExtractor.excel.containsRow, (Value)rowURI);
                er.writeTriple((Resource)rowURI, RDF.TYPE, (Value)ExcelExtractor.excel.row);
                this.writeRowMetadata(rowURI, row, er);
                for (Cell cell : row) {
                    this.writeCell(rowURI, cell, er);
                }
            }
        }
    }

    private void writeSheetMetadata(URI sheetURI, Sheet sheet, ExtractionResult er) {
        String sheetName = sheet.getSheetName();
        int firstRowNum = sheet.getFirstRowNum();
        int lastRowNum = sheet.getLastRowNum();
        er.writeTriple((Resource)sheetURI, ExcelExtractor.excel.sheetName, (Value)RDFUtils.literal((String)sheetName));
        er.writeTriple((Resource)sheetURI, ExcelExtractor.excel.firstRow, (Value)RDFUtils.literal((int)firstRowNum));
        er.writeTriple((Resource)sheetURI, ExcelExtractor.excel.lastRow, (Value)RDFUtils.literal((int)lastRowNum));
    }

    private void writeRowMetadata(URI rowURI, Row row, ExtractionResult er) {
        short firstCellNum = row.getFirstCellNum();
        short lastCellNum = row.getLastCellNum();
        er.writeTriple((Resource)rowURI, ExcelExtractor.excel.firstCell, (Value)RDFUtils.literal((int)firstCellNum));
        er.writeTriple((Resource)rowURI, ExcelExtractor.excel.lastCell, (Value)RDFUtils.literal((int)lastCellNum));
    }

    private void writeCell(URI rowURI, Cell cell, ExtractionResult er) {
        URI cellType = this.cellTypeToType(cell.getCellType());
        if (cellType == null) {
            return;
        }
        URI cellURI = this.getCellURI(rowURI, cell);
        er.writeTriple((Resource)rowURI, ExcelExtractor.excel.containsCell, (Value)cellURI);
        er.writeTriple((Resource)cellURI, RDF.TYPE, (Value)ExcelExtractor.excel.cell);
        er.writeTriple((Resource)cellURI, ExcelExtractor.excel.cellValue, (Value)RDFUtils.literal((String)cell.getStringCellValue(), (URI)cellType));
    }

    private URI getSheetURI(URI documentURI, Sheet sheet) {
        return RDFUtils.uri((String)(documentURI.toString() + "/sheet/" + sheet.getSheetName()));
    }

    private URI getRowURI(URI sheetURI, Row row) {
        return RDFUtils.uri((String)(sheetURI.toString() + "/" + row.getRowNum()));
    }

    private URI getCellURI(URI rowURI, Cell cell) {
        return RDFUtils.uri((String)(rowURI + String.format("/%d/", cell.getColumnIndex())));
    }

    private URI cellTypeToType(int cellType) {
        String postfix;
        switch (cellType) {
            case 1: {
                postfix = "string";
                break;
            }
            case 4: {
                postfix = "boolean";
                break;
            }
            case 0: {
                postfix = "numeric";
                break;
            }
            default: {
                postfix = null;
            }
        }
        return postfix == null ? null : RDFUtils.uri((String)(excel.getNamespace().toString() + postfix));
    }
}

