/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.common.utils;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.airavata.common.exception.UtilsException;
import org.apache.airavata.common.utils.WSConstants;
import org.apache.airavata.common.utils.XMLUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xmlpull.infoset.XmlAttribute;
import org.xmlpull.infoset.XmlBuilderException;
import org.xmlpull.infoset.XmlNamespace;
import org.xmlpull.v1.builder.XmlElement;
import xsul.XmlConstants;
import xsul5.wsdl.WsdlBinding;
import xsul5.wsdl.WsdlDefinitions;
import xsul5.wsdl.WsdlPortType;
import xsul5.wsdl.WsdlPortTypeOperation;
import xsul5.wsdl.WsdlUtil;

public class WSDLUtil {
    private static final Logger logger = LoggerFactory.getLogger(WSDLUtil.class);

    public static WsdlDefinitions stringToWSDL(String wsdlString) throws UtilsException {
        try {
            org.xmlpull.infoset.XmlElement wsdlElement = XMLUtil.stringToXmlElement(wsdlString);
            WsdlDefinitions definitions = new WsdlDefinitions(wsdlElement);
            return definitions;
        }
        catch (RuntimeException e) {
            throw new UtilsException(e);
        }
    }

    public static WsdlDefinitions wsdlDefinitions3ToWsdlDefintions5(xsul.wsdl.WsdlDefinitions definitions3) {
        return new WsdlDefinitions(XMLUtil.xmlElement3ToXmlElement5((XmlElement)definitions3));
    }

    public static xsul.wsdl.WsdlDefinitions wsdlDefinitions5ToWsdlDefintions3(WsdlDefinitions definitions5) {
        return new xsul.wsdl.WsdlDefinitions(XMLUtil.xmlElement5ToXmlElement3(definitions5.xml()));
    }

    public static String getWSDLName(WsdlDefinitions definitions) {
        String wsdlName = definitions.xml().attributeValue("name");
        if (wsdlName == null) {
            wsdlName = "";
        }
        return wsdlName;
    }

    public static QName getWSDLQName(WsdlDefinitions definitions) {
        String targetNamespace = definitions.getTargetNamespace();
        String wsdlName = WSDLUtil.getWSDLName(definitions);
        return new QName(targetNamespace, wsdlName);
    }

    public static WsdlPortType getFirstPortType(WsdlDefinitions definitions) throws UtilsException {
        Iterator i$ = definitions.portTypes().iterator();
        if (i$.hasNext()) {
            WsdlPortType portType = (WsdlPortType)i$.next();
            return portType;
        }
        throw new UtilsException("No portType is defined in WSDL");
    }

    public static WsdlPortTypeOperation getFirstOperation(WsdlDefinitions definitions) throws UtilsException {
        Iterator i$ = WSDLUtil.getFirstPortType(definitions).operations().iterator();
        if (i$.hasNext()) {
            WsdlPortTypeOperation operation = (WsdlPortTypeOperation)i$.next();
            return operation;
        }
        throw new UtilsException("No portType is defined in WSDL");
    }

    public static QName getFirstPortTypeQName(WsdlDefinitions definitions) throws UtilsException {
        String targetNamespace = definitions.getTargetNamespace();
        Iterator i$ = definitions.portTypes().iterator();
        if (i$.hasNext()) {
            WsdlPortType portType = (WsdlPortType)i$.next();
            String portTypeName = portType.getName();
            QName portTypeQName = new QName(targetNamespace, portTypeName);
            return portTypeQName;
        }
        throw new UtilsException("No portType is defined.");
    }

    public static String getFirstOperationName(WsdlDefinitions definitions, QName portTypeQName) throws UtilsException {
        WsdlPortType portType = definitions.getPortType(portTypeQName.getLocalPart());
        for (WsdlPortTypeOperation operation : portType.operations()) {
            String operationName = operation.getOperationName();
            if ("Shutdown".equals(operationName) || "Kill".equals(operationName) || "Ping".equals(operationName)) continue;
            return operationName;
        }
        throw new UtilsException("No operation is defined");
    }

    public static WsdlDefinitions deepClone(WsdlDefinitions definitions) throws UtilsException {
        return new WsdlDefinitions(XMLUtil.deepClone(definitions.xml()));
    }

    public static org.xmlpull.infoset.XmlElement getSchema(WsdlDefinitions definitions, QName paramType) throws UtilsException {
        org.xmlpull.infoset.XmlElement types = definitions.getTypes();
        Iterable schemas = types.elements(WSConstants.XSD_NS, "schema");
        for (org.xmlpull.infoset.XmlElement schema : schemas) {
            if (!WSDLUtil.isTypeDefinedInSchema(paramType, schema)) continue;
            return schema;
        }
        for (org.xmlpull.infoset.XmlElement schema : schemas) {
            Iterable imports = schema.elements(WSConstants.XSD_NS, "import");
            for (org.xmlpull.infoset.XmlElement importEle : imports) {
                String schemaLocation = importEle.attributeValue("schemaLocation");
                if (null == schemaLocation || "".equals(schemaLocation)) continue;
                try {
                    URL url = new URL(schemaLocation);
                    URLConnection connection = url.openConnection();
                    connection.connect();
                    org.xmlpull.infoset.XmlElement importedSchema = xsul5.XmlConstants.BUILDER.parseFragmentFromInputStream(connection.getInputStream());
                    if (!WSDLUtil.isTypeDefinedInSchema(paramType, importedSchema)) continue;
                    return schema;
                }
                catch (MalformedURLException e) {
                    throw new UtilsException(e);
                }
                catch (XmlBuilderException e) {
                    throw new UtilsException(e);
                }
                catch (IOException e) {
                    throw new UtilsException(e);
                }
            }
        }
        return null;
    }

    private static boolean isTypeDefinedInSchema(QName paramType, org.xmlpull.infoset.XmlElement schema) {
        String schemaTargetNamespace = schema.attributeValue("targetNamespace");
        if (schemaTargetNamespace.equals(paramType.getNamespaceURI())) {
            for (org.xmlpull.infoset.XmlElement complexType : schema.elements(WSConstants.XSD_NS, "complexType")) {
                String complexTypeName = complexType.attributeValue("name");
                if (!complexTypeName.equals(paramType.getLocalPart())) continue;
                return true;
            }
            for (org.xmlpull.infoset.XmlElement simpleType : schema.elements(WSConstants.XSD_NS, "simpleType")) {
                String simpleTypeName = simpleType.attributeValue("name");
                if (!simpleTypeName.equals(paramType.getLocalPart())) continue;
                return true;
            }
        }
        return false;
    }

    public static org.xmlpull.infoset.XmlElement getTypeDefinition(WsdlDefinitions definitions, QName paramType) throws UtilsException {
        org.xmlpull.infoset.XmlElement types = definitions.getTypes();
        org.xmlpull.infoset.XmlElement returnType = null;
        types.element(null, "schema");
        Iterable schemas = types.elements(null, "schema");
        for (org.xmlpull.infoset.XmlElement schema : schemas) {
            returnType = WSDLUtil.findTypeInSchema(paramType, schema);
            if (returnType == null) continue;
            return returnType;
        }
        return WSDLUtil.findTypeDefinitionInImports(definitions, paramType);
    }

    public static org.xmlpull.infoset.XmlElement getImportContainingTypeDefinition(WsdlDefinitions definitions, QName paramType) throws UtilsException {
        org.xmlpull.infoset.XmlElement types = definitions.getTypes();
        org.xmlpull.infoset.XmlElement returnType = null;
        Iterable schemas = types.elements(WSConstants.XSD_NS, "schema");
        for (org.xmlpull.infoset.XmlElement schema : schemas) {
            Iterable imports = schema.elements(WSConstants.XSD_NS, "import");
            for (org.xmlpull.infoset.XmlElement importEle : imports) {
                String schemaLocation = importEle.attributeValue("schemaLocation");
                if (null == schemaLocation || "".equals(schemaLocation)) continue;
                try {
                    URL url = new URL(schemaLocation);
                    URLConnection connection = url.openConnection();
                    connection.connect();
                    org.xmlpull.infoset.XmlElement importedSchema = xsul5.XmlConstants.BUILDER.parseFragmentFromInputStream(connection.getInputStream());
                    returnType = WSDLUtil.findTypeInSchema(paramType, importedSchema);
                    if (returnType == null) continue;
                    return importEle;
                }
                catch (MalformedURLException e) {
                    throw new UtilsException(e);
                }
                catch (XmlBuilderException e) {
                    throw new UtilsException(e);
                }
                catch (IOException e) {
                    throw new UtilsException(e);
                }
            }
        }
        return null;
    }

    public static org.xmlpull.infoset.XmlElement findTypeDefinitionInImports(WsdlDefinitions definitions, QName paramType) throws UtilsException {
        org.xmlpull.infoset.XmlElement types = definitions.getTypes();
        org.xmlpull.infoset.XmlElement returnType = null;
        Iterable schemas = types.elements(null, "schema");
        for (org.xmlpull.infoset.XmlElement schema : schemas) {
            Iterable imports = schema.elements(WSConstants.XSD_NS, "import");
            for (org.xmlpull.infoset.XmlElement importEle : imports) {
                String schemaLocation = importEle.attributeValue("schemaLocation");
                if (null == schemaLocation || "".equals(schemaLocation)) continue;
                try {
                    URL url = new URL(schemaLocation);
                    URLConnection connection = url.openConnection();
                    connection.connect();
                    org.xmlpull.infoset.XmlElement importedSchema = xsul5.XmlConstants.BUILDER.parseFragmentFromInputStream(connection.getInputStream());
                    returnType = WSDLUtil.findTypeInSchema(paramType, importedSchema);
                    if (returnType == null) continue;
                    return returnType;
                }
                catch (MalformedURLException e) {
                    throw new UtilsException(e);
                }
                catch (XmlBuilderException e) {
                    throw new UtilsException(e);
                }
                catch (IOException e) {
                    throw new UtilsException(e);
                }
            }
        }
        return null;
    }

    private static org.xmlpull.infoset.XmlElement findTypeInSchema(QName paramType, org.xmlpull.infoset.XmlElement schema) {
        String schemaTargetNamespace = schema.attributeValue("targetNamespace");
        if (null != schemaTargetNamespace && schemaTargetNamespace.equals(paramType.getNamespaceURI())) {
            for (org.xmlpull.infoset.XmlElement complexType : schema.elements(WSConstants.XSD_NS, "complexType")) {
                String complexTypeName = complexType.attributeValue("name");
                if (!complexTypeName.equals(paramType.getLocalPart())) continue;
                return complexType;
            }
            for (org.xmlpull.infoset.XmlElement simpleType : schema.elements(WSConstants.XSD_NS, "simpleType")) {
                String simpleTypeName = simpleType.attributeValue("name");
                if (!simpleTypeName.equals(paramType.getLocalPart())) continue;
                return simpleType;
            }
        }
        return null;
    }

    public static boolean isAWSDL(WsdlDefinitions wsdl) {
        return !wsdl.services().iterator().hasNext();
    }

    public static boolean isAsynchronousSupported(WsdlDefinitions definitions) {
        for (WsdlBinding binding : definitions.bindings()) {
            org.xmlpull.infoset.XmlElement element = binding.xml().element("UsingAddressing");
            if (element == null) continue;
            return true;
        }
        return false;
    }

    public static WsdlDefinitions convertToCWSDL(WsdlDefinitions definitions, URI url) {
        for (WsdlPortType portType : definitions.portTypes()) {
            WsdlUtil.createCWSDL((WsdlDefinitions)definitions, (WsdlPortType)portType, (URI)url);
        }
        return definitions;
    }

    public static String appendWSDLQuary(String uri) {
        URI wsdlURI = WSDLUtil.appendWSDLQuary(URI.create(uri));
        return wsdlURI.toString();
    }

    public static List<XmlNamespace> getNamespaces(org.xmlpull.infoset.XmlElement element) {
        LinkedList<XmlNamespace> namespaces = new LinkedList<XmlNamespace>();
        namespaces.add(element.getNamespace());
        Iterable attributes = element.attributes();
        for (XmlAttribute xmlAttribute : attributes) {
            String prefix;
            int index;
            if (xmlAttribute.getNamespace() != null && !namespaces.contains(xmlAttribute.getNamespace())) {
                namespaces.add(xmlAttribute.getNamespace());
            }
            if (-1 == (index = xmlAttribute.getValue().indexOf(58)) || element.lookupNamespaceByPrefix(prefix = xmlAttribute.getValue().substring(0, index)) == null) continue;
            namespaces.add(element.lookupNamespaceByPrefix(prefix));
        }
        Iterable children = element.children();
        for (Object object : children) {
            if (!(object instanceof org.xmlpull.infoset.XmlElement)) continue;
            List<XmlNamespace> newNSs = WSDLUtil.getNamespaces((org.xmlpull.infoset.XmlElement)object);
            for (XmlNamespace xmlNamespace : newNSs) {
                if (namespaces.contains(xmlNamespace)) continue;
                namespaces.add(xmlNamespace);
            }
        }
        return namespaces;
    }

    public static URI appendWSDLQuary(URI uri) {
        if (uri.toString().endsWith("?wsdl")) {
            logger.warn("URL already has ?wsdl at the end: " + uri.toString());
            return uri;
        }
        String path = uri.getPath();
        if (path == null || path.length() == 0) {
            uri = uri.resolve("/");
        }
        uri = URI.create(uri.toString() + "?wsdl");
        return uri;
    }

    public static XmlElement xmlElement5ToXmlElementv1(org.xmlpull.infoset.XmlElement valueElement) {
        return XmlConstants.BUILDER.parseFragmentFromReader((Reader)new StringReader(xsul5.XmlConstants.BUILDER.serializeToStringPretty((Object)valueElement)));
    }

    public static <T> T getfirst(Iterable<T> vals) {
        Iterator<T> i$ = vals.iterator();
        if (i$.hasNext()) {
            T class1 = i$.next();
            return class1;
        }
        throw new RuntimeException("Iterator empty");
    }

    public static void print(org.xmlpull.infoset.XmlElement serviceSchema) {
        System.out.println(xsul5.XmlConstants.BUILDER.serializeToStringPretty((Object)serviceSchema));
    }

    public static String findWorkflowName(URI workflowID) {
        String[] splits = workflowID.toString().split("/");
        return splits[splits.length - 1];
    }

    public static void replaceAttributeValue(org.xmlpull.infoset.XmlElement element, String name, String oldValue, String newValue) {
        XmlAttribute attribute = element.attribute(name);
        if (null != attribute && oldValue.equals(attribute.getValue())) {
            element.removeAttribute(attribute);
            element.setAttributeValue(name, newValue);
        }
        Iterable iterator = element.children();
        for (Object object : iterator) {
            if (!(object instanceof org.xmlpull.infoset.XmlElement)) continue;
            WSDLUtil.replaceAttributeValue((org.xmlpull.infoset.XmlElement)object, name, oldValue, newValue);
        }
    }

    public static boolean attributeExist(org.xmlpull.infoset.XmlElement element, String name, String value) {
        XmlAttribute attribute = element.attribute(name);
        if (null != attribute && value.equals(attribute.getValue())) {
            return true;
        }
        Iterable iterator = element.children();
        boolean ret = false;
        for (Object object : iterator) {
            if (!(object instanceof org.xmlpull.infoset.XmlElement)) continue;
            ret = ret || WSDLUtil.attributeExist((org.xmlpull.infoset.XmlElement)object, name, value);
        }
        return ret;
    }
}

