/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.cloud.openstack;

import java.util.Properties;
import org.openstack4j.api.OSClient;
import org.openstack4j.api.client.IOSClientBuilder;
import org.openstack4j.model.common.Identifier;
import org.openstack4j.openstack.OSFactory;

public class OS4JClientProvider {
    private static OSClient os = null;
    private static Integer apiVersion = null;

    public static OSClient getOSClient(Properties properties) {
        block4: {
            try {
                String endPoint = properties.getProperty("OS_AUTH_URL");
                String userName = properties.getProperty("OS_USERNAME");
                String password = properties.getProperty("OS_PASSWORD");
                String domain = properties.getProperty("OS_USER_DOMAIN_NAME");
                String apiVersion = properties.getProperty("OS_IDENTITY_API_VERSION");
                if (apiVersion.equals("3")) {
                    String project = properties.getProperty("OS_PROJECT_DOMAIN_NAME");
                    OS4JClientProvider.getOSClientV3(endPoint, userName, password, domain, project);
                    break block4;
                }
                if (apiVersion.equals("2")) {
                    OS4JClientProvider.getOSClientV2(endPoint, userName, password, domain);
                    break block4;
                }
                throw new Exception("Non- supported Openstack API version " + properties.getProperty("OS_IDENTITY_API_VERSION"));
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return os;
    }

    public static void getOSClientV3(String endPoint, String userName, String password, String domain, String project) {
        if (os == null || apiVersion == null || apiVersion != 3 || !os.getEndpoint().equals(endPoint)) {
            Identifier domainIdentifier = Identifier.byName((String)domain);
            Identifier projectIdentifier = Identifier.byName((String)project);
            os = (OSClient)((IOSClientBuilder.V3)OSFactory.builderV3().scopeToProject(projectIdentifier, domainIdentifier).endpoint(endPoint)).credentials(userName, password, domainIdentifier).authenticate();
            apiVersion = 3;
        }
    }

    public static void getOSClientV2(String endPoint, String userName, String password, String domain) {
        if (os == null || apiVersion == null || apiVersion != 2 || !os.getEndpoint().equals(endPoint)) {
            Identifier domainIdentifier = Identifier.byName((String)domain);
            os = (OSClient)((IOSClientBuilder.V3)OSFactory.builderV3().endpoint(endPoint)).credentials(userName, password, domainIdentifier).authenticate();
            apiVersion = 2;
        }
    }
}

