/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.cloud.intf.impl;

import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import org.apache.airavata.cloud.intf.CloudInterface;
import org.apache.airavata.cloud.openstack.OS4JClientProvider;
import org.apache.airavata.cloud.util.IPType;
import org.apache.airavata.cloud.util.OpenstackIntfUtil;
import org.openstack4j.api.Builders;
import org.openstack4j.api.OSClient;
import org.openstack4j.model.compute.ActionResponse;
import org.openstack4j.model.compute.Address;
import org.openstack4j.model.compute.FloatingIP;
import org.openstack4j.model.compute.Keypair;
import org.openstack4j.model.compute.Server;
import org.openstack4j.model.compute.ServerCreate;
import org.openstack4j.model.network.AttachInterfaceType;
import org.openstack4j.model.network.IPVersionType;
import org.openstack4j.model.network.Network;
import org.openstack4j.model.network.Router;
import org.openstack4j.model.network.RouterInterface;
import org.openstack4j.model.network.Subnet;
import org.openstack4j.openstack.compute.domain.NovaAddresses;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenstackIntfImpl
implements CloudInterface {
    private String propertiesFile;
    private Properties properties;
    private Logger logger = LoggerFactory.getLogger(OpenstackIntfImpl.class);
    OSClient os = null;

    public OpenstackIntfImpl(String propFile) {
        try {
            this.propertiesFile = propFile;
            InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream(this.propertiesFile);
            if (inputStream == null) {
                throw new FileNotFoundException("property file: " + this.propertiesFile + " not found!");
            }
            this.properties = new Properties();
            this.properties.load(inputStream);
            this.os = OS4JClientProvider.getOSClient(this.properties);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public Server createServer(String serverName, String imageId, String flavorId, String keyPairName) {
        try {
            Server newServer = null;
            String networkId = null;
            String networkName = "subnet-" + this.properties.getProperty("OS_NETWORK_NAME");
            for (Subnet net : this.os.networking().subnet().list()) {
                if (!net.getName().equals(networkName)) continue;
                networkId = net.getNetworkId();
                this.logger.info("Using network " + networkName + " with ID: " + networkId);
                break;
            }
            if (networkId != null) {
                LinkedList<String> srvNet = new LinkedList<String>();
                srvNet.add(networkId);
                ServerCreate sc = (ServerCreate)Builders.server().name(serverName).flavor(flavorId).image(imageId).networks(srvNet).keypairName(keyPairName).build();
                newServer = this.os.compute().servers().boot(sc);
                this.logger.info("New server created with ID: " + newServer.getId());
            } else {
                this.logger.error("Network with name " + networkName + " not found.");
            }
            return newServer;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.logger.error("Failed to create server.");
            return null;
        }
    }

    public Server getServer(String serverId) {
        try {
            Server server = this.os.compute().servers().get(serverId);
            this.logger.info("Server retrieved successfully for ID: " + serverId);
            return server;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.logger.error("Failed to retrieve server for ID: " + serverId);
            return null;
        }
    }

    @Override
    public void deleteServer(String serverId) {
        try {
            Server server = this.getServer(serverId);
            String floatingIpAddr = null;
            for (Address novaAddress : (List)server.getAddresses().getAddresses().get(this.properties.getProperty("OS_NETWORK_NAME"))) {
                if (!(novaAddress = (NovaAddresses.NovaAddress)novaAddress).getType().equals(IPType.FLOATING.toString())) continue;
                floatingIpAddr = novaAddress.getAddr();
                break;
            }
            if (server != null) {
                this.os.compute().servers().delete(serverId);
                if (floatingIpAddr != null) {
                    for (FloatingIP floatIp : this.os.compute().floatingIps().list()) {
                        if (!floatIp.getFloatingIpAddress().equals(floatingIpAddr)) continue;
                        this.os.compute().floatingIps().deallocateIP(floatIp.getId());
                    }
                }
                this.logger.info("Server deleted successfully for ID: " + serverId);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.logger.error("Failed to delete server with ID: " + serverId);
        }
    }

    public Keypair createKeyPair(String keyPairName, String publicKey) {
        try {
            Keypair keyp = this.os.compute().keypairs().create(keyPairName, publicKey);
            this.logger.info("Keypair created successfully: " + keyp.getName());
            return keyp;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.logger.error("Failed to create keypair: " + keyPairName);
            return null;
        }
    }

    public Keypair getKeyPair(String keyPairName) {
        try {
            Keypair keyp = this.os.compute().keypairs().get(keyPairName);
            if (keyp != null) {
                this.logger.info("Keypair retrieved successfully: " + keyp.getName());
            }
            return keyp;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.logger.error("Failed to retrieve keypair: " + keyPairName);
            return null;
        }
    }

    @Override
    public void deleteKeyPair(String keyPairName) {
        try {
            this.os.compute().keypairs().delete(keyPairName);
            this.logger.info("Keypair deleted successfully: " + keyPairName);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.logger.error("Failed to delete keypair: " + keyPairName);
        }
    }

    @Override
    public void addFloatingIP(String serverId) {
        try {
            Server server = this.getServer(serverId);
            FloatingIP floatIp = null;
            if (server != null) {
                String ipAddr;
                List floatIPList = this.os.compute().floatingIps().list();
                if (floatIPList.size() > 0) {
                    for (FloatingIP ip : floatIPList) {
                        this.logger.info("Checking if floating ip : " + ip.getFloatingIpAddress() + " is free to use.");
                        Boolean isFloatingIpUsed = OpenstackIntfUtil.isFloatingIPUsed(ip);
                        if (isFloatingIpUsed == null || isFloatingIpUsed.booleanValue()) continue;
                        floatIp = ip;
                        this.logger.info("Floating ip " + ip.getFloatingIpAddress() + " found to be free.");
                        break;
                    }
                }
                if (floatIp == null) {
                    floatIp = this.os.compute().floatingIps().allocateIP(this.properties.getProperty("OS_FLOATING_IP_POOL"));
                    this.logger.info("Created new floating ip " + floatIp.getFloatingIpAddress());
                }
                if (floatIp != null && (ipAddr = floatIp.getFloatingIpAddress()) != null) {
                    ActionResponse response = this.os.compute().floatingIps().addFloatingIP(server, ipAddr);
                    this.logger.info(response.isSuccess() + ":" + response.getCode() + ":" + response.getFault() + ":" + response.toString());
                    if (response.isSuccess()) {
                        this.logger.info("Floating IP " + ipAddr + " assigned successfully to server with ID: " + serverId);
                    } else {
                        this.logger.error("Failed to associate Floating IP.");
                    }
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.logger.error("Failed to associate floating IP to server with ID: " + serverId);
        }
    }

    @Override
    public Object createNetwork(String networkName) {
        Network network = null;
        try {
            network = this.os.networking().network().create((Network)Builders.network().name(networkName).adminStateUp(true).build());
            this.logger.info("Created a new network : " + network);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.logger.error("Failed to create network: " + networkName + ". Exception: " + ex.getMessage(), (Throwable)ex);
        }
        return network;
    }

    @Override
    public Object createRouter(String routerName, String externalGatewayName) {
        String publicNetId = null;
        Router router = null;
        try {
            for (Network net : this.os.networking().network().list()) {
                if (!net.getName().equals(externalGatewayName)) continue;
                publicNetId = net.getId();
            }
            if (publicNetId != null) {
                router = this.os.networking().router().create((Router)Builders.router().name(routerName).adminStateUp(true).externalGateway(publicNetId).build());
                this.logger.info("Created a new router " + router + " for external gateway : [" + externalGatewayName + "]");
            } else {
                this.logger.error("Failed to create router because external gateway [ " + externalGatewayName + "] is not found!");
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.logger.error("Failed to create network: " + routerName + ". Exception: " + ex.getMessage(), (Throwable)ex);
        }
        return router;
    }

    @Override
    public Object createSubnet(String subnetName, String networkName, String subnetCIDR, int ipVersion) {
        String networkId = null;
        Subnet subnet = null;
        try {
            for (Network network : this.os.networking().network().list()) {
                if (!network.getName().equals(networkName)) continue;
                networkId = network.getId();
            }
            if (networkId != null) {
                subnet = this.os.networking().subnet().create((Subnet)Builders.subnet().enableDHCP(true).name(subnetName).networkId(networkId).ipVersion(IPVersionType.valueOf((int)ipVersion)).cidr(subnetCIDR).build());
                this.logger.info("Created a subnet : " + subnetName + " for network [ " + networkName + "]");
            } else {
                this.logger.error("Failed to create subnet because network [ " + networkName + "] is not found!");
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.logger.error("Failed to create subnet: " + subnetName + ". Exception: " + ex.getMessage(), (Throwable)ex);
        }
        return subnet;
    }

    @Override
    public Object createRouterSubnetInterface(String routerName, String subnetName) {
        String subnetId = null;
        String routerId = null;
        RouterInterface iface = null;
        try {
            for (Subnet subnet : this.os.networking().subnet().list()) {
                if (!subnet.getName().equals(subnetName)) continue;
                subnetId = subnet.getId();
            }
            for (Router router : this.os.networking().router().list()) {
                if (!router.getName().equals(routerName)) continue;
                routerId = router.getId();
            }
            if (routerId != null && subnetId != null) {
                iface = this.os.networking().router().attachInterface(routerId, AttachInterfaceType.SUBNET, subnetId);
                this.logger.info("Attached external interface to router : " + iface);
            } else {
                this.logger.error("Either router or network is not found. Kindly re-check and try again.");
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.logger.error("Failed to create subnet-router interface. Exception: " + ex.getMessage(), (Throwable)ex);
        }
        return iface;
    }

    @Override
    public void deleteRouterSubnetInterface(String routerName, String subnetName) {
        String routerId = null;
        String subnetId = null;
        try {
            for (Subnet subnet : this.os.networking().subnet().list()) {
                if (!subnet.getName().equals(subnetName)) continue;
                subnetId = subnet.getId();
            }
            for (Router router : this.os.networking().router().list()) {
                if (!router.getName().equals(routerName)) continue;
                routerId = router.getId();
            }
            if (routerId != null && subnetId != null) {
                this.os.networking().router().detachInterface(routerId, subnetId, null);
            } else {
                this.logger.error("Failed to delete router subnet interface. Either router/subnet not found.");
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.logger.error("Failed to delete subnet: " + subnetName + ". Exception: " + ex.getMessage(), (Throwable)ex);
        }
    }

    @Override
    public void deleteSubnet(String subnetName) {
        try {
            for (Subnet subnet : this.os.networking().subnet().list()) {
                if (!subnet.getName().equals(subnetName)) continue;
                this.os.networking().subnet().delete(subnet.getId());
                this.logger.info("Deleted Subnet [" + subnet.getName() + "] Successfully.");
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.logger.error("Failed to delete subnet: " + subnetName + ". Exception: " + ex.getMessage(), (Throwable)ex);
        }
    }

    @Override
    public void deleteRouter(String routerName) {
        try {
            for (Router router : this.os.networking().router().list()) {
                if (!router.getName().equals(routerName)) continue;
                this.os.networking().router().delete(router.getId());
                this.logger.info("Deleted Router [" + router.getName() + "] Successfully.");
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.logger.error("Failed to delete router: " + routerName + ". Exception: " + ex.getMessage(), (Throwable)ex);
        }
    }

    @Override
    public void deleteNetwork(String networkName) {
        try {
            for (Network network : this.os.networking().network().list()) {
                if (!network.getName().equals(networkName)) continue;
                this.os.networking().network().delete(network.getId());
                this.logger.info("Deleted Network [" + network.getName() + "] Successfully.");
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.logger.error("Failed to delete network: " + networkName + ". Exception: " + ex.getMessage(), (Throwable)ex);
        }
    }
}

