<?php
namespace Airavata\API;
/**
 * Autogenerated by Thrift Compiler (0.9.1)
 *
 * DO NOT EDIT UNLESS YOU ARE SURE THAT YOU KNOW WHAT YOU ARE DOING
 *  @generated
 */
use Thrift\Base\TBase;
use Thrift\Type\TType;
use Thrift\Type\TMessageType;
use Thrift\Exception\TException;
use Thrift\Exception\TProtocolException;
use Thrift\Protocol\TProtocol;
use Thrift\Protocol\TBinaryProtocolAccelerated;
use Thrift\Exception\TApplicationException;


interface AiravataIf {
  public function getAPIVersion();
  public function createProject(\Airavata\Model\Workspace\Project $project);
  public function updateProject($projectId, \Airavata\Model\Workspace\Project $updatedProject);
  public function getProject($projectId);
  public function getAllUserProjects($userName);
  public function searchProjectsByProjectName($userName, $projectName);
  public function searchProjectsByProjectDesc($userName, $description);
  public function searchExperimentsByName($userName, $expName);
  public function searchExperimentsByDesc($userName, $description);
  public function searchExperimentsByApplication($userName, $applicationId);
  public function searchExperimentsByStatus($userName, $experimentState);
  public function searchExperimentsByCreationTime($userName, $fromTime, $toTime);
  public function getAllExperimentsInProject($projectId);
  public function getAllUserExperiments($userName);
  public function createExperiment(\Airavata\Model\Workspace\Experiment\Experiment $experiment);
  public function getExperiment($airavataExperimentId);
  public function updateExperiment($airavataExperimentId, \Airavata\Model\Workspace\Experiment\Experiment $experiment);
  public function updateExperimentConfiguration($airavataExperimentId, \Airavata\Model\Workspace\Experiment\UserConfigurationData $userConfiguration);
  public function updateResourceScheduleing($airavataExperimentId, \Airavata\Model\Workspace\Experiment\ComputationalResourceScheduling $resourceScheduling);
  public function validateExperiment($airavataExperimentId);
  public function launchExperiment($airavataExperimentId, $airavataCredStoreToken);
  public function getExperimentStatus($airavataExperimentId);
  public function getExperimentOutputs($airavataExperimentId);
  public function getJobStatuses($airavataExperimentId);
  public function getJobDetails($airavataExperimentId);
  public function getDataTransferDetails($airavataExperimentId);
  public function cloneExperiment($existingExperimentID, $newExperimentName);
  public function terminateExperiment($airavataExperimentId);
  public function registerApplicationModule(\Airavata\Model\AppCatalog\AppDeployment\ApplicationModule $applicationModule);
  public function getApplicationModule($appModuleId);
  public function updateApplicationModule($appModuleId, \Airavata\Model\AppCatalog\AppDeployment\ApplicationModule $applicationModule);
  public function getAllAppModules();
  public function deleteApplicationModule($appModuleId);
  public function registerApplicationDeployment(\Airavata\Model\AppCatalog\AppDeployment\ApplicationDeploymentDescription $applicationDeployment);
  public function getApplicationDeployment($appDeploymentId);
  public function updateApplicationDeployment($appDeploymentId, \Airavata\Model\AppCatalog\AppDeployment\ApplicationDeploymentDescription $applicationDeployment);
  public function deleteApplicationDeployment($appDeploymentId);
  public function getAllApplicationDeployments();
  public function getAppModuleDeployedResources($appModuleId);
  public function registerApplicationInterface(\Airavata\Model\AppCatalog\AppInterface\ApplicationInterfaceDescription $applicationInterface);
  public function getApplicationInterface($appInterfaceId);
  public function updateApplicationInterface($appInterfaceId, \Airavata\Model\AppCatalog\AppInterface\ApplicationInterfaceDescription $applicationInterface);
  public function deleteApplicationInterface($appInterfaceId);
  public function getAllApplicationInterfaceNames();
  public function getAllApplicationInterfaces();
  public function getApplicationInputs($appInterfaceId);
  public function getApplicationOutputs($appInterfaceId);
  public function getAvailableAppInterfaceComputeResources($appInterfaceId);
  public function registerComputeResource(\Airavata\Model\AppCatalog\ComputeResource\ComputeResourceDescription $computeResourceDescription);
  public function getComputeResource($computeResourceId);
  public function getAllComputeResourceNames();
  public function updateComputeResource($computeResourceId, \Airavata\Model\AppCatalog\ComputeResource\ComputeResourceDescription $computeResourceDescription);
  public function deleteComputeResource($computeResourceId);
  public function addLocalSubmissionDetails($computeResourceId, $priorityOrder, \Airavata\Model\AppCatalog\ComputeResource\LOCALSubmission $localSubmission);
  public function updateLocalSubmissionDetails($jobSubmissionInterfaceId, \Airavata\Model\AppCatalog\ComputeResource\LOCALSubmission $localSubmission);
  public function getLocalJobSubmission($jobSubmissionId);
  public function addSSHJobSubmissionDetails($computeResourceId, $priorityOrder, \Airavata\Model\AppCatalog\ComputeResource\SSHJobSubmission $sshJobSubmission);
  public function getSSHJobSubmission($jobSubmissionId);
  public function addUNICOREJobSubmissionDetails($computeResourceId, $priorityOrder, \Airavata\Model\AppCatalog\ComputeResource\UnicoreJobSubmission $unicoreJobSubmission);
  public function getUnicoreJobSubmission($jobSubmissionId);
  public function addCloudJobSubmissionDetails($computeResourceId, $priorityOrder, \Airavata\Model\AppCatalog\ComputeResource\CloudJobSubmission $cloudSubmission);
  public function getCloudJobSubmission($jobSubmissionId);
  public function updateSSHJobSubmissionDetails($jobSubmissionInterfaceId, \Airavata\Model\AppCatalog\ComputeResource\SSHJobSubmission $sshJobSubmission);
  public function updateCloudJobSubmissionDetails($jobSubmissionInterfaceId, \Airavata\Model\AppCatalog\ComputeResource\CloudJobSubmission $sshJobSubmission);
  public function addLocalDataMovementDetails($computeResourceId, $priorityOrder, \Airavata\Model\AppCatalog\ComputeResource\LOCALDataMovement $localDataMovement);
  public function updateLocalDataMovementDetails($dataMovementInterfaceId, \Airavata\Model\AppCatalog\ComputeResource\LOCALDataMovement $localDataMovement);
  public function getLocalDataMovement($dataMovementId);
  public function addSCPDataMovementDetails($computeResourceId, $priorityOrder, \Airavata\Model\AppCatalog\ComputeResource\SCPDataMovement $scpDataMovement);
  public function updateSCPDataMovementDetails($dataMovementInterfaceId, \Airavata\Model\AppCatalog\ComputeResource\SCPDataMovement $scpDataMovement);
  public function getSCPDataMovement($dataMovementId);
  public function addGridFTPDataMovementDetails($computeResourceId, $priorityOrder, \Airavata\Model\AppCatalog\ComputeResource\GridFTPDataMovement $gridFTPDataMovement);
  public function updateGridFTPDataMovementDetails($dataMovementInterfaceId, \Airavata\Model\AppCatalog\ComputeResource\GridFTPDataMovement $gridFTPDataMovement);
  public function getGridFTPDataMovement($dataMovementId);
  public function changeJobSubmissionPriority($jobSubmissionInterfaceId, $newPriorityOrder);
  public function changeDataMovementPriority($dataMovementInterfaceId, $newPriorityOrder);
  public function changeJobSubmissionPriorities($jobSubmissionPriorityMap);
  public function changeDataMovementPriorities($dataMovementPriorityMap);
  public function deleteJobSubmissionInterface($computeResourceId, $jobSubmissionInterfaceId);
  public function deleteDataMovementInterface($computeResourceId, $dataMovementInterfaceId);
  public function registerResourceJobManager(\Airavata\Model\AppCatalog\ComputeResource\ResourceJobManager $resourceJobManager);
  public function updateResourceJobManager($resourceJobManagerId, \Airavata\Model\AppCatalog\ComputeResource\ResourceJobManager $updatedResourceJobManager);
  public function getResourceJobManager($resourceJobManagerId);
  public function deleteResourceJobManager($resourceJobManagerId);
  public function deleteBatchQueue($computeResourceId, $queueName);
  public function registerGatewayResourceProfile(\Airavata\Model\AppCatalog\GatewayProfile\GatewayResourceProfile $gatewayResourceProfile);
  public function getGatewayResourceProfile($gatewayID);
  public function updateGatewayResourceProfile($gatewayID, \Airavata\Model\AppCatalog\GatewayProfile\GatewayResourceProfile $gatewayResourceProfile);
  public function deleteGatewayResourceProfile($gatewayID);
  public function addGatewayComputeResourcePreference($gatewayID, $computeResourceId, \Airavata\Model\AppCatalog\GatewayProfile\ComputeResourcePreference $computeResourcePreference);
  public function getGatewayComputeResourcePreference($gatewayID, $computeResourceId);
  public function getAllGatewayComputeResourcePreferences($gatewayID);
  public function updateGatewayComputeResourcePreference($gatewayID, $computeResourceId, \Airavata\Model\AppCatalog\GatewayProfile\ComputeResourcePreference $computeResourcePreference);
  public function deleteGatewayComputeResourcePreference($gatewayID, $computeResourceId);
  public function getAllWorkflows();
  public function getWorkflow($workflowTemplateId);
  public function deleteWorkflow($workflowTemplateId);
  public function registerWorkflow(\Airavata\Model\Workflow $workflow);
  public function updateWorkflow($workflowTemplateId, \Airavata\Model\Workflow $workflow);
  public function getWorkflowTemplateId($workflowName);
  public function isWorkflowExistWithName($workflowName);
}

class AiravataClient implements \Airavata\API\AiravataIf {
  protected $input_ = null;
  protected $output_ = null;

  protected $seqid_ = 0;

  public function __construct($input, $output=null) {
    $this->input_ = $input;
    $this->output_ = $output ? $output : $input;
  }

  public function getAPIVersion()
  {
    $this->send_getAPIVersion();
    return $this->recv_getAPIVersion();
  }

  public function send_getAPIVersion()
  {
    $args = new \Airavata\API\Airavata_getAPIVersion_args();
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'getAPIVersion', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('getAPIVersion', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_getAPIVersion()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Airavata\API\Airavata_getAPIVersion_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Airavata\API\Airavata_getAPIVersion_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->ire !== null) {
      throw $result->ire;
    }
    if ($result->ace !== null) {
      throw $result->ace;
    }
    if ($result->ase !== null) {
      throw $result->ase;
    }
    throw new \Exception("getAPIVersion failed: unknown result");
  }

  public function createProject(\Airavata\Model\Workspace\Project $project)
  {
    $this->send_createProject($project);
    return $this->recv_createProject();
  }

  public function send_createProject(\Airavata\Model\Workspace\Project $project)
  {
    $args = new \Airavata\API\Airavata_createProject_args();
    $args->project = $project;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'createProject', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('createProject', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_createProject()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Airavata\API\Airavata_createProject_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Airavata\API\Airavata_createProject_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->ire !== null) {
      throw $result->ire;
    }
    if ($result->ace !== null) {
      throw $result->ace;
    }
    if ($result->ase !== null) {
      throw $result->ase;
    }
    throw new \Exception("createProject failed: unknown result");
  }

  public function updateProject($projectId, \Airavata\Model\Workspace\Project $updatedProject)
  {
    $this->send_updateProject($projectId, $updatedProject);
    $this->recv_updateProject();
  }

  public function send_updateProject($projectId, \Airavata\Model\Workspace\Project $updatedProject)
  {
    $args = new \Airavata\API\Airavata_updateProject_args();
    $args->projectId = $projectId;
    $args->updatedProject = $updatedProject;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'updateProject', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('updateProject', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_updateProject()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Airavata\API\Airavata_updateProject_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Airavata\API\Airavata_updateProject_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->ire !== null) {
      throw $result->ire;
    }
    if ($result->ace !== null) {
      throw $result->ace;
    }
    if ($result->ase !== null) {
      throw $result->ase;
    }
    if ($result->pnfe !== null) {
      throw $result->pnfe;
    }
    return;
  }

  public function getProject($projectId)
  {
    $this->send_getProject($projectId);
    return $this->recv_getProject();
  }

  public function send_getProject($projectId)
  {
    $args = new \Airavata\API\Airavata_getProject_args();
    $args->projectId = $projectId;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'getProject', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('getProject', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_getProject()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Airavata\API\Airavata_getProject_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Airavata\API\Airavata_getProject_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->ire !== null) {
      throw $result->ire;
    }
    if ($result->ace !== null) {
      throw $result->ace;
    }
    if ($result->ase !== null) {
      throw $result->ase;
    }
    if ($result->pnfe !== null) {
      throw $result->pnfe;
    }
    throw new \Exception("getProject failed: unknown result");
  }

  public function getAllUserProjects($userName)
  {
    $this->send_getAllUserProjects($userName);
    return $this->recv_getAllUserProjects();
  }

  public function send_getAllUserProjects($userName)
  {
    $args = new \Airavata\API\Airavata_getAllUserProjects_args();
    $args->userName = $userName;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'getAllUserProjects', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('getAllUserProjects', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_getAllUserProjects()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Airavata\API\Airavata_getAllUserProjects_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Airavata\API\Airavata_getAllUserProjects_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->ire !== null) {
      throw $result->ire;
    }
    if ($result->ace !== null) {
      throw $result->ace;
    }
    if ($result->ase !== null) {
      throw $result->ase;
    }
    throw new \Exception("getAllUserProjects failed: unknown result");
  }

  public function searchProjectsByProjectName($userName, $projectName)
  {
    $this->send_searchProjectsByProjectName($userName, $projectName);
    return $this->recv_searchProjectsByProjectName();
  }

  public function send_searchProjectsByProjectName($userName, $projectName)
  {
    $args = new \Airavata\API\Airavata_searchProjectsByProjectName_args();
    $args->userName = $userName;
    $args->projectName = $projectName;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'searchProjectsByProjectName', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('searchProjectsByProjectName', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_searchProjectsByProjectName()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Airavata\API\Airavata_searchProjectsByProjectName_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Airavata\API\Airavata_searchProjectsByProjectName_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->ire !== null) {
      throw $result->ire;
    }
    if ($result->ace !== null) {
      throw $result->ace;
    }
    if ($result->ase !== null) {
      throw $result->ase;
    }
    throw new \Exception("searchProjectsByProjectName failed: unknown result");
  }

  public function searchProjectsByProjectDesc($userName, $description)
  {
    $this->send_searchProjectsByProjectDesc($userName, $description);
    return $this->recv_searchProjectsByProjectDesc();
  }

  public function send_searchProjectsByProjectDesc($userName, $description)
  {
    $args = new \Airavata\API\Airavata_searchProjectsByProjectDesc_args();
    $args->userName = $userName;
    $args->description = $description;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'searchProjectsByProjectDesc', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('searchProjectsByProjectDesc', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_searchProjectsByProjectDesc()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Airavata\API\Airavata_searchProjectsByProjectDesc_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Airavata\API\Airavata_searchProjectsByProjectDesc_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->ire !== null) {
      throw $result->ire;
    }
    if ($result->ace !== null) {
      throw $result->ace;
    }
    if ($result->ase !== null) {
      throw $result->ase;
    }
    throw new \Exception("searchProjectsByProjectDesc failed: unknown result");
  }

  public function searchExperimentsByName($userName, $expName)
  {
    $this->send_searchExperimentsByName($userName, $expName);
    return $this->recv_searchExperimentsByName();
  }

  public function send_searchExperimentsByName($userName, $expName)
  {
    $args = new \Airavata\API\Airavata_searchExperimentsByName_args();
    $args->userName = $userName;
    $args->expName = $expName;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'searchExperimentsByName', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('searchExperimentsByName', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_searchExperimentsByName()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Airavata\API\Airavata_searchExperimentsByName_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Airavata\API\Airavata_searchExperimentsByName_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->ire !== null) {
      throw $result->ire;
    }
    if ($result->ace !== null) {
      throw $result->ace;
    }
    if ($result->ase !== null) {
      throw $result->ase;
    }
    throw new \Exception("searchExperimentsByName failed: unknown result");
  }

  public function searchExperimentsByDesc($userName, $description)
  {
    $this->send_searchExperimentsByDesc($userName, $description);
    return $this->recv_searchExperimentsByDesc();
  }

  public function send_searchExperimentsByDesc($userName, $description)
  {
    $args = new \Airavata\API\Airavata_searchExperimentsByDesc_args();
    $args->userName = $userName;
    $args->description = $description;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'searchExperimentsByDesc', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('searchExperimentsByDesc', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_searchExperimentsByDesc()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Airavata\API\Airavata_searchExperimentsByDesc_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Airavata\API\Airavata_searchExperimentsByDesc_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->ire !== null) {
      throw $result->ire;
    }
    if ($result->ace !== null) {
      throw $result->ace;
    }
    if ($result->ase !== null) {
      throw $result->ase;
    }
    throw new \Exception("searchExperimentsByDesc failed: unknown result");
  }

  public function searchExperimentsByApplication($userName, $applicationId)
  {
    $this->send_searchExperimentsByApplication($userName, $applicationId);
    return $this->recv_searchExperimentsByApplication();
  }

  public function send_searchExperimentsByApplication($userName, $applicationId)
  {
    $args = new \Airavata\API\Airavata_searchExperimentsByApplication_args();
    $args->userName = $userName;
    $args->applicationId = $applicationId;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'searchExperimentsByApplication', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('searchExperimentsByApplication', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_searchExperimentsByApplication()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Airavata\API\Airavata_searchExperimentsByApplication_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Airavata\API\Airavata_searchExperimentsByApplication_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->ire !== null) {
      throw $result->ire;
    }
    if ($result->ace !== null) {
      throw $result->ace;
    }
    if ($result->ase !== null) {
      throw $result->ase;
    }
    throw new \Exception("searchExperimentsByApplication failed: unknown result");
  }

  public function searchExperimentsByStatus($userName, $experimentState)
  {
    $this->send_searchExperimentsByStatus($userName, $experimentState);
    return $this->recv_searchExperimentsByStatus();
  }

  public function send_searchExperimentsByStatus($userName, $experimentState)
  {
    $args = new \Airavata\API\Airavata_searchExperimentsByStatus_args();
    $args->userName = $userName;
    $args->experimentState = $experimentState;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'searchExperimentsByStatus', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('searchExperimentsByStatus', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_searchExperimentsByStatus()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Airavata\API\Airavata_searchExperimentsByStatus_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Airavata\API\Airavata_searchExperimentsByStatus_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->ire !== null) {
      throw $result->ire;
    }
    if ($result->ace !== null) {
      throw $result->ace;
    }
    if ($result->ase !== null) {
      throw $result->ase;
    }
    throw new \Exception("searchExperimentsByStatus failed: unknown result");
  }

  public function searchExperimentsByCreationTime($userName, $fromTime, $toTime)
  {
    $this->send_searchExperimentsByCreationTime($userName, $fromTime, $toTime);
    return $this->recv_searchExperimentsByCreationTime();
  }

  public function send_searchExperimentsByCreationTime($userName, $fromTime, $toTime)
  {
    $args = new \Airavata\API\Airavata_searchExperimentsByCreationTime_args();
    $args->userName = $userName;
    $args->fromTime = $fromTime;
    $args->toTime = $toTime;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'searchExperimentsByCreationTime', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('searchExperimentsByCreationTime', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_searchExperimentsByCreationTime()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Airavata\API\Airavata_searchExperimentsByCreationTime_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Airavata\API\Airavata_searchExperimentsByCreationTime_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->ire !== null) {
      throw $result->ire;
    }
    if ($result->ace !== null) {
      throw $result->ace;
    }
    if ($result->ase !== null) {
      throw $result->ase;
    }
    throw new \Exception("searchExperimentsByCreationTime failed: unknown result");
  }

  public function getAllExperimentsInProject($projectId)
  {
    $this->send_getAllExperimentsInProject($projectId);
    return $this->recv_getAllExperimentsInProject();
  }

  public function send_getAllExperimentsInProject($projectId)
  {
    $args = new \Airavata\API\Airavata_getAllExperimentsInProject_args();
    $args->projectId = $projectId;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'getAllExperimentsInProject', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('getAllExperimentsInProject', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_getAllExperimentsInProject()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Airavata\API\Airavata_getAllExperimentsInProject_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Airavata\API\Airavata_getAllExperimentsInProject_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->ire !== null) {
      throw $result->ire;
    }
    if ($result->ace !== null) {
      throw $result->ace;
    }
    if ($result->ase !== null) {
      throw $result->ase;
    }
    if ($result->pnfe !== null) {
      throw $result->pnfe;
    }
    throw new \Exception("getAllExperimentsInProject failed: unknown result");
  }

  public function getAllUserExperiments($userName)
  {
    $this->send_getAllUserExperiments($userName);
    return $this->recv_getAllUserExperiments();
  }

  public function send_getAllUserExperiments($userName)
  {
    $args = new \Airavata\API\Airavata_getAllUserExperiments_args();
    $args->userName = $userName;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'getAllUserExperiments', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('getAllUserExperiments', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_getAllUserExperiments()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Airavata\API\Airavata_getAllUserExperiments_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Airavata\API\Airavata_getAllUserExperiments_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->ire !== null) {
      throw $result->ire;
    }
    if ($result->ace !== null) {
      throw $result->ace;
    }
    if ($result->ase !== null) {
      throw $result->ase;
    }
    throw new \Exception("getAllUserExperiments failed: unknown result");
  }

  public function createExperiment(\Airavata\Model\Workspace\Experiment\Experiment $experiment)
  {
    $this->send_createExperiment($experiment);
    return $this->recv_createExperiment();
  }

  public function send_createExperiment(\Airavata\Model\Workspace\Experiment\Experiment $experiment)
  {
    $args = new \Airavata\API\Airavata_createExperiment_args();
    $args->experiment = $experiment;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'createExperiment', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('createExperiment', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_createExperiment()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Airavata\API\Airavata_createExperiment_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Airavata\API\Airavata_createExperiment_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->ire !== null) {
      throw $result->ire;
    }
    if ($result->ace !== null) {
      throw $result->ace;
    }
    if ($result->ase !== null) {
      throw $result->ase;
    }
    throw new \Exception("createExperiment failed: unknown result");
  }

  public function getExperiment($airavataExperimentId)
  {
    $this->send_getExperiment($airavataExperimentId);
    return $this->recv_getExperiment();
  }

  public function send_getExperiment($airavataExperimentId)
  {
    $args = new \Airavata\API\Airavata_getExperiment_args();
    $args->airavataExperimentId = $airavataExperimentId;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'getExperiment', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('getExperiment', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_getExperiment()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Airavata\API\Airavata_getExperiment_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Airavata\API\Airavata_getExperiment_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->ire !== null) {
      throw $result->ire;
    }
    if ($result->enf !== null) {
      throw $result->enf;
    }
    if ($result->ace !== null) {
      throw $result->ace;
    }
    if ($result->ase !== null) {
      throw $result->ase;
    }
    throw new \Exception("getExperiment failed: unknown result");
  }

  public function updateExperiment($airavataExperimentId, \Airavata\Model\Workspace\Experiment\Experiment $experiment)
  {
    $this->send_updateExperiment($airavataExperimentId, $experiment);
    $this->recv_updateExperiment();
  }

  public function send_updateExperiment($airavataExperimentId, \Airavata\Model\Workspace\Experiment\Experiment $experiment)
  {
    $args = new \Airavata\API\Airavata_updateExperiment_args();
    $args->airavataExperimentId = $airavataExperimentId;
    $args->experiment = $experiment;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'updateExperiment', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('updateExperiment', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_updateExperiment()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Airavata\API\Airavata_updateExperiment_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Airavata\API\Airavata_updateExperiment_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->ire !== null) {
      throw $result->ire;
    }
    if ($result->enf !== null) {
      throw $result->enf;
    }
    if ($result->ace !== null) {
      throw $result->ace;
    }
    if ($result->ase !== null) {
      throw $result->ase;
    }
    return;
  }

  public function updateExperimentConfiguration($airavataExperimentId, \Airavata\Model\Workspace\Experiment\UserConfigurationData $userConfiguration)
  {
    $this->send_updateExperimentConfiguration($airavataExperimentId, $userConfiguration);
    $this->recv_updateExperimentConfiguration();
  }

  public function send_updateExperimentConfiguration($airavataExperimentId, \Airavata\Model\Workspace\Experiment\UserConfigurationData $userConfiguration)
  {
    $args = new \Airavata\API\Airavata_updateExperimentConfiguration_args();
    $args->airavataExperimentId = $airavataExperimentId;
    $args->userConfiguration = $userConfiguration;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'updateExperimentConfiguration', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('updateExperimentConfiguration', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_updateExperimentConfiguration()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Airavata\API\Airavata_updateExperimentConfiguration_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Airavata\API\Airavata_updateExperimentConfiguration_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    return;
  }

  public function updateResourceScheduleing($airavataExperimentId, \Airavata\Model\Workspace\Experiment\ComputationalResourceScheduling $resourceScheduling)
  {
    $this->send_updateResourceScheduleing($airavataExperimentId, $resourceScheduling);
    $this->recv_updateResourceScheduleing();
  }

  public function send_updateResourceScheduleing($airavataExperimentId, \Airavata\Model\Workspace\Experiment\ComputationalResourceScheduling $resourceScheduling)
  {
    $args = new \Airavata\API\Airavata_updateResourceScheduleing_args();
    $args->airavataExperimentId = $airavataExperimentId;
    $args->resourceScheduling = $resourceScheduling;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'updateResourceScheduleing', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('updateResourceScheduleing', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_updateResourceScheduleing()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Airavata\API\Airavata_updateResourceScheduleing_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Airavata\API\Airavata_updateResourceScheduleing_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    return;
  }

  public function validateExperiment($airavataExperimentId)
  {
    $this->send_validateExperiment($airavataExperimentId);
    return $this->recv_validateExperiment();
  }

  public function send_validateExperiment($airavataExperimentId)
  {
    $args = new \Airavata\API\Airavata_validateExperiment_args();
    $args->airavataExperimentId = $airavataExperimentId;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'validateExperiment', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('validateExperiment', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_validateExperiment()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Airavata\API\Airavata_validateExperiment_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Airavata\API\Airavata_validateExperiment_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->ire !== null) {
      throw $result->ire;
    }
    if ($result->enf !== null) {
      throw $result->enf;
    }
    if ($result->ace !== null) {
      throw $result->ace;
    }
    if ($result->ase !== null) {
      throw $result->ase;
    }
    throw new \Exception("validateExperiment failed: unknown result");
  }

  public function launchExperiment($airavataExperimentId, $airavataCredStoreToken)
  {
    $this->send_launchExperiment($airavataExperimentId, $airavataCredStoreToken);
    $this->recv_launchExperiment();
  }

  public function send_launchExperiment($airavataExperimentId, $airavataCredStoreToken)
  {
    $args = new \Airavata\API\Airavata_launchExperiment_args();
    $args->airavataExperimentId = $airavataExperimentId;
    $args->airavataCredStoreToken = $airavataCredStoreToken;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'launchExperiment', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('launchExperiment', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_launchExperiment()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Airavata\API\Airavata_launchExperiment_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Airavata\API\Airavata_launchExperiment_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->ire !== null) {
      throw $result->ire;
    }
    if ($result->enf !== null) {
      throw $result->enf;
    }
    if ($result->ace !== null) {
      throw $result->ace;
    }
    if ($result->ase !== null) {
      throw $result->ase;
    }
    if ($result->lve !== null) {
      throw $result->lve;
    }
    return;
  }

  public function getExperimentStatus($airavataExperimentId)
  {
    $this->send_getExperimentStatus($airavataExperimentId);
    return $this->recv_getExperimentStatus();
  }

  public function send_getExperimentStatus($airavataExperimentId)
  {
    $args = new \Airavata\API\Airavata_getExperimentStatus_args();
    $args->airavataExperimentId = $airavataExperimentId;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'getExperimentStatus', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('getExperimentStatus', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_getExperimentStatus()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Airavata\API\Airavata_getExperimentStatus_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Airavata\API\Airavata_getExperimentStatus_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->ire !== null) {
      throw $result->ire;
    }
    if ($result->enf !== null) {
      throw $result->enf;
    }
    if ($result->ace !== null) {
      throw $result->ace;
    }
    if ($result->ase !== null) {
      throw $result->ase;
    }
    throw new \Exception("getExperimentStatus failed: unknown result");
  }

  public function getExperimentOutputs($airavataExperimentId)
  {
    $this->send_getExperimentOutputs($airavataExperimentId);
    return $this->recv_getExperimentOutputs();
  }

  public function send_getExperimentOutputs($airavataExperimentId)
  {
    $args = new \Airavata\API\Airavata_getExperimentOutputs_args();
    $args->airavataExperimentId = $airavataExperimentId;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'getExperimentOutputs', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('getExperimentOutputs', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_getExperimentOutputs()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Airavata\API\Airavata_getExperimentOutputs_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Airavata\API\Airavata_getExperimentOutputs_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->ire !== null) {
      throw $result->ire;
    }
    if ($result->enf !== null) {
      throw $result->enf;
    }
    if ($result->ace !== null) {
      throw $result->ace;
    }
    if ($result->ase !== null) {
      throw $result->ase;
    }
    throw new \Exception("getExperimentOutputs failed: unknown result");
  }

  public function getJobStatuses($airavataExperimentId)
  {
    $this->send_getJobStatuses($airavataExperimentId);
    return $this->recv_getJobStatuses();
  }

  public function send_getJobStatuses($airavataExperimentId)
  {
    $args = new \Airavata\API\Airavata_getJobStatuses_args();
    $args->airavataExperimentId = $airavataExperimentId;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'getJobStatuses', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('getJobStatuses', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_getJobStatuses()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Airavata\API\Airavata_getJobStatuses_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Airavata\API\Airavata_getJobStatuses_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->ire !== null) {
      throw $result->ire;
    }
    if ($result->enf !== null) {
      throw $result->enf;
    }
    if ($result->ace !== null) {
      throw $result->ace;
    }
    if ($result->ase !== null) {
      throw $result->ase;
    }
    throw new \Exception("getJobStatuses failed: unknown result");
  }

  public function getJobDetails($airavataExperimentId)
  {
    $this->send_getJobDetails($airavataExperimentId);
    return $this->recv_getJobDetails();
  }

  public function send_getJobDetails($airavataExperimentId)
  {
    $args = new \Airavata\API\Airavata_getJobDetails_args();
    $args->airavataExperimentId = $airavataExperimentId;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'getJobDetails', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('getJobDetails', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_getJobDetails()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Airavata\API\Airavata_getJobDetails_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Airavata\API\Airavata_getJobDetails_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->ire !== null) {
      throw $result->ire;
    }
    if ($result->enf !== null) {
      throw $result->enf;
    }
    if ($result->ace !== null) {
      throw $result->ace;
    }
    if ($result->ase !== null) {
      throw $result->ase;
    }
    throw new \Exception("getJobDetails failed: unknown result");
  }

  public function getDataTransferDetails($airavataExperimentId)
  {
    $this->send_getDataTransferDetails($airavataExperimentId);
    return $this->recv_getDataTransferDetails();
  }

  public function send_getDataTransferDetails($airavataExperimentId)
  {
    $args = new \Airavata\API\Airavata_getDataTransferDetails_args();
    $args->airavataExperimentId = $airavataExperimentId;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'getDataTransferDetails', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('getDataTransferDetails', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_getDataTransferDetails()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Airavata\API\Airavata_getDataTransferDetails_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Airavata\API\Airavata_getDataTransferDetails_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->ire !== null) {
      throw $result->ire;
    }
    if ($result->enf !== null) {
      throw $result->enf;
    }
    if ($result->ace !== null) {
      throw $result->ace;
    }
    if ($result->ase !== null) {
      throw $result->ase;
    }
    throw new \Exception("getDataTransferDetails failed: unknown result");
  }

  public function cloneExperiment($existingExperimentID, $newExperimentName)
  {
    $this->send_cloneExperiment($existingExperimentID, $newExperimentName);
    return $this->recv_cloneExperiment();
  }

  public function send_cloneExperiment($existingExperimentID, $newExperimentName)
  {
    $args = new \Airavata\API\Airavata_cloneExperiment_args();
    $args->existingExperimentID = $existingExperimentID;
    $args->newExperimentName = $newExperimentName;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'cloneExperiment', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('cloneExperiment', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_cloneExperiment()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Airavata\API\Airavata_cloneExperiment_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Airavata\API\Airavata_cloneExperiment_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->ire !== null) {
      throw $result->ire;
    }
    if ($result->enf !== null) {
      throw $result->enf;
    }
    if ($result->ace !== null) {
      throw $result->ace;
    }
    if ($result->ase !== null) {
      throw $result->ase;
    }
    throw new \Exception("cloneExperiment failed: unknown result");
  }

  public function terminateExperiment($airavataExperimentId)
  {
    $this->send_terminateExperiment($airavataExperimentId);
    $this->recv_terminateExperiment();
  }

  public function send_terminateExperiment($airavataExperimentId)
  {
    $args = new \Airavata\API\Airavata_terminateExperiment_args();
    $args->airavataExperimentId = $airavataExperimentId;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'terminateExperiment', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('terminateExperiment', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_terminateExperiment()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Airavata\API\Airavata_terminateExperiment_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Airavata\API\Airavata_terminateExperiment_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->ire !== null) {
      throw $result->ire;
    }
    if ($result->enf !== null) {
      throw $result->enf;
    }
    if ($result->ace !== null) {
      throw $result->ace;
    }
    if ($result->ase !== null) {
      throw $result->ase;
    }
    return;
  }

  public function registerApplicationModule(\Airavata\Model\AppCatalog\AppDeployment\ApplicationModule $applicationModule)
  {
    $this->send_registerApplicationModule($applicationModule);
    return $this->recv_registerApplicationModule();
  }

  public function send_registerApplicationModule(\Airavata\Model\AppCatalog\AppDeployment\ApplicationModule $applicationModule)
  {
    $args = new \Airavata\API\Airavata_registerApplicationModule_args();
    $args->applicationModule = $applicationModule;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'registerApplicationModule', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('registerApplicationModule', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_registerApplicationModule()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Airavata\API\Airavata_registerApplicationModule_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Airavata\API\Airavata_registerApplicationModule_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->ire !== null) {
      throw $result->ire;
    }
    if ($result->ace !== null) {
      throw $result->ace;
    }
    if ($result->ase !== null) {
      throw $result->ase;
    }
    throw new \Exception("registerApplicationModule failed: unknown result");
  }

  public function getApplicationModule($appModuleId)
  {
    $this->send_getApplicationModule($appModuleId);
    return $this->recv_getApplicationModule();
  }

  public function send_getApplicationModule($appModuleId)
  {
    $args = new \Airavata\API\Airavata_getApplicationModule_args();
    $args->appModuleId = $appModuleId;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'getApplicationModule', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('getApplicationModule', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_getApplicationModule()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Airavata\API\Airavata_getApplicationModule_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Airavata\API\Airavata_getApplicationModule_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->ire !== null) {
      throw $result->ire;
    }
    if ($result->ace !== null) {
      throw $result->ace;
    }
    if ($result->ase !== null) {
      throw $result->ase;
    }
    throw new \Exception("getApplicationModule failed: unknown result");
  }

  public function updateApplicationModule($appModuleId, \Airavata\Model\AppCatalog\AppDeployment\ApplicationModule $applicationModule)
  {
    $this->send_updateApplicationModule($appModuleId, $applicationModule);
    return $this->recv_updateApplicationModule();
  }

  public function send_updateApplicationModule($appModuleId, \Airavata\Model\AppCatalog\AppDeployment\ApplicationModule $applicationModule)
  {
    $args = new \Airavata\API\Airavata_updateApplicationModule_args();
    $args->appModuleId = $appModuleId;
    $args->applicationModule = $applicationModule;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'updateApplicationModule', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('updateApplicationModule', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_updateApplicationModule()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Airavata\API\Airavata_updateApplicationModule_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Airavata\API\Airavata_updateApplicationModule_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->ire !== null) {
      throw $result->ire;
    }
    if ($result->ace !== null) {
      throw $result->ace;
    }
    if ($result->ase !== null) {
      throw $result->ase;
    }
    throw new \Exception("updateApplicationModule failed: unknown result");
  }

  public function getAllAppModules()
  {
    $this->send_getAllAppModules();
    return $this->recv_getAllAppModules();
  }

  public function send_getAllAppModules()
  {
    $args = new \Airavata\API\Airavata_getAllAppModules_args();
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'getAllAppModules', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('getAllAppModules', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_getAllAppModules()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Airavata\API\Airavata_getAllAppModules_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Airavata\API\Airavata_getAllAppModules_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->ire !== null) {
      throw $result->ire;
    }
    if ($result->ace !== null) {
      throw $result->ace;
    }
    if ($result->ase !== null) {
      throw $result->ase;
    }
    throw new \Exception("getAllAppModules failed: unknown result");
  }

  public function deleteApplicationModule($appModuleId)
  {
    $this->send_deleteApplicationModule($appModuleId);
    return $this->recv_deleteApplicationModule();
  }

  public function send_deleteApplicationModule($appModuleId)
  {
    $args = new \Airavata\API\Airavata_deleteApplicationModule_args();
    $args->appModuleId = $appModuleId;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'deleteApplicationModule', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('deleteApplicationModule', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_deleteApplicationModule()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Airavata\API\Airavata_deleteApplicationModule_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Airavata\API\Airavata_deleteApplicationModule_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->ire !== null) {
      throw $result->ire;
    }
    if ($result->ace !== null) {
      throw $result->ace;
    }
    if ($result->ase !== null) {
      throw $result->ase;
    }
    throw new \Exception("deleteApplicationModule failed: unknown result");
  }

  public function registerApplicationDeployment(\Airavata\Model\AppCatalog\AppDeployment\ApplicationDeploymentDescription $applicationDeployment)
  {
    $this->send_registerApplicationDeployment($applicationDeployment);
    return $this->recv_registerApplicationDeployment();
  }

  public function send_registerApplicationDeployment(\Airavata\Model\AppCatalog\AppDeployment\ApplicationDeploymentDescription $applicationDeployment)
  {
    $args = new \Airavata\API\Airavata_registerApplicationDeployment_args();
    $args->applicationDeployment = $applicationDeployment;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'registerApplicationDeployment', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('registerApplicationDeployment', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_registerApplicationDeployment()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Airavata\API\Airavata_registerApplicationDeployment_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Airavata\API\Airavata_registerApplicationDeployment_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->ire !== null) {
      throw $result->ire;
    }
    if ($result->ace !== null) {
      throw $result->ace;
    }
    if ($result->ase !== null) {
      throw $result->ase;
    }
    throw new \Exception("registerApplicationDeployment failed: unknown result");
  }

  public function getApplicationDeployment($appDeploymentId)
  {
    $this->send_getApplicationDeployment($appDeploymentId);
    return $this->recv_getApplicationDeployment();
  }

  public function send_getApplicationDeployment($appDeploymentId)
  {
    $args = new \Airavata\API\Airavata_getApplicationDeployment_args();
    $args->appDeploymentId = $appDeploymentId;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'getApplicationDeployment', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('getApplicationDeployment', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_getApplicationDeployment()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Airavata\API\Airavata_getApplicationDeployment_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Airavata\API\Airavata_getApplicationDeployment_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->ire !== null) {
      throw $result->ire;
    }
    if ($result->ace !== null) {
      throw $result->ace;
    }
    if ($result->ase !== null) {
      throw $result->ase;
    }
    throw new \Exception("getApplicationDeployment failed: unknown result");
  }

  public function updateApplicationDeployment($appDeploymentId, \Airavata\Model\AppCatalog\AppDeployment\ApplicationDeploymentDescription $applicationDeployment)
  {
    $this->send_updateApplicationDeployment($appDeploymentId, $applicationDeployment);
    return $this->recv_updateApplicationDeployment();
  }

  public function send_updateApplicationDeployment($appDeploymentId, \Airavata\Model\AppCatalog\AppDeployment\ApplicationDeploymentDescription $applicationDeployment)
  {
    $args = new \Airavata\API\Airavata_updateApplicationDeployment_args();
    $args->appDeploymentId = $appDeploymentId;
    $args->applicationDeployment = $applicationDeployment;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'updateApplicationDeployment', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('updateApplicationDeployment', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_updateApplicationDeployment()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Airavata\API\Airavata_updateApplicationDeployment_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Airavata\API\Airavata_updateApplicationDeployment_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->ire !== null) {
      throw $result->ire;
    }
    if ($result->ace !== null) {
      throw $result->ace;
    }
    if ($result->ase !== null) {
      throw $result->ase;
    }
    throw new \Exception("updateApplicationDeployment failed: unknown result");
  }

  public function deleteApplicationDeployment($appDeploymentId)
  {
    $this->send_deleteApplicationDeployment($appDeploymentId);
    return $this->recv_deleteApplicationDeployment();
  }

  public function send_deleteApplicationDeployment($appDeploymentId)
  {
    $args = new \Airavata\API\Airavata_deleteApplicationDeployment_args();
    $args->appDeploymentId = $appDeploymentId;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'deleteApplicationDeployment', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('deleteApplicationDeployment', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_deleteApplicationDeployment()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Airavata\API\Airavata_deleteApplicationDeployment_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Airavata\API\Airavata_deleteApplicationDeployment_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->ire !== null) {
      throw $result->ire;
    }
    if ($result->ace !== null) {
      throw $result->ace;
    }
    if ($result->ase !== null) {
      throw $result->ase;
    }
    throw new \Exception("deleteApplicationDeployment failed: unknown result");
  }

  public function getAllApplicationDeployments()
  {
    $this->send_getAllApplicationDeployments();
    return $this->recv_getAllApplicationDeployments();
  }

  public function send_getAllApplicationDeployments()
  {
    $args = new \Airavata\API\Airavata_getAllApplicationDeployments_args();
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'getAllApplicationDeployments', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('getAllApplicationDeployments', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_getAllApplicationDeployments()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Airavata\API\Airavata_getAllApplicationDeployments_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Airavata\API\Airavata_getAllApplicationDeployments_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->ire !== null) {
      throw $result->ire;
    }
    if ($result->ace !== null) {
      throw $result->ace;
    }
    if ($result->ase !== null) {
      throw $result->ase;
    }
    throw new \Exception("getAllApplicationDeployments failed: unknown result");
  }

  public function getAppModuleDeployedResources($appModuleId)
  {
    $this->send_getAppModuleDeployedResources($appModuleId);
    return $this->recv_getAppModuleDeployedResources();
  }

  public function send_getAppModuleDeployedResources($appModuleId)
  {
    $args = new \Airavata\API\Airavata_getAppModuleDeployedResources_args();
    $args->appModuleId = $appModuleId;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'getAppModuleDeployedResources', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('getAppModuleDeployedResources', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_getAppModuleDeployedResources()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Airavata\API\Airavata_getAppModuleDeployedResources_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Airavata\API\Airavata_getAppModuleDeployedResources_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->ire !== null) {
      throw $result->ire;
    }
    if ($result->ace !== null) {
      throw $result->ace;
    }
    if ($result->ase !== null) {
      throw $result->ase;
    }
    throw new \Exception("getAppModuleDeployedResources failed: unknown result");
  }

  public function registerApplicationInterface(\Airavata\Model\AppCatalog\AppInterface\ApplicationInterfaceDescription $applicationInterface)
  {
    $this->send_registerApplicationInterface($applicationInterface);
    return $this->recv_registerApplicationInterface();
  }

  public function send_registerApplicationInterface(\Airavata\Model\AppCatalog\AppInterface\ApplicationInterfaceDescription $applicationInterface)
  {
    $args = new \Airavata\API\Airavata_registerApplicationInterface_args();
    $args->applicationInterface = $applicationInterface;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'registerApplicationInterface', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('registerApplicationInterface', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_registerApplicationInterface()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Airavata\API\Airavata_registerApplicationInterface_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Airavata\API\Airavata_registerApplicationInterface_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->ire !== null) {
      throw $result->ire;
    }
    if ($result->ace !== null) {
      throw $result->ace;
    }
    if ($result->ase !== null) {
      throw $result->ase;
    }
    throw new \Exception("registerApplicationInterface failed: unknown result");
  }

  public function getApplicationInterface($appInterfaceId)
  {
    $this->send_getApplicationInterface($appInterfaceId);
    return $this->recv_getApplicationInterface();
  }

  public function send_getApplicationInterface($appInterfaceId)
  {
    $args = new \Airavata\API\Airavata_getApplicationInterface_args();
    $args->appInterfaceId = $appInterfaceId;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'getApplicationInterface', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('getApplicationInterface', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_getApplicationInterface()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Airavata\API\Airavata_getApplicationInterface_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Airavata\API\Airavata_getApplicationInterface_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->ire !== null) {
      throw $result->ire;
    }
    if ($result->ace !== null) {
      throw $result->ace;
    }
    if ($result->ase !== null) {
      throw $result->ase;
    }
    throw new \Exception("getApplicationInterface failed: unknown result");
  }

  public function updateApplicationInterface($appInterfaceId, \Airavata\Model\AppCatalog\AppInterface\ApplicationInterfaceDescription $applicationInterface)
  {
    $this->send_updateApplicationInterface($appInterfaceId, $applicationInterface);
    return $this->recv_updateApplicationInterface();
  }

  public function send_updateApplicationInterface($appInterfaceId, \Airavata\Model\AppCatalog\AppInterface\ApplicationInterfaceDescription $applicationInterface)
  {
    $args = new \Airavata\API\Airavata_updateApplicationInterface_args();
    $args->appInterfaceId = $appInterfaceId;
    $args->applicationInterface = $applicationInterface;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'updateApplicationInterface', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('updateApplicationInterface', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_updateApplicationInterface()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Airavata\API\Airavata_updateApplicationInterface_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Airavata\API\Airavata_updateApplicationInterface_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->ire !== null) {
      throw $result->ire;
    }
    if ($result->ace !== null) {
      throw $result->ace;
    }
    if ($result->ase !== null) {
      throw $result->ase;
    }
    throw new \Exception("updateApplicationInterface failed: unknown result");
  }

  public function deleteApplicationInterface($appInterfaceId)
  {
    $this->send_deleteApplicationInterface($appInterfaceId);
    return $this->recv_deleteApplicationInterface();
  }

  public function send_deleteApplicationInterface($appInterfaceId)
  {
    $args = new \Airavata\API\Airavata_deleteApplicationInterface_args();
    $args->appInterfaceId = $appInterfaceId;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'deleteApplicationInterface', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('deleteApplicationInterface', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_deleteApplicationInterface()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Airavata\API\Airavata_deleteApplicationInterface_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Airavata\API\Airavata_deleteApplicationInterface_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->ire !== null) {
      throw $result->ire;
    }
    if ($result->ace !== null) {
      throw $result->ace;
    }
    if ($result->ase !== null) {
      throw $result->ase;
    }
    throw new \Exception("deleteApplicationInterface failed: unknown result");
  }

  public function getAllApplicationInterfaceNames()
  {
    $this->send_getAllApplicationInterfaceNames();
    return $this->recv_getAllApplicationInterfaceNames();
  }

  public function send_getAllApplicationInterfaceNames()
  {
    $args = new \Airavata\API\Airavata_getAllApplicationInterfaceNames_args();
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'getAllApplicationInterfaceNames', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('getAllApplicationInterfaceNames', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_getAllApplicationInterfaceNames()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Airavata\API\Airavata_getAllApplicationInterfaceNames_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Airavata\API\Airavata_getAllApplicationInterfaceNames_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->ire !== null) {
      throw $result->ire;
    }
    if ($result->ace !== null) {
      throw $result->ace;
    }
    if ($result->ase !== null) {
      throw $result->ase;
    }
    throw new \Exception("getAllApplicationInterfaceNames failed: unknown result");
  }

  public function getAllApplicationInterfaces()
  {
    $this->send_getAllApplicationInterfaces();
    return $this->recv_getAllApplicationInterfaces();
  }

  public function send_getAllApplicationInterfaces()
  {
    $args = new \Airavata\API\Airavata_getAllApplicationInterfaces_args();
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'getAllApplicationInterfaces', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('getAllApplicationInterfaces', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_getAllApplicationInterfaces()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Airavata\API\Airavata_getAllApplicationInterfaces_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Airavata\API\Airavata_getAllApplicationInterfaces_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->ire !== null) {
      throw $result->ire;
    }
    if ($result->ace !== null) {
      throw $result->ace;
    }
    if ($result->ase !== null) {
      throw $result->ase;
    }
    throw new \Exception("getAllApplicationInterfaces failed: unknown result");
  }

  public function getApplicationInputs($appInterfaceId)
  {
    $this->send_getApplicationInputs($appInterfaceId);
    return $this->recv_getApplicationInputs();
  }

  public function send_getApplicationInputs($appInterfaceId)
  {
    $args = new \Airavata\API\Airavata_getApplicationInputs_args();
    $args->appInterfaceId = $appInterfaceId;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'getApplicationInputs', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('getApplicationInputs', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_getApplicationInputs()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Airavata\API\Airavata_getApplicationInputs_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Airavata\API\Airavata_getApplicationInputs_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->ire !== null) {
      throw $result->ire;
    }
    if ($result->ace !== null) {
      throw $result->ace;
    }
    if ($result->ase !== null) {
      throw $result->ase;
    }
    throw new \Exception("getApplicationInputs failed: unknown result");
  }

  public function getApplicationOutputs($appInterfaceId)
  {
    $this->send_getApplicationOutputs($appInterfaceId);
    return $this->recv_getApplicationOutputs();
  }

  public function send_getApplicationOutputs($appInterfaceId)
  {
    $args = new \Airavata\API\Airavata_getApplicationOutputs_args();
    $args->appInterfaceId = $appInterfaceId;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'getApplicationOutputs', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('getApplicationOutputs', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_getApplicationOutputs()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Airavata\API\Airavata_getApplicationOutputs_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Airavata\API\Airavata_getApplicationOutputs_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->ire !== null) {
      throw $result->ire;
    }
    if ($result->ace !== null) {
      throw $result->ace;
    }
    if ($result->ase !== null) {
      throw $result->ase;
    }
    throw new \Exception("getApplicationOutputs failed: unknown result");
  }

  public function getAvailableAppInterfaceComputeResources($appInterfaceId)
  {
    $this->send_getAvailableAppInterfaceComputeResources($appInterfaceId);
    return $this->recv_getAvailableAppInterfaceComputeResources();
  }

  public function send_getAvailableAppInterfaceComputeResources($appInterfaceId)
  {
    $args = new \Airavata\API\Airavata_getAvailableAppInterfaceComputeResources_args();
    $args->appInterfaceId = $appInterfaceId;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'getAvailableAppInterfaceComputeResources', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('getAvailableAppInterfaceComputeResources', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_getAvailableAppInterfaceComputeResources()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Airavata\API\Airavata_getAvailableAppInterfaceComputeResources_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Airavata\API\Airavata_getAvailableAppInterfaceComputeResources_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->ire !== null) {
      throw $result->ire;
    }
    if ($result->ace !== null) {
      throw $result->ace;
    }
    if ($result->ase !== null) {
      throw $result->ase;
    }
    throw new \Exception("getAvailableAppInterfaceComputeResources failed: unknown result");
  }

  public function registerComputeResource(\Airavata\Model\AppCatalog\ComputeResource\ComputeResourceDescription $computeResourceDescription)
  {
    $this->send_registerComputeResource($computeResourceDescription);
    return $this->recv_registerComputeResource();
  }

  public function send_registerComputeResource(\Airavata\Model\AppCatalog\ComputeResource\ComputeResourceDescription $computeResourceDescription)
  {
    $args = new \Airavata\API\Airavata_registerComputeResource_args();
    $args->computeResourceDescription = $computeResourceDescription;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'registerComputeResource', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('registerComputeResource', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_registerComputeResource()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Airavata\API\Airavata_registerComputeResource_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Airavata\API\Airavata_registerComputeResource_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->ire !== null) {
      throw $result->ire;
    }
    if ($result->ace !== null) {
      throw $result->ace;
    }
    if ($result->ase !== null) {
      throw $result->ase;
    }
    throw new \Exception("registerComputeResource failed: unknown result");
  }

  public function getComputeResource($computeResourceId)
  {
    $this->send_getComputeResource($computeResourceId);
    return $this->recv_getComputeResource();
  }

  public function send_getComputeResource($computeResourceId)
  {
    $args = new \Airavata\API\Airavata_getComputeResource_args();
    $args->computeResourceId = $computeResourceId;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'getComputeResource', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('getComputeResource', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_getComputeResource()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Airavata\API\Airavata_getComputeResource_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Airavata\API\Airavata_getComputeResource_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->ire !== null) {
      throw $result->ire;
    }
    if ($result->ace !== null) {
      throw $result->ace;
    }
    if ($result->ase !== null) {
      throw $result->ase;
    }
    throw new \Exception("getComputeResource failed: unknown result");
  }

  public function getAllComputeResourceNames()
  {
    $this->send_getAllComputeResourceNames();
    return $this->recv_getAllComputeResourceNames();
  }

  public function send_getAllComputeResourceNames()
  {
    $args = new \Airavata\API\Airavata_getAllComputeResourceNames_args();
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'getAllComputeResourceNames', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('getAllComputeResourceNames', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_getAllComputeResourceNames()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Airavata\API\Airavata_getAllComputeResourceNames_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Airavata\API\Airavata_getAllComputeResourceNames_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->ire !== null) {
      throw $result->ire;
    }
    if ($result->ace !== null) {
      throw $result->ace;
    }
    if ($result->ase !== null) {
      throw $result->ase;
    }
    throw new \Exception("getAllComputeResourceNames failed: unknown result");
  }

  public function updateComputeResource($computeResourceId, \Airavata\Model\AppCatalog\ComputeResource\ComputeResourceDescription $computeResourceDescription)
  {
    $this->send_updateComputeResource($computeResourceId, $computeResourceDescription);
    return $this->recv_updateComputeResource();
  }

  public function send_updateComputeResource($computeResourceId, \Airavata\Model\AppCatalog\ComputeResource\ComputeResourceDescription $computeResourceDescription)
  {
    $args = new \Airavata\API\Airavata_updateComputeResource_args();
    $args->computeResourceId = $computeResourceId;
    $args->computeResourceDescription = $computeResourceDescription;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'updateComputeResource', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('updateComputeResource', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_updateComputeResource()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Airavata\API\Airavata_updateComputeResource_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Airavata\API\Airavata_updateComputeResource_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->ire !== null) {
      throw $result->ire;
    }
    if ($result->ace !== null) {
      throw $result->ace;
    }
    if ($result->ase !== null) {
      throw $result->ase;
    }
    throw new \Exception("updateComputeResource failed: unknown result");
  }

  public function deleteComputeResource($computeResourceId)
  {
    $this->send_deleteComputeResource($computeResourceId);
    return $this->recv_deleteComputeResource();
  }

  public function send_deleteComputeResource($computeResourceId)
  {
    $args = new \Airavata\API\Airavata_deleteComputeResource_args();
    $args->computeResourceId = $computeResourceId;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'deleteComputeResource', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('deleteComputeResource', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_deleteComputeResource()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Airavata\API\Airavata_deleteComputeResource_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Airavata\API\Airavata_deleteComputeResource_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->ire !== null) {
      throw $result->ire;
    }
    if ($result->ace !== null) {
      throw $result->ace;
    }
    if ($result->ase !== null) {
      throw $result->ase;
    }
    throw new \Exception("deleteComputeResource failed: unknown result");
  }

  public function addLocalSubmissionDetails($computeResourceId, $priorityOrder, \Airavata\Model\AppCatalog\ComputeResource\LOCALSubmission $localSubmission)
  {
    $this->send_addLocalSubmissionDetails($computeResourceId, $priorityOrder, $localSubmission);
    return $this->recv_addLocalSubmissionDetails();
  }

  public function send_addLocalSubmissionDetails($computeResourceId, $priorityOrder, \Airavata\Model\AppCatalog\ComputeResource\LOCALSubmission $localSubmission)
  {
    $args = new \Airavata\API\Airavata_addLocalSubmissionDetails_args();
    $args->computeResourceId = $computeResourceId;
    $args->priorityOrder = $priorityOrder;
    $args->localSubmission = $localSubmission;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'addLocalSubmissionDetails', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('addLocalSubmissionDetails', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_addLocalSubmissionDetails()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Airavata\API\Airavata_addLocalSubmissionDetails_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Airavata\API\Airavata_addLocalSubmissionDetails_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->ire !== null) {
      throw $result->ire;
    }
    if ($result->ace !== null) {
      throw $result->ace;
    }
    if ($result->ase !== null) {
      throw $result->ase;
    }
    throw new \Exception("addLocalSubmissionDetails failed: unknown result");
  }

  public function updateLocalSubmissionDetails($jobSubmissionInterfaceId, \Airavata\Model\AppCatalog\ComputeResource\LOCALSubmission $localSubmission)
  {
    $this->send_updateLocalSubmissionDetails($jobSubmissionInterfaceId, $localSubmission);
    return $this->recv_updateLocalSubmissionDetails();
  }

  public function send_updateLocalSubmissionDetails($jobSubmissionInterfaceId, \Airavata\Model\AppCatalog\ComputeResource\LOCALSubmission $localSubmission)
  {
    $args = new \Airavata\API\Airavata_updateLocalSubmissionDetails_args();
    $args->jobSubmissionInterfaceId = $jobSubmissionInterfaceId;
    $args->localSubmission = $localSubmission;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'updateLocalSubmissionDetails', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('updateLocalSubmissionDetails', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_updateLocalSubmissionDetails()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Airavata\API\Airavata_updateLocalSubmissionDetails_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Airavata\API\Airavata_updateLocalSubmissionDetails_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->ire !== null) {
      throw $result->ire;
    }
    if ($result->ace !== null) {
      throw $result->ace;
    }
    if ($result->ase !== null) {
      throw $result->ase;
    }
    throw new \Exception("updateLocalSubmissionDetails failed: unknown result");
  }

  public function getLocalJobSubmission($jobSubmissionId)
  {
    $this->send_getLocalJobSubmission($jobSubmissionId);
    return $this->recv_getLocalJobSubmission();
  }

  public function send_getLocalJobSubmission($jobSubmissionId)
  {
    $args = new \Airavata\API\Airavata_getLocalJobSubmission_args();
    $args->jobSubmissionId = $jobSubmissionId;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'getLocalJobSubmission', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('getLocalJobSubmission', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_getLocalJobSubmission()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Airavata\API\Airavata_getLocalJobSubmission_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Airavata\API\Airavata_getLocalJobSubmission_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->ire !== null) {
      throw $result->ire;
    }
    if ($result->ace !== null) {
      throw $result->ace;
    }
    if ($result->ase !== null) {
      throw $result->ase;
    }
    throw new \Exception("getLocalJobSubmission failed: unknown result");
  }

  public function addSSHJobSubmissionDetails($computeResourceId, $priorityOrder, \Airavata\Model\AppCatalog\ComputeResource\SSHJobSubmission $sshJobSubmission)
  {
    $this->send_addSSHJobSubmissionDetails($computeResourceId, $priorityOrder, $sshJobSubmission);
    return $this->recv_addSSHJobSubmissionDetails();
  }

  public function send_addSSHJobSubmissionDetails($computeResourceId, $priorityOrder, \Airavata\Model\AppCatalog\ComputeResource\SSHJobSubmission $sshJobSubmission)
  {
    $args = new \Airavata\API\Airavata_addSSHJobSubmissionDetails_args();
    $args->computeResourceId = $computeResourceId;
    $args->priorityOrder = $priorityOrder;
    $args->sshJobSubmission = $sshJobSubmission;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'addSSHJobSubmissionDetails', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('addSSHJobSubmissionDetails', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_addSSHJobSubmissionDetails()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Airavata\API\Airavata_addSSHJobSubmissionDetails_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Airavata\API\Airavata_addSSHJobSubmissionDetails_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->ire !== null) {
      throw $result->ire;
    }
    if ($result->ace !== null) {
      throw $result->ace;
    }
    if ($result->ase !== null) {
      throw $result->ase;
    }
    throw new \Exception("addSSHJobSubmissionDetails failed: unknown result");
  }

  public function getSSHJobSubmission($jobSubmissionId)
  {
    $this->send_getSSHJobSubmission($jobSubmissionId);
    return $this->recv_getSSHJobSubmission();
  }

  public function send_getSSHJobSubmission($jobSubmissionId)
  {
    $args = new \Airavata\API\Airavata_getSSHJobSubmission_args();
    $args->jobSubmissionId = $jobSubmissionId;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'getSSHJobSubmission', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('getSSHJobSubmission', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_getSSHJobSubmission()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Airavata\API\Airavata_getSSHJobSubmission_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Airavata\API\Airavata_getSSHJobSubmission_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->ire !== null) {
      throw $result->ire;
    }
    if ($result->ace !== null) {
      throw $result->ace;
    }
    if ($result->ase !== null) {
      throw $result->ase;
    }
    throw new \Exception("getSSHJobSubmission failed: unknown result");
  }

  public function addUNICOREJobSubmissionDetails($computeResourceId, $priorityOrder, \Airavata\Model\AppCatalog\ComputeResource\UnicoreJobSubmission $unicoreJobSubmission)
  {
    $this->send_addUNICOREJobSubmissionDetails($computeResourceId, $priorityOrder, $unicoreJobSubmission);
    return $this->recv_addUNICOREJobSubmissionDetails();
  }

  public function send_addUNICOREJobSubmissionDetails($computeResourceId, $priorityOrder, \Airavata\Model\AppCatalog\ComputeResource\UnicoreJobSubmission $unicoreJobSubmission)
  {
    $args = new \Airavata\API\Airavata_addUNICOREJobSubmissionDetails_args();
    $args->computeResourceId = $computeResourceId;
    $args->priorityOrder = $priorityOrder;
    $args->unicoreJobSubmission = $unicoreJobSubmission;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'addUNICOREJobSubmissionDetails', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('addUNICOREJobSubmissionDetails', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_addUNICOREJobSubmissionDetails()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Airavata\API\Airavata_addUNICOREJobSubmissionDetails_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Airavata\API\Airavata_addUNICOREJobSubmissionDetails_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->ire !== null) {
      throw $result->ire;
    }
    if ($result->ace !== null) {
      throw $result->ace;
    }
    if ($result->ase !== null) {
      throw $result->ase;
    }
    throw new \Exception("addUNICOREJobSubmissionDetails failed: unknown result");
  }

  public function getUnicoreJobSubmission($jobSubmissionId)
  {
    $this->send_getUnicoreJobSubmission($jobSubmissionId);
    return $this->recv_getUnicoreJobSubmission();
  }

  public function send_getUnicoreJobSubmission($jobSubmissionId)
  {
    $args = new \Airavata\API\Airavata_getUnicoreJobSubmission_args();
    $args->jobSubmissionId = $jobSubmissionId;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'getUnicoreJobSubmission', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('getUnicoreJobSubmission', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_getUnicoreJobSubmission()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Airavata\API\Airavata_getUnicoreJobSubmission_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Airavata\API\Airavata_getUnicoreJobSubmission_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->ire !== null) {
      throw $result->ire;
    }
    if ($result->ace !== null) {
      throw $result->ace;
    }
    if ($result->ase !== null) {
      throw $result->ase;
    }
    throw new \Exception("getUnicoreJobSubmission failed: unknown result");
  }

  public function addCloudJobSubmissionDetails($computeResourceId, $priorityOrder, \Airavata\Model\AppCatalog\ComputeResource\CloudJobSubmission $cloudSubmission)
  {
    $this->send_addCloudJobSubmissionDetails($computeResourceId, $priorityOrder, $cloudSubmission);
    return $this->recv_addCloudJobSubmissionDetails();
  }

  public function send_addCloudJobSubmissionDetails($computeResourceId, $priorityOrder, \Airavata\Model\AppCatalog\ComputeResource\CloudJobSubmission $cloudSubmission)
  {
    $args = new \Airavata\API\Airavata_addCloudJobSubmissionDetails_args();
    $args->computeResourceId = $computeResourceId;
    $args->priorityOrder = $priorityOrder;
    $args->cloudSubmission = $cloudSubmission;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'addCloudJobSubmissionDetails', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('addCloudJobSubmissionDetails', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_addCloudJobSubmissionDetails()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Airavata\API\Airavata_addCloudJobSubmissionDetails_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Airavata\API\Airavata_addCloudJobSubmissionDetails_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->ire !== null) {
      throw $result->ire;
    }
    if ($result->ace !== null) {
      throw $result->ace;
    }
    if ($result->ase !== null) {
      throw $result->ase;
    }
    throw new \Exception("addCloudJobSubmissionDetails failed: unknown result");
  }

  public function getCloudJobSubmission($jobSubmissionId)
  {
    $this->send_getCloudJobSubmission($jobSubmissionId);
    return $this->recv_getCloudJobSubmission();
  }

  public function send_getCloudJobSubmission($jobSubmissionId)
  {
    $args = new \Airavata\API\Airavata_getCloudJobSubmission_args();
    $args->jobSubmissionId = $jobSubmissionId;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'getCloudJobSubmission', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('getCloudJobSubmission', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_getCloudJobSubmission()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Airavata\API\Airavata_getCloudJobSubmission_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Airavata\API\Airavata_getCloudJobSubmission_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->ire !== null) {
      throw $result->ire;
    }
    if ($result->ace !== null) {
      throw $result->ace;
    }
    if ($result->ase !== null) {
      throw $result->ase;
    }
    throw new \Exception("getCloudJobSubmission failed: unknown result");
  }

  public function updateSSHJobSubmissionDetails($jobSubmissionInterfaceId, \Airavata\Model\AppCatalog\ComputeResource\SSHJobSubmission $sshJobSubmission)
  {
    $this->send_updateSSHJobSubmissionDetails($jobSubmissionInterfaceId, $sshJobSubmission);
    return $this->recv_updateSSHJobSubmissionDetails();
  }

  public function send_updateSSHJobSubmissionDetails($jobSubmissionInterfaceId, \Airavata\Model\AppCatalog\ComputeResource\SSHJobSubmission $sshJobSubmission)
  {
    $args = new \Airavata\API\Airavata_updateSSHJobSubmissionDetails_args();
    $args->jobSubmissionInterfaceId = $jobSubmissionInterfaceId;
    $args->sshJobSubmission = $sshJobSubmission;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'updateSSHJobSubmissionDetails', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('updateSSHJobSubmissionDetails', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_updateSSHJobSubmissionDetails()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Airavata\API\Airavata_updateSSHJobSubmissionDetails_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Airavata\API\Airavata_updateSSHJobSubmissionDetails_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->ire !== null) {
      throw $result->ire;
    }
    if ($result->ace !== null) {
      throw $result->ace;
    }
    if ($result->ase !== null) {
      throw $result->ase;
    }
    throw new \Exception("updateSSHJobSubmissionDetails failed: unknown result");
  }

  public function updateCloudJobSubmissionDetails($jobSubmissionInterfaceId, \Airavata\Model\AppCatalog\ComputeResource\CloudJobSubmission $sshJobSubmission)
  {
    $this->send_updateCloudJobSubmissionDetails($jobSubmissionInterfaceId, $sshJobSubmission);
    return $this->recv_updateCloudJobSubmissionDetails();
  }

  public function send_updateCloudJobSubmissionDetails($jobSubmissionInterfaceId, \Airavata\Model\AppCatalog\ComputeResource\CloudJobSubmission $sshJobSubmission)
  {
    $args = new \Airavata\API\Airavata_updateCloudJobSubmissionDetails_args();
    $args->jobSubmissionInterfaceId = $jobSubmissionInterfaceId;
    $args->sshJobSubmission = $sshJobSubmission;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'updateCloudJobSubmissionDetails', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('updateCloudJobSubmissionDetails', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_updateCloudJobSubmissionDetails()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Airavata\API\Airavata_updateCloudJobSubmissionDetails_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Airavata\API\Airavata_updateCloudJobSubmissionDetails_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->ire !== null) {
      throw $result->ire;
    }
    if ($result->ace !== null) {
      throw $result->ace;
    }
    if ($result->ase !== null) {
      throw $result->ase;
    }
    throw new \Exception("updateCloudJobSubmissionDetails failed: unknown result");
  }

  public function addLocalDataMovementDetails($computeResourceId, $priorityOrder, \Airavata\Model\AppCatalog\ComputeResource\LOCALDataMovement $localDataMovement)
  {
    $this->send_addLocalDataMovementDetails($computeResourceId, $priorityOrder, $localDataMovement);
    return $this->recv_addLocalDataMovementDetails();
  }

  public function send_addLocalDataMovementDetails($computeResourceId, $priorityOrder, \Airavata\Model\AppCatalog\ComputeResource\LOCALDataMovement $localDataMovement)
  {
    $args = new \Airavata\API\Airavata_addLocalDataMovementDetails_args();
    $args->computeResourceId = $computeResourceId;
    $args->priorityOrder = $priorityOrder;
    $args->localDataMovement = $localDataMovement;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'addLocalDataMovementDetails', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('addLocalDataMovementDetails', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_addLocalDataMovementDetails()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Airavata\API\Airavata_addLocalDataMovementDetails_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Airavata\API\Airavata_addLocalDataMovementDetails_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->ire !== null) {
      throw $result->ire;
    }
    if ($result->ace !== null) {
      throw $result->ace;
    }
    if ($result->ase !== null) {
      throw $result->ase;
    }
    throw new \Exception("addLocalDataMovementDetails failed: unknown result");
  }

  public function updateLocalDataMovementDetails($dataMovementInterfaceId, \Airavata\Model\AppCatalog\ComputeResource\LOCALDataMovement $localDataMovement)
  {
    $this->send_updateLocalDataMovementDetails($dataMovementInterfaceId, $localDataMovement);
    return $this->recv_updateLocalDataMovementDetails();
  }

  public function send_updateLocalDataMovementDetails($dataMovementInterfaceId, \Airavata\Model\AppCatalog\ComputeResource\LOCALDataMovement $localDataMovement)
  {
    $args = new \Airavata\API\Airavata_updateLocalDataMovementDetails_args();
    $args->dataMovementInterfaceId = $dataMovementInterfaceId;
    $args->localDataMovement = $localDataMovement;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'updateLocalDataMovementDetails', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('updateLocalDataMovementDetails', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_updateLocalDataMovementDetails()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Airavata\API\Airavata_updateLocalDataMovementDetails_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Airavata\API\Airavata_updateLocalDataMovementDetails_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->ire !== null) {
      throw $result->ire;
    }
    if ($result->ace !== null) {
      throw $result->ace;
    }
    if ($result->ase !== null) {
      throw $result->ase;
    }
    throw new \Exception("updateLocalDataMovementDetails failed: unknown result");
  }

  public function getLocalDataMovement($dataMovementId)
  {
    $this->send_getLocalDataMovement($dataMovementId);
    return $this->recv_getLocalDataMovement();
  }

  public function send_getLocalDataMovement($dataMovementId)
  {
    $args = new \Airavata\API\Airavata_getLocalDataMovement_args();
    $args->dataMovementId = $dataMovementId;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'getLocalDataMovement', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('getLocalDataMovement', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_getLocalDataMovement()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Airavata\API\Airavata_getLocalDataMovement_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Airavata\API\Airavata_getLocalDataMovement_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->ire !== null) {
      throw $result->ire;
    }
    if ($result->ace !== null) {
      throw $result->ace;
    }
    if ($result->ase !== null) {
      throw $result->ase;
    }
    throw new \Exception("getLocalDataMovement failed: unknown result");
  }

  public function addSCPDataMovementDetails($computeResourceId, $priorityOrder, \Airavata\Model\AppCatalog\ComputeResource\SCPDataMovement $scpDataMovement)
  {
    $this->send_addSCPDataMovementDetails($computeResourceId, $priorityOrder, $scpDataMovement);
    return $this->recv_addSCPDataMovementDetails();
  }

  public function send_addSCPDataMovementDetails($computeResourceId, $priorityOrder, \Airavata\Model\AppCatalog\ComputeResource\SCPDataMovement $scpDataMovement)
  {
    $args = new \Airavata\API\Airavata_addSCPDataMovementDetails_args();
    $args->computeResourceId = $computeResourceId;
    $args->priorityOrder = $priorityOrder;
    $args->scpDataMovement = $scpDataMovement;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'addSCPDataMovementDetails', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('addSCPDataMovementDetails', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_addSCPDataMovementDetails()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Airavata\API\Airavata_addSCPDataMovementDetails_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Airavata\API\Airavata_addSCPDataMovementDetails_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->ire !== null) {
      throw $result->ire;
    }
    if ($result->ace !== null) {
      throw $result->ace;
    }
    if ($result->ase !== null) {
      throw $result->ase;
    }
    throw new \Exception("addSCPDataMovementDetails failed: unknown result");
  }

  public function updateSCPDataMovementDetails($dataMovementInterfaceId, \Airavata\Model\AppCatalog\ComputeResource\SCPDataMovement $scpDataMovement)
  {
    $this->send_updateSCPDataMovementDetails($dataMovementInterfaceId, $scpDataMovement);
    return $this->recv_updateSCPDataMovementDetails();
  }

  public function send_updateSCPDataMovementDetails($dataMovementInterfaceId, \Airavata\Model\AppCatalog\ComputeResource\SCPDataMovement $scpDataMovement)
  {
    $args = new \Airavata\API\Airavata_updateSCPDataMovementDetails_args();
    $args->dataMovementInterfaceId = $dataMovementInterfaceId;
    $args->scpDataMovement = $scpDataMovement;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'updateSCPDataMovementDetails', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('updateSCPDataMovementDetails', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_updateSCPDataMovementDetails()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Airavata\API\Airavata_updateSCPDataMovementDetails_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Airavata\API\Airavata_updateSCPDataMovementDetails_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->ire !== null) {
      throw $result->ire;
    }
    if ($result->ace !== null) {
      throw $result->ace;
    }
    if ($result->ase !== null) {
      throw $result->ase;
    }
    throw new \Exception("updateSCPDataMovementDetails failed: unknown result");
  }

  public function getSCPDataMovement($dataMovementId)
  {
    $this->send_getSCPDataMovement($dataMovementId);
    return $this->recv_getSCPDataMovement();
  }

  public function send_getSCPDataMovement($dataMovementId)
  {
    $args = new \Airavata\API\Airavata_getSCPDataMovement_args();
    $args->dataMovementId = $dataMovementId;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'getSCPDataMovement', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('getSCPDataMovement', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_getSCPDataMovement()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Airavata\API\Airavata_getSCPDataMovement_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Airavata\API\Airavata_getSCPDataMovement_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->ire !== null) {
      throw $result->ire;
    }
    if ($result->ace !== null) {
      throw $result->ace;
    }
    if ($result->ase !== null) {
      throw $result->ase;
    }
    throw new \Exception("getSCPDataMovement failed: unknown result");
  }

  public function addGridFTPDataMovementDetails($computeResourceId, $priorityOrder, \Airavata\Model\AppCatalog\ComputeResource\GridFTPDataMovement $gridFTPDataMovement)
  {
    $this->send_addGridFTPDataMovementDetails($computeResourceId, $priorityOrder, $gridFTPDataMovement);
    return $this->recv_addGridFTPDataMovementDetails();
  }

  public function send_addGridFTPDataMovementDetails($computeResourceId, $priorityOrder, \Airavata\Model\AppCatalog\ComputeResource\GridFTPDataMovement $gridFTPDataMovement)
  {
    $args = new \Airavata\API\Airavata_addGridFTPDataMovementDetails_args();
    $args->computeResourceId = $computeResourceId;
    $args->priorityOrder = $priorityOrder;
    $args->gridFTPDataMovement = $gridFTPDataMovement;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'addGridFTPDataMovementDetails', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('addGridFTPDataMovementDetails', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_addGridFTPDataMovementDetails()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Airavata\API\Airavata_addGridFTPDataMovementDetails_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Airavata\API\Airavata_addGridFTPDataMovementDetails_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->ire !== null) {
      throw $result->ire;
    }
    if ($result->ace !== null) {
      throw $result->ace;
    }
    if ($result->ase !== null) {
      throw $result->ase;
    }
    throw new \Exception("addGridFTPDataMovementDetails failed: unknown result");
  }

  public function updateGridFTPDataMovementDetails($dataMovementInterfaceId, \Airavata\Model\AppCatalog\ComputeResource\GridFTPDataMovement $gridFTPDataMovement)
  {
    $this->send_updateGridFTPDataMovementDetails($dataMovementInterfaceId, $gridFTPDataMovement);
    return $this->recv_updateGridFTPDataMovementDetails();
  }

  public function send_updateGridFTPDataMovementDetails($dataMovementInterfaceId, \Airavata\Model\AppCatalog\ComputeResource\GridFTPDataMovement $gridFTPDataMovement)
  {
    $args = new \Airavata\API\Airavata_updateGridFTPDataMovementDetails_args();
    $args->dataMovementInterfaceId = $dataMovementInterfaceId;
    $args->gridFTPDataMovement = $gridFTPDataMovement;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'updateGridFTPDataMovementDetails', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('updateGridFTPDataMovementDetails', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_updateGridFTPDataMovementDetails()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Airavata\API\Airavata_updateGridFTPDataMovementDetails_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Airavata\API\Airavata_updateGridFTPDataMovementDetails_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->ire !== null) {
      throw $result->ire;
    }
    if ($result->ace !== null) {
      throw $result->ace;
    }
    if ($result->ase !== null) {
      throw $result->ase;
    }
    throw new \Exception("updateGridFTPDataMovementDetails failed: unknown result");
  }

  public function getGridFTPDataMovement($dataMovementId)
  {
    $this->send_getGridFTPDataMovement($dataMovementId);
    return $this->recv_getGridFTPDataMovement();
  }

  public function send_getGridFTPDataMovement($dataMovementId)
  {
    $args = new \Airavata\API\Airavata_getGridFTPDataMovement_args();
    $args->dataMovementId = $dataMovementId;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'getGridFTPDataMovement', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('getGridFTPDataMovement', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_getGridFTPDataMovement()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Airavata\API\Airavata_getGridFTPDataMovement_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Airavata\API\Airavata_getGridFTPDataMovement_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->ire !== null) {
      throw $result->ire;
    }
    if ($result->ace !== null) {
      throw $result->ace;
    }
    if ($result->ase !== null) {
      throw $result->ase;
    }
    throw new \Exception("getGridFTPDataMovement failed: unknown result");
  }

  public function changeJobSubmissionPriority($jobSubmissionInterfaceId, $newPriorityOrder)
  {
    $this->send_changeJobSubmissionPriority($jobSubmissionInterfaceId, $newPriorityOrder);
    return $this->recv_changeJobSubmissionPriority();
  }

  public function send_changeJobSubmissionPriority($jobSubmissionInterfaceId, $newPriorityOrder)
  {
    $args = new \Airavata\API\Airavata_changeJobSubmissionPriority_args();
    $args->jobSubmissionInterfaceId = $jobSubmissionInterfaceId;
    $args->newPriorityOrder = $newPriorityOrder;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'changeJobSubmissionPriority', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('changeJobSubmissionPriority', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_changeJobSubmissionPriority()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Airavata\API\Airavata_changeJobSubmissionPriority_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Airavata\API\Airavata_changeJobSubmissionPriority_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->ire !== null) {
      throw $result->ire;
    }
    if ($result->ace !== null) {
      throw $result->ace;
    }
    if ($result->ase !== null) {
      throw $result->ase;
    }
    throw new \Exception("changeJobSubmissionPriority failed: unknown result");
  }

  public function changeDataMovementPriority($dataMovementInterfaceId, $newPriorityOrder)
  {
    $this->send_changeDataMovementPriority($dataMovementInterfaceId, $newPriorityOrder);
    return $this->recv_changeDataMovementPriority();
  }

  public function send_changeDataMovementPriority($dataMovementInterfaceId, $newPriorityOrder)
  {
    $args = new \Airavata\API\Airavata_changeDataMovementPriority_args();
    $args->dataMovementInterfaceId = $dataMovementInterfaceId;
    $args->newPriorityOrder = $newPriorityOrder;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'changeDataMovementPriority', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('changeDataMovementPriority', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_changeDataMovementPriority()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Airavata\API\Airavata_changeDataMovementPriority_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Airavata\API\Airavata_changeDataMovementPriority_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->ire !== null) {
      throw $result->ire;
    }
    if ($result->ace !== null) {
      throw $result->ace;
    }
    if ($result->ase !== null) {
      throw $result->ase;
    }
    throw new \Exception("changeDataMovementPriority failed: unknown result");
  }

  public function changeJobSubmissionPriorities($jobSubmissionPriorityMap)
  {
    $this->send_changeJobSubmissionPriorities($jobSubmissionPriorityMap);
    return $this->recv_changeJobSubmissionPriorities();
  }

  public function send_changeJobSubmissionPriorities($jobSubmissionPriorityMap)
  {
    $args = new \Airavata\API\Airavata_changeJobSubmissionPriorities_args();
    $args->jobSubmissionPriorityMap = $jobSubmissionPriorityMap;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'changeJobSubmissionPriorities', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('changeJobSubmissionPriorities', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_changeJobSubmissionPriorities()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Airavata\API\Airavata_changeJobSubmissionPriorities_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Airavata\API\Airavata_changeJobSubmissionPriorities_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->ire !== null) {
      throw $result->ire;
    }
    if ($result->ace !== null) {
      throw $result->ace;
    }
    if ($result->ase !== null) {
      throw $result->ase;
    }
    throw new \Exception("changeJobSubmissionPriorities failed: unknown result");
  }

  public function changeDataMovementPriorities($dataMovementPriorityMap)
  {
    $this->send_changeDataMovementPriorities($dataMovementPriorityMap);
    return $this->recv_changeDataMovementPriorities();
  }

  public function send_changeDataMovementPriorities($dataMovementPriorityMap)
  {
    $args = new \Airavata\API\Airavata_changeDataMovementPriorities_args();
    $args->dataMovementPriorityMap = $dataMovementPriorityMap;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'changeDataMovementPriorities', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('changeDataMovementPriorities', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_changeDataMovementPriorities()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Airavata\API\Airavata_changeDataMovementPriorities_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Airavata\API\Airavata_changeDataMovementPriorities_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->ire !== null) {
      throw $result->ire;
    }
    if ($result->ace !== null) {
      throw $result->ace;
    }
    if ($result->ase !== null) {
      throw $result->ase;
    }
    throw new \Exception("changeDataMovementPriorities failed: unknown result");
  }

  public function deleteJobSubmissionInterface($computeResourceId, $jobSubmissionInterfaceId)
  {
    $this->send_deleteJobSubmissionInterface($computeResourceId, $jobSubmissionInterfaceId);
    return $this->recv_deleteJobSubmissionInterface();
  }

  public function send_deleteJobSubmissionInterface($computeResourceId, $jobSubmissionInterfaceId)
  {
    $args = new \Airavata\API\Airavata_deleteJobSubmissionInterface_args();
    $args->computeResourceId = $computeResourceId;
    $args->jobSubmissionInterfaceId = $jobSubmissionInterfaceId;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'deleteJobSubmissionInterface', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('deleteJobSubmissionInterface', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_deleteJobSubmissionInterface()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Airavata\API\Airavata_deleteJobSubmissionInterface_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Airavata\API\Airavata_deleteJobSubmissionInterface_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->ire !== null) {
      throw $result->ire;
    }
    if ($result->ace !== null) {
      throw $result->ace;
    }
    if ($result->ase !== null) {
      throw $result->ase;
    }
    throw new \Exception("deleteJobSubmissionInterface failed: unknown result");
  }

  public function deleteDataMovementInterface($computeResourceId, $dataMovementInterfaceId)
  {
    $this->send_deleteDataMovementInterface($computeResourceId, $dataMovementInterfaceId);
    return $this->recv_deleteDataMovementInterface();
  }

  public function send_deleteDataMovementInterface($computeResourceId, $dataMovementInterfaceId)
  {
    $args = new \Airavata\API\Airavata_deleteDataMovementInterface_args();
    $args->computeResourceId = $computeResourceId;
    $args->dataMovementInterfaceId = $dataMovementInterfaceId;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'deleteDataMovementInterface', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('deleteDataMovementInterface', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_deleteDataMovementInterface()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Airavata\API\Airavata_deleteDataMovementInterface_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Airavata\API\Airavata_deleteDataMovementInterface_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->ire !== null) {
      throw $result->ire;
    }
    if ($result->ace !== null) {
      throw $result->ace;
    }
    if ($result->ase !== null) {
      throw $result->ase;
    }
    throw new \Exception("deleteDataMovementInterface failed: unknown result");
  }

  public function registerResourceJobManager(\Airavata\Model\AppCatalog\ComputeResource\ResourceJobManager $resourceJobManager)
  {
    $this->send_registerResourceJobManager($resourceJobManager);
    return $this->recv_registerResourceJobManager();
  }

  public function send_registerResourceJobManager(\Airavata\Model\AppCatalog\ComputeResource\ResourceJobManager $resourceJobManager)
  {
    $args = new \Airavata\API\Airavata_registerResourceJobManager_args();
    $args->resourceJobManager = $resourceJobManager;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'registerResourceJobManager', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('registerResourceJobManager', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_registerResourceJobManager()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Airavata\API\Airavata_registerResourceJobManager_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Airavata\API\Airavata_registerResourceJobManager_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->ire !== null) {
      throw $result->ire;
    }
    if ($result->ace !== null) {
      throw $result->ace;
    }
    if ($result->ase !== null) {
      throw $result->ase;
    }
    throw new \Exception("registerResourceJobManager failed: unknown result");
  }

  public function updateResourceJobManager($resourceJobManagerId, \Airavata\Model\AppCatalog\ComputeResource\ResourceJobManager $updatedResourceJobManager)
  {
    $this->send_updateResourceJobManager($resourceJobManagerId, $updatedResourceJobManager);
    return $this->recv_updateResourceJobManager();
  }

  public function send_updateResourceJobManager($resourceJobManagerId, \Airavata\Model\AppCatalog\ComputeResource\ResourceJobManager $updatedResourceJobManager)
  {
    $args = new \Airavata\API\Airavata_updateResourceJobManager_args();
    $args->resourceJobManagerId = $resourceJobManagerId;
    $args->updatedResourceJobManager = $updatedResourceJobManager;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'updateResourceJobManager', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('updateResourceJobManager', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_updateResourceJobManager()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Airavata\API\Airavata_updateResourceJobManager_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Airavata\API\Airavata_updateResourceJobManager_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->ire !== null) {
      throw $result->ire;
    }
    if ($result->ace !== null) {
      throw $result->ace;
    }
    if ($result->ase !== null) {
      throw $result->ase;
    }
    throw new \Exception("updateResourceJobManager failed: unknown result");
  }

  public function getResourceJobManager($resourceJobManagerId)
  {
    $this->send_getResourceJobManager($resourceJobManagerId);
    return $this->recv_getResourceJobManager();
  }

  public function send_getResourceJobManager($resourceJobManagerId)
  {
    $args = new \Airavata\API\Airavata_getResourceJobManager_args();
    $args->resourceJobManagerId = $resourceJobManagerId;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'getResourceJobManager', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('getResourceJobManager', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_getResourceJobManager()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Airavata\API\Airavata_getResourceJobManager_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Airavata\API\Airavata_getResourceJobManager_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->ire !== null) {
      throw $result->ire;
    }
    if ($result->ace !== null) {
      throw $result->ace;
    }
    if ($result->ase !== null) {
      throw $result->ase;
    }
    throw new \Exception("getResourceJobManager failed: unknown result");
  }

  public function deleteResourceJobManager($resourceJobManagerId)
  {
    $this->send_deleteResourceJobManager($resourceJobManagerId);
    return $this->recv_deleteResourceJobManager();
  }

  public function send_deleteResourceJobManager($resourceJobManagerId)
  {
    $args = new \Airavata\API\Airavata_deleteResourceJobManager_args();
    $args->resourceJobManagerId = $resourceJobManagerId;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'deleteResourceJobManager', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('deleteResourceJobManager', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_deleteResourceJobManager()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Airavata\API\Airavata_deleteResourceJobManager_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Airavata\API\Airavata_deleteResourceJobManager_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->ire !== null) {
      throw $result->ire;
    }
    if ($result->ace !== null) {
      throw $result->ace;
    }
    if ($result->ase !== null) {
      throw $result->ase;
    }
    throw new \Exception("deleteResourceJobManager failed: unknown result");
  }

  public function deleteBatchQueue($computeResourceId, $queueName)
  {
    $this->send_deleteBatchQueue($computeResourceId, $queueName);
    return $this->recv_deleteBatchQueue();
  }

  public function send_deleteBatchQueue($computeResourceId, $queueName)
  {
    $args = new \Airavata\API\Airavata_deleteBatchQueue_args();
    $args->computeResourceId = $computeResourceId;
    $args->queueName = $queueName;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'deleteBatchQueue', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('deleteBatchQueue', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_deleteBatchQueue()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Airavata\API\Airavata_deleteBatchQueue_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Airavata\API\Airavata_deleteBatchQueue_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->ire !== null) {
      throw $result->ire;
    }
    if ($result->ace !== null) {
      throw $result->ace;
    }
    if ($result->ase !== null) {
      throw $result->ase;
    }
    throw new \Exception("deleteBatchQueue failed: unknown result");
  }

  public function registerGatewayResourceProfile(\Airavata\Model\AppCatalog\GatewayProfile\GatewayResourceProfile $gatewayResourceProfile)
  {
    $this->send_registerGatewayResourceProfile($gatewayResourceProfile);
    return $this->recv_registerGatewayResourceProfile();
  }

  public function send_registerGatewayResourceProfile(\Airavata\Model\AppCatalog\GatewayProfile\GatewayResourceProfile $gatewayResourceProfile)
  {
    $args = new \Airavata\API\Airavata_registerGatewayResourceProfile_args();
    $args->gatewayResourceProfile = $gatewayResourceProfile;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'registerGatewayResourceProfile', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('registerGatewayResourceProfile', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_registerGatewayResourceProfile()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Airavata\API\Airavata_registerGatewayResourceProfile_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Airavata\API\Airavata_registerGatewayResourceProfile_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->ire !== null) {
      throw $result->ire;
    }
    if ($result->ace !== null) {
      throw $result->ace;
    }
    if ($result->ase !== null) {
      throw $result->ase;
    }
    throw new \Exception("registerGatewayResourceProfile failed: unknown result");
  }

  public function getGatewayResourceProfile($gatewayID)
  {
    $this->send_getGatewayResourceProfile($gatewayID);
    return $this->recv_getGatewayResourceProfile();
  }

  public function send_getGatewayResourceProfile($gatewayID)
  {
    $args = new \Airavata\API\Airavata_getGatewayResourceProfile_args();
    $args->gatewayID = $gatewayID;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'getGatewayResourceProfile', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('getGatewayResourceProfile', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_getGatewayResourceProfile()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Airavata\API\Airavata_getGatewayResourceProfile_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Airavata\API\Airavata_getGatewayResourceProfile_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->ire !== null) {
      throw $result->ire;
    }
    if ($result->ace !== null) {
      throw $result->ace;
    }
    if ($result->ase !== null) {
      throw $result->ase;
    }
    throw new \Exception("getGatewayResourceProfile failed: unknown result");
  }

  public function updateGatewayResourceProfile($gatewayID, \Airavata\Model\AppCatalog\GatewayProfile\GatewayResourceProfile $gatewayResourceProfile)
  {
    $this->send_updateGatewayResourceProfile($gatewayID, $gatewayResourceProfile);
    return $this->recv_updateGatewayResourceProfile();
  }

  public function send_updateGatewayResourceProfile($gatewayID, \Airavata\Model\AppCatalog\GatewayProfile\GatewayResourceProfile $gatewayResourceProfile)
  {
    $args = new \Airavata\API\Airavata_updateGatewayResourceProfile_args();
    $args->gatewayID = $gatewayID;
    $args->gatewayResourceProfile = $gatewayResourceProfile;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'updateGatewayResourceProfile', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('updateGatewayResourceProfile', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_updateGatewayResourceProfile()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Airavata\API\Airavata_updateGatewayResourceProfile_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Airavata\API\Airavata_updateGatewayResourceProfile_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->ire !== null) {
      throw $result->ire;
    }
    if ($result->ace !== null) {
      throw $result->ace;
    }
    if ($result->ase !== null) {
      throw $result->ase;
    }
    throw new \Exception("updateGatewayResourceProfile failed: unknown result");
  }

  public function deleteGatewayResourceProfile($gatewayID)
  {
    $this->send_deleteGatewayResourceProfile($gatewayID);
    return $this->recv_deleteGatewayResourceProfile();
  }

  public function send_deleteGatewayResourceProfile($gatewayID)
  {
    $args = new \Airavata\API\Airavata_deleteGatewayResourceProfile_args();
    $args->gatewayID = $gatewayID;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'deleteGatewayResourceProfile', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('deleteGatewayResourceProfile', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_deleteGatewayResourceProfile()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Airavata\API\Airavata_deleteGatewayResourceProfile_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Airavata\API\Airavata_deleteGatewayResourceProfile_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->ire !== null) {
      throw $result->ire;
    }
    if ($result->ace !== null) {
      throw $result->ace;
    }
    if ($result->ase !== null) {
      throw $result->ase;
    }
    throw new \Exception("deleteGatewayResourceProfile failed: unknown result");
  }

  public function addGatewayComputeResourcePreference($gatewayID, $computeResourceId, \Airavata\Model\AppCatalog\GatewayProfile\ComputeResourcePreference $computeResourcePreference)
  {
    $this->send_addGatewayComputeResourcePreference($gatewayID, $computeResourceId, $computeResourcePreference);
    return $this->recv_addGatewayComputeResourcePreference();
  }

  public function send_addGatewayComputeResourcePreference($gatewayID, $computeResourceId, \Airavata\Model\AppCatalog\GatewayProfile\ComputeResourcePreference $computeResourcePreference)
  {
    $args = new \Airavata\API\Airavata_addGatewayComputeResourcePreference_args();
    $args->gatewayID = $gatewayID;
    $args->computeResourceId = $computeResourceId;
    $args->computeResourcePreference = $computeResourcePreference;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'addGatewayComputeResourcePreference', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('addGatewayComputeResourcePreference', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_addGatewayComputeResourcePreference()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Airavata\API\Airavata_addGatewayComputeResourcePreference_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Airavata\API\Airavata_addGatewayComputeResourcePreference_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->ire !== null) {
      throw $result->ire;
    }
    if ($result->ace !== null) {
      throw $result->ace;
    }
    if ($result->ase !== null) {
      throw $result->ase;
    }
    throw new \Exception("addGatewayComputeResourcePreference failed: unknown result");
  }

  public function getGatewayComputeResourcePreference($gatewayID, $computeResourceId)
  {
    $this->send_getGatewayComputeResourcePreference($gatewayID, $computeResourceId);
    return $this->recv_getGatewayComputeResourcePreference();
  }

  public function send_getGatewayComputeResourcePreference($gatewayID, $computeResourceId)
  {
    $args = new \Airavata\API\Airavata_getGatewayComputeResourcePreference_args();
    $args->gatewayID = $gatewayID;
    $args->computeResourceId = $computeResourceId;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'getGatewayComputeResourcePreference', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('getGatewayComputeResourcePreference', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_getGatewayComputeResourcePreference()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Airavata\API\Airavata_getGatewayComputeResourcePreference_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Airavata\API\Airavata_getGatewayComputeResourcePreference_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->ire !== null) {
      throw $result->ire;
    }
    if ($result->ace !== null) {
      throw $result->ace;
    }
    if ($result->ase !== null) {
      throw $result->ase;
    }
    throw new \Exception("getGatewayComputeResourcePreference failed: unknown result");
  }

  public function getAllGatewayComputeResourcePreferences($gatewayID)
  {
    $this->send_getAllGatewayComputeResourcePreferences($gatewayID);
    return $this->recv_getAllGatewayComputeResourcePreferences();
  }

  public function send_getAllGatewayComputeResourcePreferences($gatewayID)
  {
    $args = new \Airavata\API\Airavata_getAllGatewayComputeResourcePreferences_args();
    $args->gatewayID = $gatewayID;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'getAllGatewayComputeResourcePreferences', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('getAllGatewayComputeResourcePreferences', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_getAllGatewayComputeResourcePreferences()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Airavata\API\Airavata_getAllGatewayComputeResourcePreferences_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Airavata\API\Airavata_getAllGatewayComputeResourcePreferences_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->ire !== null) {
      throw $result->ire;
    }
    if ($result->ace !== null) {
      throw $result->ace;
    }
    if ($result->ase !== null) {
      throw $result->ase;
    }
    throw new \Exception("getAllGatewayComputeResourcePreferences failed: unknown result");
  }

  public function updateGatewayComputeResourcePreference($gatewayID, $computeResourceId, \Airavata\Model\AppCatalog\GatewayProfile\ComputeResourcePreference $computeResourcePreference)
  {
    $this->send_updateGatewayComputeResourcePreference($gatewayID, $computeResourceId, $computeResourcePreference);
    return $this->recv_updateGatewayComputeResourcePreference();
  }

  public function send_updateGatewayComputeResourcePreference($gatewayID, $computeResourceId, \Airavata\Model\AppCatalog\GatewayProfile\ComputeResourcePreference $computeResourcePreference)
  {
    $args = new \Airavata\API\Airavata_updateGatewayComputeResourcePreference_args();
    $args->gatewayID = $gatewayID;
    $args->computeResourceId = $computeResourceId;
    $args->computeResourcePreference = $computeResourcePreference;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'updateGatewayComputeResourcePreference', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('updateGatewayComputeResourcePreference', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_updateGatewayComputeResourcePreference()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Airavata\API\Airavata_updateGatewayComputeResourcePreference_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Airavata\API\Airavata_updateGatewayComputeResourcePreference_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->ire !== null) {
      throw $result->ire;
    }
    if ($result->ace !== null) {
      throw $result->ace;
    }
    if ($result->ase !== null) {
      throw $result->ase;
    }
    throw new \Exception("updateGatewayComputeResourcePreference failed: unknown result");
  }

  public function deleteGatewayComputeResourcePreference($gatewayID, $computeResourceId)
  {
    $this->send_deleteGatewayComputeResourcePreference($gatewayID, $computeResourceId);
    return $this->recv_deleteGatewayComputeResourcePreference();
  }

  public function send_deleteGatewayComputeResourcePreference($gatewayID, $computeResourceId)
  {
    $args = new \Airavata\API\Airavata_deleteGatewayComputeResourcePreference_args();
    $args->gatewayID = $gatewayID;
    $args->computeResourceId = $computeResourceId;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'deleteGatewayComputeResourcePreference', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('deleteGatewayComputeResourcePreference', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_deleteGatewayComputeResourcePreference()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Airavata\API\Airavata_deleteGatewayComputeResourcePreference_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Airavata\API\Airavata_deleteGatewayComputeResourcePreference_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->ire !== null) {
      throw $result->ire;
    }
    if ($result->ace !== null) {
      throw $result->ace;
    }
    if ($result->ase !== null) {
      throw $result->ase;
    }
    throw new \Exception("deleteGatewayComputeResourcePreference failed: unknown result");
  }

  public function getAllWorkflows()
  {
    $this->send_getAllWorkflows();
    return $this->recv_getAllWorkflows();
  }

  public function send_getAllWorkflows()
  {
    $args = new \Airavata\API\Airavata_getAllWorkflows_args();
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'getAllWorkflows', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('getAllWorkflows', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_getAllWorkflows()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Airavata\API\Airavata_getAllWorkflows_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Airavata\API\Airavata_getAllWorkflows_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->ire !== null) {
      throw $result->ire;
    }
    if ($result->ace !== null) {
      throw $result->ace;
    }
    if ($result->ase !== null) {
      throw $result->ase;
    }
    throw new \Exception("getAllWorkflows failed: unknown result");
  }

  public function getWorkflow($workflowTemplateId)
  {
    $this->send_getWorkflow($workflowTemplateId);
    return $this->recv_getWorkflow();
  }

  public function send_getWorkflow($workflowTemplateId)
  {
    $args = new \Airavata\API\Airavata_getWorkflow_args();
    $args->workflowTemplateId = $workflowTemplateId;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'getWorkflow', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('getWorkflow', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_getWorkflow()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Airavata\API\Airavata_getWorkflow_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Airavata\API\Airavata_getWorkflow_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->ire !== null) {
      throw $result->ire;
    }
    if ($result->ace !== null) {
      throw $result->ace;
    }
    if ($result->ase !== null) {
      throw $result->ase;
    }
    throw new \Exception("getWorkflow failed: unknown result");
  }

  public function deleteWorkflow($workflowTemplateId)
  {
    $this->send_deleteWorkflow($workflowTemplateId);
    $this->recv_deleteWorkflow();
  }

  public function send_deleteWorkflow($workflowTemplateId)
  {
    $args = new \Airavata\API\Airavata_deleteWorkflow_args();
    $args->workflowTemplateId = $workflowTemplateId;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'deleteWorkflow', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('deleteWorkflow', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_deleteWorkflow()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Airavata\API\Airavata_deleteWorkflow_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Airavata\API\Airavata_deleteWorkflow_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->ire !== null) {
      throw $result->ire;
    }
    if ($result->ace !== null) {
      throw $result->ace;
    }
    if ($result->ase !== null) {
      throw $result->ase;
    }
    return;
  }

  public function registerWorkflow(\Airavata\Model\Workflow $workflow)
  {
    $this->send_registerWorkflow($workflow);
    return $this->recv_registerWorkflow();
  }

  public function send_registerWorkflow(\Airavata\Model\Workflow $workflow)
  {
    $args = new \Airavata\API\Airavata_registerWorkflow_args();
    $args->workflow = $workflow;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'registerWorkflow', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('registerWorkflow', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_registerWorkflow()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Airavata\API\Airavata_registerWorkflow_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Airavata\API\Airavata_registerWorkflow_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->ire !== null) {
      throw $result->ire;
    }
    if ($result->ace !== null) {
      throw $result->ace;
    }
    if ($result->ase !== null) {
      throw $result->ase;
    }
    throw new \Exception("registerWorkflow failed: unknown result");
  }

  public function updateWorkflow($workflowTemplateId, \Airavata\Model\Workflow $workflow)
  {
    $this->send_updateWorkflow($workflowTemplateId, $workflow);
    $this->recv_updateWorkflow();
  }

  public function send_updateWorkflow($workflowTemplateId, \Airavata\Model\Workflow $workflow)
  {
    $args = new \Airavata\API\Airavata_updateWorkflow_args();
    $args->workflowTemplateId = $workflowTemplateId;
    $args->workflow = $workflow;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'updateWorkflow', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('updateWorkflow', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_updateWorkflow()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Airavata\API\Airavata_updateWorkflow_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Airavata\API\Airavata_updateWorkflow_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->ire !== null) {
      throw $result->ire;
    }
    if ($result->ace !== null) {
      throw $result->ace;
    }
    if ($result->ase !== null) {
      throw $result->ase;
    }
    return;
  }

  public function getWorkflowTemplateId($workflowName)
  {
    $this->send_getWorkflowTemplateId($workflowName);
    return $this->recv_getWorkflowTemplateId();
  }

  public function send_getWorkflowTemplateId($workflowName)
  {
    $args = new \Airavata\API\Airavata_getWorkflowTemplateId_args();
    $args->workflowName = $workflowName;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'getWorkflowTemplateId', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('getWorkflowTemplateId', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_getWorkflowTemplateId()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Airavata\API\Airavata_getWorkflowTemplateId_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Airavata\API\Airavata_getWorkflowTemplateId_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->ire !== null) {
      throw $result->ire;
    }
    if ($result->ace !== null) {
      throw $result->ace;
    }
    if ($result->ase !== null) {
      throw $result->ase;
    }
    throw new \Exception("getWorkflowTemplateId failed: unknown result");
  }

  public function isWorkflowExistWithName($workflowName)
  {
    $this->send_isWorkflowExistWithName($workflowName);
    return $this->recv_isWorkflowExistWithName();
  }

  public function send_isWorkflowExistWithName($workflowName)
  {
    $args = new \Airavata\API\Airavata_isWorkflowExistWithName_args();
    $args->workflowName = $workflowName;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'isWorkflowExistWithName', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('isWorkflowExistWithName', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_isWorkflowExistWithName()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Airavata\API\Airavata_isWorkflowExistWithName_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Airavata\API\Airavata_isWorkflowExistWithName_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->ire !== null) {
      throw $result->ire;
    }
    if ($result->ace !== null) {
      throw $result->ace;
    }
    if ($result->ase !== null) {
      throw $result->ase;
    }
    throw new \Exception("isWorkflowExistWithName failed: unknown result");
  }

}

// HELPER FUNCTIONS AND STRUCTURES

class Airavata_getAPIVersion_args {
  static $_TSPEC;


  public function __construct() {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        );
    }
  }

  public function getName() {
    return 'Airavata_getAPIVersion_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Airavata_getAPIVersion_args');
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Airavata_getAPIVersion_result {
  static $_TSPEC;

  public $success = null;
  public $ire = null;
  public $ace = null;
  public $ase = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::STRING,
          ),
        1 => array(
          'var' => 'ire',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\InvalidRequestException',
          ),
        2 => array(
          'var' => 'ace',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AiravataClientException',
          ),
        3 => array(
          'var' => 'ase',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AiravataSystemException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['ire'])) {
        $this->ire = $vals['ire'];
      }
      if (isset($vals['ace'])) {
        $this->ace = $vals['ace'];
      }
      if (isset($vals['ase'])) {
        $this->ase = $vals['ase'];
      }
    }
  }

  public function getName() {
    return 'Airavata_getAPIVersion_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->success);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->ire = new \Airavata\API\Error\InvalidRequestException();
            $xfer += $this->ire->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->ace = new \Airavata\API\Error\AiravataClientException();
            $xfer += $this->ace->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRUCT) {
            $this->ase = new \Airavata\API\Error\AiravataSystemException();
            $xfer += $this->ase->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Airavata_getAPIVersion_result');
    if ($this->success !== null) {
      $xfer += $output->writeFieldBegin('success', TType::STRING, 0);
      $xfer += $output->writeString($this->success);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ire !== null) {
      $xfer += $output->writeFieldBegin('ire', TType::STRUCT, 1);
      $xfer += $this->ire->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ace !== null) {
      $xfer += $output->writeFieldBegin('ace', TType::STRUCT, 2);
      $xfer += $this->ace->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ase !== null) {
      $xfer += $output->writeFieldBegin('ase', TType::STRUCT, 3);
      $xfer += $this->ase->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Airavata_createProject_args {
  static $_TSPEC;

  public $project = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'project',
          'type' => TType::STRUCT,
          'class' => '\Airavata\Model\Workspace\Project',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['project'])) {
        $this->project = $vals['project'];
      }
    }
  }

  public function getName() {
    return 'Airavata_createProject_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->project = new \Airavata\Model\Workspace\Project();
            $xfer += $this->project->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Airavata_createProject_args');
    if ($this->project !== null) {
      if (!is_object($this->project)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('project', TType::STRUCT, 1);
      $xfer += $this->project->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Airavata_createProject_result {
  static $_TSPEC;

  public $success = null;
  public $ire = null;
  public $ace = null;
  public $ase = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::STRING,
          ),
        1 => array(
          'var' => 'ire',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\InvalidRequestException',
          ),
        2 => array(
          'var' => 'ace',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AiravataClientException',
          ),
        3 => array(
          'var' => 'ase',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AiravataSystemException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['ire'])) {
        $this->ire = $vals['ire'];
      }
      if (isset($vals['ace'])) {
        $this->ace = $vals['ace'];
      }
      if (isset($vals['ase'])) {
        $this->ase = $vals['ase'];
      }
    }
  }

  public function getName() {
    return 'Airavata_createProject_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->success);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->ire = new \Airavata\API\Error\InvalidRequestException();
            $xfer += $this->ire->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->ace = new \Airavata\API\Error\AiravataClientException();
            $xfer += $this->ace->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRUCT) {
            $this->ase = new \Airavata\API\Error\AiravataSystemException();
            $xfer += $this->ase->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Airavata_createProject_result');
    if ($this->success !== null) {
      $xfer += $output->writeFieldBegin('success', TType::STRING, 0);
      $xfer += $output->writeString($this->success);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ire !== null) {
      $xfer += $output->writeFieldBegin('ire', TType::STRUCT, 1);
      $xfer += $this->ire->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ace !== null) {
      $xfer += $output->writeFieldBegin('ace', TType::STRUCT, 2);
      $xfer += $this->ace->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ase !== null) {
      $xfer += $output->writeFieldBegin('ase', TType::STRUCT, 3);
      $xfer += $this->ase->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Airavata_updateProject_args {
  static $_TSPEC;

  public $projectId = null;
  public $updatedProject = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'projectId',
          'type' => TType::STRING,
          ),
        2 => array(
          'var' => 'updatedProject',
          'type' => TType::STRUCT,
          'class' => '\Airavata\Model\Workspace\Project',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['projectId'])) {
        $this->projectId = $vals['projectId'];
      }
      if (isset($vals['updatedProject'])) {
        $this->updatedProject = $vals['updatedProject'];
      }
    }
  }

  public function getName() {
    return 'Airavata_updateProject_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->projectId);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->updatedProject = new \Airavata\Model\Workspace\Project();
            $xfer += $this->updatedProject->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Airavata_updateProject_args');
    if ($this->projectId !== null) {
      $xfer += $output->writeFieldBegin('projectId', TType::STRING, 1);
      $xfer += $output->writeString($this->projectId);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->updatedProject !== null) {
      if (!is_object($this->updatedProject)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('updatedProject', TType::STRUCT, 2);
      $xfer += $this->updatedProject->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Airavata_updateProject_result {
  static $_TSPEC;

  public $ire = null;
  public $ace = null;
  public $ase = null;
  public $pnfe = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'ire',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\InvalidRequestException',
          ),
        2 => array(
          'var' => 'ace',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AiravataClientException',
          ),
        3 => array(
          'var' => 'ase',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AiravataSystemException',
          ),
        4 => array(
          'var' => 'pnfe',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\ProjectNotFoundException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['ire'])) {
        $this->ire = $vals['ire'];
      }
      if (isset($vals['ace'])) {
        $this->ace = $vals['ace'];
      }
      if (isset($vals['ase'])) {
        $this->ase = $vals['ase'];
      }
      if (isset($vals['pnfe'])) {
        $this->pnfe = $vals['pnfe'];
      }
    }
  }

  public function getName() {
    return 'Airavata_updateProject_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->ire = new \Airavata\API\Error\InvalidRequestException();
            $xfer += $this->ire->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->ace = new \Airavata\API\Error\AiravataClientException();
            $xfer += $this->ace->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRUCT) {
            $this->ase = new \Airavata\API\Error\AiravataSystemException();
            $xfer += $this->ase->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 4:
          if ($ftype == TType::STRUCT) {
            $this->pnfe = new \Airavata\API\Error\ProjectNotFoundException();
            $xfer += $this->pnfe->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Airavata_updateProject_result');
    if ($this->ire !== null) {
      $xfer += $output->writeFieldBegin('ire', TType::STRUCT, 1);
      $xfer += $this->ire->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ace !== null) {
      $xfer += $output->writeFieldBegin('ace', TType::STRUCT, 2);
      $xfer += $this->ace->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ase !== null) {
      $xfer += $output->writeFieldBegin('ase', TType::STRUCT, 3);
      $xfer += $this->ase->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->pnfe !== null) {
      $xfer += $output->writeFieldBegin('pnfe', TType::STRUCT, 4);
      $xfer += $this->pnfe->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Airavata_getProject_args {
  static $_TSPEC;

  public $projectId = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'projectId',
          'type' => TType::STRING,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['projectId'])) {
        $this->projectId = $vals['projectId'];
      }
    }
  }

  public function getName() {
    return 'Airavata_getProject_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->projectId);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Airavata_getProject_args');
    if ($this->projectId !== null) {
      $xfer += $output->writeFieldBegin('projectId', TType::STRING, 1);
      $xfer += $output->writeString($this->projectId);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Airavata_getProject_result {
  static $_TSPEC;

  public $success = null;
  public $ire = null;
  public $ace = null;
  public $ase = null;
  public $pnfe = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::STRUCT,
          'class' => '\Airavata\Model\Workspace\Project',
          ),
        1 => array(
          'var' => 'ire',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\InvalidRequestException',
          ),
        2 => array(
          'var' => 'ace',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AiravataClientException',
          ),
        3 => array(
          'var' => 'ase',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AiravataSystemException',
          ),
        4 => array(
          'var' => 'pnfe',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\ProjectNotFoundException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['ire'])) {
        $this->ire = $vals['ire'];
      }
      if (isset($vals['ace'])) {
        $this->ace = $vals['ace'];
      }
      if (isset($vals['ase'])) {
        $this->ase = $vals['ase'];
      }
      if (isset($vals['pnfe'])) {
        $this->pnfe = $vals['pnfe'];
      }
    }
  }

  public function getName() {
    return 'Airavata_getProject_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::STRUCT) {
            $this->success = new \Airavata\Model\Workspace\Project();
            $xfer += $this->success->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->ire = new \Airavata\API\Error\InvalidRequestException();
            $xfer += $this->ire->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->ace = new \Airavata\API\Error\AiravataClientException();
            $xfer += $this->ace->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRUCT) {
            $this->ase = new \Airavata\API\Error\AiravataSystemException();
            $xfer += $this->ase->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 4:
          if ($ftype == TType::STRUCT) {
            $this->pnfe = new \Airavata\API\Error\ProjectNotFoundException();
            $xfer += $this->pnfe->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Airavata_getProject_result');
    if ($this->success !== null) {
      if (!is_object($this->success)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('success', TType::STRUCT, 0);
      $xfer += $this->success->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ire !== null) {
      $xfer += $output->writeFieldBegin('ire', TType::STRUCT, 1);
      $xfer += $this->ire->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ace !== null) {
      $xfer += $output->writeFieldBegin('ace', TType::STRUCT, 2);
      $xfer += $this->ace->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ase !== null) {
      $xfer += $output->writeFieldBegin('ase', TType::STRUCT, 3);
      $xfer += $this->ase->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->pnfe !== null) {
      $xfer += $output->writeFieldBegin('pnfe', TType::STRUCT, 4);
      $xfer += $this->pnfe->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Airavata_getAllUserProjects_args {
  static $_TSPEC;

  public $userName = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'userName',
          'type' => TType::STRING,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['userName'])) {
        $this->userName = $vals['userName'];
      }
    }
  }

  public function getName() {
    return 'Airavata_getAllUserProjects_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->userName);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Airavata_getAllUserProjects_args');
    if ($this->userName !== null) {
      $xfer += $output->writeFieldBegin('userName', TType::STRING, 1);
      $xfer += $output->writeString($this->userName);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Airavata_getAllUserProjects_result {
  static $_TSPEC;

  public $success = null;
  public $ire = null;
  public $ace = null;
  public $ase = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::LST,
          'etype' => TType::STRUCT,
          'elem' => array(
            'type' => TType::STRUCT,
            'class' => '\Airavata\Model\Workspace\Project',
            ),
          ),
        1 => array(
          'var' => 'ire',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\InvalidRequestException',
          ),
        2 => array(
          'var' => 'ace',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AiravataClientException',
          ),
        3 => array(
          'var' => 'ase',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AiravataSystemException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['ire'])) {
        $this->ire = $vals['ire'];
      }
      if (isset($vals['ace'])) {
        $this->ace = $vals['ace'];
      }
      if (isset($vals['ase'])) {
        $this->ase = $vals['ase'];
      }
    }
  }

  public function getName() {
    return 'Airavata_getAllUserProjects_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::LST) {
            $this->success = array();
            $_size0 = 0;
            $_etype3 = 0;
            $xfer += $input->readListBegin($_etype3, $_size0);
            for ($_i4 = 0; $_i4 < $_size0; ++$_i4)
            {
              $elem5 = null;
              $elem5 = new \Airavata\Model\Workspace\Project();
              $xfer += $elem5->read($input);
              $this->success []= $elem5;
            }
            $xfer += $input->readListEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->ire = new \Airavata\API\Error\InvalidRequestException();
            $xfer += $this->ire->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->ace = new \Airavata\API\Error\AiravataClientException();
            $xfer += $this->ace->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRUCT) {
            $this->ase = new \Airavata\API\Error\AiravataSystemException();
            $xfer += $this->ase->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Airavata_getAllUserProjects_result');
    if ($this->success !== null) {
      if (!is_array($this->success)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('success', TType::LST, 0);
      {
        $output->writeListBegin(TType::STRUCT, count($this->success));
        {
          foreach ($this->success as $iter6)
          {
            $xfer += $iter6->write($output);
          }
        }
        $output->writeListEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ire !== null) {
      $xfer += $output->writeFieldBegin('ire', TType::STRUCT, 1);
      $xfer += $this->ire->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ace !== null) {
      $xfer += $output->writeFieldBegin('ace', TType::STRUCT, 2);
      $xfer += $this->ace->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ase !== null) {
      $xfer += $output->writeFieldBegin('ase', TType::STRUCT, 3);
      $xfer += $this->ase->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Airavata_searchProjectsByProjectName_args {
  static $_TSPEC;

  public $userName = null;
  public $projectName = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'userName',
          'type' => TType::STRING,
          ),
        2 => array(
          'var' => 'projectName',
          'type' => TType::STRING,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['userName'])) {
        $this->userName = $vals['userName'];
      }
      if (isset($vals['projectName'])) {
        $this->projectName = $vals['projectName'];
      }
    }
  }

  public function getName() {
    return 'Airavata_searchProjectsByProjectName_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->userName);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->projectName);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Airavata_searchProjectsByProjectName_args');
    if ($this->userName !== null) {
      $xfer += $output->writeFieldBegin('userName', TType::STRING, 1);
      $xfer += $output->writeString($this->userName);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->projectName !== null) {
      $xfer += $output->writeFieldBegin('projectName', TType::STRING, 2);
      $xfer += $output->writeString($this->projectName);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Airavata_searchProjectsByProjectName_result {
  static $_TSPEC;

  public $success = null;
  public $ire = null;
  public $ace = null;
  public $ase = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::LST,
          'etype' => TType::STRUCT,
          'elem' => array(
            'type' => TType::STRUCT,
            'class' => '\Airavata\Model\Workspace\Project',
            ),
          ),
        1 => array(
          'var' => 'ire',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\InvalidRequestException',
          ),
        2 => array(
          'var' => 'ace',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AiravataClientException',
          ),
        3 => array(
          'var' => 'ase',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AiravataSystemException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['ire'])) {
        $this->ire = $vals['ire'];
      }
      if (isset($vals['ace'])) {
        $this->ace = $vals['ace'];
      }
      if (isset($vals['ase'])) {
        $this->ase = $vals['ase'];
      }
    }
  }

  public function getName() {
    return 'Airavata_searchProjectsByProjectName_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::LST) {
            $this->success = array();
            $_size7 = 0;
            $_etype10 = 0;
            $xfer += $input->readListBegin($_etype10, $_size7);
            for ($_i11 = 0; $_i11 < $_size7; ++$_i11)
            {
              $elem12 = null;
              $elem12 = new \Airavata\Model\Workspace\Project();
              $xfer += $elem12->read($input);
              $this->success []= $elem12;
            }
            $xfer += $input->readListEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->ire = new \Airavata\API\Error\InvalidRequestException();
            $xfer += $this->ire->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->ace = new \Airavata\API\Error\AiravataClientException();
            $xfer += $this->ace->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRUCT) {
            $this->ase = new \Airavata\API\Error\AiravataSystemException();
            $xfer += $this->ase->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Airavata_searchProjectsByProjectName_result');
    if ($this->success !== null) {
      if (!is_array($this->success)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('success', TType::LST, 0);
      {
        $output->writeListBegin(TType::STRUCT, count($this->success));
        {
          foreach ($this->success as $iter13)
          {
            $xfer += $iter13->write($output);
          }
        }
        $output->writeListEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ire !== null) {
      $xfer += $output->writeFieldBegin('ire', TType::STRUCT, 1);
      $xfer += $this->ire->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ace !== null) {
      $xfer += $output->writeFieldBegin('ace', TType::STRUCT, 2);
      $xfer += $this->ace->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ase !== null) {
      $xfer += $output->writeFieldBegin('ase', TType::STRUCT, 3);
      $xfer += $this->ase->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Airavata_searchProjectsByProjectDesc_args {
  static $_TSPEC;

  public $userName = null;
  public $description = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'userName',
          'type' => TType::STRING,
          ),
        2 => array(
          'var' => 'description',
          'type' => TType::STRING,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['userName'])) {
        $this->userName = $vals['userName'];
      }
      if (isset($vals['description'])) {
        $this->description = $vals['description'];
      }
    }
  }

  public function getName() {
    return 'Airavata_searchProjectsByProjectDesc_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->userName);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->description);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Airavata_searchProjectsByProjectDesc_args');
    if ($this->userName !== null) {
      $xfer += $output->writeFieldBegin('userName', TType::STRING, 1);
      $xfer += $output->writeString($this->userName);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->description !== null) {
      $xfer += $output->writeFieldBegin('description', TType::STRING, 2);
      $xfer += $output->writeString($this->description);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Airavata_searchProjectsByProjectDesc_result {
  static $_TSPEC;

  public $success = null;
  public $ire = null;
  public $ace = null;
  public $ase = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::LST,
          'etype' => TType::STRUCT,
          'elem' => array(
            'type' => TType::STRUCT,
            'class' => '\Airavata\Model\Workspace\Project',
            ),
          ),
        1 => array(
          'var' => 'ire',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\InvalidRequestException',
          ),
        2 => array(
          'var' => 'ace',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AiravataClientException',
          ),
        3 => array(
          'var' => 'ase',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AiravataSystemException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['ire'])) {
        $this->ire = $vals['ire'];
      }
      if (isset($vals['ace'])) {
        $this->ace = $vals['ace'];
      }
      if (isset($vals['ase'])) {
        $this->ase = $vals['ase'];
      }
    }
  }

  public function getName() {
    return 'Airavata_searchProjectsByProjectDesc_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::LST) {
            $this->success = array();
            $_size14 = 0;
            $_etype17 = 0;
            $xfer += $input->readListBegin($_etype17, $_size14);
            for ($_i18 = 0; $_i18 < $_size14; ++$_i18)
            {
              $elem19 = null;
              $elem19 = new \Airavata\Model\Workspace\Project();
              $xfer += $elem19->read($input);
              $this->success []= $elem19;
            }
            $xfer += $input->readListEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->ire = new \Airavata\API\Error\InvalidRequestException();
            $xfer += $this->ire->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->ace = new \Airavata\API\Error\AiravataClientException();
            $xfer += $this->ace->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRUCT) {
            $this->ase = new \Airavata\API\Error\AiravataSystemException();
            $xfer += $this->ase->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Airavata_searchProjectsByProjectDesc_result');
    if ($this->success !== null) {
      if (!is_array($this->success)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('success', TType::LST, 0);
      {
        $output->writeListBegin(TType::STRUCT, count($this->success));
        {
          foreach ($this->success as $iter20)
          {
            $xfer += $iter20->write($output);
          }
        }
        $output->writeListEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ire !== null) {
      $xfer += $output->writeFieldBegin('ire', TType::STRUCT, 1);
      $xfer += $this->ire->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ace !== null) {
      $xfer += $output->writeFieldBegin('ace', TType::STRUCT, 2);
      $xfer += $this->ace->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ase !== null) {
      $xfer += $output->writeFieldBegin('ase', TType::STRUCT, 3);
      $xfer += $this->ase->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Airavata_searchExperimentsByName_args {
  static $_TSPEC;

  public $userName = null;
  public $expName = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'userName',
          'type' => TType::STRING,
          ),
        2 => array(
          'var' => 'expName',
          'type' => TType::STRING,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['userName'])) {
        $this->userName = $vals['userName'];
      }
      if (isset($vals['expName'])) {
        $this->expName = $vals['expName'];
      }
    }
  }

  public function getName() {
    return 'Airavata_searchExperimentsByName_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->userName);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->expName);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Airavata_searchExperimentsByName_args');
    if ($this->userName !== null) {
      $xfer += $output->writeFieldBegin('userName', TType::STRING, 1);
      $xfer += $output->writeString($this->userName);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->expName !== null) {
      $xfer += $output->writeFieldBegin('expName', TType::STRING, 2);
      $xfer += $output->writeString($this->expName);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Airavata_searchExperimentsByName_result {
  static $_TSPEC;

  public $success = null;
  public $ire = null;
  public $ace = null;
  public $ase = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::LST,
          'etype' => TType::STRUCT,
          'elem' => array(
            'type' => TType::STRUCT,
            'class' => '\Airavata\Model\Workspace\Experiment\ExperimentSummary',
            ),
          ),
        1 => array(
          'var' => 'ire',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\InvalidRequestException',
          ),
        2 => array(
          'var' => 'ace',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AiravataClientException',
          ),
        3 => array(
          'var' => 'ase',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AiravataSystemException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['ire'])) {
        $this->ire = $vals['ire'];
      }
      if (isset($vals['ace'])) {
        $this->ace = $vals['ace'];
      }
      if (isset($vals['ase'])) {
        $this->ase = $vals['ase'];
      }
    }
  }

  public function getName() {
    return 'Airavata_searchExperimentsByName_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::LST) {
            $this->success = array();
            $_size21 = 0;
            $_etype24 = 0;
            $xfer += $input->readListBegin($_etype24, $_size21);
            for ($_i25 = 0; $_i25 < $_size21; ++$_i25)
            {
              $elem26 = null;
              $elem26 = new \Airavata\Model\Workspace\Experiment\ExperimentSummary();
              $xfer += $elem26->read($input);
              $this->success []= $elem26;
            }
            $xfer += $input->readListEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->ire = new \Airavata\API\Error\InvalidRequestException();
            $xfer += $this->ire->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->ace = new \Airavata\API\Error\AiravataClientException();
            $xfer += $this->ace->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRUCT) {
            $this->ase = new \Airavata\API\Error\AiravataSystemException();
            $xfer += $this->ase->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Airavata_searchExperimentsByName_result');
    if ($this->success !== null) {
      if (!is_array($this->success)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('success', TType::LST, 0);
      {
        $output->writeListBegin(TType::STRUCT, count($this->success));
        {
          foreach ($this->success as $iter27)
          {
            $xfer += $iter27->write($output);
          }
        }
        $output->writeListEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ire !== null) {
      $xfer += $output->writeFieldBegin('ire', TType::STRUCT, 1);
      $xfer += $this->ire->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ace !== null) {
      $xfer += $output->writeFieldBegin('ace', TType::STRUCT, 2);
      $xfer += $this->ace->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ase !== null) {
      $xfer += $output->writeFieldBegin('ase', TType::STRUCT, 3);
      $xfer += $this->ase->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Airavata_searchExperimentsByDesc_args {
  static $_TSPEC;

  public $userName = null;
  public $description = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'userName',
          'type' => TType::STRING,
          ),
        2 => array(
          'var' => 'description',
          'type' => TType::STRING,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['userName'])) {
        $this->userName = $vals['userName'];
      }
      if (isset($vals['description'])) {
        $this->description = $vals['description'];
      }
    }
  }

  public function getName() {
    return 'Airavata_searchExperimentsByDesc_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->userName);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->description);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Airavata_searchExperimentsByDesc_args');
    if ($this->userName !== null) {
      $xfer += $output->writeFieldBegin('userName', TType::STRING, 1);
      $xfer += $output->writeString($this->userName);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->description !== null) {
      $xfer += $output->writeFieldBegin('description', TType::STRING, 2);
      $xfer += $output->writeString($this->description);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Airavata_searchExperimentsByDesc_result {
  static $_TSPEC;

  public $success = null;
  public $ire = null;
  public $ace = null;
  public $ase = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::LST,
          'etype' => TType::STRUCT,
          'elem' => array(
            'type' => TType::STRUCT,
            'class' => '\Airavata\Model\Workspace\Experiment\ExperimentSummary',
            ),
          ),
        1 => array(
          'var' => 'ire',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\InvalidRequestException',
          ),
        2 => array(
          'var' => 'ace',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AiravataClientException',
          ),
        3 => array(
          'var' => 'ase',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AiravataSystemException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['ire'])) {
        $this->ire = $vals['ire'];
      }
      if (isset($vals['ace'])) {
        $this->ace = $vals['ace'];
      }
      if (isset($vals['ase'])) {
        $this->ase = $vals['ase'];
      }
    }
  }

  public function getName() {
    return 'Airavata_searchExperimentsByDesc_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::LST) {
            $this->success = array();
            $_size28 = 0;
            $_etype31 = 0;
            $xfer += $input->readListBegin($_etype31, $_size28);
            for ($_i32 = 0; $_i32 < $_size28; ++$_i32)
            {
              $elem33 = null;
              $elem33 = new \Airavata\Model\Workspace\Experiment\ExperimentSummary();
              $xfer += $elem33->read($input);
              $this->success []= $elem33;
            }
            $xfer += $input->readListEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->ire = new \Airavata\API\Error\InvalidRequestException();
            $xfer += $this->ire->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->ace = new \Airavata\API\Error\AiravataClientException();
            $xfer += $this->ace->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRUCT) {
            $this->ase = new \Airavata\API\Error\AiravataSystemException();
            $xfer += $this->ase->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Airavata_searchExperimentsByDesc_result');
    if ($this->success !== null) {
      if (!is_array($this->success)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('success', TType::LST, 0);
      {
        $output->writeListBegin(TType::STRUCT, count($this->success));
        {
          foreach ($this->success as $iter34)
          {
            $xfer += $iter34->write($output);
          }
        }
        $output->writeListEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ire !== null) {
      $xfer += $output->writeFieldBegin('ire', TType::STRUCT, 1);
      $xfer += $this->ire->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ace !== null) {
      $xfer += $output->writeFieldBegin('ace', TType::STRUCT, 2);
      $xfer += $this->ace->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ase !== null) {
      $xfer += $output->writeFieldBegin('ase', TType::STRUCT, 3);
      $xfer += $this->ase->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Airavata_searchExperimentsByApplication_args {
  static $_TSPEC;

  public $userName = null;
  public $applicationId = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'userName',
          'type' => TType::STRING,
          ),
        2 => array(
          'var' => 'applicationId',
          'type' => TType::STRING,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['userName'])) {
        $this->userName = $vals['userName'];
      }
      if (isset($vals['applicationId'])) {
        $this->applicationId = $vals['applicationId'];
      }
    }
  }

  public function getName() {
    return 'Airavata_searchExperimentsByApplication_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->userName);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->applicationId);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Airavata_searchExperimentsByApplication_args');
    if ($this->userName !== null) {
      $xfer += $output->writeFieldBegin('userName', TType::STRING, 1);
      $xfer += $output->writeString($this->userName);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->applicationId !== null) {
      $xfer += $output->writeFieldBegin('applicationId', TType::STRING, 2);
      $xfer += $output->writeString($this->applicationId);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Airavata_searchExperimentsByApplication_result {
  static $_TSPEC;

  public $success = null;
  public $ire = null;
  public $ace = null;
  public $ase = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::LST,
          'etype' => TType::STRUCT,
          'elem' => array(
            'type' => TType::STRUCT,
            'class' => '\Airavata\Model\Workspace\Experiment\ExperimentSummary',
            ),
          ),
        1 => array(
          'var' => 'ire',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\InvalidRequestException',
          ),
        2 => array(
          'var' => 'ace',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AiravataClientException',
          ),
        3 => array(
          'var' => 'ase',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AiravataSystemException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['ire'])) {
        $this->ire = $vals['ire'];
      }
      if (isset($vals['ace'])) {
        $this->ace = $vals['ace'];
      }
      if (isset($vals['ase'])) {
        $this->ase = $vals['ase'];
      }
    }
  }

  public function getName() {
    return 'Airavata_searchExperimentsByApplication_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::LST) {
            $this->success = array();
            $_size35 = 0;
            $_etype38 = 0;
            $xfer += $input->readListBegin($_etype38, $_size35);
            for ($_i39 = 0; $_i39 < $_size35; ++$_i39)
            {
              $elem40 = null;
              $elem40 = new \Airavata\Model\Workspace\Experiment\ExperimentSummary();
              $xfer += $elem40->read($input);
              $this->success []= $elem40;
            }
            $xfer += $input->readListEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->ire = new \Airavata\API\Error\InvalidRequestException();
            $xfer += $this->ire->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->ace = new \Airavata\API\Error\AiravataClientException();
            $xfer += $this->ace->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRUCT) {
            $this->ase = new \Airavata\API\Error\AiravataSystemException();
            $xfer += $this->ase->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Airavata_searchExperimentsByApplication_result');
    if ($this->success !== null) {
      if (!is_array($this->success)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('success', TType::LST, 0);
      {
        $output->writeListBegin(TType::STRUCT, count($this->success));
        {
          foreach ($this->success as $iter41)
          {
            $xfer += $iter41->write($output);
          }
        }
        $output->writeListEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ire !== null) {
      $xfer += $output->writeFieldBegin('ire', TType::STRUCT, 1);
      $xfer += $this->ire->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ace !== null) {
      $xfer += $output->writeFieldBegin('ace', TType::STRUCT, 2);
      $xfer += $this->ace->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ase !== null) {
      $xfer += $output->writeFieldBegin('ase', TType::STRUCT, 3);
      $xfer += $this->ase->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Airavata_searchExperimentsByStatus_args {
  static $_TSPEC;

  public $userName = null;
  public $experimentState = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'userName',
          'type' => TType::STRING,
          ),
        2 => array(
          'var' => 'experimentState',
          'type' => TType::I32,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['userName'])) {
        $this->userName = $vals['userName'];
      }
      if (isset($vals['experimentState'])) {
        $this->experimentState = $vals['experimentState'];
      }
    }
  }

  public function getName() {
    return 'Airavata_searchExperimentsByStatus_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->userName);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::I32) {
            $xfer += $input->readI32($this->experimentState);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Airavata_searchExperimentsByStatus_args');
    if ($this->userName !== null) {
      $xfer += $output->writeFieldBegin('userName', TType::STRING, 1);
      $xfer += $output->writeString($this->userName);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->experimentState !== null) {
      $xfer += $output->writeFieldBegin('experimentState', TType::I32, 2);
      $xfer += $output->writeI32($this->experimentState);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Airavata_searchExperimentsByStatus_result {
  static $_TSPEC;

  public $success = null;
  public $ire = null;
  public $ace = null;
  public $ase = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::LST,
          'etype' => TType::STRUCT,
          'elem' => array(
            'type' => TType::STRUCT,
            'class' => '\Airavata\Model\Workspace\Experiment\ExperimentSummary',
            ),
          ),
        1 => array(
          'var' => 'ire',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\InvalidRequestException',
          ),
        2 => array(
          'var' => 'ace',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AiravataClientException',
          ),
        3 => array(
          'var' => 'ase',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AiravataSystemException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['ire'])) {
        $this->ire = $vals['ire'];
      }
      if (isset($vals['ace'])) {
        $this->ace = $vals['ace'];
      }
      if (isset($vals['ase'])) {
        $this->ase = $vals['ase'];
      }
    }
  }

  public function getName() {
    return 'Airavata_searchExperimentsByStatus_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::LST) {
            $this->success = array();
            $_size42 = 0;
            $_etype45 = 0;
            $xfer += $input->readListBegin($_etype45, $_size42);
            for ($_i46 = 0; $_i46 < $_size42; ++$_i46)
            {
              $elem47 = null;
              $elem47 = new \Airavata\Model\Workspace\Experiment\ExperimentSummary();
              $xfer += $elem47->read($input);
              $this->success []= $elem47;
            }
            $xfer += $input->readListEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->ire = new \Airavata\API\Error\InvalidRequestException();
            $xfer += $this->ire->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->ace = new \Airavata\API\Error\AiravataClientException();
            $xfer += $this->ace->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRUCT) {
            $this->ase = new \Airavata\API\Error\AiravataSystemException();
            $xfer += $this->ase->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Airavata_searchExperimentsByStatus_result');
    if ($this->success !== null) {
      if (!is_array($this->success)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('success', TType::LST, 0);
      {
        $output->writeListBegin(TType::STRUCT, count($this->success));
        {
          foreach ($this->success as $iter48)
          {
            $xfer += $iter48->write($output);
          }
        }
        $output->writeListEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ire !== null) {
      $xfer += $output->writeFieldBegin('ire', TType::STRUCT, 1);
      $xfer += $this->ire->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ace !== null) {
      $xfer += $output->writeFieldBegin('ace', TType::STRUCT, 2);
      $xfer += $this->ace->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ase !== null) {
      $xfer += $output->writeFieldBegin('ase', TType::STRUCT, 3);
      $xfer += $this->ase->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Airavata_searchExperimentsByCreationTime_args {
  static $_TSPEC;

  public $userName = null;
  public $fromTime = null;
  public $toTime = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'userName',
          'type' => TType::STRING,
          ),
        2 => array(
          'var' => 'fromTime',
          'type' => TType::I64,
          ),
        3 => array(
          'var' => 'toTime',
          'type' => TType::I64,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['userName'])) {
        $this->userName = $vals['userName'];
      }
      if (isset($vals['fromTime'])) {
        $this->fromTime = $vals['fromTime'];
      }
      if (isset($vals['toTime'])) {
        $this->toTime = $vals['toTime'];
      }
    }
  }

  public function getName() {
    return 'Airavata_searchExperimentsByCreationTime_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->userName);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::I64) {
            $xfer += $input->readI64($this->fromTime);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::I64) {
            $xfer += $input->readI64($this->toTime);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Airavata_searchExperimentsByCreationTime_args');
    if ($this->userName !== null) {
      $xfer += $output->writeFieldBegin('userName', TType::STRING, 1);
      $xfer += $output->writeString($this->userName);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->fromTime !== null) {
      $xfer += $output->writeFieldBegin('fromTime', TType::I64, 2);
      $xfer += $output->writeI64($this->fromTime);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->toTime !== null) {
      $xfer += $output->writeFieldBegin('toTime', TType::I64, 3);
      $xfer += $output->writeI64($this->toTime);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Airavata_searchExperimentsByCreationTime_result {
  static $_TSPEC;

  public $success = null;
  public $ire = null;
  public $ace = null;
  public $ase = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::LST,
          'etype' => TType::STRUCT,
          'elem' => array(
            'type' => TType::STRUCT,
            'class' => '\Airavata\Model\Workspace\Experiment\ExperimentSummary',
            ),
          ),
        1 => array(
          'var' => 'ire',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\InvalidRequestException',
          ),
        2 => array(
          'var' => 'ace',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AiravataClientException',
          ),
        3 => array(
          'var' => 'ase',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AiravataSystemException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['ire'])) {
        $this->ire = $vals['ire'];
      }
      if (isset($vals['ace'])) {
        $this->ace = $vals['ace'];
      }
      if (isset($vals['ase'])) {
        $this->ase = $vals['ase'];
      }
    }
  }

  public function getName() {
    return 'Airavata_searchExperimentsByCreationTime_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::LST) {
            $this->success = array();
            $_size49 = 0;
            $_etype52 = 0;
            $xfer += $input->readListBegin($_etype52, $_size49);
            for ($_i53 = 0; $_i53 < $_size49; ++$_i53)
            {
              $elem54 = null;
              $elem54 = new \Airavata\Model\Workspace\Experiment\ExperimentSummary();
              $xfer += $elem54->read($input);
              $this->success []= $elem54;
            }
            $xfer += $input->readListEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->ire = new \Airavata\API\Error\InvalidRequestException();
            $xfer += $this->ire->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->ace = new \Airavata\API\Error\AiravataClientException();
            $xfer += $this->ace->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRUCT) {
            $this->ase = new \Airavata\API\Error\AiravataSystemException();
            $xfer += $this->ase->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Airavata_searchExperimentsByCreationTime_result');
    if ($this->success !== null) {
      if (!is_array($this->success)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('success', TType::LST, 0);
      {
        $output->writeListBegin(TType::STRUCT, count($this->success));
        {
          foreach ($this->success as $iter55)
          {
            $xfer += $iter55->write($output);
          }
        }
        $output->writeListEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ire !== null) {
      $xfer += $output->writeFieldBegin('ire', TType::STRUCT, 1);
      $xfer += $this->ire->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ace !== null) {
      $xfer += $output->writeFieldBegin('ace', TType::STRUCT, 2);
      $xfer += $this->ace->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ase !== null) {
      $xfer += $output->writeFieldBegin('ase', TType::STRUCT, 3);
      $xfer += $this->ase->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Airavata_getAllExperimentsInProject_args {
  static $_TSPEC;

  public $projectId = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'projectId',
          'type' => TType::STRING,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['projectId'])) {
        $this->projectId = $vals['projectId'];
      }
    }
  }

  public function getName() {
    return 'Airavata_getAllExperimentsInProject_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->projectId);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Airavata_getAllExperimentsInProject_args');
    if ($this->projectId !== null) {
      $xfer += $output->writeFieldBegin('projectId', TType::STRING, 1);
      $xfer += $output->writeString($this->projectId);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Airavata_getAllExperimentsInProject_result {
  static $_TSPEC;

  public $success = null;
  public $ire = null;
  public $ace = null;
  public $ase = null;
  public $pnfe = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::LST,
          'etype' => TType::STRUCT,
          'elem' => array(
            'type' => TType::STRUCT,
            'class' => '\Airavata\Model\Workspace\Experiment\Experiment',
            ),
          ),
        1 => array(
          'var' => 'ire',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\InvalidRequestException',
          ),
        2 => array(
          'var' => 'ace',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AiravataClientException',
          ),
        3 => array(
          'var' => 'ase',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AiravataSystemException',
          ),
        4 => array(
          'var' => 'pnfe',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\ProjectNotFoundException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['ire'])) {
        $this->ire = $vals['ire'];
      }
      if (isset($vals['ace'])) {
        $this->ace = $vals['ace'];
      }
      if (isset($vals['ase'])) {
        $this->ase = $vals['ase'];
      }
      if (isset($vals['pnfe'])) {
        $this->pnfe = $vals['pnfe'];
      }
    }
  }

  public function getName() {
    return 'Airavata_getAllExperimentsInProject_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::LST) {
            $this->success = array();
            $_size56 = 0;
            $_etype59 = 0;
            $xfer += $input->readListBegin($_etype59, $_size56);
            for ($_i60 = 0; $_i60 < $_size56; ++$_i60)
            {
              $elem61 = null;
              $elem61 = new \Airavata\Model\Workspace\Experiment\Experiment();
              $xfer += $elem61->read($input);
              $this->success []= $elem61;
            }
            $xfer += $input->readListEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->ire = new \Airavata\API\Error\InvalidRequestException();
            $xfer += $this->ire->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->ace = new \Airavata\API\Error\AiravataClientException();
            $xfer += $this->ace->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRUCT) {
            $this->ase = new \Airavata\API\Error\AiravataSystemException();
            $xfer += $this->ase->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 4:
          if ($ftype == TType::STRUCT) {
            $this->pnfe = new \Airavata\API\Error\ProjectNotFoundException();
            $xfer += $this->pnfe->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Airavata_getAllExperimentsInProject_result');
    if ($this->success !== null) {
      if (!is_array($this->success)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('success', TType::LST, 0);
      {
        $output->writeListBegin(TType::STRUCT, count($this->success));
        {
          foreach ($this->success as $iter62)
          {
            $xfer += $iter62->write($output);
          }
        }
        $output->writeListEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ire !== null) {
      $xfer += $output->writeFieldBegin('ire', TType::STRUCT, 1);
      $xfer += $this->ire->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ace !== null) {
      $xfer += $output->writeFieldBegin('ace', TType::STRUCT, 2);
      $xfer += $this->ace->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ase !== null) {
      $xfer += $output->writeFieldBegin('ase', TType::STRUCT, 3);
      $xfer += $this->ase->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->pnfe !== null) {
      $xfer += $output->writeFieldBegin('pnfe', TType::STRUCT, 4);
      $xfer += $this->pnfe->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Airavata_getAllUserExperiments_args {
  static $_TSPEC;

  public $userName = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'userName',
          'type' => TType::STRING,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['userName'])) {
        $this->userName = $vals['userName'];
      }
    }
  }

  public function getName() {
    return 'Airavata_getAllUserExperiments_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->userName);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Airavata_getAllUserExperiments_args');
    if ($this->userName !== null) {
      $xfer += $output->writeFieldBegin('userName', TType::STRING, 1);
      $xfer += $output->writeString($this->userName);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Airavata_getAllUserExperiments_result {
  static $_TSPEC;

  public $success = null;
  public $ire = null;
  public $ace = null;
  public $ase = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::LST,
          'etype' => TType::STRUCT,
          'elem' => array(
            'type' => TType::STRUCT,
            'class' => '\Airavata\Model\Workspace\Experiment\Experiment',
            ),
          ),
        1 => array(
          'var' => 'ire',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\InvalidRequestException',
          ),
        2 => array(
          'var' => 'ace',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AiravataClientException',
          ),
        3 => array(
          'var' => 'ase',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AiravataSystemException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['ire'])) {
        $this->ire = $vals['ire'];
      }
      if (isset($vals['ace'])) {
        $this->ace = $vals['ace'];
      }
      if (isset($vals['ase'])) {
        $this->ase = $vals['ase'];
      }
    }
  }

  public function getName() {
    return 'Airavata_getAllUserExperiments_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::LST) {
            $this->success = array();
            $_size63 = 0;
            $_etype66 = 0;
            $xfer += $input->readListBegin($_etype66, $_size63);
            for ($_i67 = 0; $_i67 < $_size63; ++$_i67)
            {
              $elem68 = null;
              $elem68 = new \Airavata\Model\Workspace\Experiment\Experiment();
              $xfer += $elem68->read($input);
              $this->success []= $elem68;
            }
            $xfer += $input->readListEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->ire = new \Airavata\API\Error\InvalidRequestException();
            $xfer += $this->ire->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->ace = new \Airavata\API\Error\AiravataClientException();
            $xfer += $this->ace->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRUCT) {
            $this->ase = new \Airavata\API\Error\AiravataSystemException();
            $xfer += $this->ase->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Airavata_getAllUserExperiments_result');
    if ($this->success !== null) {
      if (!is_array($this->success)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('success', TType::LST, 0);
      {
        $output->writeListBegin(TType::STRUCT, count($this->success));
        {
          foreach ($this->success as $iter69)
          {
            $xfer += $iter69->write($output);
          }
        }
        $output->writeListEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ire !== null) {
      $xfer += $output->writeFieldBegin('ire', TType::STRUCT, 1);
      $xfer += $this->ire->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ace !== null) {
      $xfer += $output->writeFieldBegin('ace', TType::STRUCT, 2);
      $xfer += $this->ace->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ase !== null) {
      $xfer += $output->writeFieldBegin('ase', TType::STRUCT, 3);
      $xfer += $this->ase->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Airavata_createExperiment_args {
  static $_TSPEC;

  public $experiment = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'experiment',
          'type' => TType::STRUCT,
          'class' => '\Airavata\Model\Workspace\Experiment\Experiment',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['experiment'])) {
        $this->experiment = $vals['experiment'];
      }
    }
  }

  public function getName() {
    return 'Airavata_createExperiment_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->experiment = new \Airavata\Model\Workspace\Experiment\Experiment();
            $xfer += $this->experiment->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Airavata_createExperiment_args');
    if ($this->experiment !== null) {
      if (!is_object($this->experiment)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('experiment', TType::STRUCT, 1);
      $xfer += $this->experiment->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Airavata_createExperiment_result {
  static $_TSPEC;

  public $success = null;
  public $ire = null;
  public $ace = null;
  public $ase = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::STRING,
          ),
        1 => array(
          'var' => 'ire',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\InvalidRequestException',
          ),
        2 => array(
          'var' => 'ace',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AiravataClientException',
          ),
        3 => array(
          'var' => 'ase',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AiravataSystemException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['ire'])) {
        $this->ire = $vals['ire'];
      }
      if (isset($vals['ace'])) {
        $this->ace = $vals['ace'];
      }
      if (isset($vals['ase'])) {
        $this->ase = $vals['ase'];
      }
    }
  }

  public function getName() {
    return 'Airavata_createExperiment_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->success);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->ire = new \Airavata\API\Error\InvalidRequestException();
            $xfer += $this->ire->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->ace = new \Airavata\API\Error\AiravataClientException();
            $xfer += $this->ace->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRUCT) {
            $this->ase = new \Airavata\API\Error\AiravataSystemException();
            $xfer += $this->ase->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Airavata_createExperiment_result');
    if ($this->success !== null) {
      $xfer += $output->writeFieldBegin('success', TType::STRING, 0);
      $xfer += $output->writeString($this->success);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ire !== null) {
      $xfer += $output->writeFieldBegin('ire', TType::STRUCT, 1);
      $xfer += $this->ire->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ace !== null) {
      $xfer += $output->writeFieldBegin('ace', TType::STRUCT, 2);
      $xfer += $this->ace->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ase !== null) {
      $xfer += $output->writeFieldBegin('ase', TType::STRUCT, 3);
      $xfer += $this->ase->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Airavata_getExperiment_args {
  static $_TSPEC;

  public $airavataExperimentId = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'airavataExperimentId',
          'type' => TType::STRING,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['airavataExperimentId'])) {
        $this->airavataExperimentId = $vals['airavataExperimentId'];
      }
    }
  }

  public function getName() {
    return 'Airavata_getExperiment_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->airavataExperimentId);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Airavata_getExperiment_args');
    if ($this->airavataExperimentId !== null) {
      $xfer += $output->writeFieldBegin('airavataExperimentId', TType::STRING, 1);
      $xfer += $output->writeString($this->airavataExperimentId);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Airavata_getExperiment_result {
  static $_TSPEC;

  public $success = null;
  public $ire = null;
  public $enf = null;
  public $ace = null;
  public $ase = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::STRUCT,
          'class' => '\Airavata\Model\Workspace\Experiment\Experiment',
          ),
        1 => array(
          'var' => 'ire',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\InvalidRequestException',
          ),
        2 => array(
          'var' => 'enf',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\ExperimentNotFoundException',
          ),
        3 => array(
          'var' => 'ace',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AiravataClientException',
          ),
        4 => array(
          'var' => 'ase',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AiravataSystemException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['ire'])) {
        $this->ire = $vals['ire'];
      }
      if (isset($vals['enf'])) {
        $this->enf = $vals['enf'];
      }
      if (isset($vals['ace'])) {
        $this->ace = $vals['ace'];
      }
      if (isset($vals['ase'])) {
        $this->ase = $vals['ase'];
      }
    }
  }

  public function getName() {
    return 'Airavata_getExperiment_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::STRUCT) {
            $this->success = new \Airavata\Model\Workspace\Experiment\Experiment();
            $xfer += $this->success->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->ire = new \Airavata\API\Error\InvalidRequestException();
            $xfer += $this->ire->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->enf = new \Airavata\API\Error\ExperimentNotFoundException();
            $xfer += $this->enf->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRUCT) {
            $this->ace = new \Airavata\API\Error\AiravataClientException();
            $xfer += $this->ace->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 4:
          if ($ftype == TType::STRUCT) {
            $this->ase = new \Airavata\API\Error\AiravataSystemException();
            $xfer += $this->ase->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Airavata_getExperiment_result');
    if ($this->success !== null) {
      if (!is_object($this->success)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('success', TType::STRUCT, 0);
      $xfer += $this->success->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ire !== null) {
      $xfer += $output->writeFieldBegin('ire', TType::STRUCT, 1);
      $xfer += $this->ire->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->enf !== null) {
      $xfer += $output->writeFieldBegin('enf', TType::STRUCT, 2);
      $xfer += $this->enf->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ace !== null) {
      $xfer += $output->writeFieldBegin('ace', TType::STRUCT, 3);
      $xfer += $this->ace->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ase !== null) {
      $xfer += $output->writeFieldBegin('ase', TType::STRUCT, 4);
      $xfer += $this->ase->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Airavata_updateExperiment_args {
  static $_TSPEC;

  public $airavataExperimentId = null;
  public $experiment = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'airavataExperimentId',
          'type' => TType::STRING,
          ),
        2 => array(
          'var' => 'experiment',
          'type' => TType::STRUCT,
          'class' => '\Airavata\Model\Workspace\Experiment\Experiment',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['airavataExperimentId'])) {
        $this->airavataExperimentId = $vals['airavataExperimentId'];
      }
      if (isset($vals['experiment'])) {
        $this->experiment = $vals['experiment'];
      }
    }
  }

  public function getName() {
    return 'Airavata_updateExperiment_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->airavataExperimentId);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->experiment = new \Airavata\Model\Workspace\Experiment\Experiment();
            $xfer += $this->experiment->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Airavata_updateExperiment_args');
    if ($this->airavataExperimentId !== null) {
      $xfer += $output->writeFieldBegin('airavataExperimentId', TType::STRING, 1);
      $xfer += $output->writeString($this->airavataExperimentId);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->experiment !== null) {
      if (!is_object($this->experiment)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('experiment', TType::STRUCT, 2);
      $xfer += $this->experiment->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Airavata_updateExperiment_result {
  static $_TSPEC;

  public $ire = null;
  public $enf = null;
  public $ace = null;
  public $ase = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'ire',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\InvalidRequestException',
          ),
        2 => array(
          'var' => 'enf',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\ExperimentNotFoundException',
          ),
        3 => array(
          'var' => 'ace',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AiravataClientException',
          ),
        4 => array(
          'var' => 'ase',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AiravataSystemException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['ire'])) {
        $this->ire = $vals['ire'];
      }
      if (isset($vals['enf'])) {
        $this->enf = $vals['enf'];
      }
      if (isset($vals['ace'])) {
        $this->ace = $vals['ace'];
      }
      if (isset($vals['ase'])) {
        $this->ase = $vals['ase'];
      }
    }
  }

  public function getName() {
    return 'Airavata_updateExperiment_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->ire = new \Airavata\API\Error\InvalidRequestException();
            $xfer += $this->ire->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->enf = new \Airavata\API\Error\ExperimentNotFoundException();
            $xfer += $this->enf->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRUCT) {
            $this->ace = new \Airavata\API\Error\AiravataClientException();
            $xfer += $this->ace->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 4:
          if ($ftype == TType::STRUCT) {
            $this->ase = new \Airavata\API\Error\AiravataSystemException();
            $xfer += $this->ase->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Airavata_updateExperiment_result');
    if ($this->ire !== null) {
      $xfer += $output->writeFieldBegin('ire', TType::STRUCT, 1);
      $xfer += $this->ire->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->enf !== null) {
      $xfer += $output->writeFieldBegin('enf', TType::STRUCT, 2);
      $xfer += $this->enf->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ace !== null) {
      $xfer += $output->writeFieldBegin('ace', TType::STRUCT, 3);
      $xfer += $this->ace->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ase !== null) {
      $xfer += $output->writeFieldBegin('ase', TType::STRUCT, 4);
      $xfer += $this->ase->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Airavata_updateExperimentConfiguration_args {
  static $_TSPEC;

  public $airavataExperimentId = null;
  public $userConfiguration = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'airavataExperimentId',
          'type' => TType::STRING,
          ),
        2 => array(
          'var' => 'userConfiguration',
          'type' => TType::STRUCT,
          'class' => '\Airavata\Model\Workspace\Experiment\UserConfigurationData',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['airavataExperimentId'])) {
        $this->airavataExperimentId = $vals['airavataExperimentId'];
      }
      if (isset($vals['userConfiguration'])) {
        $this->userConfiguration = $vals['userConfiguration'];
      }
    }
  }

  public function getName() {
    return 'Airavata_updateExperimentConfiguration_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->airavataExperimentId);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->userConfiguration = new \Airavata\Model\Workspace\Experiment\UserConfigurationData();
            $xfer += $this->userConfiguration->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Airavata_updateExperimentConfiguration_args');
    if ($this->airavataExperimentId !== null) {
      $xfer += $output->writeFieldBegin('airavataExperimentId', TType::STRING, 1);
      $xfer += $output->writeString($this->airavataExperimentId);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->userConfiguration !== null) {
      if (!is_object($this->userConfiguration)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('userConfiguration', TType::STRUCT, 2);
      $xfer += $this->userConfiguration->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Airavata_updateExperimentConfiguration_result {
  static $_TSPEC;


  public function __construct() {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        );
    }
  }

  public function getName() {
    return 'Airavata_updateExperimentConfiguration_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Airavata_updateExperimentConfiguration_result');
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Airavata_updateResourceScheduleing_args {
  static $_TSPEC;

  public $airavataExperimentId = null;
  public $resourceScheduling = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'airavataExperimentId',
          'type' => TType::STRING,
          ),
        2 => array(
          'var' => 'resourceScheduling',
          'type' => TType::STRUCT,
          'class' => '\Airavata\Model\Workspace\Experiment\ComputationalResourceScheduling',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['airavataExperimentId'])) {
        $this->airavataExperimentId = $vals['airavataExperimentId'];
      }
      if (isset($vals['resourceScheduling'])) {
        $this->resourceScheduling = $vals['resourceScheduling'];
      }
    }
  }

  public function getName() {
    return 'Airavata_updateResourceScheduleing_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->airavataExperimentId);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->resourceScheduling = new \Airavata\Model\Workspace\Experiment\ComputationalResourceScheduling();
            $xfer += $this->resourceScheduling->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Airavata_updateResourceScheduleing_args');
    if ($this->airavataExperimentId !== null) {
      $xfer += $output->writeFieldBegin('airavataExperimentId', TType::STRING, 1);
      $xfer += $output->writeString($this->airavataExperimentId);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->resourceScheduling !== null) {
      if (!is_object($this->resourceScheduling)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('resourceScheduling', TType::STRUCT, 2);
      $xfer += $this->resourceScheduling->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Airavata_updateResourceScheduleing_result {
  static $_TSPEC;


  public function __construct() {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        );
    }
  }

  public function getName() {
    return 'Airavata_updateResourceScheduleing_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Airavata_updateResourceScheduleing_result');
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Airavata_validateExperiment_args {
  static $_TSPEC;

  public $airavataExperimentId = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'airavataExperimentId',
          'type' => TType::STRING,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['airavataExperimentId'])) {
        $this->airavataExperimentId = $vals['airavataExperimentId'];
      }
    }
  }

  public function getName() {
    return 'Airavata_validateExperiment_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->airavataExperimentId);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Airavata_validateExperiment_args');
    if ($this->airavataExperimentId !== null) {
      $xfer += $output->writeFieldBegin('airavataExperimentId', TType::STRING, 1);
      $xfer += $output->writeString($this->airavataExperimentId);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Airavata_validateExperiment_result {
  static $_TSPEC;

  public $success = null;
  public $ire = null;
  public $enf = null;
  public $ace = null;
  public $ase = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::BOOL,
          ),
        1 => array(
          'var' => 'ire',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\InvalidRequestException',
          ),
        2 => array(
          'var' => 'enf',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\ExperimentNotFoundException',
          ),
        3 => array(
          'var' => 'ace',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AiravataClientException',
          ),
        4 => array(
          'var' => 'ase',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AiravataSystemException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['ire'])) {
        $this->ire = $vals['ire'];
      }
      if (isset($vals['enf'])) {
        $this->enf = $vals['enf'];
      }
      if (isset($vals['ace'])) {
        $this->ace = $vals['ace'];
      }
      if (isset($vals['ase'])) {
        $this->ase = $vals['ase'];
      }
    }
  }

  public function getName() {
    return 'Airavata_validateExperiment_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::BOOL) {
            $xfer += $input->readBool($this->success);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->ire = new \Airavata\API\Error\InvalidRequestException();
            $xfer += $this->ire->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->enf = new \Airavata\API\Error\ExperimentNotFoundException();
            $xfer += $this->enf->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRUCT) {
            $this->ace = new \Airavata\API\Error\AiravataClientException();
            $xfer += $this->ace->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 4:
          if ($ftype == TType::STRUCT) {
            $this->ase = new \Airavata\API\Error\AiravataSystemException();
            $xfer += $this->ase->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Airavata_validateExperiment_result');
    if ($this->success !== null) {
      $xfer += $output->writeFieldBegin('success', TType::BOOL, 0);
      $xfer += $output->writeBool($this->success);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ire !== null) {
      $xfer += $output->writeFieldBegin('ire', TType::STRUCT, 1);
      $xfer += $this->ire->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->enf !== null) {
      $xfer += $output->writeFieldBegin('enf', TType::STRUCT, 2);
      $xfer += $this->enf->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ace !== null) {
      $xfer += $output->writeFieldBegin('ace', TType::STRUCT, 3);
      $xfer += $this->ace->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ase !== null) {
      $xfer += $output->writeFieldBegin('ase', TType::STRUCT, 4);
      $xfer += $this->ase->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Airavata_launchExperiment_args {
  static $_TSPEC;

  public $airavataExperimentId = null;
  public $airavataCredStoreToken = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'airavataExperimentId',
          'type' => TType::STRING,
          ),
        2 => array(
          'var' => 'airavataCredStoreToken',
          'type' => TType::STRING,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['airavataExperimentId'])) {
        $this->airavataExperimentId = $vals['airavataExperimentId'];
      }
      if (isset($vals['airavataCredStoreToken'])) {
        $this->airavataCredStoreToken = $vals['airavataCredStoreToken'];
      }
    }
  }

  public function getName() {
    return 'Airavata_launchExperiment_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->airavataExperimentId);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->airavataCredStoreToken);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Airavata_launchExperiment_args');
    if ($this->airavataExperimentId !== null) {
      $xfer += $output->writeFieldBegin('airavataExperimentId', TType::STRING, 1);
      $xfer += $output->writeString($this->airavataExperimentId);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->airavataCredStoreToken !== null) {
      $xfer += $output->writeFieldBegin('airavataCredStoreToken', TType::STRING, 2);
      $xfer += $output->writeString($this->airavataCredStoreToken);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Airavata_launchExperiment_result {
  static $_TSPEC;

  public $ire = null;
  public $enf = null;
  public $ace = null;
  public $ase = null;
  public $lve = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'ire',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\InvalidRequestException',
          ),
        2 => array(
          'var' => 'enf',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\ExperimentNotFoundException',
          ),
        3 => array(
          'var' => 'ace',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AiravataClientException',
          ),
        4 => array(
          'var' => 'ase',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AiravataSystemException',
          ),
        5 => array(
          'var' => 'lve',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\LaunchValidationException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['ire'])) {
        $this->ire = $vals['ire'];
      }
      if (isset($vals['enf'])) {
        $this->enf = $vals['enf'];
      }
      if (isset($vals['ace'])) {
        $this->ace = $vals['ace'];
      }
      if (isset($vals['ase'])) {
        $this->ase = $vals['ase'];
      }
      if (isset($vals['lve'])) {
        $this->lve = $vals['lve'];
      }
    }
  }

  public function getName() {
    return 'Airavata_launchExperiment_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->ire = new \Airavata\API\Error\InvalidRequestException();
            $xfer += $this->ire->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->enf = new \Airavata\API\Error\ExperimentNotFoundException();
            $xfer += $this->enf->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRUCT) {
            $this->ace = new \Airavata\API\Error\AiravataClientException();
            $xfer += $this->ace->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 4:
          if ($ftype == TType::STRUCT) {
            $this->ase = new \Airavata\API\Error\AiravataSystemException();
            $xfer += $this->ase->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 5:
          if ($ftype == TType::STRUCT) {
            $this->lve = new \Airavata\API\Error\LaunchValidationException();
            $xfer += $this->lve->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Airavata_launchExperiment_result');
    if ($this->ire !== null) {
      $xfer += $output->writeFieldBegin('ire', TType::STRUCT, 1);
      $xfer += $this->ire->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->enf !== null) {
      $xfer += $output->writeFieldBegin('enf', TType::STRUCT, 2);
      $xfer += $this->enf->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ace !== null) {
      $xfer += $output->writeFieldBegin('ace', TType::STRUCT, 3);
      $xfer += $this->ace->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ase !== null) {
      $xfer += $output->writeFieldBegin('ase', TType::STRUCT, 4);
      $xfer += $this->ase->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->lve !== null) {
      $xfer += $output->writeFieldBegin('lve', TType::STRUCT, 5);
      $xfer += $this->lve->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Airavata_getExperimentStatus_args {
  static $_TSPEC;

  public $airavataExperimentId = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'airavataExperimentId',
          'type' => TType::STRING,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['airavataExperimentId'])) {
        $this->airavataExperimentId = $vals['airavataExperimentId'];
      }
    }
  }

  public function getName() {
    return 'Airavata_getExperimentStatus_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->airavataExperimentId);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Airavata_getExperimentStatus_args');
    if ($this->airavataExperimentId !== null) {
      $xfer += $output->writeFieldBegin('airavataExperimentId', TType::STRING, 1);
      $xfer += $output->writeString($this->airavataExperimentId);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Airavata_getExperimentStatus_result {
  static $_TSPEC;

  public $success = null;
  public $ire = null;
  public $enf = null;
  public $ace = null;
  public $ase = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::STRUCT,
          'class' => '\Airavata\Model\Workspace\Experiment\ExperimentStatus',
          ),
        1 => array(
          'var' => 'ire',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\InvalidRequestException',
          ),
        2 => array(
          'var' => 'enf',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\ExperimentNotFoundException',
          ),
        3 => array(
          'var' => 'ace',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AiravataClientException',
          ),
        4 => array(
          'var' => 'ase',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AiravataSystemException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['ire'])) {
        $this->ire = $vals['ire'];
      }
      if (isset($vals['enf'])) {
        $this->enf = $vals['enf'];
      }
      if (isset($vals['ace'])) {
        $this->ace = $vals['ace'];
      }
      if (isset($vals['ase'])) {
        $this->ase = $vals['ase'];
      }
    }
  }

  public function getName() {
    return 'Airavata_getExperimentStatus_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::STRUCT) {
            $this->success = new \Airavata\Model\Workspace\Experiment\ExperimentStatus();
            $xfer += $this->success->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->ire = new \Airavata\API\Error\InvalidRequestException();
            $xfer += $this->ire->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->enf = new \Airavata\API\Error\ExperimentNotFoundException();
            $xfer += $this->enf->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRUCT) {
            $this->ace = new \Airavata\API\Error\AiravataClientException();
            $xfer += $this->ace->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 4:
          if ($ftype == TType::STRUCT) {
            $this->ase = new \Airavata\API\Error\AiravataSystemException();
            $xfer += $this->ase->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Airavata_getExperimentStatus_result');
    if ($this->success !== null) {
      if (!is_object($this->success)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('success', TType::STRUCT, 0);
      $xfer += $this->success->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ire !== null) {
      $xfer += $output->writeFieldBegin('ire', TType::STRUCT, 1);
      $xfer += $this->ire->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->enf !== null) {
      $xfer += $output->writeFieldBegin('enf', TType::STRUCT, 2);
      $xfer += $this->enf->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ace !== null) {
      $xfer += $output->writeFieldBegin('ace', TType::STRUCT, 3);
      $xfer += $this->ace->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ase !== null) {
      $xfer += $output->writeFieldBegin('ase', TType::STRUCT, 4);
      $xfer += $this->ase->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Airavata_getExperimentOutputs_args {
  static $_TSPEC;

  public $airavataExperimentId = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'airavataExperimentId',
          'type' => TType::STRING,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['airavataExperimentId'])) {
        $this->airavataExperimentId = $vals['airavataExperimentId'];
      }
    }
  }

  public function getName() {
    return 'Airavata_getExperimentOutputs_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->airavataExperimentId);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Airavata_getExperimentOutputs_args');
    if ($this->airavataExperimentId !== null) {
      $xfer += $output->writeFieldBegin('airavataExperimentId', TType::STRING, 1);
      $xfer += $output->writeString($this->airavataExperimentId);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Airavata_getExperimentOutputs_result {
  static $_TSPEC;

  public $success = null;
  public $ire = null;
  public $enf = null;
  public $ace = null;
  public $ase = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::LST,
          'etype' => TType::STRUCT,
          'elem' => array(
            'type' => TType::STRUCT,
            'class' => '\Airavata\Model\AppCatalog\AppInterface\OutputDataObjectType',
            ),
          ),
        1 => array(
          'var' => 'ire',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\InvalidRequestException',
          ),
        2 => array(
          'var' => 'enf',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\ExperimentNotFoundException',
          ),
        3 => array(
          'var' => 'ace',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AiravataClientException',
          ),
        4 => array(
          'var' => 'ase',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AiravataSystemException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['ire'])) {
        $this->ire = $vals['ire'];
      }
      if (isset($vals['enf'])) {
        $this->enf = $vals['enf'];
      }
      if (isset($vals['ace'])) {
        $this->ace = $vals['ace'];
      }
      if (isset($vals['ase'])) {
        $this->ase = $vals['ase'];
      }
    }
  }

  public function getName() {
    return 'Airavata_getExperimentOutputs_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::LST) {
            $this->success = array();
            $_size70 = 0;
            $_etype73 = 0;
            $xfer += $input->readListBegin($_etype73, $_size70);
            for ($_i74 = 0; $_i74 < $_size70; ++$_i74)
            {
              $elem75 = null;
              $elem75 = new \Airavata\Model\AppCatalog\AppInterface\OutputDataObjectType();
              $xfer += $elem75->read($input);
              $this->success []= $elem75;
            }
            $xfer += $input->readListEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->ire = new \Airavata\API\Error\InvalidRequestException();
            $xfer += $this->ire->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->enf = new \Airavata\API\Error\ExperimentNotFoundException();
            $xfer += $this->enf->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRUCT) {
            $this->ace = new \Airavata\API\Error\AiravataClientException();
            $xfer += $this->ace->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 4:
          if ($ftype == TType::STRUCT) {
            $this->ase = new \Airavata\API\Error\AiravataSystemException();
            $xfer += $this->ase->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Airavata_getExperimentOutputs_result');
    if ($this->success !== null) {
      if (!is_array($this->success)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('success', TType::LST, 0);
      {
        $output->writeListBegin(TType::STRUCT, count($this->success));
        {
          foreach ($this->success as $iter76)
          {
            $xfer += $iter76->write($output);
          }
        }
        $output->writeListEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ire !== null) {
      $xfer += $output->writeFieldBegin('ire', TType::STRUCT, 1);
      $xfer += $this->ire->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->enf !== null) {
      $xfer += $output->writeFieldBegin('enf', TType::STRUCT, 2);
      $xfer += $this->enf->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ace !== null) {
      $xfer += $output->writeFieldBegin('ace', TType::STRUCT, 3);
      $xfer += $this->ace->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ase !== null) {
      $xfer += $output->writeFieldBegin('ase', TType::STRUCT, 4);
      $xfer += $this->ase->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Airavata_getJobStatuses_args {
  static $_TSPEC;

  public $airavataExperimentId = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'airavataExperimentId',
          'type' => TType::STRING,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['airavataExperimentId'])) {
        $this->airavataExperimentId = $vals['airavataExperimentId'];
      }
    }
  }

  public function getName() {
    return 'Airavata_getJobStatuses_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->airavataExperimentId);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Airavata_getJobStatuses_args');
    if ($this->airavataExperimentId !== null) {
      $xfer += $output->writeFieldBegin('airavataExperimentId', TType::STRING, 1);
      $xfer += $output->writeString($this->airavataExperimentId);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Airavata_getJobStatuses_result {
  static $_TSPEC;

  public $success = null;
  public $ire = null;
  public $enf = null;
  public $ace = null;
  public $ase = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::MAP,
          'ktype' => TType::STRING,
          'vtype' => TType::STRUCT,
          'key' => array(
            'type' => TType::STRING,
          ),
          'val' => array(
            'type' => TType::STRUCT,
            'class' => '\Airavata\Model\Workspace\Experiment\JobStatus',
            ),
          ),
        1 => array(
          'var' => 'ire',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\InvalidRequestException',
          ),
        2 => array(
          'var' => 'enf',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\ExperimentNotFoundException',
          ),
        3 => array(
          'var' => 'ace',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AiravataClientException',
          ),
        4 => array(
          'var' => 'ase',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AiravataSystemException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['ire'])) {
        $this->ire = $vals['ire'];
      }
      if (isset($vals['enf'])) {
        $this->enf = $vals['enf'];
      }
      if (isset($vals['ace'])) {
        $this->ace = $vals['ace'];
      }
      if (isset($vals['ase'])) {
        $this->ase = $vals['ase'];
      }
    }
  }

  public function getName() {
    return 'Airavata_getJobStatuses_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::MAP) {
            $this->success = array();
            $_size77 = 0;
            $_ktype78 = 0;
            $_vtype79 = 0;
            $xfer += $input->readMapBegin($_ktype78, $_vtype79, $_size77);
            for ($_i81 = 0; $_i81 < $_size77; ++$_i81)
            {
              $key82 = '';
              $val83 = new \Airavata\Model\Workspace\Experiment\JobStatus();
              $xfer += $input->readString($key82);
              $val83 = new \Airavata\Model\Workspace\Experiment\JobStatus();
              $xfer += $val83->read($input);
              $this->success[$key82] = $val83;
            }
            $xfer += $input->readMapEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->ire = new \Airavata\API\Error\InvalidRequestException();
            $xfer += $this->ire->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->enf = new \Airavata\API\Error\ExperimentNotFoundException();
            $xfer += $this->enf->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRUCT) {
            $this->ace = new \Airavata\API\Error\AiravataClientException();
            $xfer += $this->ace->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 4:
          if ($ftype == TType::STRUCT) {
            $this->ase = new \Airavata\API\Error\AiravataSystemException();
            $xfer += $this->ase->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Airavata_getJobStatuses_result');
    if ($this->success !== null) {
      if (!is_array($this->success)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('success', TType::MAP, 0);
      {
        $output->writeMapBegin(TType::STRING, TType::STRUCT, count($this->success));
        {
          foreach ($this->success as $kiter84 => $viter85)
          {
            $xfer += $output->writeString($kiter84);
            $xfer += $viter85->write($output);
          }
        }
        $output->writeMapEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ire !== null) {
      $xfer += $output->writeFieldBegin('ire', TType::STRUCT, 1);
      $xfer += $this->ire->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->enf !== null) {
      $xfer += $output->writeFieldBegin('enf', TType::STRUCT, 2);
      $xfer += $this->enf->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ace !== null) {
      $xfer += $output->writeFieldBegin('ace', TType::STRUCT, 3);
      $xfer += $this->ace->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ase !== null) {
      $xfer += $output->writeFieldBegin('ase', TType::STRUCT, 4);
      $xfer += $this->ase->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Airavata_getJobDetails_args {
  static $_TSPEC;

  public $airavataExperimentId = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'airavataExperimentId',
          'type' => TType::STRING,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['airavataExperimentId'])) {
        $this->airavataExperimentId = $vals['airavataExperimentId'];
      }
    }
  }

  public function getName() {
    return 'Airavata_getJobDetails_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->airavataExperimentId);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Airavata_getJobDetails_args');
    if ($this->airavataExperimentId !== null) {
      $xfer += $output->writeFieldBegin('airavataExperimentId', TType::STRING, 1);
      $xfer += $output->writeString($this->airavataExperimentId);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Airavata_getJobDetails_result {
  static $_TSPEC;

  public $success = null;
  public $ire = null;
  public $enf = null;
  public $ace = null;
  public $ase = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::LST,
          'etype' => TType::STRUCT,
          'elem' => array(
            'type' => TType::STRUCT,
            'class' => '\Airavata\Model\Workspace\Experiment\JobDetails',
            ),
          ),
        1 => array(
          'var' => 'ire',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\InvalidRequestException',
          ),
        2 => array(
          'var' => 'enf',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\ExperimentNotFoundException',
          ),
        3 => array(
          'var' => 'ace',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AiravataClientException',
          ),
        4 => array(
          'var' => 'ase',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AiravataSystemException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['ire'])) {
        $this->ire = $vals['ire'];
      }
      if (isset($vals['enf'])) {
        $this->enf = $vals['enf'];
      }
      if (isset($vals['ace'])) {
        $this->ace = $vals['ace'];
      }
      if (isset($vals['ase'])) {
        $this->ase = $vals['ase'];
      }
    }
  }

  public function getName() {
    return 'Airavata_getJobDetails_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::LST) {
            $this->success = array();
            $_size86 = 0;
            $_etype89 = 0;
            $xfer += $input->readListBegin($_etype89, $_size86);
            for ($_i90 = 0; $_i90 < $_size86; ++$_i90)
            {
              $elem91 = null;
              $elem91 = new \Airavata\Model\Workspace\Experiment\JobDetails();
              $xfer += $elem91->read($input);
              $this->success []= $elem91;
            }
            $xfer += $input->readListEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->ire = new \Airavata\API\Error\InvalidRequestException();
            $xfer += $this->ire->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->enf = new \Airavata\API\Error\ExperimentNotFoundException();
            $xfer += $this->enf->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRUCT) {
            $this->ace = new \Airavata\API\Error\AiravataClientException();
            $xfer += $this->ace->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 4:
          if ($ftype == TType::STRUCT) {
            $this->ase = new \Airavata\API\Error\AiravataSystemException();
            $xfer += $this->ase->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Airavata_getJobDetails_result');
    if ($this->success !== null) {
      if (!is_array($this->success)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('success', TType::LST, 0);
      {
        $output->writeListBegin(TType::STRUCT, count($this->success));
        {
          foreach ($this->success as $iter92)
          {
            $xfer += $iter92->write($output);
          }
        }
        $output->writeListEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ire !== null) {
      $xfer += $output->writeFieldBegin('ire', TType::STRUCT, 1);
      $xfer += $this->ire->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->enf !== null) {
      $xfer += $output->writeFieldBegin('enf', TType::STRUCT, 2);
      $xfer += $this->enf->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ace !== null) {
      $xfer += $output->writeFieldBegin('ace', TType::STRUCT, 3);
      $xfer += $this->ace->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ase !== null) {
      $xfer += $output->writeFieldBegin('ase', TType::STRUCT, 4);
      $xfer += $this->ase->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Airavata_getDataTransferDetails_args {
  static $_TSPEC;

  public $airavataExperimentId = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'airavataExperimentId',
          'type' => TType::STRING,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['airavataExperimentId'])) {
        $this->airavataExperimentId = $vals['airavataExperimentId'];
      }
    }
  }

  public function getName() {
    return 'Airavata_getDataTransferDetails_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->airavataExperimentId);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Airavata_getDataTransferDetails_args');
    if ($this->airavataExperimentId !== null) {
      $xfer += $output->writeFieldBegin('airavataExperimentId', TType::STRING, 1);
      $xfer += $output->writeString($this->airavataExperimentId);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Airavata_getDataTransferDetails_result {
  static $_TSPEC;

  public $success = null;
  public $ire = null;
  public $enf = null;
  public $ace = null;
  public $ase = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::LST,
          'etype' => TType::STRUCT,
          'elem' => array(
            'type' => TType::STRUCT,
            'class' => '\Airavata\Model\Workspace\Experiment\DataTransferDetails',
            ),
          ),
        1 => array(
          'var' => 'ire',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\InvalidRequestException',
          ),
        2 => array(
          'var' => 'enf',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\ExperimentNotFoundException',
          ),
        3 => array(
          'var' => 'ace',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AiravataClientException',
          ),
        4 => array(
          'var' => 'ase',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AiravataSystemException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['ire'])) {
        $this->ire = $vals['ire'];
      }
      if (isset($vals['enf'])) {
        $this->enf = $vals['enf'];
      }
      if (isset($vals['ace'])) {
        $this->ace = $vals['ace'];
      }
      if (isset($vals['ase'])) {
        $this->ase = $vals['ase'];
      }
    }
  }

  public function getName() {
    return 'Airavata_getDataTransferDetails_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::LST) {
            $this->success = array();
            $_size93 = 0;
            $_etype96 = 0;
            $xfer += $input->readListBegin($_etype96, $_size93);
            for ($_i97 = 0; $_i97 < $_size93; ++$_i97)
            {
              $elem98 = null;
              $elem98 = new \Airavata\Model\Workspace\Experiment\DataTransferDetails();
              $xfer += $elem98->read($input);
              $this->success []= $elem98;
            }
            $xfer += $input->readListEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->ire = new \Airavata\API\Error\InvalidRequestException();
            $xfer += $this->ire->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->enf = new \Airavata\API\Error\ExperimentNotFoundException();
            $xfer += $this->enf->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRUCT) {
            $this->ace = new \Airavata\API\Error\AiravataClientException();
            $xfer += $this->ace->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 4:
          if ($ftype == TType::STRUCT) {
            $this->ase = new \Airavata\API\Error\AiravataSystemException();
            $xfer += $this->ase->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Airavata_getDataTransferDetails_result');
    if ($this->success !== null) {
      if (!is_array($this->success)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('success', TType::LST, 0);
      {
        $output->writeListBegin(TType::STRUCT, count($this->success));
        {
          foreach ($this->success as $iter99)
          {
            $xfer += $iter99->write($output);
          }
        }
        $output->writeListEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ire !== null) {
      $xfer += $output->writeFieldBegin('ire', TType::STRUCT, 1);
      $xfer += $this->ire->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->enf !== null) {
      $xfer += $output->writeFieldBegin('enf', TType::STRUCT, 2);
      $xfer += $this->enf->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ace !== null) {
      $xfer += $output->writeFieldBegin('ace', TType::STRUCT, 3);
      $xfer += $this->ace->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ase !== null) {
      $xfer += $output->writeFieldBegin('ase', TType::STRUCT, 4);
      $xfer += $this->ase->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Airavata_cloneExperiment_args {
  static $_TSPEC;

  public $existingExperimentID = null;
  public $newExperimentName = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'existingExperimentID',
          'type' => TType::STRING,
          ),
        2 => array(
          'var' => 'newExperimentName',
          'type' => TType::STRING,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['existingExperimentID'])) {
        $this->existingExperimentID = $vals['existingExperimentID'];
      }
      if (isset($vals['newExperimentName'])) {
        $this->newExperimentName = $vals['newExperimentName'];
      }
    }
  }

  public function getName() {
    return 'Airavata_cloneExperiment_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->existingExperimentID);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->newExperimentName);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Airavata_cloneExperiment_args');
    if ($this->existingExperimentID !== null) {
      $xfer += $output->writeFieldBegin('existingExperimentID', TType::STRING, 1);
      $xfer += $output->writeString($this->existingExperimentID);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->newExperimentName !== null) {
      $xfer += $output->writeFieldBegin('newExperimentName', TType::STRING, 2);
      $xfer += $output->writeString($this->newExperimentName);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Airavata_cloneExperiment_result {
  static $_TSPEC;

  public $success = null;
  public $ire = null;
  public $enf = null;
  public $ace = null;
  public $ase = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::STRING,
          ),
        1 => array(
          'var' => 'ire',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\InvalidRequestException',
          ),
        2 => array(
          'var' => 'enf',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\ExperimentNotFoundException',
          ),
        3 => array(
          'var' => 'ace',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AiravataClientException',
          ),
        4 => array(
          'var' => 'ase',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AiravataSystemException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['ire'])) {
        $this->ire = $vals['ire'];
      }
      if (isset($vals['enf'])) {
        $this->enf = $vals['enf'];
      }
      if (isset($vals['ace'])) {
        $this->ace = $vals['ace'];
      }
      if (isset($vals['ase'])) {
        $this->ase = $vals['ase'];
      }
    }
  }

  public function getName() {
    return 'Airavata_cloneExperiment_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->success);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->ire = new \Airavata\API\Error\InvalidRequestException();
            $xfer += $this->ire->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->enf = new \Airavata\API\Error\ExperimentNotFoundException();
            $xfer += $this->enf->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRUCT) {
            $this->ace = new \Airavata\API\Error\AiravataClientException();
            $xfer += $this->ace->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 4:
          if ($ftype == TType::STRUCT) {
            $this->ase = new \Airavata\API\Error\AiravataSystemException();
            $xfer += $this->ase->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Airavata_cloneExperiment_result');
    if ($this->success !== null) {
      $xfer += $output->writeFieldBegin('success', TType::STRING, 0);
      $xfer += $output->writeString($this->success);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ire !== null) {
      $xfer += $output->writeFieldBegin('ire', TType::STRUCT, 1);
      $xfer += $this->ire->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->enf !== null) {
      $xfer += $output->writeFieldBegin('enf', TType::STRUCT, 2);
      $xfer += $this->enf->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ace !== null) {
      $xfer += $output->writeFieldBegin('ace', TType::STRUCT, 3);
      $xfer += $this->ace->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ase !== null) {
      $xfer += $output->writeFieldBegin('ase', TType::STRUCT, 4);
      $xfer += $this->ase->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Airavata_terminateExperiment_args {
  static $_TSPEC;

  public $airavataExperimentId = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'airavataExperimentId',
          'type' => TType::STRING,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['airavataExperimentId'])) {
        $this->airavataExperimentId = $vals['airavataExperimentId'];
      }
    }
  }

  public function getName() {
    return 'Airavata_terminateExperiment_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->airavataExperimentId);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Airavata_terminateExperiment_args');
    if ($this->airavataExperimentId !== null) {
      $xfer += $output->writeFieldBegin('airavataExperimentId', TType::STRING, 1);
      $xfer += $output->writeString($this->airavataExperimentId);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Airavata_terminateExperiment_result {
  static $_TSPEC;

  public $ire = null;
  public $enf = null;
  public $ace = null;
  public $ase = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'ire',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\InvalidRequestException',
          ),
        2 => array(
          'var' => 'enf',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\ExperimentNotFoundException',
          ),
        3 => array(
          'var' => 'ace',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AiravataClientException',
          ),
        4 => array(
          'var' => 'ase',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AiravataSystemException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['ire'])) {
        $this->ire = $vals['ire'];
      }
      if (isset($vals['enf'])) {
        $this->enf = $vals['enf'];
      }
      if (isset($vals['ace'])) {
        $this->ace = $vals['ace'];
      }
      if (isset($vals['ase'])) {
        $this->ase = $vals['ase'];
      }
    }
  }

  public function getName() {
    return 'Airavata_terminateExperiment_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->ire = new \Airavata\API\Error\InvalidRequestException();
            $xfer += $this->ire->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->enf = new \Airavata\API\Error\ExperimentNotFoundException();
            $xfer += $this->enf->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRUCT) {
            $this->ace = new \Airavata\API\Error\AiravataClientException();
            $xfer += $this->ace->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 4:
          if ($ftype == TType::STRUCT) {
            $this->ase = new \Airavata\API\Error\AiravataSystemException();
            $xfer += $this->ase->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Airavata_terminateExperiment_result');
    if ($this->ire !== null) {
      $xfer += $output->writeFieldBegin('ire', TType::STRUCT, 1);
      $xfer += $this->ire->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->enf !== null) {
      $xfer += $output->writeFieldBegin('enf', TType::STRUCT, 2);
      $xfer += $this->enf->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ace !== null) {
      $xfer += $output->writeFieldBegin('ace', TType::STRUCT, 3);
      $xfer += $this->ace->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ase !== null) {
      $xfer += $output->writeFieldBegin('ase', TType::STRUCT, 4);
      $xfer += $this->ase->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Airavata_registerApplicationModule_args {
  static $_TSPEC;

  public $applicationModule = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'applicationModule',
          'type' => TType::STRUCT,
          'class' => '\Airavata\Model\AppCatalog\AppDeployment\ApplicationModule',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['applicationModule'])) {
        $this->applicationModule = $vals['applicationModule'];
      }
    }
  }

  public function getName() {
    return 'Airavata_registerApplicationModule_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->applicationModule = new \Airavata\Model\AppCatalog\AppDeployment\ApplicationModule();
            $xfer += $this->applicationModule->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Airavata_registerApplicationModule_args');
    if ($this->applicationModule !== null) {
      if (!is_object($this->applicationModule)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('applicationModule', TType::STRUCT, 1);
      $xfer += $this->applicationModule->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Airavata_registerApplicationModule_result {
  static $_TSPEC;

  public $success = null;
  public $ire = null;
  public $ace = null;
  public $ase = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::STRING,
          ),
        1 => array(
          'var' => 'ire',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\InvalidRequestException',
          ),
        2 => array(
          'var' => 'ace',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AiravataClientException',
          ),
        3 => array(
          'var' => 'ase',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AiravataSystemException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['ire'])) {
        $this->ire = $vals['ire'];
      }
      if (isset($vals['ace'])) {
        $this->ace = $vals['ace'];
      }
      if (isset($vals['ase'])) {
        $this->ase = $vals['ase'];
      }
    }
  }

  public function getName() {
    return 'Airavata_registerApplicationModule_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->success);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->ire = new \Airavata\API\Error\InvalidRequestException();
            $xfer += $this->ire->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->ace = new \Airavata\API\Error\AiravataClientException();
            $xfer += $this->ace->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRUCT) {
            $this->ase = new \Airavata\API\Error\AiravataSystemException();
            $xfer += $this->ase->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Airavata_registerApplicationModule_result');
    if ($this->success !== null) {
      $xfer += $output->writeFieldBegin('success', TType::STRING, 0);
      $xfer += $output->writeString($this->success);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ire !== null) {
      $xfer += $output->writeFieldBegin('ire', TType::STRUCT, 1);
      $xfer += $this->ire->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ace !== null) {
      $xfer += $output->writeFieldBegin('ace', TType::STRUCT, 2);
      $xfer += $this->ace->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ase !== null) {
      $xfer += $output->writeFieldBegin('ase', TType::STRUCT, 3);
      $xfer += $this->ase->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Airavata_getApplicationModule_args {
  static $_TSPEC;

  public $appModuleId = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'appModuleId',
          'type' => TType::STRING,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['appModuleId'])) {
        $this->appModuleId = $vals['appModuleId'];
      }
    }
  }

  public function getName() {
    return 'Airavata_getApplicationModule_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->appModuleId);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Airavata_getApplicationModule_args');
    if ($this->appModuleId !== null) {
      $xfer += $output->writeFieldBegin('appModuleId', TType::STRING, 1);
      $xfer += $output->writeString($this->appModuleId);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Airavata_getApplicationModule_result {
  static $_TSPEC;

  public $success = null;
  public $ire = null;
  public $ace = null;
  public $ase = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::STRUCT,
          'class' => '\Airavata\Model\AppCatalog\AppDeployment\ApplicationModule',
          ),
        1 => array(
          'var' => 'ire',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\InvalidRequestException',
          ),
        2 => array(
          'var' => 'ace',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AiravataClientException',
          ),
        3 => array(
          'var' => 'ase',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AiravataSystemException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['ire'])) {
        $this->ire = $vals['ire'];
      }
      if (isset($vals['ace'])) {
        $this->ace = $vals['ace'];
      }
      if (isset($vals['ase'])) {
        $this->ase = $vals['ase'];
      }
    }
  }

  public function getName() {
    return 'Airavata_getApplicationModule_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::STRUCT) {
            $this->success = new \Airavata\Model\AppCatalog\AppDeployment\ApplicationModule();
            $xfer += $this->success->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->ire = new \Airavata\API\Error\InvalidRequestException();
            $xfer += $this->ire->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->ace = new \Airavata\API\Error\AiravataClientException();
            $xfer += $this->ace->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRUCT) {
            $this->ase = new \Airavata\API\Error\AiravataSystemException();
            $xfer += $this->ase->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Airavata_getApplicationModule_result');
    if ($this->success !== null) {
      if (!is_object($this->success)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('success', TType::STRUCT, 0);
      $xfer += $this->success->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ire !== null) {
      $xfer += $output->writeFieldBegin('ire', TType::STRUCT, 1);
      $xfer += $this->ire->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ace !== null) {
      $xfer += $output->writeFieldBegin('ace', TType::STRUCT, 2);
      $xfer += $this->ace->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ase !== null) {
      $xfer += $output->writeFieldBegin('ase', TType::STRUCT, 3);
      $xfer += $this->ase->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Airavata_updateApplicationModule_args {
  static $_TSPEC;

  public $appModuleId = null;
  public $applicationModule = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'appModuleId',
          'type' => TType::STRING,
          ),
        2 => array(
          'var' => 'applicationModule',
          'type' => TType::STRUCT,
          'class' => '\Airavata\Model\AppCatalog\AppDeployment\ApplicationModule',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['appModuleId'])) {
        $this->appModuleId = $vals['appModuleId'];
      }
      if (isset($vals['applicationModule'])) {
        $this->applicationModule = $vals['applicationModule'];
      }
    }
  }

  public function getName() {
    return 'Airavata_updateApplicationModule_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->appModuleId);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->applicationModule = new \Airavata\Model\AppCatalog\AppDeployment\ApplicationModule();
            $xfer += $this->applicationModule->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Airavata_updateApplicationModule_args');
    if ($this->appModuleId !== null) {
      $xfer += $output->writeFieldBegin('appModuleId', TType::STRING, 1);
      $xfer += $output->writeString($this->appModuleId);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->applicationModule !== null) {
      if (!is_object($this->applicationModule)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('applicationModule', TType::STRUCT, 2);
      $xfer += $this->applicationModule->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Airavata_updateApplicationModule_result {
  static $_TSPEC;

  public $success = null;
  public $ire = null;
  public $ace = null;
  public $ase = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::BOOL,
          ),
        1 => array(
          'var' => 'ire',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\InvalidRequestException',
          ),
        2 => array(
          'var' => 'ace',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AiravataClientException',
          ),
        3 => array(
          'var' => 'ase',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AiravataSystemException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['ire'])) {
        $this->ire = $vals['ire'];
      }
      if (isset($vals['ace'])) {
        $this->ace = $vals['ace'];
      }
      if (isset($vals['ase'])) {
        $this->ase = $vals['ase'];
      }
    }
  }

  public function getName() {
    return 'Airavata_updateApplicationModule_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::BOOL) {
            $xfer += $input->readBool($this->success);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->ire = new \Airavata\API\Error\InvalidRequestException();
            $xfer += $this->ire->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->ace = new \Airavata\API\Error\AiravataClientException();
            $xfer += $this->ace->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRUCT) {
            $this->ase = new \Airavata\API\Error\AiravataSystemException();
            $xfer += $this->ase->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Airavata_updateApplicationModule_result');
    if ($this->success !== null) {
      $xfer += $output->writeFieldBegin('success', TType::BOOL, 0);
      $xfer += $output->writeBool($this->success);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ire !== null) {
      $xfer += $output->writeFieldBegin('ire', TType::STRUCT, 1);
      $xfer += $this->ire->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ace !== null) {
      $xfer += $output->writeFieldBegin('ace', TType::STRUCT, 2);
      $xfer += $this->ace->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ase !== null) {
      $xfer += $output->writeFieldBegin('ase', TType::STRUCT, 3);
      $xfer += $this->ase->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Airavata_getAllAppModules_args {
  static $_TSPEC;


  public function __construct() {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        );
    }
  }

  public function getName() {
    return 'Airavata_getAllAppModules_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Airavata_getAllAppModules_args');
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Airavata_getAllAppModules_result {
  static $_TSPEC;

  public $success = null;
  public $ire = null;
  public $ace = null;
  public $ase = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::LST,
          'etype' => TType::STRUCT,
          'elem' => array(
            'type' => TType::STRUCT,
            'class' => '\Airavata\Model\AppCatalog\AppDeployment\ApplicationModule',
            ),
          ),
        1 => array(
          'var' => 'ire',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\InvalidRequestException',
          ),
        2 => array(
          'var' => 'ace',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AiravataClientException',
          ),
        3 => array(
          'var' => 'ase',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AiravataSystemException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['ire'])) {
        $this->ire = $vals['ire'];
      }
      if (isset($vals['ace'])) {
        $this->ace = $vals['ace'];
      }
      if (isset($vals['ase'])) {
        $this->ase = $vals['ase'];
      }
    }
  }

  public function getName() {
    return 'Airavata_getAllAppModules_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::LST) {
            $this->success = array();
            $_size100 = 0;
            $_etype103 = 0;
            $xfer += $input->readListBegin($_etype103, $_size100);
            for ($_i104 = 0; $_i104 < $_size100; ++$_i104)
            {
              $elem105 = null;
              $elem105 = new \Airavata\Model\AppCatalog\AppDeployment\ApplicationModule();
              $xfer += $elem105->read($input);
              $this->success []= $elem105;
            }
            $xfer += $input->readListEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->ire = new \Airavata\API\Error\InvalidRequestException();
            $xfer += $this->ire->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->ace = new \Airavata\API\Error\AiravataClientException();
            $xfer += $this->ace->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRUCT) {
            $this->ase = new \Airavata\API\Error\AiravataSystemException();
            $xfer += $this->ase->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Airavata_getAllAppModules_result');
    if ($this->success !== null) {
      if (!is_array($this->success)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('success', TType::LST, 0);
      {
        $output->writeListBegin(TType::STRUCT, count($this->success));
        {
          foreach ($this->success as $iter106)
          {
            $xfer += $iter106->write($output);
          }
        }
        $output->writeListEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ire !== null) {
      $xfer += $output->writeFieldBegin('ire', TType::STRUCT, 1);
      $xfer += $this->ire->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ace !== null) {
      $xfer += $output->writeFieldBegin('ace', TType::STRUCT, 2);
      $xfer += $this->ace->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ase !== null) {
      $xfer += $output->writeFieldBegin('ase', TType::STRUCT, 3);
      $xfer += $this->ase->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Airavata_deleteApplicationModule_args {
  static $_TSPEC;

  public $appModuleId = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'appModuleId',
          'type' => TType::STRING,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['appModuleId'])) {
        $this->appModuleId = $vals['appModuleId'];
      }
    }
  }

  public function getName() {
    return 'Airavata_deleteApplicationModule_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->appModuleId);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Airavata_deleteApplicationModule_args');
    if ($this->appModuleId !== null) {
      $xfer += $output->writeFieldBegin('appModuleId', TType::STRING, 1);
      $xfer += $output->writeString($this->appModuleId);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Airavata_deleteApplicationModule_result {
  static $_TSPEC;

  public $success = null;
  public $ire = null;
  public $ace = null;
  public $ase = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::BOOL,
          ),
        1 => array(
          'var' => 'ire',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\InvalidRequestException',
          ),
        2 => array(
          'var' => 'ace',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AiravataClientException',
          ),
        3 => array(
          'var' => 'ase',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AiravataSystemException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['ire'])) {
        $this->ire = $vals['ire'];
      }
      if (isset($vals['ace'])) {
        $this->ace = $vals['ace'];
      }
      if (isset($vals['ase'])) {
        $this->ase = $vals['ase'];
      }
    }
  }

  public function getName() {
    return 'Airavata_deleteApplicationModule_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::BOOL) {
            $xfer += $input->readBool($this->success);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->ire = new \Airavata\API\Error\InvalidRequestException();
            $xfer += $this->ire->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->ace = new \Airavata\API\Error\AiravataClientException();
            $xfer += $this->ace->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRUCT) {
            $this->ase = new \Airavata\API\Error\AiravataSystemException();
            $xfer += $this->ase->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Airavata_deleteApplicationModule_result');
    if ($this->success !== null) {
      $xfer += $output->writeFieldBegin('success', TType::BOOL, 0);
      $xfer += $output->writeBool($this->success);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ire !== null) {
      $xfer += $output->writeFieldBegin('ire', TType::STRUCT, 1);
      $xfer += $this->ire->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ace !== null) {
      $xfer += $output->writeFieldBegin('ace', TType::STRUCT, 2);
      $xfer += $this->ace->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ase !== null) {
      $xfer += $output->writeFieldBegin('ase', TType::STRUCT, 3);
      $xfer += $this->ase->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Airavata_registerApplicationDeployment_args {
  static $_TSPEC;

  public $applicationDeployment = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'applicationDeployment',
          'type' => TType::STRUCT,
          'class' => '\Airavata\Model\AppCatalog\AppDeployment\ApplicationDeploymentDescription',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['applicationDeployment'])) {
        $this->applicationDeployment = $vals['applicationDeployment'];
      }
    }
  }

  public function getName() {
    return 'Airavata_registerApplicationDeployment_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->applicationDeployment = new \Airavata\Model\AppCatalog\AppDeployment\ApplicationDeploymentDescription();
            $xfer += $this->applicationDeployment->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Airavata_registerApplicationDeployment_args');
    if ($this->applicationDeployment !== null) {
      if (!is_object($this->applicationDeployment)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('applicationDeployment', TType::STRUCT, 1);
      $xfer += $this->applicationDeployment->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Airavata_registerApplicationDeployment_result {
  static $_TSPEC;

  public $success = null;
  public $ire = null;
  public $ace = null;
  public $ase = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::STRING,
          ),
        1 => array(
          'var' => 'ire',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\InvalidRequestException',
          ),
        2 => array(
          'var' => 'ace',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AiravataClientException',
          ),
        3 => array(
          'var' => 'ase',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AiravataSystemException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['ire'])) {
        $this->ire = $vals['ire'];
      }
      if (isset($vals['ace'])) {
        $this->ace = $vals['ace'];
      }
      if (isset($vals['ase'])) {
        $this->ase = $vals['ase'];
      }
    }
  }

  public function getName() {
    return 'Airavata_registerApplicationDeployment_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->success);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->ire = new \Airavata\API\Error\InvalidRequestException();
            $xfer += $this->ire->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->ace = new \Airavata\API\Error\AiravataClientException();
            $xfer += $this->ace->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRUCT) {
            $this->ase = new \Airavata\API\Error\AiravataSystemException();
            $xfer += $this->ase->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Airavata_registerApplicationDeployment_result');
    if ($this->success !== null) {
      $xfer += $output->writeFieldBegin('success', TType::STRING, 0);
      $xfer += $output->writeString($this->success);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ire !== null) {
      $xfer += $output->writeFieldBegin('ire', TType::STRUCT, 1);
      $xfer += $this->ire->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ace !== null) {
      $xfer += $output->writeFieldBegin('ace', TType::STRUCT, 2);
      $xfer += $this->ace->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ase !== null) {
      $xfer += $output->writeFieldBegin('ase', TType::STRUCT, 3);
      $xfer += $this->ase->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Airavata_getApplicationDeployment_args {
  static $_TSPEC;

  public $appDeploymentId = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'appDeploymentId',
          'type' => TType::STRING,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['appDeploymentId'])) {
        $this->appDeploymentId = $vals['appDeploymentId'];
      }
    }
  }

  public function getName() {
    return 'Airavata_getApplicationDeployment_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->appDeploymentId);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Airavata_getApplicationDeployment_args');
    if ($this->appDeploymentId !== null) {
      $xfer += $output->writeFieldBegin('appDeploymentId', TType::STRING, 1);
      $xfer += $output->writeString($this->appDeploymentId);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Airavata_getApplicationDeployment_result {
  static $_TSPEC;

  public $success = null;
  public $ire = null;
  public $ace = null;
  public $ase = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::STRUCT,
          'class' => '\Airavata\Model\AppCatalog\AppDeployment\ApplicationDeploymentDescription',
          ),
        1 => array(
          'var' => 'ire',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\InvalidRequestException',
          ),
        2 => array(
          'var' => 'ace',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AiravataClientException',
          ),
        3 => array(
          'var' => 'ase',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AiravataSystemException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['ire'])) {
        $this->ire = $vals['ire'];
      }
      if (isset($vals['ace'])) {
        $this->ace = $vals['ace'];
      }
      if (isset($vals['ase'])) {
        $this->ase = $vals['ase'];
      }
    }
  }

  public function getName() {
    return 'Airavata_getApplicationDeployment_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::STRUCT) {
            $this->success = new \Airavata\Model\AppCatalog\AppDeployment\ApplicationDeploymentDescription();
            $xfer += $this->success->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->ire = new \Airavata\API\Error\InvalidRequestException();
            $xfer += $this->ire->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->ace = new \Airavata\API\Error\AiravataClientException();
            $xfer += $this->ace->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRUCT) {
            $this->ase = new \Airavata\API\Error\AiravataSystemException();
            $xfer += $this->ase->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Airavata_getApplicationDeployment_result');
    if ($this->success !== null) {
      if (!is_object($this->success)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('success', TType::STRUCT, 0);
      $xfer += $this->success->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ire !== null) {
      $xfer += $output->writeFieldBegin('ire', TType::STRUCT, 1);
      $xfer += $this->ire->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ace !== null) {
      $xfer += $output->writeFieldBegin('ace', TType::STRUCT, 2);
      $xfer += $this->ace->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ase !== null) {
      $xfer += $output->writeFieldBegin('ase', TType::STRUCT, 3);
      $xfer += $this->ase->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Airavata_updateApplicationDeployment_args {
  static $_TSPEC;

  public $appDeploymentId = null;
  public $applicationDeployment = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'appDeploymentId',
          'type' => TType::STRING,
          ),
        2 => array(
          'var' => 'applicationDeployment',
          'type' => TType::STRUCT,
          'class' => '\Airavata\Model\AppCatalog\AppDeployment\ApplicationDeploymentDescription',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['appDeploymentId'])) {
        $this->appDeploymentId = $vals['appDeploymentId'];
      }
      if (isset($vals['applicationDeployment'])) {
        $this->applicationDeployment = $vals['applicationDeployment'];
      }
    }
  }

  public function getName() {
    return 'Airavata_updateApplicationDeployment_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->appDeploymentId);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->applicationDeployment = new \Airavata\Model\AppCatalog\AppDeployment\ApplicationDeploymentDescription();
            $xfer += $this->applicationDeployment->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Airavata_updateApplicationDeployment_args');
    if ($this->appDeploymentId !== null) {
      $xfer += $output->writeFieldBegin('appDeploymentId', TType::STRING, 1);
      $xfer += $output->writeString($this->appDeploymentId);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->applicationDeployment !== null) {
      if (!is_object($this->applicationDeployment)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('applicationDeployment', TType::STRUCT, 2);
      $xfer += $this->applicationDeployment->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Airavata_updateApplicationDeployment_result {
  static $_TSPEC;

  public $success = null;
  public $ire = null;
  public $ace = null;
  public $ase = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::BOOL,
          ),
        1 => array(
          'var' => 'ire',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\InvalidRequestException',
          ),
        2 => array(
          'var' => 'ace',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AiravataClientException',
          ),
        3 => array(
          'var' => 'ase',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AiravataSystemException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['ire'])) {
        $this->ire = $vals['ire'];
      }
      if (isset($vals['ace'])) {
        $this->ace = $vals['ace'];
      }
      if (isset($vals['ase'])) {
        $this->ase = $vals['ase'];
      }
    }
  }

  public function getName() {
    return 'Airavata_updateApplicationDeployment_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::BOOL) {
            $xfer += $input->readBool($this->success);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->ire = new \Airavata\API\Error\InvalidRequestException();
            $xfer += $this->ire->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->ace = new \Airavata\API\Error\AiravataClientException();
            $xfer += $this->ace->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRUCT) {
            $this->ase = new \Airavata\API\Error\AiravataSystemException();
            $xfer += $this->ase->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Airavata_updateApplicationDeployment_result');
    if ($this->success !== null) {
      $xfer += $output->writeFieldBegin('success', TType::BOOL, 0);
      $xfer += $output->writeBool($this->success);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ire !== null) {
      $xfer += $output->writeFieldBegin('ire', TType::STRUCT, 1);
      $xfer += $this->ire->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ace !== null) {
      $xfer += $output->writeFieldBegin('ace', TType::STRUCT, 2);
      $xfer += $this->ace->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ase !== null) {
      $xfer += $output->writeFieldBegin('ase', TType::STRUCT, 3);
      $xfer += $this->ase->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Airavata_deleteApplicationDeployment_args {
  static $_TSPEC;

  public $appDeploymentId = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'appDeploymentId',
          'type' => TType::STRING,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['appDeploymentId'])) {
        $this->appDeploymentId = $vals['appDeploymentId'];
      }
    }
  }

  public function getName() {
    return 'Airavata_deleteApplicationDeployment_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->appDeploymentId);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Airavata_deleteApplicationDeployment_args');
    if ($this->appDeploymentId !== null) {
      $xfer += $output->writeFieldBegin('appDeploymentId', TType::STRING, 1);
      $xfer += $output->writeString($this->appDeploymentId);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Airavata_deleteApplicationDeployment_result {
  static $_TSPEC;

  public $success = null;
  public $ire = null;
  public $ace = null;
  public $ase = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::BOOL,
          ),
        1 => array(
          'var' => 'ire',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\InvalidRequestException',
          ),
        2 => array(
          'var' => 'ace',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AiravataClientException',
          ),
        3 => array(
          'var' => 'ase',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AiravataSystemException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['ire'])) {
        $this->ire = $vals['ire'];
      }
      if (isset($vals['ace'])) {
        $this->ace = $vals['ace'];
      }
      if (isset($vals['ase'])) {
        $this->ase = $vals['ase'];
      }
    }
  }

  public function getName() {
    return 'Airavata_deleteApplicationDeployment_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::BOOL) {
            $xfer += $input->readBool($this->success);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->ire = new \Airavata\API\Error\InvalidRequestException();
            $xfer += $this->ire->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->ace = new \Airavata\API\Error\AiravataClientException();
            $xfer += $this->ace->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRUCT) {
            $this->ase = new \Airavata\API\Error\AiravataSystemException();
            $xfer += $this->ase->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Airavata_deleteApplicationDeployment_result');
    if ($this->success !== null) {
      $xfer += $output->writeFieldBegin('success', TType::BOOL, 0);
      $xfer += $output->writeBool($this->success);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ire !== null) {
      $xfer += $output->writeFieldBegin('ire', TType::STRUCT, 1);
      $xfer += $this->ire->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ace !== null) {
      $xfer += $output->writeFieldBegin('ace', TType::STRUCT, 2);
      $xfer += $this->ace->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ase !== null) {
      $xfer += $output->writeFieldBegin('ase', TType::STRUCT, 3);
      $xfer += $this->ase->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Airavata_getAllApplicationDeployments_args {
  static $_TSPEC;


  public function __construct() {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        );
    }
  }

  public function getName() {
    return 'Airavata_getAllApplicationDeployments_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Airavata_getAllApplicationDeployments_args');
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Airavata_getAllApplicationDeployments_result {
  static $_TSPEC;

  public $success = null;
  public $ire = null;
  public $ace = null;
  public $ase = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::LST,
          'etype' => TType::STRUCT,
          'elem' => array(
            'type' => TType::STRUCT,
            'class' => '\Airavata\Model\AppCatalog\AppDeployment\ApplicationDeploymentDescription',
            ),
          ),
        1 => array(
          'var' => 'ire',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\InvalidRequestException',
          ),
        2 => array(
          'var' => 'ace',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AiravataClientException',
          ),
        3 => array(
          'var' => 'ase',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AiravataSystemException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['ire'])) {
        $this->ire = $vals['ire'];
      }
      if (isset($vals['ace'])) {
        $this->ace = $vals['ace'];
      }
      if (isset($vals['ase'])) {
        $this->ase = $vals['ase'];
      }
    }
  }

  public function getName() {
    return 'Airavata_getAllApplicationDeployments_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::LST) {
            $this->success = array();
            $_size107 = 0;
            $_etype110 = 0;
            $xfer += $input->readListBegin($_etype110, $_size107);
            for ($_i111 = 0; $_i111 < $_size107; ++$_i111)
            {
              $elem112 = null;
              $elem112 = new \Airavata\Model\AppCatalog\AppDeployment\ApplicationDeploymentDescription();
              $xfer += $elem112->read($input);
              $this->success []= $elem112;
            }
            $xfer += $input->readListEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->ire = new \Airavata\API\Error\InvalidRequestException();
            $xfer += $this->ire->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->ace = new \Airavata\API\Error\AiravataClientException();
            $xfer += $this->ace->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRUCT) {
            $this->ase = new \Airavata\API\Error\AiravataSystemException();
            $xfer += $this->ase->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Airavata_getAllApplicationDeployments_result');
    if ($this->success !== null) {
      if (!is_array($this->success)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('success', TType::LST, 0);
      {
        $output->writeListBegin(TType::STRUCT, count($this->success));
        {
          foreach ($this->success as $iter113)
          {
            $xfer += $iter113->write($output);
          }
        }
        $output->writeListEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ire !== null) {
      $xfer += $output->writeFieldBegin('ire', TType::STRUCT, 1);
      $xfer += $this->ire->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ace !== null) {
      $xfer += $output->writeFieldBegin('ace', TType::STRUCT, 2);
      $xfer += $this->ace->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ase !== null) {
      $xfer += $output->writeFieldBegin('ase', TType::STRUCT, 3);
      $xfer += $this->ase->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Airavata_getAppModuleDeployedResources_args {
  static $_TSPEC;

  public $appModuleId = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'appModuleId',
          'type' => TType::STRING,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['appModuleId'])) {
        $this->appModuleId = $vals['appModuleId'];
      }
    }
  }

  public function getName() {
    return 'Airavata_getAppModuleDeployedResources_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->appModuleId);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Airavata_getAppModuleDeployedResources_args');
    if ($this->appModuleId !== null) {
      $xfer += $output->writeFieldBegin('appModuleId', TType::STRING, 1);
      $xfer += $output->writeString($this->appModuleId);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Airavata_getAppModuleDeployedResources_result {
  static $_TSPEC;

  public $success = null;
  public $ire = null;
  public $ace = null;
  public $ase = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::LST,
          'etype' => TType::STRING,
          'elem' => array(
            'type' => TType::STRING,
            ),
          ),
        1 => array(
          'var' => 'ire',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\InvalidRequestException',
          ),
        2 => array(
          'var' => 'ace',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AiravataClientException',
          ),
        3 => array(
          'var' => 'ase',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AiravataSystemException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['ire'])) {
        $this->ire = $vals['ire'];
      }
      if (isset($vals['ace'])) {
        $this->ace = $vals['ace'];
      }
      if (isset($vals['ase'])) {
        $this->ase = $vals['ase'];
      }
    }
  }

  public function getName() {
    return 'Airavata_getAppModuleDeployedResources_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::LST) {
            $this->success = array();
            $_size114 = 0;
            $_etype117 = 0;
            $xfer += $input->readListBegin($_etype117, $_size114);
            for ($_i118 = 0; $_i118 < $_size114; ++$_i118)
            {
              $elem119 = null;
              $xfer += $input->readString($elem119);
              $this->success []= $elem119;
            }
            $xfer += $input->readListEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->ire = new \Airavata\API\Error\InvalidRequestException();
            $xfer += $this->ire->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->ace = new \Airavata\API\Error\AiravataClientException();
            $xfer += $this->ace->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRUCT) {
            $this->ase = new \Airavata\API\Error\AiravataSystemException();
            $xfer += $this->ase->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Airavata_getAppModuleDeployedResources_result');
    if ($this->success !== null) {
      if (!is_array($this->success)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('success', TType::LST, 0);
      {
        $output->writeListBegin(TType::STRING, count($this->success));
        {
          foreach ($this->success as $iter120)
          {
            $xfer += $output->writeString($iter120);
          }
        }
        $output->writeListEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ire !== null) {
      $xfer += $output->writeFieldBegin('ire', TType::STRUCT, 1);
      $xfer += $this->ire->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ace !== null) {
      $xfer += $output->writeFieldBegin('ace', TType::STRUCT, 2);
      $xfer += $this->ace->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ase !== null) {
      $xfer += $output->writeFieldBegin('ase', TType::STRUCT, 3);
      $xfer += $this->ase->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Airavata_registerApplicationInterface_args {
  static $_TSPEC;

  public $applicationInterface = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'applicationInterface',
          'type' => TType::STRUCT,
          'class' => '\Airavata\Model\AppCatalog\AppInterface\ApplicationInterfaceDescription',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['applicationInterface'])) {
        $this->applicationInterface = $vals['applicationInterface'];
      }
    }
  }

  public function getName() {
    return 'Airavata_registerApplicationInterface_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->applicationInterface = new \Airavata\Model\AppCatalog\AppInterface\ApplicationInterfaceDescription();
            $xfer += $this->applicationInterface->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Airavata_registerApplicationInterface_args');
    if ($this->applicationInterface !== null) {
      if (!is_object($this->applicationInterface)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('applicationInterface', TType::STRUCT, 1);
      $xfer += $this->applicationInterface->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Airavata_registerApplicationInterface_result {
  static $_TSPEC;

  public $success = null;
  public $ire = null;
  public $ace = null;
  public $ase = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::STRING,
          ),
        1 => array(
          'var' => 'ire',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\InvalidRequestException',
          ),
        2 => array(
          'var' => 'ace',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AiravataClientException',
          ),
        3 => array(
          'var' => 'ase',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AiravataSystemException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['ire'])) {
        $this->ire = $vals['ire'];
      }
      if (isset($vals['ace'])) {
        $this->ace = $vals['ace'];
      }
      if (isset($vals['ase'])) {
        $this->ase = $vals['ase'];
      }
    }
  }

  public function getName() {
    return 'Airavata_registerApplicationInterface_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->success);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->ire = new \Airavata\API\Error\InvalidRequestException();
            $xfer += $this->ire->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->ace = new \Airavata\API\Error\AiravataClientException();
            $xfer += $this->ace->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRUCT) {
            $this->ase = new \Airavata\API\Error\AiravataSystemException();
            $xfer += $this->ase->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Airavata_registerApplicationInterface_result');
    if ($this->success !== null) {
      $xfer += $output->writeFieldBegin('success', TType::STRING, 0);
      $xfer += $output->writeString($this->success);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ire !== null) {
      $xfer += $output->writeFieldBegin('ire', TType::STRUCT, 1);
      $xfer += $this->ire->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ace !== null) {
      $xfer += $output->writeFieldBegin('ace', TType::STRUCT, 2);
      $xfer += $this->ace->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ase !== null) {
      $xfer += $output->writeFieldBegin('ase', TType::STRUCT, 3);
      $xfer += $this->ase->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Airavata_getApplicationInterface_args {
  static $_TSPEC;

  public $appInterfaceId = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'appInterfaceId',
          'type' => TType::STRING,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['appInterfaceId'])) {
        $this->appInterfaceId = $vals['appInterfaceId'];
      }
    }
  }

  public function getName() {
    return 'Airavata_getApplicationInterface_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->appInterfaceId);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Airavata_getApplicationInterface_args');
    if ($this->appInterfaceId !== null) {
      $xfer += $output->writeFieldBegin('appInterfaceId', TType::STRING, 1);
      $xfer += $output->writeString($this->appInterfaceId);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Airavata_getApplicationInterface_result {
  static $_TSPEC;

  public $success = null;
  public $ire = null;
  public $ace = null;
  public $ase = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::STRUCT,
          'class' => '\Airavata\Model\AppCatalog\AppInterface\ApplicationInterfaceDescription',
          ),
        1 => array(
          'var' => 'ire',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\InvalidRequestException',
          ),
        2 => array(
          'var' => 'ace',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AiravataClientException',
          ),
        3 => array(
          'var' => 'ase',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AiravataSystemException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['ire'])) {
        $this->ire = $vals['ire'];
      }
      if (isset($vals['ace'])) {
        $this->ace = $vals['ace'];
      }
      if (isset($vals['ase'])) {
        $this->ase = $vals['ase'];
      }
    }
  }

  public function getName() {
    return 'Airavata_getApplicationInterface_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::STRUCT) {
            $this->success = new \Airavata\Model\AppCatalog\AppInterface\ApplicationInterfaceDescription();
            $xfer += $this->success->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->ire = new \Airavata\API\Error\InvalidRequestException();
            $xfer += $this->ire->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->ace = new \Airavata\API\Error\AiravataClientException();
            $xfer += $this->ace->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRUCT) {
            $this->ase = new \Airavata\API\Error\AiravataSystemException();
            $xfer += $this->ase->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Airavata_getApplicationInterface_result');
    if ($this->success !== null) {
      if (!is_object($this->success)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('success', TType::STRUCT, 0);
      $xfer += $this->success->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ire !== null) {
      $xfer += $output->writeFieldBegin('ire', TType::STRUCT, 1);
      $xfer += $this->ire->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ace !== null) {
      $xfer += $output->writeFieldBegin('ace', TType::STRUCT, 2);
      $xfer += $this->ace->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ase !== null) {
      $xfer += $output->writeFieldBegin('ase', TType::STRUCT, 3);
      $xfer += $this->ase->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Airavata_updateApplicationInterface_args {
  static $_TSPEC;

  public $appInterfaceId = null;
  public $applicationInterface = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'appInterfaceId',
          'type' => TType::STRING,
          ),
        2 => array(
          'var' => 'applicationInterface',
          'type' => TType::STRUCT,
          'class' => '\Airavata\Model\AppCatalog\AppInterface\ApplicationInterfaceDescription',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['appInterfaceId'])) {
        $this->appInterfaceId = $vals['appInterfaceId'];
      }
      if (isset($vals['applicationInterface'])) {
        $this->applicationInterface = $vals['applicationInterface'];
      }
    }
  }

  public function getName() {
    return 'Airavata_updateApplicationInterface_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->appInterfaceId);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->applicationInterface = new \Airavata\Model\AppCatalog\AppInterface\ApplicationInterfaceDescription();
            $xfer += $this->applicationInterface->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Airavata_updateApplicationInterface_args');
    if ($this->appInterfaceId !== null) {
      $xfer += $output->writeFieldBegin('appInterfaceId', TType::STRING, 1);
      $xfer += $output->writeString($this->appInterfaceId);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->applicationInterface !== null) {
      if (!is_object($this->applicationInterface)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('applicationInterface', TType::STRUCT, 2);
      $xfer += $this->applicationInterface->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Airavata_updateApplicationInterface_result {
  static $_TSPEC;

  public $success = null;
  public $ire = null;
  public $ace = null;
  public $ase = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::BOOL,
          ),
        1 => array(
          'var' => 'ire',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\InvalidRequestException',
          ),
        2 => array(
          'var' => 'ace',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AiravataClientException',
          ),
        3 => array(
          'var' => 'ase',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AiravataSystemException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['ire'])) {
        $this->ire = $vals['ire'];
      }
      if (isset($vals['ace'])) {
        $this->ace = $vals['ace'];
      }
      if (isset($vals['ase'])) {
        $this->ase = $vals['ase'];
      }
    }
  }

  public function getName() {
    return 'Airavata_updateApplicationInterface_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::BOOL) {
            $xfer += $input->readBool($this->success);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->ire = new \Airavata\API\Error\InvalidRequestException();
            $xfer += $this->ire->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->ace = new \Airavata\API\Error\AiravataClientException();
            $xfer += $this->ace->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRUCT) {
            $this->ase = new \Airavata\API\Error\AiravataSystemException();
            $xfer += $this->ase->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Airavata_updateApplicationInterface_result');
    if ($this->success !== null) {
      $xfer += $output->writeFieldBegin('success', TType::BOOL, 0);
      $xfer += $output->writeBool($this->success);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ire !== null) {
      $xfer += $output->writeFieldBegin('ire', TType::STRUCT, 1);
      $xfer += $this->ire->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ace !== null) {
      $xfer += $output->writeFieldBegin('ace', TType::STRUCT, 2);
      $xfer += $this->ace->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ase !== null) {
      $xfer += $output->writeFieldBegin('ase', TType::STRUCT, 3);
      $xfer += $this->ase->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Airavata_deleteApplicationInterface_args {
  static $_TSPEC;

  public $appInterfaceId = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'appInterfaceId',
          'type' => TType::STRING,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['appInterfaceId'])) {
        $this->appInterfaceId = $vals['appInterfaceId'];
      }
    }
  }

  public function getName() {
    return 'Airavata_deleteApplicationInterface_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->appInterfaceId);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Airavata_deleteApplicationInterface_args');
    if ($this->appInterfaceId !== null) {
      $xfer += $output->writeFieldBegin('appInterfaceId', TType::STRING, 1);
      $xfer += $output->writeString($this->appInterfaceId);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Airavata_deleteApplicationInterface_result {
  static $_TSPEC;

  public $success = null;
  public $ire = null;
  public $ace = null;
  public $ase = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::BOOL,
          ),
        1 => array(
          'var' => 'ire',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\InvalidRequestException',
          ),
        2 => array(
          'var' => 'ace',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AiravataClientException',
          ),
        3 => array(
          'var' => 'ase',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AiravataSystemException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['ire'])) {
        $this->ire = $vals['ire'];
      }
      if (isset($vals['ace'])) {
        $this->ace = $vals['ace'];
      }
      if (isset($vals['ase'])) {
        $this->ase = $vals['ase'];
      }
    }
  }

  public function getName() {
    return 'Airavata_deleteApplicationInterface_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::BOOL) {
            $xfer += $input->readBool($this->success);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->ire = new \Airavata\API\Error\InvalidRequestException();
            $xfer += $this->ire->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->ace = new \Airavata\API\Error\AiravataClientException();
            $xfer += $this->ace->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRUCT) {
            $this->ase = new \Airavata\API\Error\AiravataSystemException();
            $xfer += $this->ase->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Airavata_deleteApplicationInterface_result');
    if ($this->success !== null) {
      $xfer += $output->writeFieldBegin('success', TType::BOOL, 0);
      $xfer += $output->writeBool($this->success);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ire !== null) {
      $xfer += $output->writeFieldBegin('ire', TType::STRUCT, 1);
      $xfer += $this->ire->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ace !== null) {
      $xfer += $output->writeFieldBegin('ace', TType::STRUCT, 2);
      $xfer += $this->ace->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ase !== null) {
      $xfer += $output->writeFieldBegin('ase', TType::STRUCT, 3);
      $xfer += $this->ase->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Airavata_getAllApplicationInterfaceNames_args {
  static $_TSPEC;


  public function __construct() {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        );
    }
  }

  public function getName() {
    return 'Airavata_getAllApplicationInterfaceNames_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Airavata_getAllApplicationInterfaceNames_args');
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Airavata_getAllApplicationInterfaceNames_result {
  static $_TSPEC;

  public $success = null;
  public $ire = null;
  public $ace = null;
  public $ase = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::MAP,
          'ktype' => TType::STRING,
          'vtype' => TType::STRING,
          'key' => array(
            'type' => TType::STRING,
          ),
          'val' => array(
            'type' => TType::STRING,
            ),
          ),
        1 => array(
          'var' => 'ire',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\InvalidRequestException',
          ),
        2 => array(
          'var' => 'ace',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AiravataClientException',
          ),
        3 => array(
          'var' => 'ase',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AiravataSystemException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['ire'])) {
        $this->ire = $vals['ire'];
      }
      if (isset($vals['ace'])) {
        $this->ace = $vals['ace'];
      }
      if (isset($vals['ase'])) {
        $this->ase = $vals['ase'];
      }
    }
  }

  public function getName() {
    return 'Airavata_getAllApplicationInterfaceNames_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::MAP) {
            $this->success = array();
            $_size121 = 0;
            $_ktype122 = 0;
            $_vtype123 = 0;
            $xfer += $input->readMapBegin($_ktype122, $_vtype123, $_size121);
            for ($_i125 = 0; $_i125 < $_size121; ++$_i125)
            {
              $key126 = '';
              $val127 = '';
              $xfer += $input->readString($key126);
              $xfer += $input->readString($val127);
              $this->success[$key126] = $val127;
            }
            $xfer += $input->readMapEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->ire = new \Airavata\API\Error\InvalidRequestException();
            $xfer += $this->ire->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->ace = new \Airavata\API\Error\AiravataClientException();
            $xfer += $this->ace->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRUCT) {
            $this->ase = new \Airavata\API\Error\AiravataSystemException();
            $xfer += $this->ase->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Airavata_getAllApplicationInterfaceNames_result');
    if ($this->success !== null) {
      if (!is_array($this->success)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('success', TType::MAP, 0);
      {
        $output->writeMapBegin(TType::STRING, TType::STRING, count($this->success));
        {
          foreach ($this->success as $kiter128 => $viter129)
          {
            $xfer += $output->writeString($kiter128);
            $xfer += $output->writeString($viter129);
          }
        }
        $output->writeMapEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ire !== null) {
      $xfer += $output->writeFieldBegin('ire', TType::STRUCT, 1);
      $xfer += $this->ire->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ace !== null) {
      $xfer += $output->writeFieldBegin('ace', TType::STRUCT, 2);
      $xfer += $this->ace->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ase !== null) {
      $xfer += $output->writeFieldBegin('ase', TType::STRUCT, 3);
      $xfer += $this->ase->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Airavata_getAllApplicationInterfaces_args {
  static $_TSPEC;


  public function __construct() {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        );
    }
  }

  public function getName() {
    return 'Airavata_getAllApplicationInterfaces_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Airavata_getAllApplicationInterfaces_args');
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Airavata_getAllApplicationInterfaces_result {
  static $_TSPEC;

  public $success = null;
  public $ire = null;
  public $ace = null;
  public $ase = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::LST,
          'etype' => TType::STRUCT,
          'elem' => array(
            'type' => TType::STRUCT,
            'class' => '\Airavata\Model\AppCatalog\AppInterface\ApplicationInterfaceDescription',
            ),
          ),
        1 => array(
          'var' => 'ire',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\InvalidRequestException',
          ),
        2 => array(
          'var' => 'ace',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AiravataClientException',
          ),
        3 => array(
          'var' => 'ase',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AiravataSystemException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['ire'])) {
        $this->ire = $vals['ire'];
      }
      if (isset($vals['ace'])) {
        $this->ace = $vals['ace'];
      }
      if (isset($vals['ase'])) {
        $this->ase = $vals['ase'];
      }
    }
  }

  public function getName() {
    return 'Airavata_getAllApplicationInterfaces_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::LST) {
            $this->success = array();
            $_size130 = 0;
            $_etype133 = 0;
            $xfer += $input->readListBegin($_etype133, $_size130);
            for ($_i134 = 0; $_i134 < $_size130; ++$_i134)
            {
              $elem135 = null;
              $elem135 = new \Airavata\Model\AppCatalog\AppInterface\ApplicationInterfaceDescription();
              $xfer += $elem135->read($input);
              $this->success []= $elem135;
            }
            $xfer += $input->readListEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->ire = new \Airavata\API\Error\InvalidRequestException();
            $xfer += $this->ire->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->ace = new \Airavata\API\Error\AiravataClientException();
            $xfer += $this->ace->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRUCT) {
            $this->ase = new \Airavata\API\Error\AiravataSystemException();
            $xfer += $this->ase->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Airavata_getAllApplicationInterfaces_result');
    if ($this->success !== null) {
      if (!is_array($this->success)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('success', TType::LST, 0);
      {
        $output->writeListBegin(TType::STRUCT, count($this->success));
        {
          foreach ($this->success as $iter136)
          {
            $xfer += $iter136->write($output);
          }
        }
        $output->writeListEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ire !== null) {
      $xfer += $output->writeFieldBegin('ire', TType::STRUCT, 1);
      $xfer += $this->ire->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ace !== null) {
      $xfer += $output->writeFieldBegin('ace', TType::STRUCT, 2);
      $xfer += $this->ace->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ase !== null) {
      $xfer += $output->writeFieldBegin('ase', TType::STRUCT, 3);
      $xfer += $this->ase->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Airavata_getApplicationInputs_args {
  static $_TSPEC;

  public $appInterfaceId = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'appInterfaceId',
          'type' => TType::STRING,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['appInterfaceId'])) {
        $this->appInterfaceId = $vals['appInterfaceId'];
      }
    }
  }

  public function getName() {
    return 'Airavata_getApplicationInputs_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->appInterfaceId);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Airavata_getApplicationInputs_args');
    if ($this->appInterfaceId !== null) {
      $xfer += $output->writeFieldBegin('appInterfaceId', TType::STRING, 1);
      $xfer += $output->writeString($this->appInterfaceId);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Airavata_getApplicationInputs_result {
  static $_TSPEC;

  public $success = null;
  public $ire = null;
  public $ace = null;
  public $ase = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::LST,
          'etype' => TType::STRUCT,
          'elem' => array(
            'type' => TType::STRUCT,
            'class' => '\Airavata\Model\AppCatalog\AppInterface\InputDataObjectType',
            ),
          ),
        1 => array(
          'var' => 'ire',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\InvalidRequestException',
          ),
        2 => array(
          'var' => 'ace',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AiravataClientException',
          ),
        3 => array(
          'var' => 'ase',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AiravataSystemException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['ire'])) {
        $this->ire = $vals['ire'];
      }
      if (isset($vals['ace'])) {
        $this->ace = $vals['ace'];
      }
      if (isset($vals['ase'])) {
        $this->ase = $vals['ase'];
      }
    }
  }

  public function getName() {
    return 'Airavata_getApplicationInputs_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::LST) {
            $this->success = array();
            $_size137 = 0;
            $_etype140 = 0;
            $xfer += $input->readListBegin($_etype140, $_size137);
            for ($_i141 = 0; $_i141 < $_size137; ++$_i141)
            {
              $elem142 = null;
              $elem142 = new \Airavata\Model\AppCatalog\AppInterface\InputDataObjectType();
              $xfer += $elem142->read($input);
              $this->success []= $elem142;
            }
            $xfer += $input->readListEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->ire = new \Airavata\API\Error\InvalidRequestException();
            $xfer += $this->ire->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->ace = new \Airavata\API\Error\AiravataClientException();
            $xfer += $this->ace->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRUCT) {
            $this->ase = new \Airavata\API\Error\AiravataSystemException();
            $xfer += $this->ase->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Airavata_getApplicationInputs_result');
    if ($this->success !== null) {
      if (!is_array($this->success)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('success', TType::LST, 0);
      {
        $output->writeListBegin(TType::STRUCT, count($this->success));
        {
          foreach ($this->success as $iter143)
          {
            $xfer += $iter143->write($output);
          }
        }
        $output->writeListEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ire !== null) {
      $xfer += $output->writeFieldBegin('ire', TType::STRUCT, 1);
      $xfer += $this->ire->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ace !== null) {
      $xfer += $output->writeFieldBegin('ace', TType::STRUCT, 2);
      $xfer += $this->ace->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ase !== null) {
      $xfer += $output->writeFieldBegin('ase', TType::STRUCT, 3);
      $xfer += $this->ase->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Airavata_getApplicationOutputs_args {
  static $_TSPEC;

  public $appInterfaceId = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'appInterfaceId',
          'type' => TType::STRING,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['appInterfaceId'])) {
        $this->appInterfaceId = $vals['appInterfaceId'];
      }
    }
  }

  public function getName() {
    return 'Airavata_getApplicationOutputs_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->appInterfaceId);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Airavata_getApplicationOutputs_args');
    if ($this->appInterfaceId !== null) {
      $xfer += $output->writeFieldBegin('appInterfaceId', TType::STRING, 1);
      $xfer += $output->writeString($this->appInterfaceId);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Airavata_getApplicationOutputs_result {
  static $_TSPEC;

  public $success = null;
  public $ire = null;
  public $ace = null;
  public $ase = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::LST,
          'etype' => TType::STRUCT,
          'elem' => array(
            'type' => TType::STRUCT,
            'class' => '\Airavata\Model\AppCatalog\AppInterface\OutputDataObjectType',
            ),
          ),
        1 => array(
          'var' => 'ire',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\InvalidRequestException',
          ),
        2 => array(
          'var' => 'ace',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AiravataClientException',
          ),
        3 => array(
          'var' => 'ase',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AiravataSystemException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['ire'])) {
        $this->ire = $vals['ire'];
      }
      if (isset($vals['ace'])) {
        $this->ace = $vals['ace'];
      }
      if (isset($vals['ase'])) {
        $this->ase = $vals['ase'];
      }
    }
  }

  public function getName() {
    return 'Airavata_getApplicationOutputs_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::LST) {
            $this->success = array();
            $_size144 = 0;
            $_etype147 = 0;
            $xfer += $input->readListBegin($_etype147, $_size144);
            for ($_i148 = 0; $_i148 < $_size144; ++$_i148)
            {
              $elem149 = null;
              $elem149 = new \Airavata\Model\AppCatalog\AppInterface\OutputDataObjectType();
              $xfer += $elem149->read($input);
              $this->success []= $elem149;
            }
            $xfer += $input->readListEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->ire = new \Airavata\API\Error\InvalidRequestException();
            $xfer += $this->ire->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->ace = new \Airavata\API\Error\AiravataClientException();
            $xfer += $this->ace->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRUCT) {
            $this->ase = new \Airavata\API\Error\AiravataSystemException();
            $xfer += $this->ase->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Airavata_getApplicationOutputs_result');
    if ($this->success !== null) {
      if (!is_array($this->success)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('success', TType::LST, 0);
      {
        $output->writeListBegin(TType::STRUCT, count($this->success));
        {
          foreach ($this->success as $iter150)
          {
            $xfer += $iter150->write($output);
          }
        }
        $output->writeListEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ire !== null) {
      $xfer += $output->writeFieldBegin('ire', TType::STRUCT, 1);
      $xfer += $this->ire->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ace !== null) {
      $xfer += $output->writeFieldBegin('ace', TType::STRUCT, 2);
      $xfer += $this->ace->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ase !== null) {
      $xfer += $output->writeFieldBegin('ase', TType::STRUCT, 3);
      $xfer += $this->ase->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Airavata_getAvailableAppInterfaceComputeResources_args {
  static $_TSPEC;

  public $appInterfaceId = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'appInterfaceId',
          'type' => TType::STRING,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['appInterfaceId'])) {
        $this->appInterfaceId = $vals['appInterfaceId'];
      }
    }
  }

  public function getName() {
    return 'Airavata_getAvailableAppInterfaceComputeResources_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->appInterfaceId);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Airavata_getAvailableAppInterfaceComputeResources_args');
    if ($this->appInterfaceId !== null) {
      $xfer += $output->writeFieldBegin('appInterfaceId', TType::STRING, 1);
      $xfer += $output->writeString($this->appInterfaceId);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Airavata_getAvailableAppInterfaceComputeResources_result {
  static $_TSPEC;

  public $success = null;
  public $ire = null;
  public $ace = null;
  public $ase = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::MAP,
          'ktype' => TType::STRING,
          'vtype' => TType::STRING,
          'key' => array(
            'type' => TType::STRING,
          ),
          'val' => array(
            'type' => TType::STRING,
            ),
          ),
        1 => array(
          'var' => 'ire',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\InvalidRequestException',
          ),
        2 => array(
          'var' => 'ace',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AiravataClientException',
          ),
        3 => array(
          'var' => 'ase',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AiravataSystemException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['ire'])) {
        $this->ire = $vals['ire'];
      }
      if (isset($vals['ace'])) {
        $this->ace = $vals['ace'];
      }
      if (isset($vals['ase'])) {
        $this->ase = $vals['ase'];
      }
    }
  }

  public function getName() {
    return 'Airavata_getAvailableAppInterfaceComputeResources_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::MAP) {
            $this->success = array();
            $_size151 = 0;
            $_ktype152 = 0;
            $_vtype153 = 0;
            $xfer += $input->readMapBegin($_ktype152, $_vtype153, $_size151);
            for ($_i155 = 0; $_i155 < $_size151; ++$_i155)
            {
              $key156 = '';
              $val157 = '';
              $xfer += $input->readString($key156);
              $xfer += $input->readString($val157);
              $this->success[$key156] = $val157;
            }
            $xfer += $input->readMapEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->ire = new \Airavata\API\Error\InvalidRequestException();
            $xfer += $this->ire->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->ace = new \Airavata\API\Error\AiravataClientException();
            $xfer += $this->ace->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRUCT) {
            $this->ase = new \Airavata\API\Error\AiravataSystemException();
            $xfer += $this->ase->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Airavata_getAvailableAppInterfaceComputeResources_result');
    if ($this->success !== null) {
      if (!is_array($this->success)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('success', TType::MAP, 0);
      {
        $output->writeMapBegin(TType::STRING, TType::STRING, count($this->success));
        {
          foreach ($this->success as $kiter158 => $viter159)
          {
            $xfer += $output->writeString($kiter158);
            $xfer += $output->writeString($viter159);
          }
        }
        $output->writeMapEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ire !== null) {
      $xfer += $output->writeFieldBegin('ire', TType::STRUCT, 1);
      $xfer += $this->ire->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ace !== null) {
      $xfer += $output->writeFieldBegin('ace', TType::STRUCT, 2);
      $xfer += $this->ace->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ase !== null) {
      $xfer += $output->writeFieldBegin('ase', TType::STRUCT, 3);
      $xfer += $this->ase->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Airavata_registerComputeResource_args {
  static $_TSPEC;

  public $computeResourceDescription = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'computeResourceDescription',
          'type' => TType::STRUCT,
          'class' => '\Airavata\Model\AppCatalog\ComputeResource\ComputeResourceDescription',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['computeResourceDescription'])) {
        $this->computeResourceDescription = $vals['computeResourceDescription'];
      }
    }
  }

  public function getName() {
    return 'Airavata_registerComputeResource_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->computeResourceDescription = new \Airavata\Model\AppCatalog\ComputeResource\ComputeResourceDescription();
            $xfer += $this->computeResourceDescription->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Airavata_registerComputeResource_args');
    if ($this->computeResourceDescription !== null) {
      if (!is_object($this->computeResourceDescription)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('computeResourceDescription', TType::STRUCT, 1);
      $xfer += $this->computeResourceDescription->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Airavata_registerComputeResource_result {
  static $_TSPEC;

  public $success = null;
  public $ire = null;
  public $ace = null;
  public $ase = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::STRING,
          ),
        1 => array(
          'var' => 'ire',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\InvalidRequestException',
          ),
        2 => array(
          'var' => 'ace',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AiravataClientException',
          ),
        3 => array(
          'var' => 'ase',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AiravataSystemException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['ire'])) {
        $this->ire = $vals['ire'];
      }
      if (isset($vals['ace'])) {
        $this->ace = $vals['ace'];
      }
      if (isset($vals['ase'])) {
        $this->ase = $vals['ase'];
      }
    }
  }

  public function getName() {
    return 'Airavata_registerComputeResource_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->success);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->ire = new \Airavata\API\Error\InvalidRequestException();
            $xfer += $this->ire->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->ace = new \Airavata\API\Error\AiravataClientException();
            $xfer += $this->ace->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRUCT) {
            $this->ase = new \Airavata\API\Error\AiravataSystemException();
            $xfer += $this->ase->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Airavata_registerComputeResource_result');
    if ($this->success !== null) {
      $xfer += $output->writeFieldBegin('success', TType::STRING, 0);
      $xfer += $output->writeString($this->success);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ire !== null) {
      $xfer += $output->writeFieldBegin('ire', TType::STRUCT, 1);
      $xfer += $this->ire->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ace !== null) {
      $xfer += $output->writeFieldBegin('ace', TType::STRUCT, 2);
      $xfer += $this->ace->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ase !== null) {
      $xfer += $output->writeFieldBegin('ase', TType::STRUCT, 3);
      $xfer += $this->ase->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Airavata_getComputeResource_args {
  static $_TSPEC;

  public $computeResourceId = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'computeResourceId',
          'type' => TType::STRING,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['computeResourceId'])) {
        $this->computeResourceId = $vals['computeResourceId'];
      }
    }
  }

  public function getName() {
    return 'Airavata_getComputeResource_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->computeResourceId);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Airavata_getComputeResource_args');
    if ($this->computeResourceId !== null) {
      $xfer += $output->writeFieldBegin('computeResourceId', TType::STRING, 1);
      $xfer += $output->writeString($this->computeResourceId);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Airavata_getComputeResource_result {
  static $_TSPEC;

  public $success = null;
  public $ire = null;
  public $ace = null;
  public $ase = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::STRUCT,
          'class' => '\Airavata\Model\AppCatalog\ComputeResource\ComputeResourceDescription',
          ),
        1 => array(
          'var' => 'ire',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\InvalidRequestException',
          ),
        2 => array(
          'var' => 'ace',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AiravataClientException',
          ),
        3 => array(
          'var' => 'ase',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AiravataSystemException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['ire'])) {
        $this->ire = $vals['ire'];
      }
      if (isset($vals['ace'])) {
        $this->ace = $vals['ace'];
      }
      if (isset($vals['ase'])) {
        $this->ase = $vals['ase'];
      }
    }
  }

  public function getName() {
    return 'Airavata_getComputeResource_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::STRUCT) {
            $this->success = new \Airavata\Model\AppCatalog\ComputeResource\ComputeResourceDescription();
            $xfer += $this->success->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->ire = new \Airavata\API\Error\InvalidRequestException();
            $xfer += $this->ire->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->ace = new \Airavata\API\Error\AiravataClientException();
            $xfer += $this->ace->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRUCT) {
            $this->ase = new \Airavata\API\Error\AiravataSystemException();
            $xfer += $this->ase->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Airavata_getComputeResource_result');
    if ($this->success !== null) {
      if (!is_object($this->success)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('success', TType::STRUCT, 0);
      $xfer += $this->success->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ire !== null) {
      $xfer += $output->writeFieldBegin('ire', TType::STRUCT, 1);
      $xfer += $this->ire->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ace !== null) {
      $xfer += $output->writeFieldBegin('ace', TType::STRUCT, 2);
      $xfer += $this->ace->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ase !== null) {
      $xfer += $output->writeFieldBegin('ase', TType::STRUCT, 3);
      $xfer += $this->ase->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Airavata_getAllComputeResourceNames_args {
  static $_TSPEC;


  public function __construct() {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        );
    }
  }

  public function getName() {
    return 'Airavata_getAllComputeResourceNames_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Airavata_getAllComputeResourceNames_args');
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Airavata_getAllComputeResourceNames_result {
  static $_TSPEC;

  public $success = null;
  public $ire = null;
  public $ace = null;
  public $ase = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::MAP,
          'ktype' => TType::STRING,
          'vtype' => TType::STRING,
          'key' => array(
            'type' => TType::STRING,
          ),
          'val' => array(
            'type' => TType::STRING,
            ),
          ),
        1 => array(
          'var' => 'ire',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\InvalidRequestException',
          ),
        2 => array(
          'var' => 'ace',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AiravataClientException',
          ),
        3 => array(
          'var' => 'ase',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AiravataSystemException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['ire'])) {
        $this->ire = $vals['ire'];
      }
      if (isset($vals['ace'])) {
        $this->ace = $vals['ace'];
      }
      if (isset($vals['ase'])) {
        $this->ase = $vals['ase'];
      }
    }
  }

  public function getName() {
    return 'Airavata_getAllComputeResourceNames_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::MAP) {
            $this->success = array();
            $_size160 = 0;
            $_ktype161 = 0;
            $_vtype162 = 0;
            $xfer += $input->readMapBegin($_ktype161, $_vtype162, $_size160);
            for ($_i164 = 0; $_i164 < $_size160; ++$_i164)
            {
              $key165 = '';
              $val166 = '';
              $xfer += $input->readString($key165);
              $xfer += $input->readString($val166);
              $this->success[$key165] = $val166;
            }
            $xfer += $input->readMapEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->ire = new \Airavata\API\Error\InvalidRequestException();
            $xfer += $this->ire->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->ace = new \Airavata\API\Error\AiravataClientException();
            $xfer += $this->ace->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRUCT) {
            $this->ase = new \Airavata\API\Error\AiravataSystemException();
            $xfer += $this->ase->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Airavata_getAllComputeResourceNames_result');
    if ($this->success !== null) {
      if (!is_array($this->success)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('success', TType::MAP, 0);
      {
        $output->writeMapBegin(TType::STRING, TType::STRING, count($this->success));
        {
          foreach ($this->success as $kiter167 => $viter168)
          {
            $xfer += $output->writeString($kiter167);
            $xfer += $output->writeString($viter168);
          }
        }
        $output->writeMapEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ire !== null) {
      $xfer += $output->writeFieldBegin('ire', TType::STRUCT, 1);
      $xfer += $this->ire->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ace !== null) {
      $xfer += $output->writeFieldBegin('ace', TType::STRUCT, 2);
      $xfer += $this->ace->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ase !== null) {
      $xfer += $output->writeFieldBegin('ase', TType::STRUCT, 3);
      $xfer += $this->ase->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Airavata_updateComputeResource_args {
  static $_TSPEC;

  public $computeResourceId = null;
  public $computeResourceDescription = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'computeResourceId',
          'type' => TType::STRING,
          ),
        2 => array(
          'var' => 'computeResourceDescription',
          'type' => TType::STRUCT,
          'class' => '\Airavata\Model\AppCatalog\ComputeResource\ComputeResourceDescription',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['computeResourceId'])) {
        $this->computeResourceId = $vals['computeResourceId'];
      }
      if (isset($vals['computeResourceDescription'])) {
        $this->computeResourceDescription = $vals['computeResourceDescription'];
      }
    }
  }

  public function getName() {
    return 'Airavata_updateComputeResource_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->computeResourceId);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->computeResourceDescription = new \Airavata\Model\AppCatalog\ComputeResource\ComputeResourceDescription();
            $xfer += $this->computeResourceDescription->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Airavata_updateComputeResource_args');
    if ($this->computeResourceId !== null) {
      $xfer += $output->writeFieldBegin('computeResourceId', TType::STRING, 1);
      $xfer += $output->writeString($this->computeResourceId);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->computeResourceDescription !== null) {
      if (!is_object($this->computeResourceDescription)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('computeResourceDescription', TType::STRUCT, 2);
      $xfer += $this->computeResourceDescription->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Airavata_updateComputeResource_result {
  static $_TSPEC;

  public $success = null;
  public $ire = null;
  public $ace = null;
  public $ase = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::BOOL,
          ),
        1 => array(
          'var' => 'ire',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\InvalidRequestException',
          ),
        2 => array(
          'var' => 'ace',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AiravataClientException',
          ),
        3 => array(
          'var' => 'ase',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AiravataSystemException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['ire'])) {
        $this->ire = $vals['ire'];
      }
      if (isset($vals['ace'])) {
        $this->ace = $vals['ace'];
      }
      if (isset($vals['ase'])) {
        $this->ase = $vals['ase'];
      }
    }
  }

  public function getName() {
    return 'Airavata_updateComputeResource_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::BOOL) {
            $xfer += $input->readBool($this->success);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->ire = new \Airavata\API\Error\InvalidRequestException();
            $xfer += $this->ire->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->ace = new \Airavata\API\Error\AiravataClientException();
            $xfer += $this->ace->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRUCT) {
            $this->ase = new \Airavata\API\Error\AiravataSystemException();
            $xfer += $this->ase->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Airavata_updateComputeResource_result');
    if ($this->success !== null) {
      $xfer += $output->writeFieldBegin('success', TType::BOOL, 0);
      $xfer += $output->writeBool($this->success);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ire !== null) {
      $xfer += $output->writeFieldBegin('ire', TType::STRUCT, 1);
      $xfer += $this->ire->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ace !== null) {
      $xfer += $output->writeFieldBegin('ace', TType::STRUCT, 2);
      $xfer += $this->ace->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ase !== null) {
      $xfer += $output->writeFieldBegin('ase', TType::STRUCT, 3);
      $xfer += $this->ase->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Airavata_deleteComputeResource_args {
  static $_TSPEC;

  public $computeResourceId = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'computeResourceId',
          'type' => TType::STRING,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['computeResourceId'])) {
        $this->computeResourceId = $vals['computeResourceId'];
      }
    }
  }

  public function getName() {
    return 'Airavata_deleteComputeResource_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->computeResourceId);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Airavata_deleteComputeResource_args');
    if ($this->computeResourceId !== null) {
      $xfer += $output->writeFieldBegin('computeResourceId', TType::STRING, 1);
      $xfer += $output->writeString($this->computeResourceId);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Airavata_deleteComputeResource_result {
  static $_TSPEC;

  public $success = null;
  public $ire = null;
  public $ace = null;
  public $ase = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::BOOL,
          ),
        1 => array(
          'var' => 'ire',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\InvalidRequestException',
          ),
        2 => array(
          'var' => 'ace',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AiravataClientException',
          ),
        3 => array(
          'var' => 'ase',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AiravataSystemException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['ire'])) {
        $this->ire = $vals['ire'];
      }
      if (isset($vals['ace'])) {
        $this->ace = $vals['ace'];
      }
      if (isset($vals['ase'])) {
        $this->ase = $vals['ase'];
      }
    }
  }

  public function getName() {
    return 'Airavata_deleteComputeResource_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::BOOL) {
            $xfer += $input->readBool($this->success);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->ire = new \Airavata\API\Error\InvalidRequestException();
            $xfer += $this->ire->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->ace = new \Airavata\API\Error\AiravataClientException();
            $xfer += $this->ace->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRUCT) {
            $this->ase = new \Airavata\API\Error\AiravataSystemException();
            $xfer += $this->ase->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Airavata_deleteComputeResource_result');
    if ($this->success !== null) {
      $xfer += $output->writeFieldBegin('success', TType::BOOL, 0);
      $xfer += $output->writeBool($this->success);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ire !== null) {
      $xfer += $output->writeFieldBegin('ire', TType::STRUCT, 1);
      $xfer += $this->ire->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ace !== null) {
      $xfer += $output->writeFieldBegin('ace', TType::STRUCT, 2);
      $xfer += $this->ace->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ase !== null) {
      $xfer += $output->writeFieldBegin('ase', TType::STRUCT, 3);
      $xfer += $this->ase->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Airavata_addLocalSubmissionDetails_args {
  static $_TSPEC;

  public $computeResourceId = null;
  public $priorityOrder = null;
  public $localSubmission = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'computeResourceId',
          'type' => TType::STRING,
          ),
        2 => array(
          'var' => 'priorityOrder',
          'type' => TType::I32,
          ),
        3 => array(
          'var' => 'localSubmission',
          'type' => TType::STRUCT,
          'class' => '\Airavata\Model\AppCatalog\ComputeResource\LOCALSubmission',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['computeResourceId'])) {
        $this->computeResourceId = $vals['computeResourceId'];
      }
      if (isset($vals['priorityOrder'])) {
        $this->priorityOrder = $vals['priorityOrder'];
      }
      if (isset($vals['localSubmission'])) {
        $this->localSubmission = $vals['localSubmission'];
      }
    }
  }

  public function getName() {
    return 'Airavata_addLocalSubmissionDetails_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->computeResourceId);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::I32) {
            $xfer += $input->readI32($this->priorityOrder);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRUCT) {
            $this->localSubmission = new \Airavata\Model\AppCatalog\ComputeResource\LOCALSubmission();
            $xfer += $this->localSubmission->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Airavata_addLocalSubmissionDetails_args');
    if ($this->computeResourceId !== null) {
      $xfer += $output->writeFieldBegin('computeResourceId', TType::STRING, 1);
      $xfer += $output->writeString($this->computeResourceId);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->priorityOrder !== null) {
      $xfer += $output->writeFieldBegin('priorityOrder', TType::I32, 2);
      $xfer += $output->writeI32($this->priorityOrder);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->localSubmission !== null) {
      if (!is_object($this->localSubmission)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('localSubmission', TType::STRUCT, 3);
      $xfer += $this->localSubmission->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Airavata_addLocalSubmissionDetails_result {
  static $_TSPEC;

  public $success = null;
  public $ire = null;
  public $ace = null;
  public $ase = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::STRING,
          ),
        1 => array(
          'var' => 'ire',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\InvalidRequestException',
          ),
        2 => array(
          'var' => 'ace',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AiravataClientException',
          ),
        3 => array(
          'var' => 'ase',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AiravataSystemException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['ire'])) {
        $this->ire = $vals['ire'];
      }
      if (isset($vals['ace'])) {
        $this->ace = $vals['ace'];
      }
      if (isset($vals['ase'])) {
        $this->ase = $vals['ase'];
      }
    }
  }

  public function getName() {
    return 'Airavata_addLocalSubmissionDetails_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->success);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->ire = new \Airavata\API\Error\InvalidRequestException();
            $xfer += $this->ire->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->ace = new \Airavata\API\Error\AiravataClientException();
            $xfer += $this->ace->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRUCT) {
            $this->ase = new \Airavata\API\Error\AiravataSystemException();
            $xfer += $this->ase->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Airavata_addLocalSubmissionDetails_result');
    if ($this->success !== null) {
      $xfer += $output->writeFieldBegin('success', TType::STRING, 0);
      $xfer += $output->writeString($this->success);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ire !== null) {
      $xfer += $output->writeFieldBegin('ire', TType::STRUCT, 1);
      $xfer += $this->ire->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ace !== null) {
      $xfer += $output->writeFieldBegin('ace', TType::STRUCT, 2);
      $xfer += $this->ace->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ase !== null) {
      $xfer += $output->writeFieldBegin('ase', TType::STRUCT, 3);
      $xfer += $this->ase->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Airavata_updateLocalSubmissionDetails_args {
  static $_TSPEC;

  public $jobSubmissionInterfaceId = null;
  public $localSubmission = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'jobSubmissionInterfaceId',
          'type' => TType::STRING,
          ),
        2 => array(
          'var' => 'localSubmission',
          'type' => TType::STRUCT,
          'class' => '\Airavata\Model\AppCatalog\ComputeResource\LOCALSubmission',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['jobSubmissionInterfaceId'])) {
        $this->jobSubmissionInterfaceId = $vals['jobSubmissionInterfaceId'];
      }
      if (isset($vals['localSubmission'])) {
        $this->localSubmission = $vals['localSubmission'];
      }
    }
  }

  public function getName() {
    return 'Airavata_updateLocalSubmissionDetails_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->jobSubmissionInterfaceId);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->localSubmission = new \Airavata\Model\AppCatalog\ComputeResource\LOCALSubmission();
            $xfer += $this->localSubmission->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Airavata_updateLocalSubmissionDetails_args');
    if ($this->jobSubmissionInterfaceId !== null) {
      $xfer += $output->writeFieldBegin('jobSubmissionInterfaceId', TType::STRING, 1);
      $xfer += $output->writeString($this->jobSubmissionInterfaceId);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->localSubmission !== null) {
      if (!is_object($this->localSubmission)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('localSubmission', TType::STRUCT, 2);
      $xfer += $this->localSubmission->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Airavata_updateLocalSubmissionDetails_result {
  static $_TSPEC;

  public $success = null;
  public $ire = null;
  public $ace = null;
  public $ase = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::BOOL,
          ),
        1 => array(
          'var' => 'ire',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\InvalidRequestException',
          ),
        2 => array(
          'var' => 'ace',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AiravataClientException',
          ),
        3 => array(
          'var' => 'ase',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AiravataSystemException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['ire'])) {
        $this->ire = $vals['ire'];
      }
      if (isset($vals['ace'])) {
        $this->ace = $vals['ace'];
      }
      if (isset($vals['ase'])) {
        $this->ase = $vals['ase'];
      }
    }
  }

  public function getName() {
    return 'Airavata_updateLocalSubmissionDetails_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::BOOL) {
            $xfer += $input->readBool($this->success);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->ire = new \Airavata\API\Error\InvalidRequestException();
            $xfer += $this->ire->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->ace = new \Airavata\API\Error\AiravataClientException();
            $xfer += $this->ace->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRUCT) {
            $this->ase = new \Airavata\API\Error\AiravataSystemException();
            $xfer += $this->ase->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Airavata_updateLocalSubmissionDetails_result');
    if ($this->success !== null) {
      $xfer += $output->writeFieldBegin('success', TType::BOOL, 0);
      $xfer += $output->writeBool($this->success);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ire !== null) {
      $xfer += $output->writeFieldBegin('ire', TType::STRUCT, 1);
      $xfer += $this->ire->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ace !== null) {
      $xfer += $output->writeFieldBegin('ace', TType::STRUCT, 2);
      $xfer += $this->ace->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ase !== null) {
      $xfer += $output->writeFieldBegin('ase', TType::STRUCT, 3);
      $xfer += $this->ase->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Airavata_getLocalJobSubmission_args {
  static $_TSPEC;

  public $jobSubmissionId = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'jobSubmissionId',
          'type' => TType::STRING,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['jobSubmissionId'])) {
        $this->jobSubmissionId = $vals['jobSubmissionId'];
      }
    }
  }

  public function getName() {
    return 'Airavata_getLocalJobSubmission_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->jobSubmissionId);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Airavata_getLocalJobSubmission_args');
    if ($this->jobSubmissionId !== null) {
      $xfer += $output->writeFieldBegin('jobSubmissionId', TType::STRING, 1);
      $xfer += $output->writeString($this->jobSubmissionId);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Airavata_getLocalJobSubmission_result {
  static $_TSPEC;

  public $success = null;
  public $ire = null;
  public $ace = null;
  public $ase = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::STRUCT,
          'class' => '\Airavata\Model\AppCatalog\ComputeResource\LOCALSubmission',
          ),
        1 => array(
          'var' => 'ire',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\InvalidRequestException',
          ),
        2 => array(
          'var' => 'ace',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AiravataClientException',
          ),
        3 => array(
          'var' => 'ase',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AiravataSystemException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['ire'])) {
        $this->ire = $vals['ire'];
      }
      if (isset($vals['ace'])) {
        $this->ace = $vals['ace'];
      }
      if (isset($vals['ase'])) {
        $this->ase = $vals['ase'];
      }
    }
  }

  public function getName() {
    return 'Airavata_getLocalJobSubmission_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::STRUCT) {
            $this->success = new \Airavata\Model\AppCatalog\ComputeResource\LOCALSubmission();
            $xfer += $this->success->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->ire = new \Airavata\API\Error\InvalidRequestException();
            $xfer += $this->ire->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->ace = new \Airavata\API\Error\AiravataClientException();
            $xfer += $this->ace->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRUCT) {
            $this->ase = new \Airavata\API\Error\AiravataSystemException();
            $xfer += $this->ase->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Airavata_getLocalJobSubmission_result');
    if ($this->success !== null) {
      if (!is_object($this->success)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('success', TType::STRUCT, 0);
      $xfer += $this->success->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ire !== null) {
      $xfer += $output->writeFieldBegin('ire', TType::STRUCT, 1);
      $xfer += $this->ire->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ace !== null) {
      $xfer += $output->writeFieldBegin('ace', TType::STRUCT, 2);
      $xfer += $this->ace->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ase !== null) {
      $xfer += $output->writeFieldBegin('ase', TType::STRUCT, 3);
      $xfer += $this->ase->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Airavata_addSSHJobSubmissionDetails_args {
  static $_TSPEC;

  public $computeResourceId = null;
  public $priorityOrder = null;
  public $sshJobSubmission = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'computeResourceId',
          'type' => TType::STRING,
          ),
        2 => array(
          'var' => 'priorityOrder',
          'type' => TType::I32,
          ),
        3 => array(
          'var' => 'sshJobSubmission',
          'type' => TType::STRUCT,
          'class' => '\Airavata\Model\AppCatalog\ComputeResource\SSHJobSubmission',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['computeResourceId'])) {
        $this->computeResourceId = $vals['computeResourceId'];
      }
      if (isset($vals['priorityOrder'])) {
        $this->priorityOrder = $vals['priorityOrder'];
      }
      if (isset($vals['sshJobSubmission'])) {
        $this->sshJobSubmission = $vals['sshJobSubmission'];
      }
    }
  }

  public function getName() {
    return 'Airavata_addSSHJobSubmissionDetails_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->computeResourceId);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::I32) {
            $xfer += $input->readI32($this->priorityOrder);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRUCT) {
            $this->sshJobSubmission = new \Airavata\Model\AppCatalog\ComputeResource\SSHJobSubmission();
            $xfer += $this->sshJobSubmission->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Airavata_addSSHJobSubmissionDetails_args');
    if ($this->computeResourceId !== null) {
      $xfer += $output->writeFieldBegin('computeResourceId', TType::STRING, 1);
      $xfer += $output->writeString($this->computeResourceId);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->priorityOrder !== null) {
      $xfer += $output->writeFieldBegin('priorityOrder', TType::I32, 2);
      $xfer += $output->writeI32($this->priorityOrder);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->sshJobSubmission !== null) {
      if (!is_object($this->sshJobSubmission)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('sshJobSubmission', TType::STRUCT, 3);
      $xfer += $this->sshJobSubmission->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Airavata_addSSHJobSubmissionDetails_result {
  static $_TSPEC;

  public $success = null;
  public $ire = null;
  public $ace = null;
  public $ase = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::STRING,
          ),
        1 => array(
          'var' => 'ire',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\InvalidRequestException',
          ),
        2 => array(
          'var' => 'ace',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AiravataClientException',
          ),
        3 => array(
          'var' => 'ase',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AiravataSystemException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['ire'])) {
        $this->ire = $vals['ire'];
      }
      if (isset($vals['ace'])) {
        $this->ace = $vals['ace'];
      }
      if (isset($vals['ase'])) {
        $this->ase = $vals['ase'];
      }
    }
  }

  public function getName() {
    return 'Airavata_addSSHJobSubmissionDetails_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->success);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->ire = new \Airavata\API\Error\InvalidRequestException();
            $xfer += $this->ire->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->ace = new \Airavata\API\Error\AiravataClientException();
            $xfer += $this->ace->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRUCT) {
            $this->ase = new \Airavata\API\Error\AiravataSystemException();
            $xfer += $this->ase->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Airavata_addSSHJobSubmissionDetails_result');
    if ($this->success !== null) {
      $xfer += $output->writeFieldBegin('success', TType::STRING, 0);
      $xfer += $output->writeString($this->success);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ire !== null) {
      $xfer += $output->writeFieldBegin('ire', TType::STRUCT, 1);
      $xfer += $this->ire->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ace !== null) {
      $xfer += $output->writeFieldBegin('ace', TType::STRUCT, 2);
      $xfer += $this->ace->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ase !== null) {
      $xfer += $output->writeFieldBegin('ase', TType::STRUCT, 3);
      $xfer += $this->ase->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Airavata_getSSHJobSubmission_args {
  static $_TSPEC;

  public $jobSubmissionId = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'jobSubmissionId',
          'type' => TType::STRING,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['jobSubmissionId'])) {
        $this->jobSubmissionId = $vals['jobSubmissionId'];
      }
    }
  }

  public function getName() {
    return 'Airavata_getSSHJobSubmission_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->jobSubmissionId);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Airavata_getSSHJobSubmission_args');
    if ($this->jobSubmissionId !== null) {
      $xfer += $output->writeFieldBegin('jobSubmissionId', TType::STRING, 1);
      $xfer += $output->writeString($this->jobSubmissionId);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Airavata_getSSHJobSubmission_result {
  static $_TSPEC;

  public $success = null;
  public $ire = null;
  public $ace = null;
  public $ase = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::STRUCT,
          'class' => '\Airavata\Model\AppCatalog\ComputeResource\SSHJobSubmission',
          ),
        1 => array(
          'var' => 'ire',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\InvalidRequestException',
          ),
        2 => array(
          'var' => 'ace',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AiravataClientException',
          ),
        3 => array(
          'var' => 'ase',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AiravataSystemException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['ire'])) {
        $this->ire = $vals['ire'];
      }
      if (isset($vals['ace'])) {
        $this->ace = $vals['ace'];
      }
      if (isset($vals['ase'])) {
        $this->ase = $vals['ase'];
      }
    }
  }

  public function getName() {
    return 'Airavata_getSSHJobSubmission_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::STRUCT) {
            $this->success = new \Airavata\Model\AppCatalog\ComputeResource\SSHJobSubmission();
            $xfer += $this->success->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->ire = new \Airavata\API\Error\InvalidRequestException();
            $xfer += $this->ire->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->ace = new \Airavata\API\Error\AiravataClientException();
            $xfer += $this->ace->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRUCT) {
            $this->ase = new \Airavata\API\Error\AiravataSystemException();
            $xfer += $this->ase->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Airavata_getSSHJobSubmission_result');
    if ($this->success !== null) {
      if (!is_object($this->success)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('success', TType::STRUCT, 0);
      $xfer += $this->success->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ire !== null) {
      $xfer += $output->writeFieldBegin('ire', TType::STRUCT, 1);
      $xfer += $this->ire->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ace !== null) {
      $xfer += $output->writeFieldBegin('ace', TType::STRUCT, 2);
      $xfer += $this->ace->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ase !== null) {
      $xfer += $output->writeFieldBegin('ase', TType::STRUCT, 3);
      $xfer += $this->ase->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Airavata_addUNICOREJobSubmissionDetails_args {
  static $_TSPEC;

  public $computeResourceId = null;
  public $priorityOrder = null;
  public $unicoreJobSubmission = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'computeResourceId',
          'type' => TType::STRING,
          ),
        2 => array(
          'var' => 'priorityOrder',
          'type' => TType::I32,
          ),
        3 => array(
          'var' => 'unicoreJobSubmission',
          'type' => TType::STRUCT,
          'class' => '\Airavata\Model\AppCatalog\ComputeResource\UnicoreJobSubmission',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['computeResourceId'])) {
        $this->computeResourceId = $vals['computeResourceId'];
      }
      if (isset($vals['priorityOrder'])) {
        $this->priorityOrder = $vals['priorityOrder'];
      }
      if (isset($vals['unicoreJobSubmission'])) {
        $this->unicoreJobSubmission = $vals['unicoreJobSubmission'];
      }
    }
  }

  public function getName() {
    return 'Airavata_addUNICOREJobSubmissionDetails_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->computeResourceId);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::I32) {
            $xfer += $input->readI32($this->priorityOrder);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRUCT) {
            $this->unicoreJobSubmission = new \Airavata\Model\AppCatalog\ComputeResource\UnicoreJobSubmission();
            $xfer += $this->unicoreJobSubmission->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Airavata_addUNICOREJobSubmissionDetails_args');
    if ($this->computeResourceId !== null) {
      $xfer += $output->writeFieldBegin('computeResourceId', TType::STRING, 1);
      $xfer += $output->writeString($this->computeResourceId);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->priorityOrder !== null) {
      $xfer += $output->writeFieldBegin('priorityOrder', TType::I32, 2);
      $xfer += $output->writeI32($this->priorityOrder);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->unicoreJobSubmission !== null) {
      if (!is_object($this->unicoreJobSubmission)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('unicoreJobSubmission', TType::STRUCT, 3);
      $xfer += $this->unicoreJobSubmission->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Airavata_addUNICOREJobSubmissionDetails_result {
  static $_TSPEC;

  public $success = null;
  public $ire = null;
  public $ace = null;
  public $ase = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::STRING,
          ),
        1 => array(
          'var' => 'ire',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\InvalidRequestException',
          ),
        2 => array(
          'var' => 'ace',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AiravataClientException',
          ),
        3 => array(
          'var' => 'ase',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AiravataSystemException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['ire'])) {
        $this->ire = $vals['ire'];
      }
      if (isset($vals['ace'])) {
        $this->ace = $vals['ace'];
      }
      if (isset($vals['ase'])) {
        $this->ase = $vals['ase'];
      }
    }
  }

  public function getName() {
    return 'Airavata_addUNICOREJobSubmissionDetails_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->success);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->ire = new \Airavata\API\Error\InvalidRequestException();
            $xfer += $this->ire->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->ace = new \Airavata\API\Error\AiravataClientException();
            $xfer += $this->ace->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRUCT) {
            $this->ase = new \Airavata\API\Error\AiravataSystemException();
            $xfer += $this->ase->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Airavata_addUNICOREJobSubmissionDetails_result');
    if ($this->success !== null) {
      $xfer += $output->writeFieldBegin('success', TType::STRING, 0);
      $xfer += $output->writeString($this->success);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ire !== null) {
      $xfer += $output->writeFieldBegin('ire', TType::STRUCT, 1);
      $xfer += $this->ire->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ace !== null) {
      $xfer += $output->writeFieldBegin('ace', TType::STRUCT, 2);
      $xfer += $this->ace->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ase !== null) {
      $xfer += $output->writeFieldBegin('ase', TType::STRUCT, 3);
      $xfer += $this->ase->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Airavata_getUnicoreJobSubmission_args {
  static $_TSPEC;

  public $jobSubmissionId = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'jobSubmissionId',
          'type' => TType::STRING,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['jobSubmissionId'])) {
        $this->jobSubmissionId = $vals['jobSubmissionId'];
      }
    }
  }

  public function getName() {
    return 'Airavata_getUnicoreJobSubmission_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->jobSubmissionId);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Airavata_getUnicoreJobSubmission_args');
    if ($this->jobSubmissionId !== null) {
      $xfer += $output->writeFieldBegin('jobSubmissionId', TType::STRING, 1);
      $xfer += $output->writeString($this->jobSubmissionId);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Airavata_getUnicoreJobSubmission_result {
  static $_TSPEC;

  public $success = null;
  public $ire = null;
  public $ace = null;
  public $ase = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::STRUCT,
          'class' => '\Airavata\Model\AppCatalog\ComputeResource\UnicoreJobSubmission',
          ),
        1 => array(
          'var' => 'ire',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\InvalidRequestException',
          ),
        2 => array(
          'var' => 'ace',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AiravataClientException',
          ),
        3 => array(
          'var' => 'ase',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AiravataSystemException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['ire'])) {
        $this->ire = $vals['ire'];
      }
      if (isset($vals['ace'])) {
        $this->ace = $vals['ace'];
      }
      if (isset($vals['ase'])) {
        $this->ase = $vals['ase'];
      }
    }
  }

  public function getName() {
    return 'Airavata_getUnicoreJobSubmission_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::STRUCT) {
            $this->success = new \Airavata\Model\AppCatalog\ComputeResource\UnicoreJobSubmission();
            $xfer += $this->success->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->ire = new \Airavata\API\Error\InvalidRequestException();
            $xfer += $this->ire->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->ace = new \Airavata\API\Error\AiravataClientException();
            $xfer += $this->ace->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRUCT) {
            $this->ase = new \Airavata\API\Error\AiravataSystemException();
            $xfer += $this->ase->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Airavata_getUnicoreJobSubmission_result');
    if ($this->success !== null) {
      if (!is_object($this->success)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('success', TType::STRUCT, 0);
      $xfer += $this->success->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ire !== null) {
      $xfer += $output->writeFieldBegin('ire', TType::STRUCT, 1);
      $xfer += $this->ire->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ace !== null) {
      $xfer += $output->writeFieldBegin('ace', TType::STRUCT, 2);
      $xfer += $this->ace->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ase !== null) {
      $xfer += $output->writeFieldBegin('ase', TType::STRUCT, 3);
      $xfer += $this->ase->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Airavata_addCloudJobSubmissionDetails_args {
  static $_TSPEC;

  public $computeResourceId = null;
  public $priorityOrder = null;
  public $cloudSubmission = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'computeResourceId',
          'type' => TType::STRING,
          ),
        2 => array(
          'var' => 'priorityOrder',
          'type' => TType::I32,
          ),
        3 => array(
          'var' => 'cloudSubmission',
          'type' => TType::STRUCT,
          'class' => '\Airavata\Model\AppCatalog\ComputeResource\CloudJobSubmission',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['computeResourceId'])) {
        $this->computeResourceId = $vals['computeResourceId'];
      }
      if (isset($vals['priorityOrder'])) {
        $this->priorityOrder = $vals['priorityOrder'];
      }
      if (isset($vals['cloudSubmission'])) {
        $this->cloudSubmission = $vals['cloudSubmission'];
      }
    }
  }

  public function getName() {
    return 'Airavata_addCloudJobSubmissionDetails_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->computeResourceId);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::I32) {
            $xfer += $input->readI32($this->priorityOrder);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRUCT) {
            $this->cloudSubmission = new \Airavata\Model\AppCatalog\ComputeResource\CloudJobSubmission();
            $xfer += $this->cloudSubmission->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Airavata_addCloudJobSubmissionDetails_args');
    if ($this->computeResourceId !== null) {
      $xfer += $output->writeFieldBegin('computeResourceId', TType::STRING, 1);
      $xfer += $output->writeString($this->computeResourceId);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->priorityOrder !== null) {
      $xfer += $output->writeFieldBegin('priorityOrder', TType::I32, 2);
      $xfer += $output->writeI32($this->priorityOrder);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->cloudSubmission !== null) {
      if (!is_object($this->cloudSubmission)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('cloudSubmission', TType::STRUCT, 3);
      $xfer += $this->cloudSubmission->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Airavata_addCloudJobSubmissionDetails_result {
  static $_TSPEC;

  public $success = null;
  public $ire = null;
  public $ace = null;
  public $ase = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::STRING,
          ),
        1 => array(
          'var' => 'ire',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\InvalidRequestException',
          ),
        2 => array(
          'var' => 'ace',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AiravataClientException',
          ),
        3 => array(
          'var' => 'ase',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AiravataSystemException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['ire'])) {
        $this->ire = $vals['ire'];
      }
      if (isset($vals['ace'])) {
        $this->ace = $vals['ace'];
      }
      if (isset($vals['ase'])) {
        $this->ase = $vals['ase'];
      }
    }
  }

  public function getName() {
    return 'Airavata_addCloudJobSubmissionDetails_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->success);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->ire = new \Airavata\API\Error\InvalidRequestException();
            $xfer += $this->ire->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->ace = new \Airavata\API\Error\AiravataClientException();
            $xfer += $this->ace->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRUCT) {
            $this->ase = new \Airavata\API\Error\AiravataSystemException();
            $xfer += $this->ase->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Airavata_addCloudJobSubmissionDetails_result');
    if ($this->success !== null) {
      $xfer += $output->writeFieldBegin('success', TType::STRING, 0);
      $xfer += $output->writeString($this->success);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ire !== null) {
      $xfer += $output->writeFieldBegin('ire', TType::STRUCT, 1);
      $xfer += $this->ire->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ace !== null) {
      $xfer += $output->writeFieldBegin('ace', TType::STRUCT, 2);
      $xfer += $this->ace->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ase !== null) {
      $xfer += $output->writeFieldBegin('ase', TType::STRUCT, 3);
      $xfer += $this->ase->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Airavata_getCloudJobSubmission_args {
  static $_TSPEC;

  public $jobSubmissionId = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'jobSubmissionId',
          'type' => TType::STRING,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['jobSubmissionId'])) {
        $this->jobSubmissionId = $vals['jobSubmissionId'];
      }
    }
  }

  public function getName() {
    return 'Airavata_getCloudJobSubmission_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->jobSubmissionId);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Airavata_getCloudJobSubmission_args');
    if ($this->jobSubmissionId !== null) {
      $xfer += $output->writeFieldBegin('jobSubmissionId', TType::STRING, 1);
      $xfer += $output->writeString($this->jobSubmissionId);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Airavata_getCloudJobSubmission_result {
  static $_TSPEC;

  public $success = null;
  public $ire = null;
  public $ace = null;
  public $ase = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::STRUCT,
          'class' => '\Airavata\Model\AppCatalog\ComputeResource\CloudJobSubmission',
          ),
        1 => array(
          'var' => 'ire',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\InvalidRequestException',
          ),
        2 => array(
          'var' => 'ace',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AiravataClientException',
          ),
        3 => array(
          'var' => 'ase',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AiravataSystemException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['ire'])) {
        $this->ire = $vals['ire'];
      }
      if (isset($vals['ace'])) {
        $this->ace = $vals['ace'];
      }
      if (isset($vals['ase'])) {
        $this->ase = $vals['ase'];
      }
    }
  }

  public function getName() {
    return 'Airavata_getCloudJobSubmission_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::STRUCT) {
            $this->success = new \Airavata\Model\AppCatalog\ComputeResource\CloudJobSubmission();
            $xfer += $this->success->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->ire = new \Airavata\API\Error\InvalidRequestException();
            $xfer += $this->ire->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->ace = new \Airavata\API\Error\AiravataClientException();
            $xfer += $this->ace->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRUCT) {
            $this->ase = new \Airavata\API\Error\AiravataSystemException();
            $xfer += $this->ase->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Airavata_getCloudJobSubmission_result');
    if ($this->success !== null) {
      if (!is_object($this->success)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('success', TType::STRUCT, 0);
      $xfer += $this->success->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ire !== null) {
      $xfer += $output->writeFieldBegin('ire', TType::STRUCT, 1);
      $xfer += $this->ire->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ace !== null) {
      $xfer += $output->writeFieldBegin('ace', TType::STRUCT, 2);
      $xfer += $this->ace->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ase !== null) {
      $xfer += $output->writeFieldBegin('ase', TType::STRUCT, 3);
      $xfer += $this->ase->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Airavata_updateSSHJobSubmissionDetails_args {
  static $_TSPEC;

  public $jobSubmissionInterfaceId = null;
  public $sshJobSubmission = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'jobSubmissionInterfaceId',
          'type' => TType::STRING,
          ),
        2 => array(
          'var' => 'sshJobSubmission',
          'type' => TType::STRUCT,
          'class' => '\Airavata\Model\AppCatalog\ComputeResource\SSHJobSubmission',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['jobSubmissionInterfaceId'])) {
        $this->jobSubmissionInterfaceId = $vals['jobSubmissionInterfaceId'];
      }
      if (isset($vals['sshJobSubmission'])) {
        $this->sshJobSubmission = $vals['sshJobSubmission'];
      }
    }
  }

  public function getName() {
    return 'Airavata_updateSSHJobSubmissionDetails_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->jobSubmissionInterfaceId);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->sshJobSubmission = new \Airavata\Model\AppCatalog\ComputeResource\SSHJobSubmission();
            $xfer += $this->sshJobSubmission->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Airavata_updateSSHJobSubmissionDetails_args');
    if ($this->jobSubmissionInterfaceId !== null) {
      $xfer += $output->writeFieldBegin('jobSubmissionInterfaceId', TType::STRING, 1);
      $xfer += $output->writeString($this->jobSubmissionInterfaceId);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->sshJobSubmission !== null) {
      if (!is_object($this->sshJobSubmission)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('sshJobSubmission', TType::STRUCT, 2);
      $xfer += $this->sshJobSubmission->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Airavata_updateSSHJobSubmissionDetails_result {
  static $_TSPEC;

  public $success = null;
  public $ire = null;
  public $ace = null;
  public $ase = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::BOOL,
          ),
        1 => array(
          'var' => 'ire',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\InvalidRequestException',
          ),
        2 => array(
          'var' => 'ace',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AiravataClientException',
          ),
        3 => array(
          'var' => 'ase',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AiravataSystemException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['ire'])) {
        $this->ire = $vals['ire'];
      }
      if (isset($vals['ace'])) {
        $this->ace = $vals['ace'];
      }
      if (isset($vals['ase'])) {
        $this->ase = $vals['ase'];
      }
    }
  }

  public function getName() {
    return 'Airavata_updateSSHJobSubmissionDetails_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::BOOL) {
            $xfer += $input->readBool($this->success);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->ire = new \Airavata\API\Error\InvalidRequestException();
            $xfer += $this->ire->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->ace = new \Airavata\API\Error\AiravataClientException();
            $xfer += $this->ace->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRUCT) {
            $this->ase = new \Airavata\API\Error\AiravataSystemException();
            $xfer += $this->ase->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Airavata_updateSSHJobSubmissionDetails_result');
    if ($this->success !== null) {
      $xfer += $output->writeFieldBegin('success', TType::BOOL, 0);
      $xfer += $output->writeBool($this->success);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ire !== null) {
      $xfer += $output->writeFieldBegin('ire', TType::STRUCT, 1);
      $xfer += $this->ire->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ace !== null) {
      $xfer += $output->writeFieldBegin('ace', TType::STRUCT, 2);
      $xfer += $this->ace->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ase !== null) {
      $xfer += $output->writeFieldBegin('ase', TType::STRUCT, 3);
      $xfer += $this->ase->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Airavata_updateCloudJobSubmissionDetails_args {
  static $_TSPEC;

  public $jobSubmissionInterfaceId = null;
  public $sshJobSubmission = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'jobSubmissionInterfaceId',
          'type' => TType::STRING,
          ),
        2 => array(
          'var' => 'sshJobSubmission',
          'type' => TType::STRUCT,
          'class' => '\Airavata\Model\AppCatalog\ComputeResource\CloudJobSubmission',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['jobSubmissionInterfaceId'])) {
        $this->jobSubmissionInterfaceId = $vals['jobSubmissionInterfaceId'];
      }
      if (isset($vals['sshJobSubmission'])) {
        $this->sshJobSubmission = $vals['sshJobSubmission'];
      }
    }
  }

  public function getName() {
    return 'Airavata_updateCloudJobSubmissionDetails_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->jobSubmissionInterfaceId);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->sshJobSubmission = new \Airavata\Model\AppCatalog\ComputeResource\CloudJobSubmission();
            $xfer += $this->sshJobSubmission->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Airavata_updateCloudJobSubmissionDetails_args');
    if ($this->jobSubmissionInterfaceId !== null) {
      $xfer += $output->writeFieldBegin('jobSubmissionInterfaceId', TType::STRING, 1);
      $xfer += $output->writeString($this->jobSubmissionInterfaceId);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->sshJobSubmission !== null) {
      if (!is_object($this->sshJobSubmission)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('sshJobSubmission', TType::STRUCT, 2);
      $xfer += $this->sshJobSubmission->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Airavata_updateCloudJobSubmissionDetails_result {
  static $_TSPEC;

  public $success = null;
  public $ire = null;
  public $ace = null;
  public $ase = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::BOOL,
          ),
        1 => array(
          'var' => 'ire',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\InvalidRequestException',
          ),
        2 => array(
          'var' => 'ace',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AiravataClientException',
          ),
        3 => array(
          'var' => 'ase',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AiravataSystemException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['ire'])) {
        $this->ire = $vals['ire'];
      }
      if (isset($vals['ace'])) {
        $this->ace = $vals['ace'];
      }
      if (isset($vals['ase'])) {
        $this->ase = $vals['ase'];
      }
    }
  }

  public function getName() {
    return 'Airavata_updateCloudJobSubmissionDetails_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::BOOL) {
            $xfer += $input->readBool($this->success);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->ire = new \Airavata\API\Error\InvalidRequestException();
            $xfer += $this->ire->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->ace = new \Airavata\API\Error\AiravataClientException();
            $xfer += $this->ace->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRUCT) {
            $this->ase = new \Airavata\API\Error\AiravataSystemException();
            $xfer += $this->ase->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Airavata_updateCloudJobSubmissionDetails_result');
    if ($this->success !== null) {
      $xfer += $output->writeFieldBegin('success', TType::BOOL, 0);
      $xfer += $output->writeBool($this->success);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ire !== null) {
      $xfer += $output->writeFieldBegin('ire', TType::STRUCT, 1);
      $xfer += $this->ire->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ace !== null) {
      $xfer += $output->writeFieldBegin('ace', TType::STRUCT, 2);
      $xfer += $this->ace->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ase !== null) {
      $xfer += $output->writeFieldBegin('ase', TType::STRUCT, 3);
      $xfer += $this->ase->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Airavata_addLocalDataMovementDetails_args {
  static $_TSPEC;

  public $computeResourceId = null;
  public $priorityOrder = null;
  public $localDataMovement = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'computeResourceId',
          'type' => TType::STRING,
          ),
        2 => array(
          'var' => 'priorityOrder',
          'type' => TType::I32,
          ),
        3 => array(
          'var' => 'localDataMovement',
          'type' => TType::STRUCT,
          'class' => '\Airavata\Model\AppCatalog\ComputeResource\LOCALDataMovement',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['computeResourceId'])) {
        $this->computeResourceId = $vals['computeResourceId'];
      }
      if (isset($vals['priorityOrder'])) {
        $this->priorityOrder = $vals['priorityOrder'];
      }
      if (isset($vals['localDataMovement'])) {
        $this->localDataMovement = $vals['localDataMovement'];
      }
    }
  }

  public function getName() {
    return 'Airavata_addLocalDataMovementDetails_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->computeResourceId);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::I32) {
            $xfer += $input->readI32($this->priorityOrder);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRUCT) {
            $this->localDataMovement = new \Airavata\Model\AppCatalog\ComputeResource\LOCALDataMovement();
            $xfer += $this->localDataMovement->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Airavata_addLocalDataMovementDetails_args');
    if ($this->computeResourceId !== null) {
      $xfer += $output->writeFieldBegin('computeResourceId', TType::STRING, 1);
      $xfer += $output->writeString($this->computeResourceId);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->priorityOrder !== null) {
      $xfer += $output->writeFieldBegin('priorityOrder', TType::I32, 2);
      $xfer += $output->writeI32($this->priorityOrder);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->localDataMovement !== null) {
      if (!is_object($this->localDataMovement)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('localDataMovement', TType::STRUCT, 3);
      $xfer += $this->localDataMovement->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Airavata_addLocalDataMovementDetails_result {
  static $_TSPEC;

  public $success = null;
  public $ire = null;
  public $ace = null;
  public $ase = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::STRING,
          ),
        1 => array(
          'var' => 'ire',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\InvalidRequestException',
          ),
        2 => array(
          'var' => 'ace',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AiravataClientException',
          ),
        3 => array(
          'var' => 'ase',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AiravataSystemException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['ire'])) {
        $this->ire = $vals['ire'];
      }
      if (isset($vals['ace'])) {
        $this->ace = $vals['ace'];
      }
      if (isset($vals['ase'])) {
        $this->ase = $vals['ase'];
      }
    }
  }

  public function getName() {
    return 'Airavata_addLocalDataMovementDetails_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->success);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->ire = new \Airavata\API\Error\InvalidRequestException();
            $xfer += $this->ire->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->ace = new \Airavata\API\Error\AiravataClientException();
            $xfer += $this->ace->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRUCT) {
            $this->ase = new \Airavata\API\Error\AiravataSystemException();
            $xfer += $this->ase->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Airavata_addLocalDataMovementDetails_result');
    if ($this->success !== null) {
      $xfer += $output->writeFieldBegin('success', TType::STRING, 0);
      $xfer += $output->writeString($this->success);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ire !== null) {
      $xfer += $output->writeFieldBegin('ire', TType::STRUCT, 1);
      $xfer += $this->ire->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ace !== null) {
      $xfer += $output->writeFieldBegin('ace', TType::STRUCT, 2);
      $xfer += $this->ace->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ase !== null) {
      $xfer += $output->writeFieldBegin('ase', TType::STRUCT, 3);
      $xfer += $this->ase->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Airavata_updateLocalDataMovementDetails_args {
  static $_TSPEC;

  public $dataMovementInterfaceId = null;
  public $localDataMovement = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'dataMovementInterfaceId',
          'type' => TType::STRING,
          ),
        2 => array(
          'var' => 'localDataMovement',
          'type' => TType::STRUCT,
          'class' => '\Airavata\Model\AppCatalog\ComputeResource\LOCALDataMovement',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['dataMovementInterfaceId'])) {
        $this->dataMovementInterfaceId = $vals['dataMovementInterfaceId'];
      }
      if (isset($vals['localDataMovement'])) {
        $this->localDataMovement = $vals['localDataMovement'];
      }
    }
  }

  public function getName() {
    return 'Airavata_updateLocalDataMovementDetails_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->dataMovementInterfaceId);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->localDataMovement = new \Airavata\Model\AppCatalog\ComputeResource\LOCALDataMovement();
            $xfer += $this->localDataMovement->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Airavata_updateLocalDataMovementDetails_args');
    if ($this->dataMovementInterfaceId !== null) {
      $xfer += $output->writeFieldBegin('dataMovementInterfaceId', TType::STRING, 1);
      $xfer += $output->writeString($this->dataMovementInterfaceId);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->localDataMovement !== null) {
      if (!is_object($this->localDataMovement)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('localDataMovement', TType::STRUCT, 2);
      $xfer += $this->localDataMovement->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Airavata_updateLocalDataMovementDetails_result {
  static $_TSPEC;

  public $success = null;
  public $ire = null;
  public $ace = null;
  public $ase = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::BOOL,
          ),
        1 => array(
          'var' => 'ire',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\InvalidRequestException',
          ),
        2 => array(
          'var' => 'ace',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AiravataClientException',
          ),
        3 => array(
          'var' => 'ase',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AiravataSystemException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['ire'])) {
        $this->ire = $vals['ire'];
      }
      if (isset($vals['ace'])) {
        $this->ace = $vals['ace'];
      }
      if (isset($vals['ase'])) {
        $this->ase = $vals['ase'];
      }
    }
  }

  public function getName() {
    return 'Airavata_updateLocalDataMovementDetails_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::BOOL) {
            $xfer += $input->readBool($this->success);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->ire = new \Airavata\API\Error\InvalidRequestException();
            $xfer += $this->ire->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->ace = new \Airavata\API\Error\AiravataClientException();
            $xfer += $this->ace->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRUCT) {
            $this->ase = new \Airavata\API\Error\AiravataSystemException();
            $xfer += $this->ase->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Airavata_updateLocalDataMovementDetails_result');
    if ($this->success !== null) {
      $xfer += $output->writeFieldBegin('success', TType::BOOL, 0);
      $xfer += $output->writeBool($this->success);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ire !== null) {
      $xfer += $output->writeFieldBegin('ire', TType::STRUCT, 1);
      $xfer += $this->ire->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ace !== null) {
      $xfer += $output->writeFieldBegin('ace', TType::STRUCT, 2);
      $xfer += $this->ace->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ase !== null) {
      $xfer += $output->writeFieldBegin('ase', TType::STRUCT, 3);
      $xfer += $this->ase->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Airavata_getLocalDataMovement_args {
  static $_TSPEC;

  public $dataMovementId = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'dataMovementId',
          'type' => TType::STRING,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['dataMovementId'])) {
        $this->dataMovementId = $vals['dataMovementId'];
      }
    }
  }

  public function getName() {
    return 'Airavata_getLocalDataMovement_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->dataMovementId);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Airavata_getLocalDataMovement_args');
    if ($this->dataMovementId !== null) {
      $xfer += $output->writeFieldBegin('dataMovementId', TType::STRING, 1);
      $xfer += $output->writeString($this->dataMovementId);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Airavata_getLocalDataMovement_result {
  static $_TSPEC;

  public $success = null;
  public $ire = null;
  public $ace = null;
  public $ase = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::STRUCT,
          'class' => '\Airavata\Model\AppCatalog\ComputeResource\LOCALDataMovement',
          ),
        1 => array(
          'var' => 'ire',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\InvalidRequestException',
          ),
        2 => array(
          'var' => 'ace',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AiravataClientException',
          ),
        3 => array(
          'var' => 'ase',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AiravataSystemException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['ire'])) {
        $this->ire = $vals['ire'];
      }
      if (isset($vals['ace'])) {
        $this->ace = $vals['ace'];
      }
      if (isset($vals['ase'])) {
        $this->ase = $vals['ase'];
      }
    }
  }

  public function getName() {
    return 'Airavata_getLocalDataMovement_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::STRUCT) {
            $this->success = new \Airavata\Model\AppCatalog\ComputeResource\LOCALDataMovement();
            $xfer += $this->success->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->ire = new \Airavata\API\Error\InvalidRequestException();
            $xfer += $this->ire->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->ace = new \Airavata\API\Error\AiravataClientException();
            $xfer += $this->ace->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRUCT) {
            $this->ase = new \Airavata\API\Error\AiravataSystemException();
            $xfer += $this->ase->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Airavata_getLocalDataMovement_result');
    if ($this->success !== null) {
      if (!is_object($this->success)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('success', TType::STRUCT, 0);
      $xfer += $this->success->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ire !== null) {
      $xfer += $output->writeFieldBegin('ire', TType::STRUCT, 1);
      $xfer += $this->ire->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ace !== null) {
      $xfer += $output->writeFieldBegin('ace', TType::STRUCT, 2);
      $xfer += $this->ace->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ase !== null) {
      $xfer += $output->writeFieldBegin('ase', TType::STRUCT, 3);
      $xfer += $this->ase->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Airavata_addSCPDataMovementDetails_args {
  static $_TSPEC;

  public $computeResourceId = null;
  public $priorityOrder = null;
  public $scpDataMovement = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'computeResourceId',
          'type' => TType::STRING,
          ),
        2 => array(
          'var' => 'priorityOrder',
          'type' => TType::I32,
          ),
        3 => array(
          'var' => 'scpDataMovement',
          'type' => TType::STRUCT,
          'class' => '\Airavata\Model\AppCatalog\ComputeResource\SCPDataMovement',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['computeResourceId'])) {
        $this->computeResourceId = $vals['computeResourceId'];
      }
      if (isset($vals['priorityOrder'])) {
        $this->priorityOrder = $vals['priorityOrder'];
      }
      if (isset($vals['scpDataMovement'])) {
        $this->scpDataMovement = $vals['scpDataMovement'];
      }
    }
  }

  public function getName() {
    return 'Airavata_addSCPDataMovementDetails_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->computeResourceId);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::I32) {
            $xfer += $input->readI32($this->priorityOrder);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRUCT) {
            $this->scpDataMovement = new \Airavata\Model\AppCatalog\ComputeResource\SCPDataMovement();
            $xfer += $this->scpDataMovement->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Airavata_addSCPDataMovementDetails_args');
    if ($this->computeResourceId !== null) {
      $xfer += $output->writeFieldBegin('computeResourceId', TType::STRING, 1);
      $xfer += $output->writeString($this->computeResourceId);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->priorityOrder !== null) {
      $xfer += $output->writeFieldBegin('priorityOrder', TType::I32, 2);
      $xfer += $output->writeI32($this->priorityOrder);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->scpDataMovement !== null) {
      if (!is_object($this->scpDataMovement)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('scpDataMovement', TType::STRUCT, 3);
      $xfer += $this->scpDataMovement->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Airavata_addSCPDataMovementDetails_result {
  static $_TSPEC;

  public $success = null;
  public $ire = null;
  public $ace = null;
  public $ase = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::STRING,
          ),
        1 => array(
          'var' => 'ire',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\InvalidRequestException',
          ),
        2 => array(
          'var' => 'ace',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AiravataClientException',
          ),
        3 => array(
          'var' => 'ase',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AiravataSystemException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['ire'])) {
        $this->ire = $vals['ire'];
      }
      if (isset($vals['ace'])) {
        $this->ace = $vals['ace'];
      }
      if (isset($vals['ase'])) {
        $this->ase = $vals['ase'];
      }
    }
  }

  public function getName() {
    return 'Airavata_addSCPDataMovementDetails_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->success);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->ire = new \Airavata\API\Error\InvalidRequestException();
            $xfer += $this->ire->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->ace = new \Airavata\API\Error\AiravataClientException();
            $xfer += $this->ace->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRUCT) {
            $this->ase = new \Airavata\API\Error\AiravataSystemException();
            $xfer += $this->ase->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Airavata_addSCPDataMovementDetails_result');
    if ($this->success !== null) {
      $xfer += $output->writeFieldBegin('success', TType::STRING, 0);
      $xfer += $output->writeString($this->success);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ire !== null) {
      $xfer += $output->writeFieldBegin('ire', TType::STRUCT, 1);
      $xfer += $this->ire->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ace !== null) {
      $xfer += $output->writeFieldBegin('ace', TType::STRUCT, 2);
      $xfer += $this->ace->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ase !== null) {
      $xfer += $output->writeFieldBegin('ase', TType::STRUCT, 3);
      $xfer += $this->ase->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Airavata_updateSCPDataMovementDetails_args {
  static $_TSPEC;

  public $dataMovementInterfaceId = null;
  public $scpDataMovement = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'dataMovementInterfaceId',
          'type' => TType::STRING,
          ),
        2 => array(
          'var' => 'scpDataMovement',
          'type' => TType::STRUCT,
          'class' => '\Airavata\Model\AppCatalog\ComputeResource\SCPDataMovement',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['dataMovementInterfaceId'])) {
        $this->dataMovementInterfaceId = $vals['dataMovementInterfaceId'];
      }
      if (isset($vals['scpDataMovement'])) {
        $this->scpDataMovement = $vals['scpDataMovement'];
      }
    }
  }

  public function getName() {
    return 'Airavata_updateSCPDataMovementDetails_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->dataMovementInterfaceId);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->scpDataMovement = new \Airavata\Model\AppCatalog\ComputeResource\SCPDataMovement();
            $xfer += $this->scpDataMovement->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Airavata_updateSCPDataMovementDetails_args');
    if ($this->dataMovementInterfaceId !== null) {
      $xfer += $output->writeFieldBegin('dataMovementInterfaceId', TType::STRING, 1);
      $xfer += $output->writeString($this->dataMovementInterfaceId);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->scpDataMovement !== null) {
      if (!is_object($this->scpDataMovement)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('scpDataMovement', TType::STRUCT, 2);
      $xfer += $this->scpDataMovement->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Airavata_updateSCPDataMovementDetails_result {
  static $_TSPEC;

  public $success = null;
  public $ire = null;
  public $ace = null;
  public $ase = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::BOOL,
          ),
        1 => array(
          'var' => 'ire',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\InvalidRequestException',
          ),
        2 => array(
          'var' => 'ace',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AiravataClientException',
          ),
        3 => array(
          'var' => 'ase',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AiravataSystemException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['ire'])) {
        $this->ire = $vals['ire'];
      }
      if (isset($vals['ace'])) {
        $this->ace = $vals['ace'];
      }
      if (isset($vals['ase'])) {
        $this->ase = $vals['ase'];
      }
    }
  }

  public function getName() {
    return 'Airavata_updateSCPDataMovementDetails_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::BOOL) {
            $xfer += $input->readBool($this->success);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->ire = new \Airavata\API\Error\InvalidRequestException();
            $xfer += $this->ire->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->ace = new \Airavata\API\Error\AiravataClientException();
            $xfer += $this->ace->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRUCT) {
            $this->ase = new \Airavata\API\Error\AiravataSystemException();
            $xfer += $this->ase->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Airavata_updateSCPDataMovementDetails_result');
    if ($this->success !== null) {
      $xfer += $output->writeFieldBegin('success', TType::BOOL, 0);
      $xfer += $output->writeBool($this->success);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ire !== null) {
      $xfer += $output->writeFieldBegin('ire', TType::STRUCT, 1);
      $xfer += $this->ire->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ace !== null) {
      $xfer += $output->writeFieldBegin('ace', TType::STRUCT, 2);
      $xfer += $this->ace->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ase !== null) {
      $xfer += $output->writeFieldBegin('ase', TType::STRUCT, 3);
      $xfer += $this->ase->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Airavata_getSCPDataMovement_args {
  static $_TSPEC;

  public $dataMovementId = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'dataMovementId',
          'type' => TType::STRING,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['dataMovementId'])) {
        $this->dataMovementId = $vals['dataMovementId'];
      }
    }
  }

  public function getName() {
    return 'Airavata_getSCPDataMovement_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->dataMovementId);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Airavata_getSCPDataMovement_args');
    if ($this->dataMovementId !== null) {
      $xfer += $output->writeFieldBegin('dataMovementId', TType::STRING, 1);
      $xfer += $output->writeString($this->dataMovementId);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Airavata_getSCPDataMovement_result {
  static $_TSPEC;

  public $success = null;
  public $ire = null;
  public $ace = null;
  public $ase = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::STRUCT,
          'class' => '\Airavata\Model\AppCatalog\ComputeResource\SCPDataMovement',
          ),
        1 => array(
          'var' => 'ire',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\InvalidRequestException',
          ),
        2 => array(
          'var' => 'ace',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AiravataClientException',
          ),
        3 => array(
          'var' => 'ase',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AiravataSystemException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['ire'])) {
        $this->ire = $vals['ire'];
      }
      if (isset($vals['ace'])) {
        $this->ace = $vals['ace'];
      }
      if (isset($vals['ase'])) {
        $this->ase = $vals['ase'];
      }
    }
  }

  public function getName() {
    return 'Airavata_getSCPDataMovement_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::STRUCT) {
            $this->success = new \Airavata\Model\AppCatalog\ComputeResource\SCPDataMovement();
            $xfer += $this->success->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->ire = new \Airavata\API\Error\InvalidRequestException();
            $xfer += $this->ire->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->ace = new \Airavata\API\Error\AiravataClientException();
            $xfer += $this->ace->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRUCT) {
            $this->ase = new \Airavata\API\Error\AiravataSystemException();
            $xfer += $this->ase->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Airavata_getSCPDataMovement_result');
    if ($this->success !== null) {
      if (!is_object($this->success)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('success', TType::STRUCT, 0);
      $xfer += $this->success->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ire !== null) {
      $xfer += $output->writeFieldBegin('ire', TType::STRUCT, 1);
      $xfer += $this->ire->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ace !== null) {
      $xfer += $output->writeFieldBegin('ace', TType::STRUCT, 2);
      $xfer += $this->ace->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ase !== null) {
      $xfer += $output->writeFieldBegin('ase', TType::STRUCT, 3);
      $xfer += $this->ase->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Airavata_addGridFTPDataMovementDetails_args {
  static $_TSPEC;

  public $computeResourceId = null;
  public $priorityOrder = null;
  public $gridFTPDataMovement = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'computeResourceId',
          'type' => TType::STRING,
          ),
        2 => array(
          'var' => 'priorityOrder',
          'type' => TType::I32,
          ),
        3 => array(
          'var' => 'gridFTPDataMovement',
          'type' => TType::STRUCT,
          'class' => '\Airavata\Model\AppCatalog\ComputeResource\GridFTPDataMovement',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['computeResourceId'])) {
        $this->computeResourceId = $vals['computeResourceId'];
      }
      if (isset($vals['priorityOrder'])) {
        $this->priorityOrder = $vals['priorityOrder'];
      }
      if (isset($vals['gridFTPDataMovement'])) {
        $this->gridFTPDataMovement = $vals['gridFTPDataMovement'];
      }
    }
  }

  public function getName() {
    return 'Airavata_addGridFTPDataMovementDetails_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->computeResourceId);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::I32) {
            $xfer += $input->readI32($this->priorityOrder);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRUCT) {
            $this->gridFTPDataMovement = new \Airavata\Model\AppCatalog\ComputeResource\GridFTPDataMovement();
            $xfer += $this->gridFTPDataMovement->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Airavata_addGridFTPDataMovementDetails_args');
    if ($this->computeResourceId !== null) {
      $xfer += $output->writeFieldBegin('computeResourceId', TType::STRING, 1);
      $xfer += $output->writeString($this->computeResourceId);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->priorityOrder !== null) {
      $xfer += $output->writeFieldBegin('priorityOrder', TType::I32, 2);
      $xfer += $output->writeI32($this->priorityOrder);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->gridFTPDataMovement !== null) {
      if (!is_object($this->gridFTPDataMovement)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('gridFTPDataMovement', TType::STRUCT, 3);
      $xfer += $this->gridFTPDataMovement->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Airavata_addGridFTPDataMovementDetails_result {
  static $_TSPEC;

  public $success = null;
  public $ire = null;
  public $ace = null;
  public $ase = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::STRING,
          ),
        1 => array(
          'var' => 'ire',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\InvalidRequestException',
          ),
        2 => array(
          'var' => 'ace',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AiravataClientException',
          ),
        3 => array(
          'var' => 'ase',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AiravataSystemException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['ire'])) {
        $this->ire = $vals['ire'];
      }
      if (isset($vals['ace'])) {
        $this->ace = $vals['ace'];
      }
      if (isset($vals['ase'])) {
        $this->ase = $vals['ase'];
      }
    }
  }

  public function getName() {
    return 'Airavata_addGridFTPDataMovementDetails_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->success);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->ire = new \Airavata\API\Error\InvalidRequestException();
            $xfer += $this->ire->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->ace = new \Airavata\API\Error\AiravataClientException();
            $xfer += $this->ace->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRUCT) {
            $this->ase = new \Airavata\API\Error\AiravataSystemException();
            $xfer += $this->ase->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Airavata_addGridFTPDataMovementDetails_result');
    if ($this->success !== null) {
      $xfer += $output->writeFieldBegin('success', TType::STRING, 0);
      $xfer += $output->writeString($this->success);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ire !== null) {
      $xfer += $output->writeFieldBegin('ire', TType::STRUCT, 1);
      $xfer += $this->ire->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ace !== null) {
      $xfer += $output->writeFieldBegin('ace', TType::STRUCT, 2);
      $xfer += $this->ace->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ase !== null) {
      $xfer += $output->writeFieldBegin('ase', TType::STRUCT, 3);
      $xfer += $this->ase->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Airavata_updateGridFTPDataMovementDetails_args {
  static $_TSPEC;

  public $dataMovementInterfaceId = null;
  public $gridFTPDataMovement = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'dataMovementInterfaceId',
          'type' => TType::STRING,
          ),
        2 => array(
          'var' => 'gridFTPDataMovement',
          'type' => TType::STRUCT,
          'class' => '\Airavata\Model\AppCatalog\ComputeResource\GridFTPDataMovement',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['dataMovementInterfaceId'])) {
        $this->dataMovementInterfaceId = $vals['dataMovementInterfaceId'];
      }
      if (isset($vals['gridFTPDataMovement'])) {
        $this->gridFTPDataMovement = $vals['gridFTPDataMovement'];
      }
    }
  }

  public function getName() {
    return 'Airavata_updateGridFTPDataMovementDetails_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->dataMovementInterfaceId);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->gridFTPDataMovement = new \Airavata\Model\AppCatalog\ComputeResource\GridFTPDataMovement();
            $xfer += $this->gridFTPDataMovement->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Airavata_updateGridFTPDataMovementDetails_args');
    if ($this->dataMovementInterfaceId !== null) {
      $xfer += $output->writeFieldBegin('dataMovementInterfaceId', TType::STRING, 1);
      $xfer += $output->writeString($this->dataMovementInterfaceId);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->gridFTPDataMovement !== null) {
      if (!is_object($this->gridFTPDataMovement)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('gridFTPDataMovement', TType::STRUCT, 2);
      $xfer += $this->gridFTPDataMovement->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Airavata_updateGridFTPDataMovementDetails_result {
  static $_TSPEC;

  public $success = null;
  public $ire = null;
  public $ace = null;
  public $ase = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::BOOL,
          ),
        1 => array(
          'var' => 'ire',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\InvalidRequestException',
          ),
        2 => array(
          'var' => 'ace',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AiravataClientException',
          ),
        3 => array(
          'var' => 'ase',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AiravataSystemException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['ire'])) {
        $this->ire = $vals['ire'];
      }
      if (isset($vals['ace'])) {
        $this->ace = $vals['ace'];
      }
      if (isset($vals['ase'])) {
        $this->ase = $vals['ase'];
      }
    }
  }

  public function getName() {
    return 'Airavata_updateGridFTPDataMovementDetails_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::BOOL) {
            $xfer += $input->readBool($this->success);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->ire = new \Airavata\API\Error\InvalidRequestException();
            $xfer += $this->ire->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->ace = new \Airavata\API\Error\AiravataClientException();
            $xfer += $this->ace->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRUCT) {
            $this->ase = new \Airavata\API\Error\AiravataSystemException();
            $xfer += $this->ase->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Airavata_updateGridFTPDataMovementDetails_result');
    if ($this->success !== null) {
      $xfer += $output->writeFieldBegin('success', TType::BOOL, 0);
      $xfer += $output->writeBool($this->success);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ire !== null) {
      $xfer += $output->writeFieldBegin('ire', TType::STRUCT, 1);
      $xfer += $this->ire->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ace !== null) {
      $xfer += $output->writeFieldBegin('ace', TType::STRUCT, 2);
      $xfer += $this->ace->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ase !== null) {
      $xfer += $output->writeFieldBegin('ase', TType::STRUCT, 3);
      $xfer += $this->ase->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Airavata_getGridFTPDataMovement_args {
  static $_TSPEC;

  public $dataMovementId = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'dataMovementId',
          'type' => TType::STRING,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['dataMovementId'])) {
        $this->dataMovementId = $vals['dataMovementId'];
      }
    }
  }

  public function getName() {
    return 'Airavata_getGridFTPDataMovement_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->dataMovementId);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Airavata_getGridFTPDataMovement_args');
    if ($this->dataMovementId !== null) {
      $xfer += $output->writeFieldBegin('dataMovementId', TType::STRING, 1);
      $xfer += $output->writeString($this->dataMovementId);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Airavata_getGridFTPDataMovement_result {
  static $_TSPEC;

  public $success = null;
  public $ire = null;
  public $ace = null;
  public $ase = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::STRUCT,
          'class' => '\Airavata\Model\AppCatalog\ComputeResource\GridFTPDataMovement',
          ),
        1 => array(
          'var' => 'ire',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\InvalidRequestException',
          ),
        2 => array(
          'var' => 'ace',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AiravataClientException',
          ),
        3 => array(
          'var' => 'ase',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AiravataSystemException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['ire'])) {
        $this->ire = $vals['ire'];
      }
      if (isset($vals['ace'])) {
        $this->ace = $vals['ace'];
      }
      if (isset($vals['ase'])) {
        $this->ase = $vals['ase'];
      }
    }
  }

  public function getName() {
    return 'Airavata_getGridFTPDataMovement_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::STRUCT) {
            $this->success = new \Airavata\Model\AppCatalog\ComputeResource\GridFTPDataMovement();
            $xfer += $this->success->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->ire = new \Airavata\API\Error\InvalidRequestException();
            $xfer += $this->ire->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->ace = new \Airavata\API\Error\AiravataClientException();
            $xfer += $this->ace->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRUCT) {
            $this->ase = new \Airavata\API\Error\AiravataSystemException();
            $xfer += $this->ase->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Airavata_getGridFTPDataMovement_result');
    if ($this->success !== null) {
      if (!is_object($this->success)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('success', TType::STRUCT, 0);
      $xfer += $this->success->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ire !== null) {
      $xfer += $output->writeFieldBegin('ire', TType::STRUCT, 1);
      $xfer += $this->ire->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ace !== null) {
      $xfer += $output->writeFieldBegin('ace', TType::STRUCT, 2);
      $xfer += $this->ace->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ase !== null) {
      $xfer += $output->writeFieldBegin('ase', TType::STRUCT, 3);
      $xfer += $this->ase->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Airavata_changeJobSubmissionPriority_args {
  static $_TSPEC;

  public $jobSubmissionInterfaceId = null;
  public $newPriorityOrder = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'jobSubmissionInterfaceId',
          'type' => TType::STRING,
          ),
        2 => array(
          'var' => 'newPriorityOrder',
          'type' => TType::I32,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['jobSubmissionInterfaceId'])) {
        $this->jobSubmissionInterfaceId = $vals['jobSubmissionInterfaceId'];
      }
      if (isset($vals['newPriorityOrder'])) {
        $this->newPriorityOrder = $vals['newPriorityOrder'];
      }
    }
  }

  public function getName() {
    return 'Airavata_changeJobSubmissionPriority_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->jobSubmissionInterfaceId);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::I32) {
            $xfer += $input->readI32($this->newPriorityOrder);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Airavata_changeJobSubmissionPriority_args');
    if ($this->jobSubmissionInterfaceId !== null) {
      $xfer += $output->writeFieldBegin('jobSubmissionInterfaceId', TType::STRING, 1);
      $xfer += $output->writeString($this->jobSubmissionInterfaceId);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->newPriorityOrder !== null) {
      $xfer += $output->writeFieldBegin('newPriorityOrder', TType::I32, 2);
      $xfer += $output->writeI32($this->newPriorityOrder);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Airavata_changeJobSubmissionPriority_result {
  static $_TSPEC;

  public $success = null;
  public $ire = null;
  public $ace = null;
  public $ase = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::BOOL,
          ),
        1 => array(
          'var' => 'ire',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\InvalidRequestException',
          ),
        2 => array(
          'var' => 'ace',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AiravataClientException',
          ),
        3 => array(
          'var' => 'ase',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AiravataSystemException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['ire'])) {
        $this->ire = $vals['ire'];
      }
      if (isset($vals['ace'])) {
        $this->ace = $vals['ace'];
      }
      if (isset($vals['ase'])) {
        $this->ase = $vals['ase'];
      }
    }
  }

  public function getName() {
    return 'Airavata_changeJobSubmissionPriority_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::BOOL) {
            $xfer += $input->readBool($this->success);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->ire = new \Airavata\API\Error\InvalidRequestException();
            $xfer += $this->ire->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->ace = new \Airavata\API\Error\AiravataClientException();
            $xfer += $this->ace->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRUCT) {
            $this->ase = new \Airavata\API\Error\AiravataSystemException();
            $xfer += $this->ase->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Airavata_changeJobSubmissionPriority_result');
    if ($this->success !== null) {
      $xfer += $output->writeFieldBegin('success', TType::BOOL, 0);
      $xfer += $output->writeBool($this->success);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ire !== null) {
      $xfer += $output->writeFieldBegin('ire', TType::STRUCT, 1);
      $xfer += $this->ire->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ace !== null) {
      $xfer += $output->writeFieldBegin('ace', TType::STRUCT, 2);
      $xfer += $this->ace->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ase !== null) {
      $xfer += $output->writeFieldBegin('ase', TType::STRUCT, 3);
      $xfer += $this->ase->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Airavata_changeDataMovementPriority_args {
  static $_TSPEC;

  public $dataMovementInterfaceId = null;
  public $newPriorityOrder = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'dataMovementInterfaceId',
          'type' => TType::STRING,
          ),
        2 => array(
          'var' => 'newPriorityOrder',
          'type' => TType::I32,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['dataMovementInterfaceId'])) {
        $this->dataMovementInterfaceId = $vals['dataMovementInterfaceId'];
      }
      if (isset($vals['newPriorityOrder'])) {
        $this->newPriorityOrder = $vals['newPriorityOrder'];
      }
    }
  }

  public function getName() {
    return 'Airavata_changeDataMovementPriority_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->dataMovementInterfaceId);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::I32) {
            $xfer += $input->readI32($this->newPriorityOrder);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Airavata_changeDataMovementPriority_args');
    if ($this->dataMovementInterfaceId !== null) {
      $xfer += $output->writeFieldBegin('dataMovementInterfaceId', TType::STRING, 1);
      $xfer += $output->writeString($this->dataMovementInterfaceId);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->newPriorityOrder !== null) {
      $xfer += $output->writeFieldBegin('newPriorityOrder', TType::I32, 2);
      $xfer += $output->writeI32($this->newPriorityOrder);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Airavata_changeDataMovementPriority_result {
  static $_TSPEC;

  public $success = null;
  public $ire = null;
  public $ace = null;
  public $ase = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::BOOL,
          ),
        1 => array(
          'var' => 'ire',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\InvalidRequestException',
          ),
        2 => array(
          'var' => 'ace',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AiravataClientException',
          ),
        3 => array(
          'var' => 'ase',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AiravataSystemException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['ire'])) {
        $this->ire = $vals['ire'];
      }
      if (isset($vals['ace'])) {
        $this->ace = $vals['ace'];
      }
      if (isset($vals['ase'])) {
        $this->ase = $vals['ase'];
      }
    }
  }

  public function getName() {
    return 'Airavata_changeDataMovementPriority_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::BOOL) {
            $xfer += $input->readBool($this->success);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->ire = new \Airavata\API\Error\InvalidRequestException();
            $xfer += $this->ire->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->ace = new \Airavata\API\Error\AiravataClientException();
            $xfer += $this->ace->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRUCT) {
            $this->ase = new \Airavata\API\Error\AiravataSystemException();
            $xfer += $this->ase->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Airavata_changeDataMovementPriority_result');
    if ($this->success !== null) {
      $xfer += $output->writeFieldBegin('success', TType::BOOL, 0);
      $xfer += $output->writeBool($this->success);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ire !== null) {
      $xfer += $output->writeFieldBegin('ire', TType::STRUCT, 1);
      $xfer += $this->ire->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ace !== null) {
      $xfer += $output->writeFieldBegin('ace', TType::STRUCT, 2);
      $xfer += $this->ace->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ase !== null) {
      $xfer += $output->writeFieldBegin('ase', TType::STRUCT, 3);
      $xfer += $this->ase->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Airavata_changeJobSubmissionPriorities_args {
  static $_TSPEC;

  public $jobSubmissionPriorityMap = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'jobSubmissionPriorityMap',
          'type' => TType::MAP,
          'ktype' => TType::STRING,
          'vtype' => TType::I32,
          'key' => array(
            'type' => TType::STRING,
          ),
          'val' => array(
            'type' => TType::I32,
            ),
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['jobSubmissionPriorityMap'])) {
        $this->jobSubmissionPriorityMap = $vals['jobSubmissionPriorityMap'];
      }
    }
  }

  public function getName() {
    return 'Airavata_changeJobSubmissionPriorities_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::MAP) {
            $this->jobSubmissionPriorityMap = array();
            $_size169 = 0;
            $_ktype170 = 0;
            $_vtype171 = 0;
            $xfer += $input->readMapBegin($_ktype170, $_vtype171, $_size169);
            for ($_i173 = 0; $_i173 < $_size169; ++$_i173)
            {
              $key174 = '';
              $val175 = 0;
              $xfer += $input->readString($key174);
              $xfer += $input->readI32($val175);
              $this->jobSubmissionPriorityMap[$key174] = $val175;
            }
            $xfer += $input->readMapEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Airavata_changeJobSubmissionPriorities_args');
    if ($this->jobSubmissionPriorityMap !== null) {
      if (!is_array($this->jobSubmissionPriorityMap)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('jobSubmissionPriorityMap', TType::MAP, 1);
      {
        $output->writeMapBegin(TType::STRING, TType::I32, count($this->jobSubmissionPriorityMap));
        {
          foreach ($this->jobSubmissionPriorityMap as $kiter176 => $viter177)
          {
            $xfer += $output->writeString($kiter176);
            $xfer += $output->writeI32($viter177);
          }
        }
        $output->writeMapEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Airavata_changeJobSubmissionPriorities_result {
  static $_TSPEC;

  public $success = null;
  public $ire = null;
  public $ace = null;
  public $ase = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::BOOL,
          ),
        1 => array(
          'var' => 'ire',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\InvalidRequestException',
          ),
        2 => array(
          'var' => 'ace',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AiravataClientException',
          ),
        3 => array(
          'var' => 'ase',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AiravataSystemException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['ire'])) {
        $this->ire = $vals['ire'];
      }
      if (isset($vals['ace'])) {
        $this->ace = $vals['ace'];
      }
      if (isset($vals['ase'])) {
        $this->ase = $vals['ase'];
      }
    }
  }

  public function getName() {
    return 'Airavata_changeJobSubmissionPriorities_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::BOOL) {
            $xfer += $input->readBool($this->success);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->ire = new \Airavata\API\Error\InvalidRequestException();
            $xfer += $this->ire->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->ace = new \Airavata\API\Error\AiravataClientException();
            $xfer += $this->ace->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRUCT) {
            $this->ase = new \Airavata\API\Error\AiravataSystemException();
            $xfer += $this->ase->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Airavata_changeJobSubmissionPriorities_result');
    if ($this->success !== null) {
      $xfer += $output->writeFieldBegin('success', TType::BOOL, 0);
      $xfer += $output->writeBool($this->success);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ire !== null) {
      $xfer += $output->writeFieldBegin('ire', TType::STRUCT, 1);
      $xfer += $this->ire->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ace !== null) {
      $xfer += $output->writeFieldBegin('ace', TType::STRUCT, 2);
      $xfer += $this->ace->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ase !== null) {
      $xfer += $output->writeFieldBegin('ase', TType::STRUCT, 3);
      $xfer += $this->ase->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Airavata_changeDataMovementPriorities_args {
  static $_TSPEC;

  public $dataMovementPriorityMap = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'dataMovementPriorityMap',
          'type' => TType::MAP,
          'ktype' => TType::STRING,
          'vtype' => TType::I32,
          'key' => array(
            'type' => TType::STRING,
          ),
          'val' => array(
            'type' => TType::I32,
            ),
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['dataMovementPriorityMap'])) {
        $this->dataMovementPriorityMap = $vals['dataMovementPriorityMap'];
      }
    }
  }

  public function getName() {
    return 'Airavata_changeDataMovementPriorities_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::MAP) {
            $this->dataMovementPriorityMap = array();
            $_size178 = 0;
            $_ktype179 = 0;
            $_vtype180 = 0;
            $xfer += $input->readMapBegin($_ktype179, $_vtype180, $_size178);
            for ($_i182 = 0; $_i182 < $_size178; ++$_i182)
            {
              $key183 = '';
              $val184 = 0;
              $xfer += $input->readString($key183);
              $xfer += $input->readI32($val184);
              $this->dataMovementPriorityMap[$key183] = $val184;
            }
            $xfer += $input->readMapEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Airavata_changeDataMovementPriorities_args');
    if ($this->dataMovementPriorityMap !== null) {
      if (!is_array($this->dataMovementPriorityMap)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('dataMovementPriorityMap', TType::MAP, 1);
      {
        $output->writeMapBegin(TType::STRING, TType::I32, count($this->dataMovementPriorityMap));
        {
          foreach ($this->dataMovementPriorityMap as $kiter185 => $viter186)
          {
            $xfer += $output->writeString($kiter185);
            $xfer += $output->writeI32($viter186);
          }
        }
        $output->writeMapEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Airavata_changeDataMovementPriorities_result {
  static $_TSPEC;

  public $success = null;
  public $ire = null;
  public $ace = null;
  public $ase = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::BOOL,
          ),
        1 => array(
          'var' => 'ire',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\InvalidRequestException',
          ),
        2 => array(
          'var' => 'ace',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AiravataClientException',
          ),
        3 => array(
          'var' => 'ase',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AiravataSystemException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['ire'])) {
        $this->ire = $vals['ire'];
      }
      if (isset($vals['ace'])) {
        $this->ace = $vals['ace'];
      }
      if (isset($vals['ase'])) {
        $this->ase = $vals['ase'];
      }
    }
  }

  public function getName() {
    return 'Airavata_changeDataMovementPriorities_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::BOOL) {
            $xfer += $input->readBool($this->success);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->ire = new \Airavata\API\Error\InvalidRequestException();
            $xfer += $this->ire->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->ace = new \Airavata\API\Error\AiravataClientException();
            $xfer += $this->ace->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRUCT) {
            $this->ase = new \Airavata\API\Error\AiravataSystemException();
            $xfer += $this->ase->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Airavata_changeDataMovementPriorities_result');
    if ($this->success !== null) {
      $xfer += $output->writeFieldBegin('success', TType::BOOL, 0);
      $xfer += $output->writeBool($this->success);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ire !== null) {
      $xfer += $output->writeFieldBegin('ire', TType::STRUCT, 1);
      $xfer += $this->ire->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ace !== null) {
      $xfer += $output->writeFieldBegin('ace', TType::STRUCT, 2);
      $xfer += $this->ace->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ase !== null) {
      $xfer += $output->writeFieldBegin('ase', TType::STRUCT, 3);
      $xfer += $this->ase->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Airavata_deleteJobSubmissionInterface_args {
  static $_TSPEC;

  public $computeResourceId = null;
  public $jobSubmissionInterfaceId = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'computeResourceId',
          'type' => TType::STRING,
          ),
        2 => array(
          'var' => 'jobSubmissionInterfaceId',
          'type' => TType::STRING,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['computeResourceId'])) {
        $this->computeResourceId = $vals['computeResourceId'];
      }
      if (isset($vals['jobSubmissionInterfaceId'])) {
        $this->jobSubmissionInterfaceId = $vals['jobSubmissionInterfaceId'];
      }
    }
  }

  public function getName() {
    return 'Airavata_deleteJobSubmissionInterface_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->computeResourceId);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->jobSubmissionInterfaceId);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Airavata_deleteJobSubmissionInterface_args');
    if ($this->computeResourceId !== null) {
      $xfer += $output->writeFieldBegin('computeResourceId', TType::STRING, 1);
      $xfer += $output->writeString($this->computeResourceId);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->jobSubmissionInterfaceId !== null) {
      $xfer += $output->writeFieldBegin('jobSubmissionInterfaceId', TType::STRING, 2);
      $xfer += $output->writeString($this->jobSubmissionInterfaceId);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Airavata_deleteJobSubmissionInterface_result {
  static $_TSPEC;

  public $success = null;
  public $ire = null;
  public $ace = null;
  public $ase = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::BOOL,
          ),
        1 => array(
          'var' => 'ire',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\InvalidRequestException',
          ),
        2 => array(
          'var' => 'ace',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AiravataClientException',
          ),
        3 => array(
          'var' => 'ase',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AiravataSystemException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['ire'])) {
        $this->ire = $vals['ire'];
      }
      if (isset($vals['ace'])) {
        $this->ace = $vals['ace'];
      }
      if (isset($vals['ase'])) {
        $this->ase = $vals['ase'];
      }
    }
  }

  public function getName() {
    return 'Airavata_deleteJobSubmissionInterface_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::BOOL) {
            $xfer += $input->readBool($this->success);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->ire = new \Airavata\API\Error\InvalidRequestException();
            $xfer += $this->ire->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->ace = new \Airavata\API\Error\AiravataClientException();
            $xfer += $this->ace->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRUCT) {
            $this->ase = new \Airavata\API\Error\AiravataSystemException();
            $xfer += $this->ase->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Airavata_deleteJobSubmissionInterface_result');
    if ($this->success !== null) {
      $xfer += $output->writeFieldBegin('success', TType::BOOL, 0);
      $xfer += $output->writeBool($this->success);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ire !== null) {
      $xfer += $output->writeFieldBegin('ire', TType::STRUCT, 1);
      $xfer += $this->ire->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ace !== null) {
      $xfer += $output->writeFieldBegin('ace', TType::STRUCT, 2);
      $xfer += $this->ace->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ase !== null) {
      $xfer += $output->writeFieldBegin('ase', TType::STRUCT, 3);
      $xfer += $this->ase->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Airavata_deleteDataMovementInterface_args {
  static $_TSPEC;

  public $computeResourceId = null;
  public $dataMovementInterfaceId = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'computeResourceId',
          'type' => TType::STRING,
          ),
        2 => array(
          'var' => 'dataMovementInterfaceId',
          'type' => TType::STRING,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['computeResourceId'])) {
        $this->computeResourceId = $vals['computeResourceId'];
      }
      if (isset($vals['dataMovementInterfaceId'])) {
        $this->dataMovementInterfaceId = $vals['dataMovementInterfaceId'];
      }
    }
  }

  public function getName() {
    return 'Airavata_deleteDataMovementInterface_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->computeResourceId);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->dataMovementInterfaceId);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Airavata_deleteDataMovementInterface_args');
    if ($this->computeResourceId !== null) {
      $xfer += $output->writeFieldBegin('computeResourceId', TType::STRING, 1);
      $xfer += $output->writeString($this->computeResourceId);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->dataMovementInterfaceId !== null) {
      $xfer += $output->writeFieldBegin('dataMovementInterfaceId', TType::STRING, 2);
      $xfer += $output->writeString($this->dataMovementInterfaceId);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Airavata_deleteDataMovementInterface_result {
  static $_TSPEC;

  public $success = null;
  public $ire = null;
  public $ace = null;
  public $ase = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::BOOL,
          ),
        1 => array(
          'var' => 'ire',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\InvalidRequestException',
          ),
        2 => array(
          'var' => 'ace',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AiravataClientException',
          ),
        3 => array(
          'var' => 'ase',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AiravataSystemException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['ire'])) {
        $this->ire = $vals['ire'];
      }
      if (isset($vals['ace'])) {
        $this->ace = $vals['ace'];
      }
      if (isset($vals['ase'])) {
        $this->ase = $vals['ase'];
      }
    }
  }

  public function getName() {
    return 'Airavata_deleteDataMovementInterface_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::BOOL) {
            $xfer += $input->readBool($this->success);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->ire = new \Airavata\API\Error\InvalidRequestException();
            $xfer += $this->ire->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->ace = new \Airavata\API\Error\AiravataClientException();
            $xfer += $this->ace->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRUCT) {
            $this->ase = new \Airavata\API\Error\AiravataSystemException();
            $xfer += $this->ase->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Airavata_deleteDataMovementInterface_result');
    if ($this->success !== null) {
      $xfer += $output->writeFieldBegin('success', TType::BOOL, 0);
      $xfer += $output->writeBool($this->success);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ire !== null) {
      $xfer += $output->writeFieldBegin('ire', TType::STRUCT, 1);
      $xfer += $this->ire->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ace !== null) {
      $xfer += $output->writeFieldBegin('ace', TType::STRUCT, 2);
      $xfer += $this->ace->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ase !== null) {
      $xfer += $output->writeFieldBegin('ase', TType::STRUCT, 3);
      $xfer += $this->ase->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Airavata_registerResourceJobManager_args {
  static $_TSPEC;

  public $resourceJobManager = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'resourceJobManager',
          'type' => TType::STRUCT,
          'class' => '\Airavata\Model\AppCatalog\ComputeResource\ResourceJobManager',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['resourceJobManager'])) {
        $this->resourceJobManager = $vals['resourceJobManager'];
      }
    }
  }

  public function getName() {
    return 'Airavata_registerResourceJobManager_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->resourceJobManager = new \Airavata\Model\AppCatalog\ComputeResource\ResourceJobManager();
            $xfer += $this->resourceJobManager->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Airavata_registerResourceJobManager_args');
    if ($this->resourceJobManager !== null) {
      if (!is_object($this->resourceJobManager)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('resourceJobManager', TType::STRUCT, 1);
      $xfer += $this->resourceJobManager->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Airavata_registerResourceJobManager_result {
  static $_TSPEC;

  public $success = null;
  public $ire = null;
  public $ace = null;
  public $ase = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::STRING,
          ),
        1 => array(
          'var' => 'ire',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\InvalidRequestException',
          ),
        2 => array(
          'var' => 'ace',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AiravataClientException',
          ),
        3 => array(
          'var' => 'ase',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AiravataSystemException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['ire'])) {
        $this->ire = $vals['ire'];
      }
      if (isset($vals['ace'])) {
        $this->ace = $vals['ace'];
      }
      if (isset($vals['ase'])) {
        $this->ase = $vals['ase'];
      }
    }
  }

  public function getName() {
    return 'Airavata_registerResourceJobManager_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->success);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->ire = new \Airavata\API\Error\InvalidRequestException();
            $xfer += $this->ire->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->ace = new \Airavata\API\Error\AiravataClientException();
            $xfer += $this->ace->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRUCT) {
            $this->ase = new \Airavata\API\Error\AiravataSystemException();
            $xfer += $this->ase->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Airavata_registerResourceJobManager_result');
    if ($this->success !== null) {
      $xfer += $output->writeFieldBegin('success', TType::STRING, 0);
      $xfer += $output->writeString($this->success);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ire !== null) {
      $xfer += $output->writeFieldBegin('ire', TType::STRUCT, 1);
      $xfer += $this->ire->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ace !== null) {
      $xfer += $output->writeFieldBegin('ace', TType::STRUCT, 2);
      $xfer += $this->ace->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ase !== null) {
      $xfer += $output->writeFieldBegin('ase', TType::STRUCT, 3);
      $xfer += $this->ase->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Airavata_updateResourceJobManager_args {
  static $_TSPEC;

  public $resourceJobManagerId = null;
  public $updatedResourceJobManager = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'resourceJobManagerId',
          'type' => TType::STRING,
          ),
        2 => array(
          'var' => 'updatedResourceJobManager',
          'type' => TType::STRUCT,
          'class' => '\Airavata\Model\AppCatalog\ComputeResource\ResourceJobManager',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['resourceJobManagerId'])) {
        $this->resourceJobManagerId = $vals['resourceJobManagerId'];
      }
      if (isset($vals['updatedResourceJobManager'])) {
        $this->updatedResourceJobManager = $vals['updatedResourceJobManager'];
      }
    }
  }

  public function getName() {
    return 'Airavata_updateResourceJobManager_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->resourceJobManagerId);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->updatedResourceJobManager = new \Airavata\Model\AppCatalog\ComputeResource\ResourceJobManager();
            $xfer += $this->updatedResourceJobManager->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Airavata_updateResourceJobManager_args');
    if ($this->resourceJobManagerId !== null) {
      $xfer += $output->writeFieldBegin('resourceJobManagerId', TType::STRING, 1);
      $xfer += $output->writeString($this->resourceJobManagerId);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->updatedResourceJobManager !== null) {
      if (!is_object($this->updatedResourceJobManager)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('updatedResourceJobManager', TType::STRUCT, 2);
      $xfer += $this->updatedResourceJobManager->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Airavata_updateResourceJobManager_result {
  static $_TSPEC;

  public $success = null;
  public $ire = null;
  public $ace = null;
  public $ase = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::BOOL,
          ),
        1 => array(
          'var' => 'ire',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\InvalidRequestException',
          ),
        2 => array(
          'var' => 'ace',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AiravataClientException',
          ),
        3 => array(
          'var' => 'ase',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AiravataSystemException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['ire'])) {
        $this->ire = $vals['ire'];
      }
      if (isset($vals['ace'])) {
        $this->ace = $vals['ace'];
      }
      if (isset($vals['ase'])) {
        $this->ase = $vals['ase'];
      }
    }
  }

  public function getName() {
    return 'Airavata_updateResourceJobManager_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::BOOL) {
            $xfer += $input->readBool($this->success);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->ire = new \Airavata\API\Error\InvalidRequestException();
            $xfer += $this->ire->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->ace = new \Airavata\API\Error\AiravataClientException();
            $xfer += $this->ace->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRUCT) {
            $this->ase = new \Airavata\API\Error\AiravataSystemException();
            $xfer += $this->ase->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Airavata_updateResourceJobManager_result');
    if ($this->success !== null) {
      $xfer += $output->writeFieldBegin('success', TType::BOOL, 0);
      $xfer += $output->writeBool($this->success);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ire !== null) {
      $xfer += $output->writeFieldBegin('ire', TType::STRUCT, 1);
      $xfer += $this->ire->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ace !== null) {
      $xfer += $output->writeFieldBegin('ace', TType::STRUCT, 2);
      $xfer += $this->ace->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ase !== null) {
      $xfer += $output->writeFieldBegin('ase', TType::STRUCT, 3);
      $xfer += $this->ase->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Airavata_getResourceJobManager_args {
  static $_TSPEC;

  public $resourceJobManagerId = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'resourceJobManagerId',
          'type' => TType::STRING,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['resourceJobManagerId'])) {
        $this->resourceJobManagerId = $vals['resourceJobManagerId'];
      }
    }
  }

  public function getName() {
    return 'Airavata_getResourceJobManager_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->resourceJobManagerId);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Airavata_getResourceJobManager_args');
    if ($this->resourceJobManagerId !== null) {
      $xfer += $output->writeFieldBegin('resourceJobManagerId', TType::STRING, 1);
      $xfer += $output->writeString($this->resourceJobManagerId);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Airavata_getResourceJobManager_result {
  static $_TSPEC;

  public $success = null;
  public $ire = null;
  public $ace = null;
  public $ase = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::STRUCT,
          'class' => '\Airavata\Model\AppCatalog\ComputeResource\ResourceJobManager',
          ),
        1 => array(
          'var' => 'ire',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\InvalidRequestException',
          ),
        2 => array(
          'var' => 'ace',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AiravataClientException',
          ),
        3 => array(
          'var' => 'ase',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AiravataSystemException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['ire'])) {
        $this->ire = $vals['ire'];
      }
      if (isset($vals['ace'])) {
        $this->ace = $vals['ace'];
      }
      if (isset($vals['ase'])) {
        $this->ase = $vals['ase'];
      }
    }
  }

  public function getName() {
    return 'Airavata_getResourceJobManager_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::STRUCT) {
            $this->success = new \Airavata\Model\AppCatalog\ComputeResource\ResourceJobManager();
            $xfer += $this->success->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->ire = new \Airavata\API\Error\InvalidRequestException();
            $xfer += $this->ire->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->ace = new \Airavata\API\Error\AiravataClientException();
            $xfer += $this->ace->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRUCT) {
            $this->ase = new \Airavata\API\Error\AiravataSystemException();
            $xfer += $this->ase->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Airavata_getResourceJobManager_result');
    if ($this->success !== null) {
      if (!is_object($this->success)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('success', TType::STRUCT, 0);
      $xfer += $this->success->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ire !== null) {
      $xfer += $output->writeFieldBegin('ire', TType::STRUCT, 1);
      $xfer += $this->ire->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ace !== null) {
      $xfer += $output->writeFieldBegin('ace', TType::STRUCT, 2);
      $xfer += $this->ace->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ase !== null) {
      $xfer += $output->writeFieldBegin('ase', TType::STRUCT, 3);
      $xfer += $this->ase->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Airavata_deleteResourceJobManager_args {
  static $_TSPEC;

  public $resourceJobManagerId = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'resourceJobManagerId',
          'type' => TType::STRING,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['resourceJobManagerId'])) {
        $this->resourceJobManagerId = $vals['resourceJobManagerId'];
      }
    }
  }

  public function getName() {
    return 'Airavata_deleteResourceJobManager_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->resourceJobManagerId);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Airavata_deleteResourceJobManager_args');
    if ($this->resourceJobManagerId !== null) {
      $xfer += $output->writeFieldBegin('resourceJobManagerId', TType::STRING, 1);
      $xfer += $output->writeString($this->resourceJobManagerId);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Airavata_deleteResourceJobManager_result {
  static $_TSPEC;

  public $success = null;
  public $ire = null;
  public $ace = null;
  public $ase = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::BOOL,
          ),
        1 => array(
          'var' => 'ire',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\InvalidRequestException',
          ),
        2 => array(
          'var' => 'ace',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AiravataClientException',
          ),
        3 => array(
          'var' => 'ase',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AiravataSystemException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['ire'])) {
        $this->ire = $vals['ire'];
      }
      if (isset($vals['ace'])) {
        $this->ace = $vals['ace'];
      }
      if (isset($vals['ase'])) {
        $this->ase = $vals['ase'];
      }
    }
  }

  public function getName() {
    return 'Airavata_deleteResourceJobManager_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::BOOL) {
            $xfer += $input->readBool($this->success);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->ire = new \Airavata\API\Error\InvalidRequestException();
            $xfer += $this->ire->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->ace = new \Airavata\API\Error\AiravataClientException();
            $xfer += $this->ace->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRUCT) {
            $this->ase = new \Airavata\API\Error\AiravataSystemException();
            $xfer += $this->ase->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Airavata_deleteResourceJobManager_result');
    if ($this->success !== null) {
      $xfer += $output->writeFieldBegin('success', TType::BOOL, 0);
      $xfer += $output->writeBool($this->success);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ire !== null) {
      $xfer += $output->writeFieldBegin('ire', TType::STRUCT, 1);
      $xfer += $this->ire->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ace !== null) {
      $xfer += $output->writeFieldBegin('ace', TType::STRUCT, 2);
      $xfer += $this->ace->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ase !== null) {
      $xfer += $output->writeFieldBegin('ase', TType::STRUCT, 3);
      $xfer += $this->ase->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Airavata_deleteBatchQueue_args {
  static $_TSPEC;

  public $computeResourceId = null;
  public $queueName = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'computeResourceId',
          'type' => TType::STRING,
          ),
        2 => array(
          'var' => 'queueName',
          'type' => TType::STRING,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['computeResourceId'])) {
        $this->computeResourceId = $vals['computeResourceId'];
      }
      if (isset($vals['queueName'])) {
        $this->queueName = $vals['queueName'];
      }
    }
  }

  public function getName() {
    return 'Airavata_deleteBatchQueue_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->computeResourceId);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->queueName);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Airavata_deleteBatchQueue_args');
    if ($this->computeResourceId !== null) {
      $xfer += $output->writeFieldBegin('computeResourceId', TType::STRING, 1);
      $xfer += $output->writeString($this->computeResourceId);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->queueName !== null) {
      $xfer += $output->writeFieldBegin('queueName', TType::STRING, 2);
      $xfer += $output->writeString($this->queueName);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Airavata_deleteBatchQueue_result {
  static $_TSPEC;

  public $success = null;
  public $ire = null;
  public $ace = null;
  public $ase = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::BOOL,
          ),
        1 => array(
          'var' => 'ire',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\InvalidRequestException',
          ),
        2 => array(
          'var' => 'ace',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AiravataClientException',
          ),
        3 => array(
          'var' => 'ase',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AiravataSystemException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['ire'])) {
        $this->ire = $vals['ire'];
      }
      if (isset($vals['ace'])) {
        $this->ace = $vals['ace'];
      }
      if (isset($vals['ase'])) {
        $this->ase = $vals['ase'];
      }
    }
  }

  public function getName() {
    return 'Airavata_deleteBatchQueue_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::BOOL) {
            $xfer += $input->readBool($this->success);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->ire = new \Airavata\API\Error\InvalidRequestException();
            $xfer += $this->ire->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->ace = new \Airavata\API\Error\AiravataClientException();
            $xfer += $this->ace->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRUCT) {
            $this->ase = new \Airavata\API\Error\AiravataSystemException();
            $xfer += $this->ase->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Airavata_deleteBatchQueue_result');
    if ($this->success !== null) {
      $xfer += $output->writeFieldBegin('success', TType::BOOL, 0);
      $xfer += $output->writeBool($this->success);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ire !== null) {
      $xfer += $output->writeFieldBegin('ire', TType::STRUCT, 1);
      $xfer += $this->ire->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ace !== null) {
      $xfer += $output->writeFieldBegin('ace', TType::STRUCT, 2);
      $xfer += $this->ace->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ase !== null) {
      $xfer += $output->writeFieldBegin('ase', TType::STRUCT, 3);
      $xfer += $this->ase->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Airavata_registerGatewayResourceProfile_args {
  static $_TSPEC;

  public $gatewayResourceProfile = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'gatewayResourceProfile',
          'type' => TType::STRUCT,
          'class' => '\Airavata\Model\AppCatalog\GatewayProfile\GatewayResourceProfile',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['gatewayResourceProfile'])) {
        $this->gatewayResourceProfile = $vals['gatewayResourceProfile'];
      }
    }
  }

  public function getName() {
    return 'Airavata_registerGatewayResourceProfile_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->gatewayResourceProfile = new \Airavata\Model\AppCatalog\GatewayProfile\GatewayResourceProfile();
            $xfer += $this->gatewayResourceProfile->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Airavata_registerGatewayResourceProfile_args');
    if ($this->gatewayResourceProfile !== null) {
      if (!is_object($this->gatewayResourceProfile)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('gatewayResourceProfile', TType::STRUCT, 1);
      $xfer += $this->gatewayResourceProfile->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Airavata_registerGatewayResourceProfile_result {
  static $_TSPEC;

  public $success = null;
  public $ire = null;
  public $ace = null;
  public $ase = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::STRING,
          ),
        1 => array(
          'var' => 'ire',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\InvalidRequestException',
          ),
        2 => array(
          'var' => 'ace',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AiravataClientException',
          ),
        3 => array(
          'var' => 'ase',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AiravataSystemException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['ire'])) {
        $this->ire = $vals['ire'];
      }
      if (isset($vals['ace'])) {
        $this->ace = $vals['ace'];
      }
      if (isset($vals['ase'])) {
        $this->ase = $vals['ase'];
      }
    }
  }

  public function getName() {
    return 'Airavata_registerGatewayResourceProfile_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->success);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->ire = new \Airavata\API\Error\InvalidRequestException();
            $xfer += $this->ire->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->ace = new \Airavata\API\Error\AiravataClientException();
            $xfer += $this->ace->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRUCT) {
            $this->ase = new \Airavata\API\Error\AiravataSystemException();
            $xfer += $this->ase->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Airavata_registerGatewayResourceProfile_result');
    if ($this->success !== null) {
      $xfer += $output->writeFieldBegin('success', TType::STRING, 0);
      $xfer += $output->writeString($this->success);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ire !== null) {
      $xfer += $output->writeFieldBegin('ire', TType::STRUCT, 1);
      $xfer += $this->ire->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ace !== null) {
      $xfer += $output->writeFieldBegin('ace', TType::STRUCT, 2);
      $xfer += $this->ace->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ase !== null) {
      $xfer += $output->writeFieldBegin('ase', TType::STRUCT, 3);
      $xfer += $this->ase->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Airavata_getGatewayResourceProfile_args {
  static $_TSPEC;

  public $gatewayID = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'gatewayID',
          'type' => TType::STRING,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['gatewayID'])) {
        $this->gatewayID = $vals['gatewayID'];
      }
    }
  }

  public function getName() {
    return 'Airavata_getGatewayResourceProfile_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->gatewayID);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Airavata_getGatewayResourceProfile_args');
    if ($this->gatewayID !== null) {
      $xfer += $output->writeFieldBegin('gatewayID', TType::STRING, 1);
      $xfer += $output->writeString($this->gatewayID);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Airavata_getGatewayResourceProfile_result {
  static $_TSPEC;

  public $success = null;
  public $ire = null;
  public $ace = null;
  public $ase = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::STRUCT,
          'class' => '\Airavata\Model\AppCatalog\GatewayProfile\GatewayResourceProfile',
          ),
        1 => array(
          'var' => 'ire',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\InvalidRequestException',
          ),
        2 => array(
          'var' => 'ace',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AiravataClientException',
          ),
        3 => array(
          'var' => 'ase',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AiravataSystemException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['ire'])) {
        $this->ire = $vals['ire'];
      }
      if (isset($vals['ace'])) {
        $this->ace = $vals['ace'];
      }
      if (isset($vals['ase'])) {
        $this->ase = $vals['ase'];
      }
    }
  }

  public function getName() {
    return 'Airavata_getGatewayResourceProfile_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::STRUCT) {
            $this->success = new \Airavata\Model\AppCatalog\GatewayProfile\GatewayResourceProfile();
            $xfer += $this->success->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->ire = new \Airavata\API\Error\InvalidRequestException();
            $xfer += $this->ire->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->ace = new \Airavata\API\Error\AiravataClientException();
            $xfer += $this->ace->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRUCT) {
            $this->ase = new \Airavata\API\Error\AiravataSystemException();
            $xfer += $this->ase->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Airavata_getGatewayResourceProfile_result');
    if ($this->success !== null) {
      if (!is_object($this->success)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('success', TType::STRUCT, 0);
      $xfer += $this->success->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ire !== null) {
      $xfer += $output->writeFieldBegin('ire', TType::STRUCT, 1);
      $xfer += $this->ire->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ace !== null) {
      $xfer += $output->writeFieldBegin('ace', TType::STRUCT, 2);
      $xfer += $this->ace->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ase !== null) {
      $xfer += $output->writeFieldBegin('ase', TType::STRUCT, 3);
      $xfer += $this->ase->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Airavata_updateGatewayResourceProfile_args {
  static $_TSPEC;

  public $gatewayID = null;
  public $gatewayResourceProfile = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'gatewayID',
          'type' => TType::STRING,
          ),
        2 => array(
          'var' => 'gatewayResourceProfile',
          'type' => TType::STRUCT,
          'class' => '\Airavata\Model\AppCatalog\GatewayProfile\GatewayResourceProfile',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['gatewayID'])) {
        $this->gatewayID = $vals['gatewayID'];
      }
      if (isset($vals['gatewayResourceProfile'])) {
        $this->gatewayResourceProfile = $vals['gatewayResourceProfile'];
      }
    }
  }

  public function getName() {
    return 'Airavata_updateGatewayResourceProfile_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->gatewayID);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->gatewayResourceProfile = new \Airavata\Model\AppCatalog\GatewayProfile\GatewayResourceProfile();
            $xfer += $this->gatewayResourceProfile->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Airavata_updateGatewayResourceProfile_args');
    if ($this->gatewayID !== null) {
      $xfer += $output->writeFieldBegin('gatewayID', TType::STRING, 1);
      $xfer += $output->writeString($this->gatewayID);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->gatewayResourceProfile !== null) {
      if (!is_object($this->gatewayResourceProfile)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('gatewayResourceProfile', TType::STRUCT, 2);
      $xfer += $this->gatewayResourceProfile->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Airavata_updateGatewayResourceProfile_result {
  static $_TSPEC;

  public $success = null;
  public $ire = null;
  public $ace = null;
  public $ase = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::BOOL,
          ),
        1 => array(
          'var' => 'ire',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\InvalidRequestException',
          ),
        2 => array(
          'var' => 'ace',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AiravataClientException',
          ),
        3 => array(
          'var' => 'ase',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AiravataSystemException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['ire'])) {
        $this->ire = $vals['ire'];
      }
      if (isset($vals['ace'])) {
        $this->ace = $vals['ace'];
      }
      if (isset($vals['ase'])) {
        $this->ase = $vals['ase'];
      }
    }
  }

  public function getName() {
    return 'Airavata_updateGatewayResourceProfile_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::BOOL) {
            $xfer += $input->readBool($this->success);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->ire = new \Airavata\API\Error\InvalidRequestException();
            $xfer += $this->ire->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->ace = new \Airavata\API\Error\AiravataClientException();
            $xfer += $this->ace->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRUCT) {
            $this->ase = new \Airavata\API\Error\AiravataSystemException();
            $xfer += $this->ase->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Airavata_updateGatewayResourceProfile_result');
    if ($this->success !== null) {
      $xfer += $output->writeFieldBegin('success', TType::BOOL, 0);
      $xfer += $output->writeBool($this->success);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ire !== null) {
      $xfer += $output->writeFieldBegin('ire', TType::STRUCT, 1);
      $xfer += $this->ire->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ace !== null) {
      $xfer += $output->writeFieldBegin('ace', TType::STRUCT, 2);
      $xfer += $this->ace->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ase !== null) {
      $xfer += $output->writeFieldBegin('ase', TType::STRUCT, 3);
      $xfer += $this->ase->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Airavata_deleteGatewayResourceProfile_args {
  static $_TSPEC;

  public $gatewayID = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'gatewayID',
          'type' => TType::STRING,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['gatewayID'])) {
        $this->gatewayID = $vals['gatewayID'];
      }
    }
  }

  public function getName() {
    return 'Airavata_deleteGatewayResourceProfile_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->gatewayID);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Airavata_deleteGatewayResourceProfile_args');
    if ($this->gatewayID !== null) {
      $xfer += $output->writeFieldBegin('gatewayID', TType::STRING, 1);
      $xfer += $output->writeString($this->gatewayID);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Airavata_deleteGatewayResourceProfile_result {
  static $_TSPEC;

  public $success = null;
  public $ire = null;
  public $ace = null;
  public $ase = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::BOOL,
          ),
        1 => array(
          'var' => 'ire',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\InvalidRequestException',
          ),
        2 => array(
          'var' => 'ace',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AiravataClientException',
          ),
        3 => array(
          'var' => 'ase',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AiravataSystemException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['ire'])) {
        $this->ire = $vals['ire'];
      }
      if (isset($vals['ace'])) {
        $this->ace = $vals['ace'];
      }
      if (isset($vals['ase'])) {
        $this->ase = $vals['ase'];
      }
    }
  }

  public function getName() {
    return 'Airavata_deleteGatewayResourceProfile_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::BOOL) {
            $xfer += $input->readBool($this->success);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->ire = new \Airavata\API\Error\InvalidRequestException();
            $xfer += $this->ire->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->ace = new \Airavata\API\Error\AiravataClientException();
            $xfer += $this->ace->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRUCT) {
            $this->ase = new \Airavata\API\Error\AiravataSystemException();
            $xfer += $this->ase->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Airavata_deleteGatewayResourceProfile_result');
    if ($this->success !== null) {
      $xfer += $output->writeFieldBegin('success', TType::BOOL, 0);
      $xfer += $output->writeBool($this->success);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ire !== null) {
      $xfer += $output->writeFieldBegin('ire', TType::STRUCT, 1);
      $xfer += $this->ire->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ace !== null) {
      $xfer += $output->writeFieldBegin('ace', TType::STRUCT, 2);
      $xfer += $this->ace->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ase !== null) {
      $xfer += $output->writeFieldBegin('ase', TType::STRUCT, 3);
      $xfer += $this->ase->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Airavata_addGatewayComputeResourcePreference_args {
  static $_TSPEC;

  public $gatewayID = null;
  public $computeResourceId = null;
  public $computeResourcePreference = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'gatewayID',
          'type' => TType::STRING,
          ),
        2 => array(
          'var' => 'computeResourceId',
          'type' => TType::STRING,
          ),
        3 => array(
          'var' => 'computeResourcePreference',
          'type' => TType::STRUCT,
          'class' => '\Airavata\Model\AppCatalog\GatewayProfile\ComputeResourcePreference',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['gatewayID'])) {
        $this->gatewayID = $vals['gatewayID'];
      }
      if (isset($vals['computeResourceId'])) {
        $this->computeResourceId = $vals['computeResourceId'];
      }
      if (isset($vals['computeResourcePreference'])) {
        $this->computeResourcePreference = $vals['computeResourcePreference'];
      }
    }
  }

  public function getName() {
    return 'Airavata_addGatewayComputeResourcePreference_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->gatewayID);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->computeResourceId);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRUCT) {
            $this->computeResourcePreference = new \Airavata\Model\AppCatalog\GatewayProfile\ComputeResourcePreference();
            $xfer += $this->computeResourcePreference->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Airavata_addGatewayComputeResourcePreference_args');
    if ($this->gatewayID !== null) {
      $xfer += $output->writeFieldBegin('gatewayID', TType::STRING, 1);
      $xfer += $output->writeString($this->gatewayID);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->computeResourceId !== null) {
      $xfer += $output->writeFieldBegin('computeResourceId', TType::STRING, 2);
      $xfer += $output->writeString($this->computeResourceId);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->computeResourcePreference !== null) {
      if (!is_object($this->computeResourcePreference)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('computeResourcePreference', TType::STRUCT, 3);
      $xfer += $this->computeResourcePreference->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Airavata_addGatewayComputeResourcePreference_result {
  static $_TSPEC;

  public $success = null;
  public $ire = null;
  public $ace = null;
  public $ase = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::BOOL,
          ),
        1 => array(
          'var' => 'ire',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\InvalidRequestException',
          ),
        2 => array(
          'var' => 'ace',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AiravataClientException',
          ),
        3 => array(
          'var' => 'ase',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AiravataSystemException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['ire'])) {
        $this->ire = $vals['ire'];
      }
      if (isset($vals['ace'])) {
        $this->ace = $vals['ace'];
      }
      if (isset($vals['ase'])) {
        $this->ase = $vals['ase'];
      }
    }
  }

  public function getName() {
    return 'Airavata_addGatewayComputeResourcePreference_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::BOOL) {
            $xfer += $input->readBool($this->success);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->ire = new \Airavata\API\Error\InvalidRequestException();
            $xfer += $this->ire->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->ace = new \Airavata\API\Error\AiravataClientException();
            $xfer += $this->ace->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRUCT) {
            $this->ase = new \Airavata\API\Error\AiravataSystemException();
            $xfer += $this->ase->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Airavata_addGatewayComputeResourcePreference_result');
    if ($this->success !== null) {
      $xfer += $output->writeFieldBegin('success', TType::BOOL, 0);
      $xfer += $output->writeBool($this->success);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ire !== null) {
      $xfer += $output->writeFieldBegin('ire', TType::STRUCT, 1);
      $xfer += $this->ire->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ace !== null) {
      $xfer += $output->writeFieldBegin('ace', TType::STRUCT, 2);
      $xfer += $this->ace->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ase !== null) {
      $xfer += $output->writeFieldBegin('ase', TType::STRUCT, 3);
      $xfer += $this->ase->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Airavata_getGatewayComputeResourcePreference_args {
  static $_TSPEC;

  public $gatewayID = null;
  public $computeResourceId = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'gatewayID',
          'type' => TType::STRING,
          ),
        2 => array(
          'var' => 'computeResourceId',
          'type' => TType::STRING,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['gatewayID'])) {
        $this->gatewayID = $vals['gatewayID'];
      }
      if (isset($vals['computeResourceId'])) {
        $this->computeResourceId = $vals['computeResourceId'];
      }
    }
  }

  public function getName() {
    return 'Airavata_getGatewayComputeResourcePreference_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->gatewayID);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->computeResourceId);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Airavata_getGatewayComputeResourcePreference_args');
    if ($this->gatewayID !== null) {
      $xfer += $output->writeFieldBegin('gatewayID', TType::STRING, 1);
      $xfer += $output->writeString($this->gatewayID);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->computeResourceId !== null) {
      $xfer += $output->writeFieldBegin('computeResourceId', TType::STRING, 2);
      $xfer += $output->writeString($this->computeResourceId);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Airavata_getGatewayComputeResourcePreference_result {
  static $_TSPEC;

  public $success = null;
  public $ire = null;
  public $ace = null;
  public $ase = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::STRUCT,
          'class' => '\Airavata\Model\AppCatalog\GatewayProfile\ComputeResourcePreference',
          ),
        1 => array(
          'var' => 'ire',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\InvalidRequestException',
          ),
        2 => array(
          'var' => 'ace',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AiravataClientException',
          ),
        3 => array(
          'var' => 'ase',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AiravataSystemException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['ire'])) {
        $this->ire = $vals['ire'];
      }
      if (isset($vals['ace'])) {
        $this->ace = $vals['ace'];
      }
      if (isset($vals['ase'])) {
        $this->ase = $vals['ase'];
      }
    }
  }

  public function getName() {
    return 'Airavata_getGatewayComputeResourcePreference_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::STRUCT) {
            $this->success = new \Airavata\Model\AppCatalog\GatewayProfile\ComputeResourcePreference();
            $xfer += $this->success->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->ire = new \Airavata\API\Error\InvalidRequestException();
            $xfer += $this->ire->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->ace = new \Airavata\API\Error\AiravataClientException();
            $xfer += $this->ace->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRUCT) {
            $this->ase = new \Airavata\API\Error\AiravataSystemException();
            $xfer += $this->ase->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Airavata_getGatewayComputeResourcePreference_result');
    if ($this->success !== null) {
      if (!is_object($this->success)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('success', TType::STRUCT, 0);
      $xfer += $this->success->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ire !== null) {
      $xfer += $output->writeFieldBegin('ire', TType::STRUCT, 1);
      $xfer += $this->ire->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ace !== null) {
      $xfer += $output->writeFieldBegin('ace', TType::STRUCT, 2);
      $xfer += $this->ace->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ase !== null) {
      $xfer += $output->writeFieldBegin('ase', TType::STRUCT, 3);
      $xfer += $this->ase->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Airavata_getAllGatewayComputeResourcePreferences_args {
  static $_TSPEC;

  public $gatewayID = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'gatewayID',
          'type' => TType::STRING,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['gatewayID'])) {
        $this->gatewayID = $vals['gatewayID'];
      }
    }
  }

  public function getName() {
    return 'Airavata_getAllGatewayComputeResourcePreferences_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->gatewayID);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Airavata_getAllGatewayComputeResourcePreferences_args');
    if ($this->gatewayID !== null) {
      $xfer += $output->writeFieldBegin('gatewayID', TType::STRING, 1);
      $xfer += $output->writeString($this->gatewayID);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Airavata_getAllGatewayComputeResourcePreferences_result {
  static $_TSPEC;

  public $success = null;
  public $ire = null;
  public $ace = null;
  public $ase = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::LST,
          'etype' => TType::STRUCT,
          'elem' => array(
            'type' => TType::STRUCT,
            'class' => '\Airavata\Model\AppCatalog\GatewayProfile\ComputeResourcePreference',
            ),
          ),
        1 => array(
          'var' => 'ire',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\InvalidRequestException',
          ),
        2 => array(
          'var' => 'ace',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AiravataClientException',
          ),
        3 => array(
          'var' => 'ase',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AiravataSystemException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['ire'])) {
        $this->ire = $vals['ire'];
      }
      if (isset($vals['ace'])) {
        $this->ace = $vals['ace'];
      }
      if (isset($vals['ase'])) {
        $this->ase = $vals['ase'];
      }
    }
  }

  public function getName() {
    return 'Airavata_getAllGatewayComputeResourcePreferences_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::LST) {
            $this->success = array();
            $_size187 = 0;
            $_etype190 = 0;
            $xfer += $input->readListBegin($_etype190, $_size187);
            for ($_i191 = 0; $_i191 < $_size187; ++$_i191)
            {
              $elem192 = null;
              $elem192 = new \Airavata\Model\AppCatalog\GatewayProfile\ComputeResourcePreference();
              $xfer += $elem192->read($input);
              $this->success []= $elem192;
            }
            $xfer += $input->readListEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->ire = new \Airavata\API\Error\InvalidRequestException();
            $xfer += $this->ire->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->ace = new \Airavata\API\Error\AiravataClientException();
            $xfer += $this->ace->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRUCT) {
            $this->ase = new \Airavata\API\Error\AiravataSystemException();
            $xfer += $this->ase->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Airavata_getAllGatewayComputeResourcePreferences_result');
    if ($this->success !== null) {
      if (!is_array($this->success)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('success', TType::LST, 0);
      {
        $output->writeListBegin(TType::STRUCT, count($this->success));
        {
          foreach ($this->success as $iter193)
          {
            $xfer += $iter193->write($output);
          }
        }
        $output->writeListEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ire !== null) {
      $xfer += $output->writeFieldBegin('ire', TType::STRUCT, 1);
      $xfer += $this->ire->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ace !== null) {
      $xfer += $output->writeFieldBegin('ace', TType::STRUCT, 2);
      $xfer += $this->ace->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ase !== null) {
      $xfer += $output->writeFieldBegin('ase', TType::STRUCT, 3);
      $xfer += $this->ase->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Airavata_updateGatewayComputeResourcePreference_args {
  static $_TSPEC;

  public $gatewayID = null;
  public $computeResourceId = null;
  public $computeResourcePreference = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'gatewayID',
          'type' => TType::STRING,
          ),
        2 => array(
          'var' => 'computeResourceId',
          'type' => TType::STRING,
          ),
        3 => array(
          'var' => 'computeResourcePreference',
          'type' => TType::STRUCT,
          'class' => '\Airavata\Model\AppCatalog\GatewayProfile\ComputeResourcePreference',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['gatewayID'])) {
        $this->gatewayID = $vals['gatewayID'];
      }
      if (isset($vals['computeResourceId'])) {
        $this->computeResourceId = $vals['computeResourceId'];
      }
      if (isset($vals['computeResourcePreference'])) {
        $this->computeResourcePreference = $vals['computeResourcePreference'];
      }
    }
  }

  public function getName() {
    return 'Airavata_updateGatewayComputeResourcePreference_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->gatewayID);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->computeResourceId);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRUCT) {
            $this->computeResourcePreference = new \Airavata\Model\AppCatalog\GatewayProfile\ComputeResourcePreference();
            $xfer += $this->computeResourcePreference->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Airavata_updateGatewayComputeResourcePreference_args');
    if ($this->gatewayID !== null) {
      $xfer += $output->writeFieldBegin('gatewayID', TType::STRING, 1);
      $xfer += $output->writeString($this->gatewayID);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->computeResourceId !== null) {
      $xfer += $output->writeFieldBegin('computeResourceId', TType::STRING, 2);
      $xfer += $output->writeString($this->computeResourceId);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->computeResourcePreference !== null) {
      if (!is_object($this->computeResourcePreference)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('computeResourcePreference', TType::STRUCT, 3);
      $xfer += $this->computeResourcePreference->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Airavata_updateGatewayComputeResourcePreference_result {
  static $_TSPEC;

  public $success = null;
  public $ire = null;
  public $ace = null;
  public $ase = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::BOOL,
          ),
        1 => array(
          'var' => 'ire',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\InvalidRequestException',
          ),
        2 => array(
          'var' => 'ace',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AiravataClientException',
          ),
        3 => array(
          'var' => 'ase',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AiravataSystemException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['ire'])) {
        $this->ire = $vals['ire'];
      }
      if (isset($vals['ace'])) {
        $this->ace = $vals['ace'];
      }
      if (isset($vals['ase'])) {
        $this->ase = $vals['ase'];
      }
    }
  }

  public function getName() {
    return 'Airavata_updateGatewayComputeResourcePreference_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::BOOL) {
            $xfer += $input->readBool($this->success);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->ire = new \Airavata\API\Error\InvalidRequestException();
            $xfer += $this->ire->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->ace = new \Airavata\API\Error\AiravataClientException();
            $xfer += $this->ace->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRUCT) {
            $this->ase = new \Airavata\API\Error\AiravataSystemException();
            $xfer += $this->ase->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Airavata_updateGatewayComputeResourcePreference_result');
    if ($this->success !== null) {
      $xfer += $output->writeFieldBegin('success', TType::BOOL, 0);
      $xfer += $output->writeBool($this->success);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ire !== null) {
      $xfer += $output->writeFieldBegin('ire', TType::STRUCT, 1);
      $xfer += $this->ire->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ace !== null) {
      $xfer += $output->writeFieldBegin('ace', TType::STRUCT, 2);
      $xfer += $this->ace->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ase !== null) {
      $xfer += $output->writeFieldBegin('ase', TType::STRUCT, 3);
      $xfer += $this->ase->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Airavata_deleteGatewayComputeResourcePreference_args {
  static $_TSPEC;

  public $gatewayID = null;
  public $computeResourceId = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'gatewayID',
          'type' => TType::STRING,
          ),
        2 => array(
          'var' => 'computeResourceId',
          'type' => TType::STRING,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['gatewayID'])) {
        $this->gatewayID = $vals['gatewayID'];
      }
      if (isset($vals['computeResourceId'])) {
        $this->computeResourceId = $vals['computeResourceId'];
      }
    }
  }

  public function getName() {
    return 'Airavata_deleteGatewayComputeResourcePreference_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->gatewayID);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->computeResourceId);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Airavata_deleteGatewayComputeResourcePreference_args');
    if ($this->gatewayID !== null) {
      $xfer += $output->writeFieldBegin('gatewayID', TType::STRING, 1);
      $xfer += $output->writeString($this->gatewayID);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->computeResourceId !== null) {
      $xfer += $output->writeFieldBegin('computeResourceId', TType::STRING, 2);
      $xfer += $output->writeString($this->computeResourceId);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Airavata_deleteGatewayComputeResourcePreference_result {
  static $_TSPEC;

  public $success = null;
  public $ire = null;
  public $ace = null;
  public $ase = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::BOOL,
          ),
        1 => array(
          'var' => 'ire',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\InvalidRequestException',
          ),
        2 => array(
          'var' => 'ace',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AiravataClientException',
          ),
        3 => array(
          'var' => 'ase',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AiravataSystemException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['ire'])) {
        $this->ire = $vals['ire'];
      }
      if (isset($vals['ace'])) {
        $this->ace = $vals['ace'];
      }
      if (isset($vals['ase'])) {
        $this->ase = $vals['ase'];
      }
    }
  }

  public function getName() {
    return 'Airavata_deleteGatewayComputeResourcePreference_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::BOOL) {
            $xfer += $input->readBool($this->success);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->ire = new \Airavata\API\Error\InvalidRequestException();
            $xfer += $this->ire->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->ace = new \Airavata\API\Error\AiravataClientException();
            $xfer += $this->ace->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRUCT) {
            $this->ase = new \Airavata\API\Error\AiravataSystemException();
            $xfer += $this->ase->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Airavata_deleteGatewayComputeResourcePreference_result');
    if ($this->success !== null) {
      $xfer += $output->writeFieldBegin('success', TType::BOOL, 0);
      $xfer += $output->writeBool($this->success);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ire !== null) {
      $xfer += $output->writeFieldBegin('ire', TType::STRUCT, 1);
      $xfer += $this->ire->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ace !== null) {
      $xfer += $output->writeFieldBegin('ace', TType::STRUCT, 2);
      $xfer += $this->ace->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ase !== null) {
      $xfer += $output->writeFieldBegin('ase', TType::STRUCT, 3);
      $xfer += $this->ase->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Airavata_getAllWorkflows_args {
  static $_TSPEC;


  public function __construct() {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        );
    }
  }

  public function getName() {
    return 'Airavata_getAllWorkflows_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Airavata_getAllWorkflows_args');
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Airavata_getAllWorkflows_result {
  static $_TSPEC;

  public $success = null;
  public $ire = null;
  public $ace = null;
  public $ase = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::LST,
          'etype' => TType::STRING,
          'elem' => array(
            'type' => TType::STRING,
            ),
          ),
        1 => array(
          'var' => 'ire',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\InvalidRequestException',
          ),
        2 => array(
          'var' => 'ace',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AiravataClientException',
          ),
        3 => array(
          'var' => 'ase',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AiravataSystemException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['ire'])) {
        $this->ire = $vals['ire'];
      }
      if (isset($vals['ace'])) {
        $this->ace = $vals['ace'];
      }
      if (isset($vals['ase'])) {
        $this->ase = $vals['ase'];
      }
    }
  }

  public function getName() {
    return 'Airavata_getAllWorkflows_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::LST) {
            $this->success = array();
            $_size194 = 0;
            $_etype197 = 0;
            $xfer += $input->readListBegin($_etype197, $_size194);
            for ($_i198 = 0; $_i198 < $_size194; ++$_i198)
            {
              $elem199 = null;
              $xfer += $input->readString($elem199);
              $this->success []= $elem199;
            }
            $xfer += $input->readListEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->ire = new \Airavata\API\Error\InvalidRequestException();
            $xfer += $this->ire->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->ace = new \Airavata\API\Error\AiravataClientException();
            $xfer += $this->ace->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRUCT) {
            $this->ase = new \Airavata\API\Error\AiravataSystemException();
            $xfer += $this->ase->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Airavata_getAllWorkflows_result');
    if ($this->success !== null) {
      if (!is_array($this->success)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('success', TType::LST, 0);
      {
        $output->writeListBegin(TType::STRING, count($this->success));
        {
          foreach ($this->success as $iter200)
          {
            $xfer += $output->writeString($iter200);
          }
        }
        $output->writeListEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ire !== null) {
      $xfer += $output->writeFieldBegin('ire', TType::STRUCT, 1);
      $xfer += $this->ire->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ace !== null) {
      $xfer += $output->writeFieldBegin('ace', TType::STRUCT, 2);
      $xfer += $this->ace->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ase !== null) {
      $xfer += $output->writeFieldBegin('ase', TType::STRUCT, 3);
      $xfer += $this->ase->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Airavata_getWorkflow_args {
  static $_TSPEC;

  public $workflowTemplateId = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'workflowTemplateId',
          'type' => TType::STRING,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['workflowTemplateId'])) {
        $this->workflowTemplateId = $vals['workflowTemplateId'];
      }
    }
  }

  public function getName() {
    return 'Airavata_getWorkflow_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->workflowTemplateId);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Airavata_getWorkflow_args');
    if ($this->workflowTemplateId !== null) {
      $xfer += $output->writeFieldBegin('workflowTemplateId', TType::STRING, 1);
      $xfer += $output->writeString($this->workflowTemplateId);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Airavata_getWorkflow_result {
  static $_TSPEC;

  public $success = null;
  public $ire = null;
  public $ace = null;
  public $ase = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::STRUCT,
          'class' => '\Airavata\Model\Workflow',
          ),
        1 => array(
          'var' => 'ire',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\InvalidRequestException',
          ),
        2 => array(
          'var' => 'ace',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AiravataClientException',
          ),
        3 => array(
          'var' => 'ase',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AiravataSystemException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['ire'])) {
        $this->ire = $vals['ire'];
      }
      if (isset($vals['ace'])) {
        $this->ace = $vals['ace'];
      }
      if (isset($vals['ase'])) {
        $this->ase = $vals['ase'];
      }
    }
  }

  public function getName() {
    return 'Airavata_getWorkflow_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::STRUCT) {
            $this->success = new \Airavata\Model\Workflow();
            $xfer += $this->success->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->ire = new \Airavata\API\Error\InvalidRequestException();
            $xfer += $this->ire->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->ace = new \Airavata\API\Error\AiravataClientException();
            $xfer += $this->ace->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRUCT) {
            $this->ase = new \Airavata\API\Error\AiravataSystemException();
            $xfer += $this->ase->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Airavata_getWorkflow_result');
    if ($this->success !== null) {
      if (!is_object($this->success)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('success', TType::STRUCT, 0);
      $xfer += $this->success->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ire !== null) {
      $xfer += $output->writeFieldBegin('ire', TType::STRUCT, 1);
      $xfer += $this->ire->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ace !== null) {
      $xfer += $output->writeFieldBegin('ace', TType::STRUCT, 2);
      $xfer += $this->ace->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ase !== null) {
      $xfer += $output->writeFieldBegin('ase', TType::STRUCT, 3);
      $xfer += $this->ase->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Airavata_deleteWorkflow_args {
  static $_TSPEC;

  public $workflowTemplateId = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'workflowTemplateId',
          'type' => TType::STRING,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['workflowTemplateId'])) {
        $this->workflowTemplateId = $vals['workflowTemplateId'];
      }
    }
  }

  public function getName() {
    return 'Airavata_deleteWorkflow_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->workflowTemplateId);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Airavata_deleteWorkflow_args');
    if ($this->workflowTemplateId !== null) {
      $xfer += $output->writeFieldBegin('workflowTemplateId', TType::STRING, 1);
      $xfer += $output->writeString($this->workflowTemplateId);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Airavata_deleteWorkflow_result {
  static $_TSPEC;

  public $ire = null;
  public $ace = null;
  public $ase = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'ire',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\InvalidRequestException',
          ),
        2 => array(
          'var' => 'ace',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AiravataClientException',
          ),
        3 => array(
          'var' => 'ase',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AiravataSystemException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['ire'])) {
        $this->ire = $vals['ire'];
      }
      if (isset($vals['ace'])) {
        $this->ace = $vals['ace'];
      }
      if (isset($vals['ase'])) {
        $this->ase = $vals['ase'];
      }
    }
  }

  public function getName() {
    return 'Airavata_deleteWorkflow_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->ire = new \Airavata\API\Error\InvalidRequestException();
            $xfer += $this->ire->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->ace = new \Airavata\API\Error\AiravataClientException();
            $xfer += $this->ace->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRUCT) {
            $this->ase = new \Airavata\API\Error\AiravataSystemException();
            $xfer += $this->ase->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Airavata_deleteWorkflow_result');
    if ($this->ire !== null) {
      $xfer += $output->writeFieldBegin('ire', TType::STRUCT, 1);
      $xfer += $this->ire->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ace !== null) {
      $xfer += $output->writeFieldBegin('ace', TType::STRUCT, 2);
      $xfer += $this->ace->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ase !== null) {
      $xfer += $output->writeFieldBegin('ase', TType::STRUCT, 3);
      $xfer += $this->ase->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Airavata_registerWorkflow_args {
  static $_TSPEC;

  public $workflow = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'workflow',
          'type' => TType::STRUCT,
          'class' => '\Airavata\Model\Workflow',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['workflow'])) {
        $this->workflow = $vals['workflow'];
      }
    }
  }

  public function getName() {
    return 'Airavata_registerWorkflow_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->workflow = new \Airavata\Model\Workflow();
            $xfer += $this->workflow->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Airavata_registerWorkflow_args');
    if ($this->workflow !== null) {
      if (!is_object($this->workflow)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('workflow', TType::STRUCT, 1);
      $xfer += $this->workflow->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Airavata_registerWorkflow_result {
  static $_TSPEC;

  public $success = null;
  public $ire = null;
  public $ace = null;
  public $ase = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::STRING,
          ),
        1 => array(
          'var' => 'ire',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\InvalidRequestException',
          ),
        2 => array(
          'var' => 'ace',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AiravataClientException',
          ),
        3 => array(
          'var' => 'ase',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AiravataSystemException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['ire'])) {
        $this->ire = $vals['ire'];
      }
      if (isset($vals['ace'])) {
        $this->ace = $vals['ace'];
      }
      if (isset($vals['ase'])) {
        $this->ase = $vals['ase'];
      }
    }
  }

  public function getName() {
    return 'Airavata_registerWorkflow_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->success);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->ire = new \Airavata\API\Error\InvalidRequestException();
            $xfer += $this->ire->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->ace = new \Airavata\API\Error\AiravataClientException();
            $xfer += $this->ace->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRUCT) {
            $this->ase = new \Airavata\API\Error\AiravataSystemException();
            $xfer += $this->ase->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Airavata_registerWorkflow_result');
    if ($this->success !== null) {
      $xfer += $output->writeFieldBegin('success', TType::STRING, 0);
      $xfer += $output->writeString($this->success);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ire !== null) {
      $xfer += $output->writeFieldBegin('ire', TType::STRUCT, 1);
      $xfer += $this->ire->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ace !== null) {
      $xfer += $output->writeFieldBegin('ace', TType::STRUCT, 2);
      $xfer += $this->ace->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ase !== null) {
      $xfer += $output->writeFieldBegin('ase', TType::STRUCT, 3);
      $xfer += $this->ase->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Airavata_updateWorkflow_args {
  static $_TSPEC;

  public $workflowTemplateId = null;
  public $workflow = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'workflowTemplateId',
          'type' => TType::STRING,
          ),
        2 => array(
          'var' => 'workflow',
          'type' => TType::STRUCT,
          'class' => '\Airavata\Model\Workflow',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['workflowTemplateId'])) {
        $this->workflowTemplateId = $vals['workflowTemplateId'];
      }
      if (isset($vals['workflow'])) {
        $this->workflow = $vals['workflow'];
      }
    }
  }

  public function getName() {
    return 'Airavata_updateWorkflow_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->workflowTemplateId);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->workflow = new \Airavata\Model\Workflow();
            $xfer += $this->workflow->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Airavata_updateWorkflow_args');
    if ($this->workflowTemplateId !== null) {
      $xfer += $output->writeFieldBegin('workflowTemplateId', TType::STRING, 1);
      $xfer += $output->writeString($this->workflowTemplateId);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->workflow !== null) {
      if (!is_object($this->workflow)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('workflow', TType::STRUCT, 2);
      $xfer += $this->workflow->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Airavata_updateWorkflow_result {
  static $_TSPEC;

  public $ire = null;
  public $ace = null;
  public $ase = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'ire',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\InvalidRequestException',
          ),
        2 => array(
          'var' => 'ace',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AiravataClientException',
          ),
        3 => array(
          'var' => 'ase',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AiravataSystemException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['ire'])) {
        $this->ire = $vals['ire'];
      }
      if (isset($vals['ace'])) {
        $this->ace = $vals['ace'];
      }
      if (isset($vals['ase'])) {
        $this->ase = $vals['ase'];
      }
    }
  }

  public function getName() {
    return 'Airavata_updateWorkflow_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->ire = new \Airavata\API\Error\InvalidRequestException();
            $xfer += $this->ire->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->ace = new \Airavata\API\Error\AiravataClientException();
            $xfer += $this->ace->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRUCT) {
            $this->ase = new \Airavata\API\Error\AiravataSystemException();
            $xfer += $this->ase->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Airavata_updateWorkflow_result');
    if ($this->ire !== null) {
      $xfer += $output->writeFieldBegin('ire', TType::STRUCT, 1);
      $xfer += $this->ire->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ace !== null) {
      $xfer += $output->writeFieldBegin('ace', TType::STRUCT, 2);
      $xfer += $this->ace->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ase !== null) {
      $xfer += $output->writeFieldBegin('ase', TType::STRUCT, 3);
      $xfer += $this->ase->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Airavata_getWorkflowTemplateId_args {
  static $_TSPEC;

  public $workflowName = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'workflowName',
          'type' => TType::STRING,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['workflowName'])) {
        $this->workflowName = $vals['workflowName'];
      }
    }
  }

  public function getName() {
    return 'Airavata_getWorkflowTemplateId_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->workflowName);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Airavata_getWorkflowTemplateId_args');
    if ($this->workflowName !== null) {
      $xfer += $output->writeFieldBegin('workflowName', TType::STRING, 1);
      $xfer += $output->writeString($this->workflowName);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Airavata_getWorkflowTemplateId_result {
  static $_TSPEC;

  public $success = null;
  public $ire = null;
  public $ace = null;
  public $ase = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::STRING,
          ),
        1 => array(
          'var' => 'ire',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\InvalidRequestException',
          ),
        2 => array(
          'var' => 'ace',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AiravataClientException',
          ),
        3 => array(
          'var' => 'ase',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AiravataSystemException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['ire'])) {
        $this->ire = $vals['ire'];
      }
      if (isset($vals['ace'])) {
        $this->ace = $vals['ace'];
      }
      if (isset($vals['ase'])) {
        $this->ase = $vals['ase'];
      }
    }
  }

  public function getName() {
    return 'Airavata_getWorkflowTemplateId_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->success);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->ire = new \Airavata\API\Error\InvalidRequestException();
            $xfer += $this->ire->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->ace = new \Airavata\API\Error\AiravataClientException();
            $xfer += $this->ace->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRUCT) {
            $this->ase = new \Airavata\API\Error\AiravataSystemException();
            $xfer += $this->ase->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Airavata_getWorkflowTemplateId_result');
    if ($this->success !== null) {
      $xfer += $output->writeFieldBegin('success', TType::STRING, 0);
      $xfer += $output->writeString($this->success);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ire !== null) {
      $xfer += $output->writeFieldBegin('ire', TType::STRUCT, 1);
      $xfer += $this->ire->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ace !== null) {
      $xfer += $output->writeFieldBegin('ace', TType::STRUCT, 2);
      $xfer += $this->ace->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ase !== null) {
      $xfer += $output->writeFieldBegin('ase', TType::STRUCT, 3);
      $xfer += $this->ase->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Airavata_isWorkflowExistWithName_args {
  static $_TSPEC;

  public $workflowName = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'workflowName',
          'type' => TType::STRING,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['workflowName'])) {
        $this->workflowName = $vals['workflowName'];
      }
    }
  }

  public function getName() {
    return 'Airavata_isWorkflowExistWithName_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->workflowName);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Airavata_isWorkflowExistWithName_args');
    if ($this->workflowName !== null) {
      $xfer += $output->writeFieldBegin('workflowName', TType::STRING, 1);
      $xfer += $output->writeString($this->workflowName);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class Airavata_isWorkflowExistWithName_result {
  static $_TSPEC;

  public $success = null;
  public $ire = null;
  public $ace = null;
  public $ase = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::BOOL,
          ),
        1 => array(
          'var' => 'ire',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\InvalidRequestException',
          ),
        2 => array(
          'var' => 'ace',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AiravataClientException',
          ),
        3 => array(
          'var' => 'ase',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AiravataSystemException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['ire'])) {
        $this->ire = $vals['ire'];
      }
      if (isset($vals['ace'])) {
        $this->ace = $vals['ace'];
      }
      if (isset($vals['ase'])) {
        $this->ase = $vals['ase'];
      }
    }
  }

  public function getName() {
    return 'Airavata_isWorkflowExistWithName_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::BOOL) {
            $xfer += $input->readBool($this->success);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->ire = new \Airavata\API\Error\InvalidRequestException();
            $xfer += $this->ire->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->ace = new \Airavata\API\Error\AiravataClientException();
            $xfer += $this->ace->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRUCT) {
            $this->ase = new \Airavata\API\Error\AiravataSystemException();
            $xfer += $this->ase->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('Airavata_isWorkflowExistWithName_result');
    if ($this->success !== null) {
      $xfer += $output->writeFieldBegin('success', TType::BOOL, 0);
      $xfer += $output->writeBool($this->success);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ire !== null) {
      $xfer += $output->writeFieldBegin('ire', TType::STRUCT, 1);
      $xfer += $this->ire->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ace !== null) {
      $xfer += $output->writeFieldBegin('ace', TType::STRUCT, 2);
      $xfer += $this->ace->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ase !== null) {
      $xfer += $output->writeFieldBegin('ase', TType::STRUCT, 3);
      $xfer += $this->ase->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}


