// This autogenerated skeleton file illustrates how to build a server.
// You should copy it to another filename to avoid overwriting it.

#include "ApplicationCatalogAPI.h"
#include <thrift/protocol/TBinaryProtocol.h>
#include <thrift/server/TSimpleServer.h>
#include <thrift/transport/TServerSocket.h>
#include <thrift/transport/TBufferTransports.h>

using namespace ::apache::thrift;
using namespace ::apache::thrift::protocol;
using namespace ::apache::thrift::transport;
using namespace ::apache::thrift::server;

using boost::shared_ptr;

using namespace  ::airavata::api::appcatalog;

class ApplicationCatalogAPIHandler : virtual public ApplicationCatalogAPIIf {
 public:
  ApplicationCatalogAPIHandler() {
    // Your initialization goes here
  }

  void GetAPIVersion(std::string& _return) {
    // Your implementation goes here
    printf("GetAPIVersion\n");
  }

  void addComputeResourceDescription(std::string& _return, const  ::ComputeResourceDescription& computeResourceDescription) {
    // Your implementation goes here
    printf("addComputeResourceDescription\n");
  }

  void addSSHJobSubmissionProtocol(std::string& _return, const std::string& computeResourceId, const  ::SSHJobSubmission& jobSubmission) {
    // Your implementation goes here
    printf("addSSHJobSubmissionProtocol\n");
  }

  void addGSISSHJobSubmissionProtocol(std::string& _return, const std::string& computeResourceId, const  ::GSISSHJobSubmission& jobSubmission) {
    // Your implementation goes here
    printf("addGSISSHJobSubmissionProtocol\n");
  }

  void addGlobusJobSubmissionProtocol(std::string& _return, const std::string& computeResourceId, const  ::GlobusJobSubmission& jobSubmission) {
    // Your implementation goes here
    printf("addGlobusJobSubmissionProtocol\n");
  }

  void addSCPDataMovementProtocol(std::string& _return, const std::string& computeResourceId, const  ::SCPDataMovement& dataMovement) {
    // Your implementation goes here
    printf("addSCPDataMovementProtocol\n");
  }

  void addGridFTPDataMovementProtocol(std::string& _return, const std::string& computeResourceId, const  ::GridFTPDataMovement& dataMovement) {
    // Your implementation goes here
    printf("addGridFTPDataMovementProtocol\n");
  }

  void listComputeResourceDescriptions(std::vector<std::string> & _return) {
    // Your implementation goes here
    printf("listComputeResourceDescriptions\n");
  }

  void getComputeResourceDescription( ::ComputeResourceDescription& _return, const std::string& computeResourceId) {
    // Your implementation goes here
    printf("getComputeResourceDescription\n");
  }

  void getSSHJobSubmissionProtocol( ::SSHJobSubmission& _return, const std::string& sshJobSubmissionProtocolResourceId) {
    // Your implementation goes here
    printf("getSSHJobSubmissionProtocol\n");
  }

  void getGSISSHJobSubmissionProtocol( ::GSISSHJobSubmission& _return, const std::string& gsisshJobSubmissionProtocolResourceId) {
    // Your implementation goes here
    printf("getGSISSHJobSubmissionProtocol\n");
  }

  void getGlobusJobSubmissionProtocol( ::GlobusJobSubmission& _return, const std::string& globusJobSubmissionProtocolResourceId) {
    // Your implementation goes here
    printf("getGlobusJobSubmissionProtocol\n");
  }

  void getSCPDataMovementProtocol( ::SCPDataMovement& _return, const std::string& scpDataMovementResourceId) {
    // Your implementation goes here
    printf("getSCPDataMovementProtocol\n");
  }

  void getGridFTPDataMovementProtocol( ::GridFTPDataMovement& _return, const std::string& gridFTPDataMovementResourceId) {
    // Your implementation goes here
    printf("getGridFTPDataMovementProtocol\n");
  }

  bool isComputeResourceDescriptionRegistered(const std::string& hostName) {
    // Your implementation goes here
    printf("isComputeResourceDescriptionRegistered\n");
  }

  void getComputeResourceDescriptionFromHostName( ::ComputeResourceDescription& _return, const std::string& hostName) {
    // Your implementation goes here
    printf("getComputeResourceDescriptionFromHostName\n");
  }

  void addApplicationInterface(std::string& _return, const  ::ApplicationInterface& applicationInterface) {
    // Your implementation goes here
    printf("addApplicationInterface\n");
  }

  void listApplicationInterfaceIds(std::vector<std::string> & _return) {
    // Your implementation goes here
    printf("listApplicationInterfaceIds\n");
  }

  void getApplicationInterface( ::ApplicationInterface& _return, const std::string& applicationInterfaceId) {
    // Your implementation goes here
    printf("getApplicationInterface\n");
  }

  void addApplicationDeployment(std::string& _return, const std::string& applicationInterfaceId, const  ::ApplicationDeployment& applicationDeployment) {
    // Your implementation goes here
    printf("addApplicationDeployment\n");
  }

  void listApplicationDeploymentIds(std::vector<std::string> & _return, const std::string& applicationInterfaceId) {
    // Your implementation goes here
    printf("listApplicationDeploymentIds\n");
  }

  void getApplicationDeployment( ::ApplicationDeployment& _return, const std::string& applicationInterfaceId, const std::string& applicationDeploymentId) {
    // Your implementation goes here
    printf("getApplicationDeployment\n");
  }

};

int main(int argc, char **argv) {
  int port = 9090;
  shared_ptr<ApplicationCatalogAPIHandler> handler(new ApplicationCatalogAPIHandler());
  shared_ptr<TProcessor> processor(new ApplicationCatalogAPIProcessor(handler));
  shared_ptr<TServerTransport> serverTransport(new TServerSocket(port));
  shared_ptr<TTransportFactory> transportFactory(new TBufferedTransportFactory());
  shared_ptr<TProtocolFactory> protocolFactory(new TBinaryProtocolFactory());

  TSimpleServer server(processor, serverTransport, transportFactory, protocolFactory);
  server.serve();
  return 0;
}

