/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.xbaya.workflow;

import java.net.URI;
import java.util.Map;
import org.apache.airavata.workflow.model.component.ComponentException;
import org.apache.airavata.workflow.model.exceptions.WorkflowRuntimeException;
import org.apache.airavata.workflow.model.graph.GraphException;
import org.apache.airavata.workflow.model.wf.Workflow;
import org.apache.airavata.ws.monitor.event.EventProducer;
import org.apache.airavata.xbaya.XBayaEngine;
import org.apache.airavata.xbaya.workflow.WorkflowEngineException;
import org.gpel.client.GcInstance;
import org.gpel.client.GcSearchList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xsul5.wsdl.WsdlDefinitions;

public abstract class WorkflowClient
extends EventProducer {
    protected static final String PROCESS_WSDL_TYTLE = "process.wsdl";
    protected static final String PROCESS_GPEL_TITLE = "process.gpel";
    protected static final String PNG_MIME_TYPE = "image/png";
    protected static final String GRAPH_MIME_TYPE = "application/x-xbaya+xml";
    protected static final Logger logger = LoggerFactory.getLogger(WorkflowClient.class);
    protected URI engineURL;

    public void setEngineURL(URI engineURL) throws WorkflowEngineException {
        this.engineURL = engineURL;
        this.connect();
    }

    public URI getEngineURL() {
        return this.engineURL;
    }

    public URI createScriptAndDeploy(Workflow workflow, boolean redeploy) throws GraphException, WorkflowEngineException {
        logger.debug("Entering: " + workflow.toString());
        workflow.createScript();
        return this.deploy(workflow, redeploy);
    }

    public Workflow load(URI templateID) throws GraphException, WorkflowEngineException, ComponentException {
        return this.load(templateID, WorkflowType.TEMPLATE);
    }

    public GcSearchList list() throws WorkflowEngineException {
        return this.list(100, WorkflowType.TEMPLATE);
    }

    public GcInstance instantiate(Workflow workflow, URI dscURL) throws WorkflowEngineException, ComponentException, GraphException {
        return this.instantiate(workflow, dscURL, null);
    }

    public boolean isSecure() {
        return true;
    }

    protected synchronized boolean isConnected() {
        throw new WorkflowRuntimeException("Critical Error: Called a unsupported API");
    }

    public abstract URI deploy(Workflow var1, boolean var2) throws WorkflowEngineException;

    public abstract Workflow load(URI var1, WorkflowType var2) throws GraphException, WorkflowEngineException, ComponentException;

    public abstract GcSearchList list(int var1, WorkflowType var2) throws WorkflowEngineException;

    public abstract GcInstance instantiate(Workflow var1, URI var2, String var3) throws WorkflowEngineException, ComponentException, GraphException;

    @Deprecated
    public abstract GcInstance instantiate(Workflow var1, Map<String, WsdlDefinitions> var2) throws WorkflowEngineException;

    public abstract WsdlDefinitions start(GcInstance var1) throws WorkflowEngineException;

    public abstract void connect() throws WorkflowEngineException;

    public abstract void setXBayaEngine(XBayaEngine var1);

    public static enum WorkflowType {
        TEMPLATE,
        INSTANCE;

    }
}

