/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.xbaya.util;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.SocketTimeoutException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.airavata.client.stub.interpretor.NameValue;
import org.apache.airavata.workflow.model.exceptions.WorkflowException;
import org.apache.airavata.workflow.model.exceptions.WorkflowRuntimeException;
import org.apache.airavata.workflow.model.graph.DataPort;
import org.apache.airavata.workflow.model.graph.Node;
import org.apache.airavata.workflow.model.graph.amazon.InstanceNode;
import org.apache.airavata.workflow.model.graph.system.ConstantNode;
import org.apache.airavata.workflow.model.graph.system.EndForEachNode;
import org.apache.airavata.workflow.model.graph.system.EndifNode;
import org.apache.airavata.workflow.model.graph.system.ForEachNode;
import org.apache.airavata.workflow.model.graph.system.InputNode;
import org.apache.airavata.workflow.model.wf.Workflow;
import org.apache.airavata.ws.monitor.MonitorConfiguration;
import org.apache.airavata.xbaya.XBayaConfiguration;
import org.apache.airavata.xbaya.XBayaEngine;
import org.apache.airavata.xbaya.interpretor.SystemComponentInvoker;
import org.apache.airavata.xbaya.interpretor.WorkFlowInterpreterException;
import org.apache.airavata.xbaya.invoker.GenericInvoker;
import org.apache.airavata.xbaya.invoker.Invoker;
import org.apache.airavata.xbaya.invoker.WorkflowInvokerWrapperForGFacInvoker;
import org.apache.airavata.xbaya.lead.LeadContextHeaderHelper;
import org.apache.airavata.xbaya.ui.dialogs.registry.RegistryWindow;
import org.apache.axis2.util.XMLUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import org.xmlpull.v1.builder.XmlElement;
import xsul.lead.LeadContextHeader;
import xsul.lead.LeadResourceMapping;
import xsul5.XmlConstants;

public class XBayaUtil {
    private static final Logger logger = LoggerFactory.getLogger(XBayaUtil.class);
    public static final String JCR_USER = "jcr.username";
    public static final String JCR_PASS = "jcr.password";
    public static final String JCR_URL = "jcr.url";

    public static LeadContextHeader buildLeadContextHeader(XBayaEngine engine, MonitorConfiguration monitorConfiguration, String nodeId, LeadResourceMapping resourceMapping) throws URISyntaxException {
        XBayaConfiguration configuration = engine.getConfiguration();
        Workflow workflow = engine.getGUI().getWorkflow();
        LeadContextHeader leadContext = XBayaUtil.buildLeadContextHeader(workflow, configuration, monitorConfiguration, nodeId, resourceMapping);
        return leadContext;
    }

    public static LeadContextHeader buildLeadContextHeader(Workflow workflow, XBayaConfiguration configuration, MonitorConfiguration monitorConfiguration, String nodeId, LeadResourceMapping resourceMapping) throws URISyntaxException {
        LeadContextHeaderHelper leadContextHelper = new LeadContextHeaderHelper();
        leadContextHelper.setXBayaConfiguration(configuration);
        leadContextHelper.setWorkflowInstanceID(workflow.getGPELInstanceID());
        leadContextHelper.setWorkflowTemplateID(workflow.getUniqueWorkflowName());
        leadContextHelper.setMonitorConfiguration(monitorConfiguration);
        LeadContextHeader leadContext = leadContextHelper.getLeadContextHeader();
        leadContext.setNodeId(nodeId);
        leadContext.setTimeStep("1");
        if (resourceMapping != null) {
            leadContext.setResourceMapping(resourceMapping);
        }
        return leadContext;
    }

    public static boolean isURLExists(String URLName) {
        try {
            if (!URLName.toUpperCase().contains("HTTP")) {
                URLName = "http://" + URLName;
            }
            URL url = new URL(URLName);
            System.setProperty("java.net.useSystemProxies", "true");
            HttpURLConnection urlConn = (HttpURLConnection)url.openConnection();
            urlConn.setConnectTimeout(9000);
            urlConn.setReadTimeout(9000);
            urlConn.connect();
            return 200 == urlConn.getResponseCode();
        }
        catch (SocketTimeoutException e) {
            return false;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static boolean acquireJCRRegistry(XBayaEngine engine) {
        XBayaConfiguration configuration = engine.getConfiguration();
        if (configuration.getAiravataAPI() == null) {
            XBayaUtil.updateJCRRegistryInfo(engine);
        }
        return engine.getConfiguration().getAiravataAPI() != null;
    }

    public static void updateJCRRegistryInfo(XBayaEngine xbayaEngine) {
        RegistryWindow window = new RegistryWindow(xbayaEngine);
        window.show();
    }

    public static Object getInputsForForEachNode(ForEachNode forEachNode, LinkedList<String> listOfValues, Map<Node, Invoker> invokerMap) throws WorkflowException {
        Node forEachInputNode = forEachNode.getInputPort(0).getFromNode();
        Object returnValForProvenance = null;
        if (forEachInputNode instanceof InputNode) {
            for (DataPort dataPort : forEachNode.getInputPorts()) {
                returnValForProvenance = XBayaUtil.findInputFromPort(dataPort, invokerMap);
                if (null == returnValForProvenance) {
                    throw new WorkFlowInterpreterException("Unable to find input for the node:" + forEachNode.getID());
                }
                String[] vals = returnValForProvenance.toString().split(",");
                listOfValues.addAll(Arrays.asList(vals));
            }
        } else {
            Invoker workflowInvoker = invokerMap.get(forEachInputNode);
            if (workflowInvoker != null) {
                if (workflowInvoker instanceof GenericInvoker) {
                    returnValForProvenance = ((GenericInvoker)workflowInvoker).getOutputs();
                    String message = returnValForProvenance.toString();
                    org.xmlpull.infoset.XmlElement msgElmt = XmlConstants.BUILDER.parseFragmentFromString(message);
                    for (Object object : msgElmt.children()) {
                        if (!(object instanceof org.xmlpull.infoset.XmlElement)) continue;
                        listOfValues.add(XmlConstants.BUILDER.serializeToString(object));
                    }
                } else if (workflowInvoker instanceof WorkflowInvokerWrapperForGFacInvoker) {
                    String outputName = forEachInputNode.getOutputPort(0).getName();
                    returnValForProvenance = workflowInvoker.getOutput(outputName);
                    XmlElement msgElmt = (XmlElement)returnValForProvenance;
                    Iterator children = msgElmt.children();
                    while (children.hasNext()) {
                        Object object2;
                        XmlElement child;
                        Iterator valItr;
                        Object object = children.next();
                        if (!(object instanceof XmlElement) || !(valItr = (child = (XmlElement)object).children()).hasNext() || !((object2 = valItr.next()) instanceof String)) continue;
                        listOfValues.add(object2.toString());
                    }
                } else if (workflowInvoker instanceof SystemComponentInvoker) {
                    String outputName = forEachInputNode.getOutputPort(0).getName();
                    returnValForProvenance = workflowInvoker.getOutput(outputName);
                    org.xmlpull.infoset.XmlElement msgElmt = XmlConstants.BUILDER.parseFragmentFromString("<temp>" + returnValForProvenance + "</temp>");
                    for (Object object2 : msgElmt.children()) {
                        if (!(object2 instanceof org.xmlpull.infoset.XmlElement)) continue;
                        listOfValues.add(((org.xmlpull.infoset.XmlElement)object2).children().iterator().next().toString());
                    }
                }
            } else {
                throw new WorkFlowInterpreterException("Did not find inputs from WS to foreach");
            }
        }
        return returnValForProvenance;
    }

    public static Object findInputFromPort(DataPort inputPort, Map<Node, Invoker> invokerMap) throws WorkflowException {
        Object outputVal;
        block13: {
            outputVal = null;
            Node fromNode = inputPort.getFromNode();
            if (fromNode instanceof InputNode) {
                outputVal = ((InputNode)fromNode).getDefaultValue();
            } else if (fromNode instanceof ConstantNode) {
                outputVal = ((ConstantNode)fromNode).getValue();
            } else if (fromNode instanceof EndifNode) {
                Invoker fromInvoker = invokerMap.get(fromNode);
                outputVal = fromInvoker.getOutput(inputPort.getFromPort().getID());
            } else {
                if (fromNode instanceof InstanceNode) {
                    return ((InstanceNode)fromNode).getOutputInstanceId();
                }
                if (fromNode instanceof EndForEachNode) {
                    outputVal = "";
                    Invoker workflowInvoker = invokerMap.get(fromNode);
                    String outputName = fromNode.getOutputPort(0).getName();
                    org.xmlpull.infoset.XmlElement msgElmt = XmlConstants.BUILDER.parseFragmentFromString("<temp>" + workflowInvoker.getOutput(outputName) + "</temp>");
                    for (Object object2 : msgElmt.children()) {
                        if (!(object2 instanceof org.xmlpull.infoset.XmlElement)) continue;
                        outputVal = outputVal + "," + ((org.xmlpull.infoset.XmlElement)object2).children().iterator().next().toString();
                    }
                    outputVal = ((String)outputVal).substring(1, ((String)outputVal).length());
                } else {
                    Invoker fromInvoker = invokerMap.get(fromNode);
                    try {
                        if (fromInvoker != null) {
                            outputVal = fromInvoker.getOutput(inputPort.getFromPort().getName());
                        }
                    }
                    catch (Exception e) {
                        if (null != outputVal) break block13;
                        outputVal = fromInvoker.getOutput(inputPort.getName());
                    }
                }
            }
        }
        return outputVal;
    }

    public static Node findEndForEachFor(ForEachNode node) {
        List toNodes = node.getOutputPort(0).getToNodes();
        if (toNodes.size() != 1) {
            throw new WorkflowRuntimeException("ForEach output does not contain single out-edge");
        }
        Node middleNode = (Node)toNodes.iterator().next();
        List outputPorts = middleNode.getOutputPorts();
        for (DataPort dataPort : outputPorts) {
            Node possibleEndForEachNode;
            if (dataPort.getToNodes().size() != 1 || !((possibleEndForEachNode = (Node)dataPort.getToNodes().get(0)) instanceof EndForEachNode)) continue;
            return possibleEndForEachNode;
        }
        throw new WorkflowRuntimeException("EndForEachNode not found");
    }

    public static List<NameValue> getIOParameterData(String xml) throws ParserConfigurationException, SAXException, IOException {
        ArrayList<NameValue> parameters = new ArrayList<NameValue>();
        Document parameterDocument = XMLUtils.newDocument((InputStream)new ByteArrayInputStream(xml.getBytes()));
        NodeList childNodes = parameterDocument.getDocumentElement().getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            org.w3c.dom.Node parameterNode = childNodes.item(i);
            NameValue pair = new NameValue();
            pair.setName(parameterNode.getLocalName());
            pair.setValue(parameterNode.getTextContent());
            parameters.add(pair);
        }
        return parameters;
    }
}

