/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.xbaya.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.airavata.workflow.model.exceptions.WorkflowException;
import org.apache.airavata.workflow.model.exceptions.WorkflowRuntimeException;
import org.apache.airavata.workflow.model.graph.DataPort;
import org.apache.airavata.workflow.model.graph.Node;
import org.apache.airavata.workflow.model.graph.amazon.InstanceNode;
import org.apache.airavata.workflow.model.graph.system.ConstantNode;
import org.apache.airavata.workflow.model.graph.system.DifferedInputNode;
import org.apache.airavata.workflow.model.graph.system.DoWhileNode;
import org.apache.airavata.workflow.model.graph.system.EndDoWhileNode;
import org.apache.airavata.workflow.model.graph.system.EndForEachNode;
import org.apache.airavata.workflow.model.graph.system.EndifNode;
import org.apache.airavata.workflow.model.graph.system.ForEachNode;
import org.apache.airavata.workflow.model.graph.system.InputNode;
import org.apache.airavata.workflow.model.graph.system.SystemDataPort;
import org.apache.airavata.workflow.model.graph.ws.WSGraph;
import org.apache.airavata.workflow.model.graph.ws.WSNode;
import org.apache.airavata.workflow.model.graph.ws.WSPort;
import org.apache.airavata.xbaya.interpretor.SystemComponentInvoker;
import org.apache.airavata.xbaya.interpretor.WorkFlowInterpreterException;
import org.apache.airavata.xbaya.invoker.GenericInvoker;
import org.apache.airavata.xbaya.invoker.Invoker;
import org.apache.airavata.xbaya.invoker.WorkflowInvokerWrapperForGFacInvoker;
import org.xmlpull.infoset.XmlAttribute;
import org.xmlpull.infoset.impl.XmlElementWithViewsImpl;
import org.xmlpull.v1.builder.XmlElement;
import xsul5.XmlConstants;
import xsul5.wsdl.WsdlPort;
import xsul5.wsdl.WsdlService;

public class InterpreterUtil {
    public static Object getInputsForForEachNode(ForEachNode forEachNode, LinkedList<String> listOfValues, Map<Node, Invoker> invokerMap) throws WorkflowException {
        List inputPorts = forEachNode.getInputPorts();
        Object returnValForProvenance = null;
        for (DataPort inputPort : inputPorts) {
            Node inputNode = inputPort.getFromNode();
            if (inputNode instanceof InputNode) {
                for (DataPort dataPort : forEachNode.getInputPorts()) {
                    returnValForProvenance = InterpreterUtil.findInputFromPort(dataPort, invokerMap);
                    if (null == returnValForProvenance) {
                        throw new WorkFlowInterpreterException("Unable to find input for the node:" + forEachNode.getID());
                    }
                    String[] vals = returnValForProvenance.toString().split(",");
                    listOfValues.addAll(Arrays.asList(vals));
                }
                continue;
            }
            Invoker workflowInvoker = invokerMap.get(inputNode);
            if (workflowInvoker != null) {
                XmlElement msgElmt;
                if (workflowInvoker instanceof GenericInvoker) {
                    String outputName = inputNode.getOutputPort(0).getName();
                    returnValForProvenance = workflowInvoker.getOutput(outputName);
                    Iterator children = null;
                    if (returnValForProvenance instanceof XmlElement) {
                        msgElmt = (XmlElement)returnValForProvenance;
                        children = msgElmt.children();
                    } else {
                        msgElmt = XmlConstants.BUILDER.parseFragmentFromString("<temp>" + returnValForProvenance + "</temp>");
                        children = msgElmt.children().iterator();
                    }
                    while (children.hasNext()) {
                        Object object2;
                        XmlElement child;
                        Iterator valItr;
                        Object object = children.next();
                        if (object instanceof XmlElement && (valItr = (child = (XmlElement)object).children()).hasNext() && (object2 = valItr.next()) instanceof String) {
                            listOfValues.add(object2.toString());
                        }
                        if (object instanceof org.xmlpull.infoset.XmlElement) {
                            listOfValues.add(((org.xmlpull.infoset.XmlElement)object).children().iterator().next().toString());
                        }
                        if (!(object instanceof String)) continue;
                        listOfValues.add(object.toString());
                    }
                    continue;
                }
                if (!(workflowInvoker instanceof SystemComponentInvoker)) continue;
                int index = inputNode.getOutputPorts().indexOf(inputPort.getEdge(0).getFromPort());
                String outputName = "";
                if (inputNode.getInputPort(index) instanceof SystemDataPort) {
                    outputName = ((SystemDataPort)inputNode.getInputPort(index)).getWSComponentPort().getName();
                } else if (inputNode.getInputPort(index) instanceof WSPort) {
                    outputName = ((SystemDataPort)inputNode.getInputPort(inputNode.getOutputPorts().indexOf(inputPort.getEdge(0).getFromPort()))).getWSComponentPort().getName();
                }
                returnValForProvenance = workflowInvoker.getOutput(outputName);
                msgElmt = XmlConstants.BUILDER.parseFragmentFromString("<temp>" + returnValForProvenance + "</temp>");
                for (Object object2 : msgElmt.children()) {
                    if (!(object2 instanceof org.xmlpull.infoset.XmlElement)) continue;
                    listOfValues.add(((org.xmlpull.infoset.XmlElement)object2).children().iterator().next().toString());
                }
                continue;
            }
            throw new WorkFlowInterpreterException("Did not find inputs from WS to foreach");
        }
        return returnValForProvenance;
    }

    public static Object findInputFromPort(DataPort inputPort, Map<Node, Invoker> invokerMap) throws WorkflowException {
        Object outputVal;
        block19: {
            outputVal = null;
            Node fromNode = inputPort.getFromNode();
            if (fromNode instanceof InputNode) {
                outputVal = ((InputNode)fromNode).getDefaultValue();
            } else if (fromNode instanceof ConstantNode) {
                outputVal = ((ConstantNode)fromNode).getValue();
            } else if (fromNode instanceof DifferedInputNode && ((DifferedInputNode)fromNode).isConfigured()) {
                outputVal = ((DifferedInputNode)fromNode).getDefaultValue();
            } else if (fromNode instanceof EndifNode || fromNode instanceof DoWhileNode || fromNode instanceof EndDoWhileNode) {
                Invoker fromInvoker = invokerMap.get(fromNode);
                outputVal = fromInvoker.getOutput(inputPort.getFromPort().getID());
            } else {
                if (fromNode instanceof InstanceNode) {
                    return ((InstanceNode)fromNode).getOutputInstanceId();
                }
                if (fromNode instanceof EndForEachNode) {
                    outputVal = "";
                    Invoker workflowInvoker = invokerMap.get(fromNode);
                    String outputName = "";
                    if (inputPort instanceof SystemDataPort) {
                        outputName = ((SystemDataPort)inputPort).getWSComponentPort().getName();
                    } else if (inputPort instanceof WSPort) {
                        outputName = ((SystemDataPort)fromNode.getInputPort(fromNode.getOutputPorts().indexOf(inputPort.getEdge(0).getFromPort()))).getWSComponentPort().getName();
                    }
                    org.xmlpull.infoset.XmlElement msgElmt = XmlConstants.BUILDER.parseFragmentFromString("<temp>" + workflowInvoker.getOutput(outputName) + "</temp>");
                    for (Object object2 : msgElmt.children()) {
                        if (!(object2 instanceof org.xmlpull.infoset.XmlElement) || !((org.xmlpull.infoset.XmlElement)object2).children().iterator().hasNext()) continue;
                        outputVal = outputVal + "," + ((org.xmlpull.infoset.XmlElement)object2).children().iterator().next().toString();
                    }
                    if (((String)outputVal).length() == 0) {
                        throw new WorkflowException("Empty Output Generated");
                    }
                    outputVal = ((String)outputVal).substring(1, ((String)outputVal).length());
                } else {
                    Invoker fromInvoker = invokerMap.get(fromNode);
                    try {
                        if (fromInvoker != null) {
                            outputVal = fromInvoker.getOutput(inputPort.getFromPort().getName());
                        }
                    }
                    catch (Exception e) {
                        if (null != outputVal) break block19;
                        outputVal = fromInvoker.getOutput(inputPort.getName());
                    }
                }
            }
        }
        return outputVal;
    }

    public static Node findEndForEachFor(ForEachNode node) {
        List toNodes = node.getOutputPort(0).getToNodes();
        if (toNodes.size() != 1) {
            throw new WorkflowRuntimeException("ForEach output does not contain single out-edge");
        }
        Node middleNode = (Node)toNodes.iterator().next();
        List outputPorts = middleNode.getOutputPorts();
        for (DataPort dataPort : outputPorts) {
            Node possibleEndForEachNode;
            if (dataPort.getToNodes().size() != 1 || !((possibleEndForEachNode = (Node)dataPort.getToNodes().get(0)) instanceof EndForEachNode)) continue;
            return possibleEndForEachNode;
        }
        throw new WorkflowRuntimeException("EndForEachNode not found");
    }

    public static Integer[] getNumberOfInputsForForEachNode(ForEachNode forEachNode, Map<Node, Invoker> invokerMap) throws WorkflowException {
        List inputPorts = forEachNode.getInputPorts();
        Integer[] inputNumbers = new Integer[inputPorts.size()];
        for (DataPort forEachInputPort : inputPorts) {
            Node forEachInputNode = forEachInputPort.getFromNode();
            int index = 0;
            Object returnValForProvenance = null;
            if (forEachInputNode instanceof InputNode) {
                returnValForProvenance = InterpreterUtil.findInputFromPort(forEachInputPort, invokerMap);
                if (null == returnValForProvenance) {
                    throw new WorkFlowInterpreterException("Unable to find input for the node:" + forEachNode.getID());
                }
                String[] vals = returnValForProvenance.toString().split(",");
                inputNumbers[inputPorts.indexOf((Object)forEachInputPort)] = vals.length;
                continue;
            }
            Invoker workflowInvoker = invokerMap.get(forEachInputNode);
            if (workflowInvoker != null) {
                org.xmlpull.infoset.XmlElement msgElmt;
                if (workflowInvoker instanceof GenericInvoker) {
                    returnValForProvenance = ((GenericInvoker)workflowInvoker).getOutputs();
                    String message = returnValForProvenance.toString();
                    msgElmt = XmlConstants.BUILDER.parseFragmentFromString(message);
                    for (Object object : msgElmt.children()) {
                        if (!(object instanceof org.xmlpull.infoset.XmlElement)) continue;
                        ++index;
                    }
                    continue;
                }
                if (workflowInvoker instanceof WorkflowInvokerWrapperForGFacInvoker) {
                    String outputName = forEachInputNode.getOutputPort(0).getName();
                    returnValForProvenance = workflowInvoker.getOutput(outputName);
                    msgElmt = (XmlElement)returnValForProvenance;
                    Iterator children = msgElmt.children();
                    while (children.hasNext()) {
                        Object object2;
                        XmlElement child;
                        Iterator valItr;
                        Object object;
                        object = children.next();
                        if (!(object instanceof XmlElement) || !(valItr = (child = (XmlElement)object).children()).hasNext() || !((object2 = valItr.next()) instanceof String)) continue;
                        ++index;
                    }
                    inputNumbers[inputPorts.indexOf((Object)forEachInputPort)] = index;
                    continue;
                }
                if (!(workflowInvoker instanceof SystemComponentInvoker)) continue;
                int portIndex = forEachInputNode.getOutputPorts().indexOf(forEachInputPort.getEdge(0).getFromPort());
                String outputName = "";
                if (forEachInputNode.getInputPort(portIndex) instanceof SystemDataPort) {
                    outputName = ((SystemDataPort)forEachInputNode.getInputPort(portIndex)).getWSComponentPort().getName();
                } else if (forEachInputNode.getInputPort(portIndex) instanceof WSPort) {
                    outputName = ((WSPort)forEachInputNode.getInputPort(portIndex)).getComponentPort().getName();
                }
                returnValForProvenance = workflowInvoker.getOutput(outputName);
                org.xmlpull.infoset.XmlElement msgElmt2 = XmlConstants.BUILDER.parseFragmentFromString("<temp>" + returnValForProvenance + "</temp>");
                for (Object object2 : msgElmt2.children()) {
                    if (!(object2 instanceof org.xmlpull.infoset.XmlElement)) continue;
                    ++index;
                }
                inputNumbers[inputPorts.indexOf((Object)forEachInputPort)] = index;
                continue;
            }
            throw new WorkFlowInterpreterException("Did not find inputs from WS to foreach");
        }
        return inputNumbers;
    }

    public static ArrayList<Node> getFinishedNodesDynamically(WSGraph graph) {
        return InterpreterUtil.getNodesWithBodyColor(Node.NodeExecutionState.FINISHED, graph);
    }

    public static ArrayList<Node> getFailedNodesDynamically(WSGraph graph) {
        return InterpreterUtil.getNodesWithBodyColor(Node.NodeExecutionState.FAILED, graph);
    }

    public static ArrayList<Node> getWaitingNodesDynamically(WSGraph graph) {
        return InterpreterUtil.getNodesWithBodyColor(Node.NodeExecutionState.WAITING, graph);
    }

    public static ArrayList<Node> getNodesWithBodyColor(Node.NodeExecutionState state, WSGraph graph) {
        ArrayList<Node> list = new ArrayList<Node>();
        List nodes = graph.getNodes();
        for (Node node : nodes) {
            if (node.getState() != state) continue;
            list.add(node);
        }
        return list;
    }

    public static int getRunningNodeCountDynamically(WSGraph graph) {
        return InterpreterUtil.getNodeCountWithBodyColor(Node.NodeExecutionState.EXECUTING, graph);
    }

    public static int getFailedNodeCountDynamically(WSGraph graph) {
        return InterpreterUtil.getFailedNodesDynamically(graph).size();
    }

    public static int getWaitingNodeCountDynamically(WSGraph graph) {
        return InterpreterUtil.getNodeCountWithBodyColor(Node.NodeExecutionState.WAITING, graph);
    }

    public static int getNodeCountWithBodyColor(Node.NodeExecutionState state, WSGraph graph) {
        int sum = 0;
        List nodes = graph.getNodes();
        for (Node node : nodes) {
            if (node.getState() != state) continue;
            ++sum;
        }
        return sum;
    }

    public static String getEPR(WSNode wsNode) {
        Iterable ports;
        Iterator portIterator;
        Iterable services = wsNode.getComponent().getWSDL().services();
        Iterator iterator = services.iterator();
        if (iterator.hasNext() && (portIterator = (ports = ((WsdlService)iterator.next()).ports()).iterator()).hasNext()) {
            WsdlPort port = (WsdlPort)portIterator.next();
            Iterable children = port.xml().children();
            for (Object next : children) {
                if (!(next instanceof XmlElementWithViewsImpl)) continue;
                XmlAttribute epr = ((XmlElementWithViewsImpl)next).attribute("location");
                return epr.getValue();
            }
        }
        return null;
    }
}

