/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.xbaya.util;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.services.ec2.AmazonEC2;
import com.amazonaws.services.ec2.AmazonEC2Client;
import com.amazonaws.services.ec2.model.DescribeInstancesResult;
import com.amazonaws.services.ec2.model.DescribeKeyPairsResult;
import com.amazonaws.services.ec2.model.Instance;
import com.amazonaws.services.ec2.model.KeyPairInfo;
import com.amazonaws.services.ec2.model.Reservation;
import com.amazonaws.services.ec2.model.RunInstancesRequest;
import com.amazonaws.services.ec2.model.RunInstancesResult;
import com.amazonaws.services.ec2.model.TerminateInstancesRequest;
import java.util.ArrayList;
import java.util.List;
import org.apache.airavata.xbaya.core.amazon.AmazonCredential;

public class AmazonUtil {
    public static final String[] INSTANCE_TYPE = new String[]{"t1.micro", "m1.small", "m1.large", "m1.xlarge", "m2.xlarge", "m2.2xlarge", "m2.4xlarge", "c1.medium", "c1.xlarge"};

    private static AmazonEC2 getEC2Client() {
        AmazonEC2Client ec2 = new AmazonEC2Client((AWSCredentials)new BasicAWSCredentials(AmazonCredential.getInstance().getAwsAccessKeyId(), AmazonCredential.getInstance().getAwsSecretAccessKey()));
        return ec2;
    }

    public static List<Instance> launchInstance(String AMI_ID, String type, Integer number) {
        ArrayList<Instance> resultList = new ArrayList<Instance>();
        RunInstancesRequest request = new RunInstancesRequest(AMI_ID, number, number);
        request.setInstanceType(type);
        RunInstancesResult result = AmazonUtil.getEC2Client().runInstances(request);
        resultList.addAll(result.getReservation().getInstances());
        return resultList;
    }

    public static List<Instance> launchInstance(String AMI_ID, String type, Integer number, String keyname) {
        ArrayList<Instance> resultList = new ArrayList<Instance>();
        RunInstancesRequest request = new RunInstancesRequest(AMI_ID, number, number);
        request.setInstanceType(type);
        request.setKeyName(keyname);
        RunInstancesResult result = AmazonUtil.getEC2Client().runInstances(request);
        resultList.addAll(result.getReservation().getInstances());
        return resultList;
    }

    public static List<Instance> loadInstances() {
        ArrayList<Instance> resultList = new ArrayList<Instance>();
        DescribeInstancesResult describeInstancesResult = AmazonUtil.getEC2Client().describeInstances();
        List reservations = describeInstancesResult.getReservations();
        for (Reservation reservation : reservations) {
            for (Instance instance : reservation.getInstances()) {
                resultList.add(instance);
            }
        }
        return resultList;
    }

    public static List<String> loadKeypairs() {
        ArrayList<String> resultList = new ArrayList<String>();
        DescribeKeyPairsResult results = AmazonUtil.getEC2Client().describeKeyPairs();
        for (KeyPairInfo key : results.getKeyPairs()) {
            resultList.add(key.getKeyName());
        }
        return resultList;
    }

    public static void terminateInstances(List<String> instanceIds) {
        TerminateInstancesRequest request = new TerminateInstancesRequest(instanceIds);
        AmazonUtil.getEC2Client().terminateInstances(request);
    }

    public static void terminateInstances(String ... instanceIds) {
        TerminateInstancesRequest request = new TerminateInstancesRequest();
        AmazonUtil.getEC2Client().terminateInstances(request.withInstanceIds(instanceIds));
    }
}

