/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.xbaya.ui.widgets.component;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceAdapter;
import java.awt.dnd.DragSourceListener;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreePath;
import org.apache.airavata.common.utils.SwingUtil;
import org.apache.airavata.workflow.model.component.Component;
import org.apache.airavata.workflow.model.component.ComponentException;
import org.apache.airavata.workflow.model.component.ComponentOperationReference;
import org.apache.airavata.workflow.model.component.ComponentReference;
import org.apache.airavata.workflow.model.component.ComponentRegistry;
import org.apache.airavata.workflow.model.component.ComponentRegistryException;
import org.apache.airavata.workflow.model.component.ws.WSComponent;
import org.apache.airavata.workflow.model.exceptions.WorkflowRuntimeException;
import org.apache.airavata.xbaya.XBayaEngine;
import org.apache.airavata.xbaya.component.registry.ComponentController;
import org.apache.airavata.xbaya.ui.widgets.XBayaComponent;
import org.apache.airavata.xbaya.ui.widgets.component.ComponentSelectorEvent;
import org.apache.airavata.xbaya.ui.widgets.component.ComponentSelectorListener;
import org.apache.airavata.xbaya.ui.widgets.component.ComponentSourceTransferable;
import org.apache.airavata.xbaya.ui.widgets.component.ComponentTreeModel;
import org.apache.airavata.xbaya.ui.widgets.component.ComponentTreeNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ComponentSelector
implements XBayaComponent {
    public static final String TITLE = "Component List";
    private static final Logger logger = LoggerFactory.getLogger(ComponentSelector.class);
    private XBayaEngine engine;
    private JTree tree;
    private ComponentTreeModel treeModel;
    private ComponentReference selectedComponentReference;
    private Component selectedComponent;
    private List<ComponentSelectorListener> listeners;
    private DragSourceListener dragSourceListener;
    private JPopupMenu popup;

    public ComponentSelector(XBayaEngine engine) {
        this.engine = engine;
        this.listeners = new LinkedList<ComponentSelectorListener>();
        this.initGUI();
    }

    @Override
    public JTree getSwingComponent() {
        return this.tree;
    }

    public void addComponentTree(ComponentTreeNode componentTree) {
        this.addComponentTree(-1, componentTree);
    }

    public void removeComponentTree(ComponentTreeNode componentTree) {
        this.treeModel.removeNodeFromParent(componentTree);
    }

    public synchronized void removeComponentRegistry(String componentRegistryName) {
        ComponentTreeNode[] treeNodes;
        ComponentTreeNode root = this.treeModel.getRoot();
        for (ComponentTreeNode treeNode : treeNodes = root.getChildren().toArray(new ComponentTreeNode[0])) {
            if (!treeNode.getComponentRegistry().getName().equals(componentRegistryName)) continue;
            root.remove(treeNode);
        }
        this.treeModel.reload();
    }

    public void addComponentTree(final int index, final ComponentTreeNode componentTree) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ComponentTreeNode root = ComponentSelector.this.treeModel.getRoot();
                if (index < 0) {
                    ComponentSelector.this.treeModel.addNodeInto(componentTree, root);
                } else {
                    ComponentSelector.this.treeModel.insertNodeInto(componentTree, root, index);
                }
                ComponentSelector.this.makeVisible(componentTree);
            }
        });
    }

    public void removeSelectedRegistry() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                TreePath selectionPath = ComponentSelector.this.tree.getSelectionPath();
                ComponentTreeNode selectedNode = (ComponentTreeNode)selectionPath.getLastPathComponent();
                if (selectedNode.getLevel() == 1) {
                    ComponentSelector.this.treeModel.removeNodeFromParent(selectedNode);
                }
            }
        });
    }

    public void updateSelectedRegistry() throws ComponentRegistryException {
        final TreePath[] selectionPathHolder = new TreePath[1];
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    selectionPathHolder[0] = ComponentSelector.this.tree.getSelectionPath();
                }
            });
        }
        catch (InterruptedException e) {
            throw new WorkflowRuntimeException((Throwable)e);
        }
        catch (InvocationTargetException e) {
            throw new WorkflowRuntimeException((Throwable)e);
        }
        TreePath selectionPath = selectionPathHolder[0];
        if (selectionPath == null) {
            return;
        }
        if (selectionPath.getPathCount() >= 2) {
            final ComponentTreeNode selectedNode = (ComponentTreeNode)selectionPath.getPath()[1];
            ComponentRegistry registry = selectedNode.getComponentRegistry();
            final ComponentTreeNode componentTree = ComponentController.getComponentTree(registry);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ComponentTreeNode root = ComponentSelector.this.treeModel.getRoot();
                    int index = root.getIndex(selectedNode);
                    ComponentSelector.this.treeModel.removeNodeFromParent(selectedNode);
                    ComponentSelector.this.treeModel.insertNodeInto(componentTree, root, index);
                }
            });
        }
    }

    public void update() throws ComponentRegistryException {
        final ArrayList<ComponentRegistry> registries = new ArrayList<ComponentRegistry>();
        if (SwingUtilities.isEventDispatchThread()) {
            this.getRegistries(registries);
        } else {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        ComponentSelector.this.getRegistries(registries);
                    }
                });
            }
            catch (InterruptedException e) {
                throw new WorkflowRuntimeException((Throwable)e);
            }
            catch (InvocationTargetException e) {
                throw new WorkflowRuntimeException((Throwable)e);
            }
        }
        final ArrayList<ComponentTreeNode> newSubTrees = new ArrayList<ComponentTreeNode>();
        for (ComponentRegistry registry : registries) {
            ComponentTreeNode componentTree = ComponentController.getComponentTree(registry);
            newSubTrees.add(componentTree);
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ComponentTreeNode root = ComponentSelector.this.treeModel.getRoot();
                ComponentSelector.this.treeModel.removeChildren(root);
                logger.debug("Removed all");
                for (ComponentTreeNode subTree : newSubTrees) {
                    ComponentSelector.this.treeModel.addNodeInto(subTree, root);
                }
                ComponentSelector.this.makeVisible((ComponentTreeNode)root.getFirstChild());
            }
        });
    }

    public Component getSelectedComponent() {
        return this.selectedComponent;
    }

    public synchronized void addComponentSelectorListener(ComponentSelectorListener listener) {
        this.listeners.add(listener);
    }

    public synchronized void removeComponentSelectorListener(ComponentSelectorListener listener) {
        this.listeners.remove(listener);
    }

    private void dragGestureRecognized(DragGestureEvent event) {
        if (this.selectedComponentReference != null) {
            event.startDrag(DragSource.DefaultCopyDrop, new ComponentSourceTransferable(this.selectedComponentReference), this.dragSourceListener);
        }
    }

    private List<ComponentRegistry> getRegistries(List<ComponentRegistry> registries) {
        ComponentTreeNode root = this.treeModel.getRoot();
        for (ComponentTreeNode componentTree : root.getChildren()) {
            registries.add(componentTree.getComponentRegistry());
        }
        return registries;
    }

    private void makeVisible(ComponentTreeNode node) {
        TreePath treePath = new TreePath(node.getPath());
        Rectangle bounds = this.tree.getPathBounds(treePath);
        if (bounds != null) {
            bounds.x = 0;
            bounds.width = 0;
            this.tree.scrollRectToVisible(bounds);
        } else {
            this.tree.scrollPathToVisible(treePath);
        }
    }

    private void select(TreePath treePath) {
        final ComponentTreeNode selectedNode = (ComponentTreeNode)treePath.getLastPathComponent();
        final ComponentReference componentReference = selectedNode.getComponentReference();
        this.selectComponent(null);
        this.selectedComponentReference = null;
        if (componentReference != null) {
            this.selectedComponentReference = componentReference;
            new Thread(){

                @Override
                public void run() {
                    try {
                        final List components = componentReference.getComponents();
                        if (components.size() == 1) {
                            ComponentSelector.this.selectComponent((Component)components.get(0));
                        } else {
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    ComponentSelector.this.expandTreeLeaf(selectedNode, components);
                                }
                            });
                        }
                    }
                    catch (ComponentException e) {
                        ComponentSelector.this.selectComponent(null);
                        ComponentSelector.this.engine.getGUI().getErrorWindow().error("The component is in wrong format.", e);
                    }
                    catch (ComponentRegistryException e) {
                        ComponentSelector.this.selectComponent(null);
                        ComponentSelector.this.engine.getGUI().getErrorWindow().error("Failed to load the component.", e);
                    }
                    catch (RuntimeException e) {
                        ComponentSelector.this.selectComponent(null);
                        ComponentSelector.this.engine.getGUI().getErrorWindow().error("Failed to load the component.", e);
                    }
                    catch (Exception e) {
                        ComponentSelector.this.selectComponent(null);
                        ComponentSelector.this.engine.getGUI().getErrorWindow().error("Failed to load the component.", e);
                    }
                }
            }.start();
        }
    }

    private void expandTreeLeaf(ComponentTreeNode selectedNode, List<? extends Component> components) {
        ComponentReference componentReference = selectedNode.getComponentReference();
        ComponentTreeNode newNode = new ComponentTreeNode(componentReference.getName());
        ComponentTreeNode parent = (ComponentTreeNode)selectedNode.getParent();
        int index = this.treeModel.getIndexOfChild(parent, selectedNode);
        this.treeModel.removeNodeFromParent(selectedNode);
        this.treeModel.insertNodeInto(newNode, parent, index);
        for (Component component : components) {
            WSComponent wsComponent = (WSComponent)component;
            String operationName = wsComponent.getOperationName();
            ComponentOperationReference reference = new ComponentOperationReference(operationName, (Component)wsComponent);
            ComponentTreeNode child = new ComponentTreeNode((ComponentReference)reference);
            this.treeModel.addNodeInto(child, newNode);
        }
        Object[] path = newNode.getPath();
        this.tree.expandPath(new TreePath(path));
    }

    private void selectComponent(Component component) {
        this.selectedComponent = component;
        this.notifyListeners(new ComponentSelectorEvent(ComponentSelectorEvent.ComponentSelectorEventType.COMPONENT_SELECTED, this, component));
    }

    private void showPopupIfNecessary(MouseEvent event) {
        Point point = event.getPoint();
        TreePath path = this.tree.getClosestPathForLocation(point.x, point.y);
        this.tree.setSelectionPath(path);
        if (path.getPathCount() >= 2) {
            this.popup.show(event.getComponent(), point.x, point.y);
        }
    }

    private void notifyListeners(ComponentSelectorEvent event) {
        for (ComponentSelectorListener listener : this.listeners) {
            listener.componentSelectorChanged(event);
        }
    }

    private void initGUI() {
        this.treeModel = new ComponentTreeModel(new ComponentTreeNode("Components"));
        this.tree = new JTree(this.treeModel);
        ToolTipManager.sharedInstance().registerComponent(this.tree);
        DefaultTreeCellRenderer renderer = new DefaultTreeCellRenderer(){

            @Override
            public java.awt.Component getTreeCellRendererComponent(JTree t, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean focus) {
                super.getTreeCellRendererComponent(t, value, sel, expanded, leaf, row, focus);
                ComponentTreeNode node = (ComponentTreeNode)value;
                if (node.getComponentReference() == null) {
                    this.setToolTipText(null);
                } else {
                    this.setToolTipText("Drag a component to the composer to add");
                }
                return this;
            }
        };
        try {
            renderer.setOpenIcon(SwingUtil.createImageIcon((String)"opened.gif"));
            renderer.setClosedIcon(SwingUtil.createImageIcon((String)"closed.gif"));
            renderer.setLeafIcon(SwingUtil.createImageIcon((String)"leaf.gif"));
        }
        catch (RuntimeException e) {
            logger.warn("Failed to load image icons.  It will use the default icons instead.", (Throwable)e);
        }
        this.tree.setCellRenderer(renderer);
        this.tree.setShowsRootHandles(true);
        this.tree.setEditable(false);
        this.tree.getSelectionModel().setSelectionMode(1);
        this.tree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent event) {
                if (event.isAddedPath()) {
                    TreePath path = event.getPath();
                    ComponentSelector.this.select(path);
                }
            }
        });
        DragGestureListener dragGestureListener = new DragGestureListener(){

            @Override
            public void dragGestureRecognized(DragGestureEvent event) {
                ComponentSelector.this.dragGestureRecognized(event);
            }
        };
        DragSource dragSource = DragSource.getDefaultDragSource();
        dragSource.createDefaultDragGestureRecognizer(this.tree, 3, dragGestureListener);
        this.dragSourceListener = new DragSourceAdapter(){};
        this.tree.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent event) {
                if (event.isPopupTrigger()) {
                    ComponentSelector.this.showPopupIfNecessary(event);
                }
            }
        });
        this.createNodePopupMenu();
    }

    private void createNodePopupMenu() {
        this.popup = new JPopupMenu();
        JMenuItem refreshItem = new JMenuItem("Refresh Registry");
        refreshItem.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent event) {
                new Thread(){

                    @Override
                    public void run() {
                        try {
                            ComponentSelector.this.updateSelectedRegistry();
                        }
                        catch (ComponentRegistryException e) {
                            ComponentSelector.this.engine.getGUI().getErrorWindow().error("Failed to load a component list.", e);
                        }
                        catch (RuntimeException e) {
                            ComponentSelector.this.engine.getGUI().getErrorWindow().error("Failed to load a component list.", e);
                        }
                        catch (Error e) {
                            ComponentSelector.this.engine.getGUI().getErrorWindow().error("Unexpected error.", e);
                        }
                    }
                }.start();
            }
        });
        this.popup.add(refreshItem);
    }

    public void refresh() {
        this.getSwingComponent().repaint();
        this.tree.repaint();
    }
}

