/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.xbaya.ui.widgets.amazon;

import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import org.apache.airavata.xbaya.ui.widgets.amazon.S3TreeModel;

public class S3Tree
extends JTree {
    public S3Tree() {
        this.setModel(S3TreeModel.getInstance());
        this.getSelectionModel().setSelectionMode(1);
        this.setShowsRootHandles(true);
    }

    public void clean() {
        this.setModel(S3TreeModel.getInstance().clean());
    }

    public void refresh() {
        this.repaint();
    }

    public DefaultMutableTreeNode addObject(Object child) {
        DefaultMutableTreeNode parentNode = null;
        TreePath parentPath = this.getSelectionPath().getParentPath();
        parentNode = parentPath == null ? (DefaultMutableTreeNode)S3TreeModel.getInstance().getRoot() : (DefaultMutableTreeNode)parentPath.getLastPathComponent();
        return this.addObject(parentNode, child, true);
    }

    public DefaultMutableTreeNode addObject(DefaultMutableTreeNode parent, Object child) {
        return this.addObject(parent, child, false);
    }

    public DefaultMutableTreeNode addObject(String parentName, Object child) {
        if (parentName.contains("/")) {
            parentName = parentName.substring(0, parentName.indexOf(47));
        }
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)S3TreeModel.getInstance().getRoot();
        int count = root.getChildCount();
        for (int i = 0; i < count; ++i) {
            Object name = ((DefaultMutableTreeNode)root.getChildAt(i)).getUserObject();
            if (!parentName.equals(name)) continue;
            return this.addObject((DefaultMutableTreeNode)root.getChildAt(i), child, true);
        }
        return null;
    }

    public DefaultMutableTreeNode addObject(DefaultMutableTreeNode parent, Object child, boolean shouldBeVisible) {
        DefaultMutableTreeNode childNode = new DefaultMutableTreeNode(child);
        if (parent == null) {
            parent = (DefaultMutableTreeNode)S3TreeModel.getInstance().getRoot();
        }
        S3TreeModel.getInstance().insertNodeInto(childNode, parent, parent.getChildCount());
        if (shouldBeVisible) {
            this.scrollPathToVisible(new TreePath(childNode.getPath()));
        }
        return childNode;
    }

    public DefaultMutableTreeNode getSelectedNode() {
        return (DefaultMutableTreeNode)this.getLastSelectedPathComponent();
    }
}

