/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.xbaya.ui.widgets;

import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import org.apache.airavata.xbaya.ui.widgets.TableRenderable;
import org.apache.airavata.xbaya.ui.widgets.XBayaComponent;

public class XbayaEnhancedList<T extends TableRenderable>
implements XBayaComponent {
    private static final int DEFAULT_WIDTH = 400;
    private static final int DEFAULT_HEIGHT = 200;
    private boolean checkbox;
    private DefaultTableModel model;
    private JTable table;
    private JScrollPane scrollPane;
    private Vector<T> tableList;

    public XbayaEnhancedList() {
        this(true);
    }

    public XbayaEnhancedList(boolean checkbox) {
        this.checkbox = checkbox;
        this.init();
    }

    private void init() {
        this.tableList = new Vector();
        this.table = new JTable(new DefaultTableModel());
        this.table.setSelectionMode(0);
        this.table.setRowSelectionAllowed(true);
        this.scrollPane = new JScrollPane(this.table);
        this.scrollPane.setHorizontalScrollBarPolicy(31);
        this.setSize(400, 200);
    }

    @Override
    public JScrollPane getSwingComponent() {
        return this.getScrollPane();
    }

    public JScrollPane getScrollPane() {
        return this.scrollPane;
    }

    public void setSize(int width, int height) {
        Dimension size = new Dimension(width, height);
        this.scrollPane.setMinimumSize(size);
        this.scrollPane.setPreferredSize(size);
    }

    public JTable getTable() {
        return this.table;
    }

    public void setListData(Iterable<T> tableData) {
        int i;
        if (this.model == null) {
            this.model = new DefaultTableModel(){

                public Class getColumnClass(int c) {
                    if (this.getValueAt(0, c) == null) {
                        return String.class;
                    }
                    return this.getValueAt(0, c).getClass();
                }

                @Override
                public boolean isCellEditable(int row, int col) {
                    return !XbayaEnhancedList.this.checkbox || col <= 0;
                }
            };
            boolean noData = true;
            Iterator<T> i$ = tableData.iterator();
            if (i$.hasNext()) {
                TableRenderable entry = (TableRenderable)i$.next();
                if (this.checkbox) {
                    this.model.addColumn("Selection");
                }
                for (i = 0; i < entry.getColumnCount(); ++i) {
                    this.model.addColumn(entry.getColumnTitle(i));
                }
                noData = false;
            }
            if (noData) {
                this.model = null;
                return;
            }
            this.table.setModel(this.model);
        }
        this.clear();
        ArrayList<Object> objList = new ArrayList<Object>();
        for (TableRenderable entry : tableData) {
            if (this.checkbox) {
                objList.add(Boolean.FALSE);
            }
            for (i = 0; i < entry.getColumnCount(); ++i) {
                objList.add(entry.getValue(i));
            }
            this.model.addRow(objList.toArray());
            this.tableList.add(entry);
            objList.clear();
        }
    }

    public T getSelectedValue() {
        int result = this.getSelectedIndex();
        if (result < 0) {
            return null;
        }
        return (T)((TableRenderable)this.tableList.get(result));
    }

    public List<T> getSelectedValues() {
        ArrayList<T> resultList = new ArrayList<T>();
        for (Integer i : this.getSelectedIndices()) {
            resultList.add(this.tableList.get(i));
        }
        return resultList;
    }

    public void removeSelectedRows() {
        int count = 0;
        for (Integer i : this.getSelectedIndices()) {
            this.model.removeRow(i - count);
            this.tableList.remove(i - count);
            ++count;
        }
    }

    public void clear() {
        if (this.model != null) {
            for (int i = this.model.getRowCount() - 1; i >= 0; --i) {
                this.model.removeRow(i);
            }
        }
        this.tableList.clear();
    }

    public void setEnabled(boolean enabled) {
        this.table.setEnabled(enabled);
    }

    public int getSelectedIndex() {
        List<Integer> intList = this.getSelectedIndices();
        if (intList.size() > 1) {
            return -2;
        }
        if (intList.size() == 0) {
            return -1;
        }
        return intList.get(0);
    }

    public List<Integer> getSelectedIndices() {
        ArrayList<Integer> intList = new ArrayList<Integer>();
        if (!this.checkbox) {
            intList.add(new Integer(this.table.getSelectedRow()));
        } else {
            for (int i = 0; i < this.getTable().getModel().getRowCount(); ++i) {
                if (!((Boolean)this.getTable().getModel().getValueAt(i, 0)).booleanValue()) continue;
                intList.add(new Integer(i));
            }
        }
        return intList;
    }

    public void addListSelectionListener(ListSelectionListener listener) {
        this.table.getSelectionModel().addListSelectionListener(listener);
    }

    public void addMouseListener(MouseAdapter adapter) {
        this.table.addMouseListener(adapter);
    }
}

