/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.xbaya.ui.widgets;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JToolBar;
import javax.swing.border.Border;
import org.apache.airavata.common.utils.SwingUtil;
import org.apache.airavata.workflow.model.graph.GraphException;
import org.apache.airavata.workflow.model.wf.Workflow;
import org.apache.airavata.workflow.model.wf.WorkflowExecutionState;
import org.apache.airavata.xbaya.XBayaEngine;
import org.apache.airavata.xbaya.ui.widgets.ToolbarButton;
import org.apache.airavata.xbaya.ui.widgets.XBayaComponent;

public class XBayaToolBar
implements XBayaComponent {
    private XBayaEngine engine;
    private JToolBar toolbar;
    private JButton play;
    private JButton step;
    private JButton stop;
    private Map<String, List<ToolbarButton>> toolbarButtons = new HashMap<String, List<ToolbarButton>>();
    private static Map<String, Integer> groupOrder;
    public static final String IMAGES_STOP_JPEG = "stop.jpeg";
    public static final String IMAGES_PAUSE_JPEG = "pause.jpeg";
    public static final String IMAGES_PLAY_JPEG = "play.jpeg";
    private static final String IMAGES_STEP_JPEG = "step.gif";
    private AbstractAction playAction;
    private AbstractAction stepAction;
    private AbstractAction stopAction;
    private ImageIcon PLAY_ICON;
    private ImageIcon PAUSE_ICON;

    public XBayaToolBar(XBayaEngine client) {
        this.engine = client;
        this.init();
    }

    @Override
    public JComponent getSwingComponent() {
        return this.toolbar;
    }

    private void init() {
        this.toolbar = new JToolBar();
        this.toolbar.setFloatable(false);
        Border border = BorderFactory.createEtchedBorder();
        this.toolbar.setBorder(border);
        JButton addNodeButton = new JButton("Add Node");
        addNodeButton.addActionListener(new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent event) {
                try {
                    XBayaToolBar.this.engine.getGUI().addNode();
                }
                catch (RuntimeException e) {
                    XBayaToolBar.this.engine.getGUI().getErrorWindow().error("Unexpected error.", e);
                }
                catch (Error e) {
                    XBayaToolBar.this.engine.getGUI().getErrorWindow().error("Unexpected error.", e);
                }
            }
        });
        JButton removeNodeButton = new JButton("Remove Node");
        removeNodeButton.addActionListener(new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent event) {
                try {
                    XBayaToolBar.this.engine.getGUI().getGraphCanvas().removeSelectedNode();
                }
                catch (GraphException e) {
                    XBayaToolBar.this.engine.getGUI().getErrorWindow().error("Unexpected error.", e);
                }
                catch (RuntimeException e) {
                    XBayaToolBar.this.engine.getGUI().getErrorWindow().error("Unexpected error.", e);
                }
                catch (Error e) {
                    XBayaToolBar.this.engine.getGUI().getErrorWindow().error("Unexpected error.", e);
                }
            }
        });
        JButton connectEdgeButton = new JButton("Connect/Disconnect");
        connectEdgeButton.addActionListener(new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent event) {
                try {
                    XBayaToolBar.this.engine.getGUI().getGraphCanvas().addOrRemoveEdge();
                }
                catch (RuntimeException e) {
                    XBayaToolBar.this.engine.getGUI().getErrorWindow().error("Unexpected error.", e);
                }
                catch (Error e) {
                    XBayaToolBar.this.engine.getGUI().getErrorWindow().error("Unexpected error.", e);
                }
            }
        });
        this.play = new JButton();
        this.PAUSE_ICON = SwingUtil.createImageIcon((String)IMAGES_PAUSE_JPEG);
        this.PLAY_ICON = SwingUtil.createImageIcon((String)IMAGES_PLAY_JPEG);
        this.playAction = new AbstractAction(null, this.PAUSE_ICON){

            @Override
            public void actionPerformed(ActionEvent e1) {
                block5: {
                    try {
                        Workflow workflow = XBayaToolBar.this.engine.getGUI().getWorkflow();
                        WorkflowExecutionState executionState = workflow.getExecutionState();
                        if (executionState == WorkflowExecutionState.RUNNING || executionState == WorkflowExecutionState.STEP) {
                            workflow.setExecutionState(WorkflowExecutionState.PAUSED);
                            XBayaToolBar.this.play.setIcon(XBayaToolBar.this.PLAY_ICON);
                            break block5;
                        }
                        if (executionState == WorkflowExecutionState.PAUSED) {
                            workflow.setExecutionState(WorkflowExecutionState.RUNNING);
                            XBayaToolBar.this.play.setIcon(XBayaToolBar.this.PAUSE_ICON);
                            break block5;
                        }
                        throw new IllegalStateException("Unknown state :" + executionState);
                    }
                    catch (RuntimeException e) {
                        XBayaToolBar.this.engine.getGUI().getErrorWindow().error("Unexpected error.", e);
                    }
                    catch (Error e) {
                        XBayaToolBar.this.engine.getGUI().getErrorWindow().error("Unexpected error.", e);
                    }
                }
            }
        };
        this.play.setAction(this.playAction);
        this.step = new JButton();
        this.stepAction = new AbstractAction(null, SwingUtil.createImageIcon((String)IMAGES_STEP_JPEG)){

            @Override
            public void actionPerformed(ActionEvent e2) {
                try {
                    if (XBayaToolBar.this.engine.getGUI().getWorkflow().getExecutionState() != WorkflowExecutionState.PAUSED) {
                        throw new IllegalStateException("Unknown state :" + XBayaToolBar.this.engine.getGUI().getWorkflow().getExecutionState());
                    }
                    XBayaToolBar.this.engine.getGUI().getWorkflow().setExecutionState(WorkflowExecutionState.STEP);
                }
                catch (RuntimeException e) {
                    XBayaToolBar.this.engine.getGUI().getErrorWindow().error("Unexpected error.", e);
                }
                catch (Error e) {
                    XBayaToolBar.this.engine.getGUI().getErrorWindow().error("Unexpected error.", e);
                }
            }
        };
        this.step.setAction(this.stepAction);
        this.stop = new JButton();
        this.stopAction = new AbstractAction(null, SwingUtil.createImageIcon((String)IMAGES_STOP_JPEG)){

            @Override
            public void actionPerformed(ActionEvent e1) {
                try {
                    if (XBayaToolBar.this.engine.getGUI().getWorkflow().getExecutionState() == WorkflowExecutionState.NONE && XBayaToolBar.this.engine.getGUI().getWorkflow().getExecutionState() == WorkflowExecutionState.STOPPED) {
                        throw new IllegalStateException("Unknown state :" + XBayaToolBar.this.engine.getGUI().getWorkflow().getExecutionState());
                    }
                    XBayaToolBar.this.engine.getGUI().getWorkflow().setExecutionState(WorkflowExecutionState.STOPPED);
                }
                catch (RuntimeException e) {
                    XBayaToolBar.this.engine.getGUI().getErrorWindow().error("Unexpected error.", e);
                }
                catch (Error e) {
                    XBayaToolBar.this.engine.getGUI().getErrorWindow().error("Unexpected error.", e);
                }
            }
        };
        this.stop.setAction(this.stopAction);
    }

    public ToolbarButton addToolbarButton(String group, String caption, Icon icon, String description, ActionListener onClick, int order) {
        ToolbarButton toolbarButton = new ToolbarButton(icon, caption, description, order);
        toolbarButton.setButtonClickListener(onClick);
        this.getToolBarButtonList(group).add(toolbarButton);
        this.rearrangeToolbarButtons();
        return toolbarButton;
    }

    private void sortButtons(List<ToolbarButton> buttons) {
        ToolbarButton[] buttonList = buttons.toArray(new ToolbarButton[0]);
        for (int i = 0; i < buttonList.length - 1; ++i) {
            for (int j = i + 1; j < buttonList.length; ++j) {
                if (buttonList[i].getOrder() == -1 || buttonList[i].getOrder() <= buttonList[j].getOrder()) continue;
                ToolbarButton temp = buttonList[i];
                buttonList[i] = buttonList[j];
                buttonList[j] = temp;
            }
        }
        buttons.clear();
        buttons.addAll(Arrays.asList(buttonList));
    }

    private void rearrangeToolbarButtons() {
        this.toolbar.removeAll();
        String[] groupIds = this.getSortedGroupIdList();
        HashMap<String, List<ToolbarButton>> tempToolbarButtons = new HashMap<String, List<ToolbarButton>>();
        tempToolbarButtons.putAll(this.toolbarButtons);
        for (String groupId : groupIds) {
            tempToolbarButtons.remove(groupId);
            if (!this.toolbarButtons.containsKey(groupId) || this.toolbarButtons.get(groupId) == null) continue;
            List<ToolbarButton> buttons = this.toolbarButtons.get(groupId);
            this.addButtonsToToolbar(buttons);
        }
        for (String groupId : tempToolbarButtons.keySet()) {
            List buttons = (List)tempToolbarButtons.get(groupId);
            this.addButtonsToToolbar(buttons);
        }
    }

    private void addButtonsToToolbar(List<ToolbarButton> buttons) {
        this.sortButtons(buttons);
        for (ToolbarButton button : buttons) {
            this.toolbar.add(button);
        }
        this.toolbar.addSeparator();
    }

    private String[] getSortedGroupIdList() {
        String[] groupIds = XBayaToolBar.getGroupOrder().keySet().toArray(new String[0]);
        for (int i = 0; i < groupIds.length - 1; ++i) {
            for (int j = i + 1; j < groupIds.length; ++j) {
                if (XBayaToolBar.getGroupOrder().get(groupIds[i]) <= XBayaToolBar.getGroupOrder().get(groupIds[j])) continue;
                String temp = groupIds[i];
                groupIds[i] = groupIds[j];
                groupIds[j] = temp;
            }
        }
        return groupIds;
    }

    public AbstractAction getPlayAction() {
        return this.playAction;
    }

    public AbstractAction getStepAction() {
        return this.stepAction;
    }

    public AbstractAction getStopAction() {
        return this.stopAction;
    }

    private List<ToolbarButton> getToolBarButtonList(String group) {
        if (!this.toolbarButtons.containsKey(group)) {
            this.toolbarButtons.put(group, new ArrayList());
        }
        return this.toolbarButtons.get(group);
    }

    public static void setGroupOrder(String groupId, int order) {
        XBayaToolBar.getGroupOrder().put(groupId, order);
    }

    public static Map<String, Integer> getGroupOrder() {
        if (groupOrder == null) {
            groupOrder = new HashMap<String, Integer>();
        }
        return groupOrder;
    }
}

