/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.xbaya.ui.widgets;

import java.net.URI;
import javax.swing.JTextField;
import org.apache.airavata.common.utils.StringUtil;
import org.apache.airavata.xbaya.ui.widgets.XBayaTextComponent;

public class XBayaTextField
implements XBayaTextComponent {
    public static final int DEFAULT_COLUMNS = 30;
    private JTextField textArea;

    public XBayaTextField() {
        this.init();
    }

    public XBayaTextField(String initStr) {
        this.init();
        this.textArea.setText(initStr);
    }

    @Override
    public JTextField getSwingComponent() {
        return this.getTextField();
    }

    public void setText(URI uri) {
        this.setText(StringUtil.toString((Object)uri));
    }

    @Override
    public void setText(String text) {
        text = text == null ? "" : text.trim();
        this.textArea.setText(text);
        this.textArea.setCaretPosition(0);
    }

    @Override
    public String getText() {
        return this.textArea.getText().trim();
    }

    public JTextField getTextField() {
        return this.textArea;
    }

    public void setEditable(boolean editable) {
        this.textArea.setEditable(editable);
    }

    public void setColumns(int columns) {
        this.textArea.setColumns(columns);
    }

    public void setEnabled(boolean enabled) {
        this.textArea.setEnabled(enabled);
    }

    private void init() {
        this.textArea = new JTextField(30);
        this.textArea.setEditable(true);
    }
}

