/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.xbaya.ui.widgets;

import java.awt.Dimension;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.apache.airavata.xbaya.ui.widgets.XBayaTextComponent;

public class XBayaTextArea
implements XBayaTextComponent {
    public static final int DEFAULT_WIDTH = 300;
    public static final int DEFAULT_HEIGHT = 200;
    private JTextArea textArea;
    private JScrollPane scrollPane;

    public XBayaTextArea() {
        this.init();
    }

    @Override
    public JScrollPane getSwingComponent() {
        return this.getScrollPane();
    }

    @Override
    public void setText(String text) {
        text = text == null ? "" : text.trim();
        this.textArea.setText(text);
        this.textArea.setCaretPosition(0);
    }

    @Override
    public String getText() {
        return this.textArea.getText().trim();
    }

    public JScrollPane getScrollPane() {
        return this.scrollPane;
    }

    public JTextArea getTextArea() {
        return this.textArea;
    }

    public void setEditable(boolean editable) {
        this.textArea.setEditable(editable);
    }

    public void setSize(int width, int height) {
        Dimension size = new Dimension(width, height);
        this.scrollPane.setMinimumSize(size);
        this.scrollPane.setPreferredSize(size);
    }

    private void init() {
        this.textArea = new JTextArea();
        this.textArea.setEditable(true);
        this.textArea.setLineWrap(true);
        this.textArea.setWrapStyleWord(true);
        this.scrollPane = new JScrollPane(this.textArea);
        this.scrollPane.setHorizontalScrollBarPolicy(31);
        this.setSize(300, 200);
    }
}

