/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.xbaya.ui.widgets;

import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.util.Collection;
import java.util.Vector;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionListener;
import org.apache.airavata.xbaya.ui.widgets.XBayaComponent;

public class XBayaList<E>
implements XBayaComponent {
    private static final int DEFAULT_WIDTH = 300;
    private static final int DEFAULT_HEIGHT = 200;
    private JList list;
    private JScrollPane scrollPane;

    public XBayaList() {
        this.init();
    }

    @Override
    public JScrollPane getSwingComponent() {
        return this.getScrollPane();
    }

    public JScrollPane getScrollPane() {
        return this.scrollPane;
    }

    public void setEnabled(boolean enabled) {
        this.list.setEnabled(enabled);
    }

    public JList getList() {
        return this.list;
    }

    public void setSize(int width, int height) {
        Dimension size = new Dimension(width, height);
        this.scrollPane.setMinimumSize(size);
        this.scrollPane.setPreferredSize(size);
    }

    public int getSelectedIndex() {
        return this.list.getSelectedIndex();
    }

    public void setSelectedIndex(int index) {
        this.list.setSelectedIndex(index);
    }

    public E getSelectedValue() {
        return this.list.getSelectedValue();
    }

    public void setListData(Iterable<E> listData) {
        if (listData instanceof Vector) {
            this.list.setListData((Vector)listData);
        } else if (listData instanceof Collection) {
            this.list.setListData(new Vector((Collection)listData));
        } else {
            Vector data = new Vector();
            for (Object datum : data) {
                data.add(datum);
            }
            this.list.setListData(data);
        }
    }

    public void setListData(E[] listData) {
        this.list.setListData(listData);
    }

    public void addListSelectionListener(ListSelectionListener listener) {
        this.list.addListSelectionListener(listener);
    }

    public void addMouseListener(MouseAdapter adapter) {
        this.list.addMouseListener(adapter);
    }

    private void init() {
        this.list = new JList();
        this.list.setSelectionMode(0);
        this.scrollPane = new JScrollPane(this.list);
        this.scrollPane.setHorizontalScrollBarPolicy(31);
        this.setSize(300, 200);
    }
}

