/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.xbaya.ui.widgets;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.plaf.basic.BasicButtonUI;

public class TabLabelButton
extends JPanel
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private JTabbedPane tabPanel;
    private ActionListener closeButtonListener;

    public TabLabelButton(final JTabbedPane pane, String closeButtonTip) {
        this.setTabPanel(pane);
        FlowLayout layout = new FlowLayout(0);
        layout.setAlignment(0);
        layout.setVgap(0);
        layout.setHgap(0);
        this.setLayout(layout);
        this.setOpaque(false);
        JLabel label = new JLabel(){
            String previousText = null;
            private static final long serialVersionUID = 1L;

            @Override
            public String getText() {
                int i = pane.indexOfTabComponent(TabLabelButton.this);
                if (i != -1) {
                    if (!pane.getTitleAt(i).equals(this.previousText)) {
                        this.previousText = pane.getTitleAt(i);
                        TabLabelButton.this.updateUI();
                    }
                    return this.previousText;
                }
                return null;
            }
        };
        this.add(label);
        label.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 5));
        JButton button = new JButton(){
            private static final long serialVersionUID = 1L;

            @Override
            protected void paintComponent(Graphics g) {
                super.paintComponent(g);
                if (pane.indexOfTabComponent(TabLabelButton.this) == pane.getSelectedIndex()) {
                    Graphics2D drawer = (Graphics2D)g.create();
                    if (this.getModel().isPressed()) {
                        drawer.translate(1, 1);
                    }
                    drawer.setStroke(new BasicStroke(2.0f));
                    drawer.setColor(Color.GRAY);
                    if (this.getModel().isRollover()) {
                        drawer.setColor(new Color(200, 0, 0));
                    }
                    this.setBorderPainted(this.getModel().isRollover());
                    int delta = 7;
                    int right = this.getWidth() - 1 - delta;
                    int bottom = this.getHeight() - 1 - delta;
                    drawer.drawLine(delta, delta, right, bottom);
                    drawer.drawLine(right, delta, delta, bottom);
                    drawer.dispose();
                }
            }
        };
        button.setPreferredSize(new Dimension(20, 20));
        button.setToolTipText(closeButtonTip);
        button.setUI(new BasicButtonUI());
        button.setContentAreaFilled(false);
        button.setFocusable(false);
        button.setBorder(BorderFactory.createLineBorder(Color.GRAY));
        button.setBorderPainted(false);
        button.setRolloverEnabled(true);
        button.addActionListener(this);
        this.add(button);
        this.setBorder(BorderFactory.createEmptyBorder(2, 0, 0, 0));
    }

    public JTabbedPane getTabPanel() {
        return this.tabPanel;
    }

    public void setTabPanel(JTabbedPane tabPanel) {
        this.tabPanel = tabPanel;
    }

    public ActionListener getCloseButtonListener() {
        return this.closeButtonListener;
    }

    public void setCloseButtonListener(ActionListener closeButtonListener) {
        this.closeButtonListener = closeButtonListener;
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        if (this.getTabPanel().indexOfTabComponent(this) == this.getTabPanel().getSelectedIndex()) {
            if (this.getCloseButtonListener() != null) {
                this.getCloseButtonListener().actionPerformed(event);
            }
        } else {
            this.getTabPanel().setSelectedIndex(this.getTabPanel().indexOfTabComponent(this));
        }
    }
}

