/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.xbaya.ui.widgets;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import org.apache.airavata.common.utils.SwingUtil;
import org.apache.airavata.xbaya.ui.widgets.XBayaComponent;

public class ScrollPanel
implements XBayaComponent {
    private JPanel panel;
    private JComponent component;

    public ScrollPanel(XBayaComponent component, String title) {
        this(component.getSwingComponent(), title);
    }

    public ScrollPanel(JComponent component, String title) {
        this(component, title, true);
    }

    public ScrollPanel(XBayaComponent component, String title, boolean scroll) {
        this(component.getSwingComponent(), title, scroll);
    }

    public ScrollPanel(JComponent component, String title, boolean scroll) {
        this.component = component;
        this.init(component, title, scroll);
    }

    @Override
    public JPanel getSwingComponent() {
        return this.getPanel();
    }

    public JPanel getPanel() {
        return this.panel;
    }

    public void setPrefferedSize(Dimension preferredSize) {
        this.component.setPreferredSize(preferredSize);
    }

    private void init(JComponent comp, String title, boolean scroll) {
        this.panel = new JPanel();
        this.panel.setLayout(new BorderLayout());
        JLabel titleLabel = new JLabel(title);
        Border border = BorderFactory.createEtchedBorder();
        titleLabel.setBorder(border);
        this.panel.add((Component)titleLabel, "North");
        if (scroll) {
            JScrollPane scrollPane = new JScrollPane(comp);
            scrollPane.setMinimumSize(SwingUtil.MINIMUM_SIZE);
            this.panel.add((Component)scrollPane, "Center");
        } else {
            comp.setMinimumSize(SwingUtil.MINIMUM_SIZE);
            this.panel.add((Component)comp, "Center");
        }
    }
}

