/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.xbaya.ui.widgets;

import java.awt.Component;
import java.awt.Container;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.apache.airavata.common.utils.SwingUtil;
import org.apache.airavata.xbaya.ui.widgets.XBayaComponent;

public class GridPanel
implements XBayaComponent {
    public static final int WEIGHT_NONE = -1;
    public static final int WEIGHT_EQUALLY = -2;
    private JPanel contentPanel;
    private JComponent rootComponent;
    private boolean scroll = false;

    public GridPanel() {
        this(false);
    }

    public GridPanel(boolean scroll) {
        this.init(scroll);
    }

    @Override
    public JComponent getSwingComponent() {
        return this.rootComponent;
    }

    public JPanel getContentPanel() {
        return this.contentPanel;
    }

    public void add(XBayaComponent component) {
        this.add(component.getSwingComponent());
    }

    public void add(XBayaComponent component, int index) {
        this.add(component.getSwingComponent(), index);
    }

    public void add(JComponent component) {
        this.contentPanel.add(component);
    }

    public void add(JComponent component, int index) {
        this.contentPanel.add((Component)component, index);
    }

    public void remove(int index) {
        this.contentPanel.remove(index);
    }

    public void layout(int numRow, int numColumn, int weightedRow, int weightedColumn) {
        SwingUtil.layoutToGrid((Container)this.contentPanel, (int)numRow, (int)numColumn, (int)weightedRow, (int)weightedColumn);
    }

    public void layout(double[] rowWeights, double[] columnWeights) {
        SwingUtil.layoutToGrid((Container)this.contentPanel, (double[])rowWeights, (double[])columnWeights);
    }

    public void layout(List<Double> rowWeights, List<Double> columnWeights) {
        SwingUtil.layoutToGrid((Container)this.contentPanel, rowWeights, columnWeights);
    }

    private void init(boolean scroll) {
        this.contentPanel = new JPanel();
        if (scroll) {
            this.contentPanel.setOpaque(true);
            JScrollPane scrollPane = new JScrollPane(this.contentPanel);
            this.rootComponent = scrollPane;
        } else {
            this.rootComponent = this.contentPanel;
        }
        this.scroll = scroll;
    }

    public void resetPanel() {
        this.init(this.scroll);
    }
}

