/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.xbaya.ui.views;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import org.apache.airavata.common.utils.SwingUtil;
import org.apache.airavata.workflow.model.graph.DataPort;
import org.apache.airavata.workflow.model.graph.Port;
import org.apache.airavata.xbaya.ui.graph.GraphCanvas;
import org.apache.airavata.xbaya.ui.graph.GraphCanvasEvent;
import org.apache.airavata.xbaya.ui.graph.GraphCanvasListener;

public class PortViewer
implements GraphCanvasListener {
    public static final String TITLE = "Parameters";
    private JPanel panel = new JPanel();
    private JEditorPane outputEditor;
    private JEditorPane inputEditor;

    public PortViewer() {
        this.panel.setMinimumSize(SwingUtil.MINIMUM_SIZE);
        this.panel.setPreferredSize(new Dimension(0, 150));
        JPanel inBox = new JPanel(new BorderLayout());
        inBox.setBorder(new TitledBorder(new EtchedBorder(), "Input Parameter"));
        this.inputEditor = this.createEditorPane();
        JScrollPane inputScrollPane = new JScrollPane(this.inputEditor);
        inputScrollPane.setMinimumSize(SwingUtil.MINIMUM_SIZE);
        inBox.add((Component)inputScrollPane, "Center");
        inBox.setMinimumSize(SwingUtil.MINIMUM_SIZE);
        JPanel outBox = new JPanel(new BorderLayout());
        outBox.setBorder(new TitledBorder(new EtchedBorder(), "Output Parameter"));
        this.outputEditor = this.createEditorPane();
        JScrollPane outScrollPane = new JScrollPane(this.outputEditor);
        outScrollPane.setMinimumSize(SwingUtil.MINIMUM_SIZE);
        outBox.add((Component)outScrollPane, "Center");
        outBox.setMinimumSize(SwingUtil.MINIMUM_SIZE);
        this.panel.setLayout(new GridLayout(1, 2));
        this.panel.add(outBox);
        this.panel.add(inBox);
    }

    public JComponent getSwingComponent() {
        return this.panel;
    }

    public void setOutputPort(Port port) {
        this.showPortInfo(this.outputEditor, port);
    }

    public void setInputPort(Port port) {
        this.showPortInfo(this.inputEditor, port);
    }

    @Override
    public void graphCanvasChanged(GraphCanvasEvent event) {
        GraphCanvasEvent.GraphCanvasEventType type = event.getType();
        GraphCanvas graphCanvas = event.getGraphCanvas();
        switch (type) {
            case INPUT_PORT_SELECTED: {
                Port inputPort = graphCanvas.getSelectedInputPort();
                this.setInputPort(inputPort);
                break;
            }
            case OUTPUT_PORT_SELECTED: {
                Port outputPort = graphCanvas.getSelectedOutputPort();
                this.setOutputPort(outputPort);
                break;
            }
        }
    }

    private void showPortInfo(JEditorPane editor, Port port) {
        if (port == null) {
            editor.setText("");
        } else {
            StringBuilder buf = new StringBuilder();
            buf.append("<strong>Component: " + port.getNode().getName() + "</strong><br>");
            buf.append("<strong>Port: " + port.getName() + "<br></strong>");
            if (port instanceof DataPort) {
                buf.append("<strong>Type</strong>: " + ((DataPort)port).getType() + "<br>");
            }
            buf.append("<strong>Description</strong>: " + port.getComponentPort().getDescription() + "<br>");
            editor.setText(buf.toString());
            editor.setCaretPosition(0);
        }
    }

    private JEditorPane createEditorPane() {
        JEditorPane editorPane = new JEditorPane();
        editorPane.setMinimumSize(SwingUtil.MINIMUM_SIZE);
        editorPane.setEditable(false);
        editorPane.setBackground(Color.WHITE);
        editorPane.setContentType("text/html; charset=utf-8");
        return editorPane;
    }
}

