/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.xbaya.ui.views;

import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.apache.airavata.common.utils.XMLUtil;
import org.apache.airavata.workflow.model.graph.system.ParameterNode;
import org.apache.airavata.xbaya.core.workflow.ParameterListModel;
import org.apache.airavata.xbaya.ui.widgets.GridPanel;
import org.apache.airavata.xbaya.ui.widgets.XBayaComponent;
import org.apache.airavata.xbaya.ui.widgets.XBayaList;
import org.apache.airavata.xbaya.ui.widgets.XBayaTextArea;
import org.xmlpull.infoset.XmlElement;

public class ParameterPropertyPanel
implements XBayaComponent {
    private String title;
    private XBayaList parameterList;
    private ParameterListModel listModel;
    private GridPanel panel;
    private XBayaTextArea metadataTextArea;
    private JButton upButton;
    private JButton downButton;

    public ParameterPropertyPanel(String title) {
        this.title = title;
        this.initGUI();
    }

    @Override
    public JComponent getSwingComponent() {
        return this.getPanel().getSwingComponent();
    }

    public GridPanel getPanel() {
        return this.panel;
    }

    public void setParameterNodes(List<? extends ParameterNode> parameterNodes) {
        this.listModel = new ParameterListModel(parameterNodes);
        this.parameterList.getList().setModel(this.listModel);
    }

    public void setMetadata(XmlElement metadata) {
        String metadataText = metadata == null ? "<appinfo xmlns=\"http://www.w3.org/2001/XMLSchema\">\n\n</appinfo>" : XMLUtil.xmlElementToString((XmlElement)metadata);
        this.metadataTextArea.setText(metadataText);
    }

    public String getMetadata() {
        return this.metadataTextArea.getText();
    }

    private void up() {
        int index = this.parameterList.getSelectedIndex();
        this.parameterList.setSelectedIndex(index - 1);
        this.listModel.up(index);
    }

    private void down() {
        int index = this.parameterList.getSelectedIndex();
        this.parameterList.setSelectedIndex(index + 1);
        this.listModel.down(index);
    }

    private void selectionChanged() {
        int index = this.parameterList.getSelectedIndex();
        if (index < 0) {
            this.upButton.setEnabled(false);
            this.downButton.setEnabled(false);
        } else {
            if (index == 0) {
                this.upButton.setEnabled(false);
            } else {
                this.upButton.setEnabled(true);
            }
            if (index == this.listModel.getSize() - 1) {
                this.downButton.setEnabled(false);
            } else {
                this.downButton.setEnabled(true);
            }
        }
    }

    private void initGUI() {
        this.parameterList = new XBayaList();
        this.parameterList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent event) {
                ParameterPropertyPanel.this.selectionChanged();
            }
        });
        this.upButton = new JButton("UP");
        this.upButton.setEnabled(false);
        this.upButton.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ParameterPropertyPanel.this.up();
            }
        });
        this.downButton = new JButton("DOWN");
        this.downButton.setEnabled(false);
        this.downButton.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ParameterPropertyPanel.this.down();
            }
        });
        GridPanel buttonPanel = new GridPanel();
        buttonPanel.add(this.upButton);
        buttonPanel.add(this.downButton);
        buttonPanel.layout(2, 1, -1, 0);
        GridPanel reorderingPanel = new GridPanel();
        reorderingPanel.add(this.parameterList);
        reorderingPanel.add(buttonPanel);
        reorderingPanel.layout(1, 2, 0, 0);
        this.metadataTextArea = new XBayaTextArea();
        JLabel metadataLabel = new JLabel("Metadata");
        metadataLabel.setLabelFor(this.metadataTextArea.getSwingComponent());
        this.panel = new GridPanel();
        this.panel.add(reorderingPanel);
        this.panel.add(metadataLabel);
        this.panel.add(this.metadataTextArea);
        this.panel.layout(3, 1, 2, 0);
        TitledBorder border = BorderFactory.createTitledBorder(this.title);
        this.panel.getSwingComponent().setBorder(border);
    }
}

