/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.xbaya.ui.views;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;
import javax.swing.BoundedRangeModel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeListener;
import javax.swing.event.MouseInputAdapter;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.apache.airavata.common.utils.BrowserLauncher;
import org.apache.airavata.common.utils.SwingUtil;
import org.apache.airavata.ws.monitor.EventDataRepository;
import org.apache.airavata.ws.monitor.Monitor;
import org.apache.airavata.ws.monitor.MonitorUtil;
import org.apache.airavata.xbaya.ui.XBayaGUI;
import org.apache.airavata.xbaya.ui.dialogs.monitor.MonitorWindow;
import org.apache.airavata.xbaya.ui.monitor.MonitorEventHandler;
import org.apache.airavata.xbaya.ui.widgets.XBayaComponent;
import org.xmlpull.infoset.XmlElement;

public class MonitorPanel
implements XBayaComponent,
TableModelListener {
    public static final String TITLE = "Monitoring";
    private XBayaGUI xbayaGUI;
    private EventDataRepository tableSliderModel;
    private JTable table;
    private JScrollPane scrollPane;
    private JSlider slider;
    private JPanel panel;

    public MonitorPanel(XBayaGUI xbayaGUI, Monitor monitor) {
        this(xbayaGUI, null, monitor);
    }

    public MonitorPanel(XBayaGUI xbayaGUI, String nodeID, Monitor monitor) {
        this.xbayaGUI = xbayaGUI;
        this.tableSliderModel = null == nodeID ? monitor.getEventDataRepository() : monitor.getEventData(nodeID);
        this.init();
        this.tableSliderModel.addTableModelListener((TableModelListener)this);
        MonitorEventHandler eventHandler = new MonitorEventHandler(this.xbayaGUI);
        this.tableSliderModel.addChangeListener((ChangeListener)eventHandler);
    }

    @Override
    public JPanel getSwingComponent() {
        return this.panel;
    }

    @Override
    public void tableChanged(final TableModelEvent event) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                MonitorPanel.this.tableChangedInSwingThread(event);
            }
        });
    }

    private void tableChangedInSwingThread(TableModelEvent event) {
        int type = event.getType();
        if (type == 1) {
            int firstRow = event.getFirstRow();
            boolean move = false;
            Rectangle visibleRect = this.table.getVisibleRect();
            Rectangle bottomCellRect = this.table.getCellRect(firstRow - 1, 0, true);
            move = bottomCellRect.intersects(visibleRect);
            if (move) {
                Rectangle newBottomCellRect = this.table.getCellRect(this.table.getRowCount() - 1, 0, true);
                this.table.scrollRectToVisible(newBottomCellRect);
            }
            this.scrollPane.repaint();
        } else if (type == -1) {
            // empty if block
        }
        int size = this.tableSliderModel.getEventSize();
        boolean empty = size == 0;
        this.slider.setEnabled(!empty);
    }

    private void init() {
        this.table = new JTable((TableModel)this.tableSliderModel){

            @Override
            public String getToolTipText(MouseEvent event) {
                String tip = null;
                Point point = event.getPoint();
                int colIndex = this.columnAtPoint(point);
                if (colIndex == EventDataRepository.Column.MESSAGE.ordinal()) {
                    tip = "Double click here to see the full message.";
                }
                return tip;
            }
        };
        this.table.getTableHeader().setReorderingAllowed(false);
        this.table.addMouseListener(new MouseInputAdapter(){
            private MonitorWindow window;

            @Override
            public void mouseClicked(MouseEvent event) {
                Point point = event.getPoint();
                int row = MonitorPanel.this.table.rowAtPoint(point);
                if (row >= 0 && row < MonitorPanel.this.table.getRowCount()) {
                    XmlElement message = MonitorPanel.this.tableSliderModel.getEvent(row).getEvent();
                    int clickCount = event.getClickCount();
                    if (clickCount == 1) {
                        if (MonitorUtil.getType((XmlElement)message) == MonitorUtil.EventType.PUBLISH_URL) {
                            int column = MonitorPanel.this.table.columnAtPoint(point);
                            if (column == EventDataRepository.Column.MESSAGE.ordinal()) {
                                String url = MonitorUtil.getLocation((XmlElement)message);
                                try {
                                    BrowserLauncher.openURL((String)url);
                                }
                                catch (Exception e) {
                                    MonitorPanel.this.xbayaGUI.getErrorWindow().error(e.getMessage(), e);
                                }
                            }
                        } else if (MonitorUtil.getType((XmlElement)message) == MonitorUtil.EventType.SENDING_RESULT && null != message && null != message.element("result") && null != message.element("result").element("body") && null != message.element("result").element("body").element("Body")) {
                            XmlElement body = message.element("result").element("body").element("Body");
                            Iterator bodyItr = body.children().iterator();
                            this.findAndLaunchBrowser(bodyItr);
                        }
                    } else if (clickCount >= 2) {
                        if (this.window == null) {
                            this.window = new MonitorWindow(MonitorPanel.this.xbayaGUI);
                        }
                        this.window.show(message);
                    }
                }
            }

            private void findAndLaunchBrowser(Iterator bodyItr) {
                Object firstElement;
                if (bodyItr.hasNext() && (firstElement = bodyItr.next()) instanceof XmlElement) {
                    this.findAndLuanchBrowser((XmlElement)firstElement);
                }
            }

            private void findAndLuanchBrowser(XmlElement firstElement) {
                for (Object object : firstElement.children()) {
                    if (object instanceof String) {
                        try {
                            new URL(((String)object).trim());
                            try {
                                BrowserLauncher.openURL((String)((String)object).trim());
                            }
                            catch (Throwable e) {
                            }
                        }
                        catch (MalformedURLException e) {}
                        continue;
                    }
                    if (!(object instanceof XmlElement)) continue;
                    this.findAndLuanchBrowser((XmlElement)object);
                }
            }
        });
        TableColumnModel columnModel = this.table.getColumnModel();
        int columnCount = columnModel.getColumnCount();
        for (int i = 0; i < columnCount; ++i) {
            TableColumn column = columnModel.getColumn(i);
            if (i == columnCount - 1) {
                column.setPreferredWidth(500);
                continue;
            }
            column.setPreferredWidth(50);
        }
        this.table.setAutoResizeMode(3);
        this.scrollPane = new JScrollPane(this.table);
        this.scrollPane.setMinimumSize(SwingUtil.MINIMUM_SIZE);
        this.scrollPane.setDoubleBuffered(true);
        this.slider = new JSlider((BoundedRangeModel)this.tableSliderModel);
        this.slider.setSnapToTicks(true);
        this.slider.setEnabled(false);
        this.panel = new JPanel();
        this.panel.setLayout(new BorderLayout());
        this.panel.add((Component)this.scrollPane, "Center");
        this.panel.add((Component)this.slider, "South");
    }
}

