/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.xbaya.ui.views;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.border.EmptyBorder;
import javax.swing.tree.DefaultTreeModel;
import org.apache.airavata.client.api.AiravataAPI;
import org.apache.airavata.workflow.model.component.registry.JCRComponentRegistry;
import org.apache.airavata.xbaya.XBayaEngine;
import org.apache.airavata.xbaya.registrybrowser.nodes.AbstractAiravataTreeNode;
import org.apache.airavata.xbaya.registrybrowser.nodes.AiravataTreeNodeFactory;
import org.apache.airavata.xbaya.registrybrowser.nodes.RegistryTreeCellRenderer;
import org.apache.airavata.xbaya.ui.actions.AbstractBrowserActionItem;
import org.apache.airavata.xbaya.ui.actions.registry.browser.AddAction;
import org.apache.airavata.xbaya.ui.actions.registry.browser.CopyAction;
import org.apache.airavata.xbaya.ui.actions.registry.browser.DeleteAction;
import org.apache.airavata.xbaya.ui.actions.registry.browser.EditAction;
import org.apache.airavata.xbaya.ui.actions.registry.browser.ImportAction;
import org.apache.airavata.xbaya.ui.actions.registry.browser.RefreshAction;
import org.apache.airavata.xbaya.ui.actions.registry.browser.ViewAction;

public class JCRBrowserPanel
extends JPanel
implements Observer {
    private List<AbstractBrowserActionItem> browserActions = new ArrayList<AbstractBrowserActionItem>();
    private static final long serialVersionUID = -4490110894914580271L;
    private XBayaEngine engine;
    private JTree tree;
    private JPopupMenu popupMenu;
    private AbstractBrowserActionItem actionDelete;

    public JCRBrowserPanel(XBayaEngine engine) {
        this.setEngine(engine);
        this.initGUI();
    }

    private void initGUI() {
        this.setBounds(100, 100, 450, 300);
        this.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.setLayout(new BorderLayout(0, 0));
        JScrollPane scrollPane = new JScrollPane();
        this.add((Component)scrollPane, "Center");
        this.tree = new JTree(AiravataTreeNodeFactory.getTreeNode(this.getJCRRegistry() == null ? "No registry specified" : this.getEngine(), null));
        this.tree.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 116) {
                    JCRBrowserPanel.this.triggerNodeAction(RefreshAction.ID);
                }
            }
        });
        this.tree.setCellRenderer(new RegistryTreeCellRenderer());
        scrollPane.setViewportView(this.tree);
        this.popupMenu = new JPopupMenu();
        this.popupMenu.setLabel("");
        this.addPopup(this.tree, this.popupMenu);
        RefreshAction actionRefresh = new RefreshAction();
        actionRefresh.getMenuItem().setAccelerator(KeyStroke.getKeyStroke(116, 0));
        actionRefresh.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JCRBrowserPanel.this.triggerNodeAction(RefreshAction.ID);
            }
        });
        this.actionDelete = new DeleteAction();
        this.actionDelete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                JCRBrowserPanel.this.triggerNodeAction("action.delete");
            }
        });
        AddAction actionAdd = new AddAction();
        actionAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                JCRBrowserPanel.this.triggerNodeAction("action.add");
            }
        });
        EditAction actionEdit = new EditAction();
        actionEdit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                JCRBrowserPanel.this.triggerNodeAction("action.edit");
            }
        });
        ImportAction actionImport = new ImportAction();
        actionImport.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                JCRBrowserPanel.this.triggerNodeAction("action.import");
            }
        });
        CopyAction actionCopy = new CopyAction();
        actionCopy.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                JCRBrowserPanel.this.triggerNodeAction("action.copy");
            }
        });
        ViewAction actionView = new ViewAction();
        actionView.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                JCRBrowserPanel.this.triggerNodeAction("action.view");
            }
        });
        this.tree.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    JCRBrowserPanel.this.triggerNodeAction(null);
                }
            }
        });
        this.browserActions.add(actionAdd);
        this.browserActions.add(actionView);
        this.browserActions.add(actionImport);
        this.browserActions.add(actionEdit);
        this.browserActions.add(actionRefresh);
        this.browserActions.add(this.actionDelete);
        this.browserActions.add(actionCopy);
    }

    public void close() {
        this.setVisible(false);
    }

    public void open() {
        this.setVisible(true);
    }

    public XBayaEngine getEngine() {
        return this.engine;
    }

    public void setEngine(XBayaEngine engine) {
        if (this.engine != null) {
            this.engine.getConfiguration().deleteObserver(this);
        }
        this.engine = engine;
        if (this.engine != null) {
            this.engine.getConfiguration().addObserver(this);
        }
    }

    private AiravataAPI getJCRRegistry() {
        try {
            return this.getEngine().getConfiguration().getAiravataAPI();
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public void update(Observable observable, Object o) {
        if (this.getEngine().getConfiguration() == observable) {
            if (o instanceof JCRComponentRegistry) {
                this.resetModel();
            } else if (o instanceof AiravataAPI) {
                this.resetModel();
            }
        }
    }

    private void resetModel() {
        this.tree.setModel(new DefaultTreeModel(AiravataTreeNodeFactory.getTreeNode(this.getJCRRegistry() == null ? "No registry specified" : this.getEngine(), null)));
    }

    private void addPopup(Component component, final JPopupMenu popup) {
        component.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    this.showMenu(e);
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    this.showMenu(e);
                }
            }

            private void showMenu(MouseEvent e) {
                int selRow = JCRBrowserPanel.this.tree.getRowForLocation(e.getX(), e.getY());
                if (selRow != -1 && e.isPopupTrigger()) {
                    JCRBrowserPanel.this.tree.setSelectionRow(selRow);
                    Object o = JCRBrowserPanel.this.tree.getLastSelectedPathComponent();
                    popup.removeAll();
                    if (o instanceof AbstractAiravataTreeNode) {
                        AbstractAiravataTreeNode node = (AbstractAiravataTreeNode)o;
                        for (AbstractBrowserActionItem action : JCRBrowserPanel.this.browserActions) {
                            boolean actionSupported = node.isActionSupported(action);
                            action.setVisible(actionSupported);
                            if (!actionSupported) continue;
                            action.setCaption(node.getActionCaption(action));
                            action.setIcon(node.getActionIcon(action));
                            action.setDescription(node.getActionDescription(action));
                            popup.add(action.getMenuItem());
                        }
                    }
                    if (popup.getSubElements().length > 0) {
                        popup.show(e.getComponent(), e.getX(), e.getY());
                    }
                }
            }
        });
    }

    private void triggerNodeAction(String action) {
        Object o = this.tree.getLastSelectedPathComponent();
        if (o instanceof AbstractAiravataTreeNode) {
            AbstractAiravataTreeNode node = (AbstractAiravataTreeNode)o;
            try {
                if (action == null) {
                    action = node.getDefaultAction();
                }
                if (action != null) {
                    node.triggerAction(this.tree, action);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                this.getEngine().getGUI().getErrorWindow().error(e);
            }
        }
    }
}

