/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.xbaya.ui.views;

import java.awt.Color;
import javax.swing.JEditorPane;
import javax.swing.SwingUtilities;
import org.apache.airavata.workflow.model.component.Component;
import org.apache.airavata.workflow.model.graph.Node;
import org.apache.airavata.xbaya.ui.graph.GraphCanvas;
import org.apache.airavata.xbaya.ui.graph.GraphCanvasEvent;
import org.apache.airavata.xbaya.ui.graph.GraphCanvasListener;
import org.apache.airavata.xbaya.ui.widgets.XBayaComponent;
import org.apache.airavata.xbaya.ui.widgets.component.ComponentSelectorEvent;
import org.apache.airavata.xbaya.ui.widgets.component.ComponentSelectorListener;

public class ComponentViewer
implements GraphCanvasListener,
ComponentSelectorListener,
XBayaComponent {
    public static final String TITLE = "Component Information";
    private static final String DEFAULT_HTML_MESSAGE = "<html> Select a component from the Component List.</html>";
    private Component currentComponent = null;
    private JEditorPane editorPane = new JEditorPane();

    public ComponentViewer() {
        this.editorPane.setEditable(false);
        this.editorPane.setBackground(Color.WHITE);
        this.editorPane.setContentType("text/html; charset=utf-8");
        this.editorPane.setText(DEFAULT_HTML_MESSAGE);
    }

    @Override
    public JEditorPane getSwingComponent() {
        return this.editorPane;
    }

    public void setComponent(final Component component) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (component == null) {
                    ComponentViewer.this.editorPane.setText(ComponentViewer.DEFAULT_HTML_MESSAGE);
                } else if (component != ComponentViewer.this.currentComponent) {
                    ComponentViewer.this.editorPane.setText(component.toHTML());
                    ComponentViewer.this.editorPane.setCaretPosition(0);
                }
                ComponentViewer.this.currentComponent = component;
            }
        });
    }

    @Override
    public void graphCanvasChanged(GraphCanvasEvent event) {
        GraphCanvasEvent.GraphCanvasEventType type = event.getType();
        GraphCanvas graphCanvas = event.getGraphCanvas();
        switch (type) {
            case NODE_SELECTED: {
                Node node = graphCanvas.getSelectedNode();
                if (node == null) {
                    this.setComponent(null);
                    break;
                }
                this.setComponent(node.getComponent());
                break;
            }
        }
    }

    @Override
    public void componentSelectorChanged(ComponentSelectorEvent event) {
        ComponentSelectorEvent.ComponentSelectorEventType type = event.getType();
        switch (type) {
            case COMPONENT_SELECTED: {
                Component component = event.getComponent();
                this.setComponent(component);
            }
        }
    }
}

