/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.xbaya.ui.monitor;

import org.apache.airavata.ws.monitor.MonitorException;
import org.apache.airavata.xbaya.XBayaEngine;
import org.apache.airavata.xbaya.ui.dialogs.WaitDialog;
import org.apache.airavata.xbaya.ui.utils.Cancelable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MonitorStarter
implements Cancelable {
    private static final Logger logger = LoggerFactory.getLogger(MonitorStarter.class);
    private XBayaEngine engine;
    private Thread subscribingThread;
    private boolean canceled;
    private WaitDialog startingDialog;

    public MonitorStarter(XBayaEngine engine) {
        this.engine = engine;
        this.startingDialog = new WaitDialog(this, "Starting Monitoring", "Subscribing to notification.\nPlease wait for a moment.", this.engine.getGUI());
    }

    @Override
    public void cancel() {
        this.canceled = true;
        this.subscribingThread.interrupt();
    }

    public void start() {
        this.start(false);
    }

    public void start(boolean blocking) {
        this.canceled = false;
        this.subscribingThread = new Thread(){

            @Override
            public void run() {
                MonitorStarter.this.runInThread();
            }
        };
        this.subscribingThread.start();
        this.startingDialog.show();
        if (blocking) {
            try {
                this.subscribingThread.join();
            }
            catch (InterruptedException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    private void runInThread() {
        try {
            this.engine.getMonitor().start();
            this.startingDialog.hide();
        }
        catch (MonitorException e) {
            if (this.canceled) {
                logger.error(e.getMessage(), (Throwable)e);
            } else {
                this.engine.getGUI().getErrorWindow().error("Failed to subscribe to notification.", e);
                this.startingDialog.hide();
            }
        }
        catch (RuntimeException e) {
            if (this.canceled) {
                logger.error(e.getMessage(), (Throwable)e);
            } else {
                this.engine.getGUI().getErrorWindow().error("Failed to subscribe to notification.", e);
                this.startingDialog.hide();
            }
        }
        catch (Error e) {
            this.engine.getGUI().getErrorWindow().error("Unexpected error.", e);
            this.startingDialog.hide();
        }
    }
}

