/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.xbaya.ui.monitor;

import java.awt.Color;
import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.airavata.workflow.model.graph.ControlPort;
import org.apache.airavata.workflow.model.graph.EPRPort;
import org.apache.airavata.workflow.model.graph.Edge;
import org.apache.airavata.workflow.model.graph.Graph;
import org.apache.airavata.workflow.model.graph.Node;
import org.apache.airavata.workflow.model.graph.Port;
import org.apache.airavata.workflow.model.graph.amazon.InstanceNode;
import org.apache.airavata.workflow.model.graph.impl.NodeImpl;
import org.apache.airavata.workflow.model.graph.system.InputNode;
import org.apache.airavata.workflow.model.graph.system.OutputNode;
import org.apache.airavata.workflow.model.graph.util.GraphUtil;
import org.apache.airavata.workflow.model.graph.ws.WSGraph;
import org.apache.airavata.workflow.model.wf.Workflow;
import org.apache.airavata.ws.monitor.EventData;
import org.apache.airavata.ws.monitor.EventDataRepository;
import org.apache.airavata.ws.monitor.MonitorUtil;
import org.apache.airavata.xbaya.graph.controller.NodeController;
import org.apache.airavata.xbaya.ui.XBayaGUI;
import org.apache.airavata.xbaya.ui.graph.GraphCanvas;
import org.apache.airavata.xbaya.ui.graph.NodeGUI;
import org.apache.airavata.xbaya.ui.monitor.ResourcePaintable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xmlpull.infoset.XmlElement;

public class MonitorEventHandler
implements ChangeListener {
    private static Logger logger = LoggerFactory.getLogger(MonitorEventHandler.class);
    private XBayaGUI xbayaGUI;
    private int sliderValue;
    private Collection<URI> incorrectWorkflowIDs;
    private Collection<URI> triedWorkflowIDs;
    private Map<Node, LinkedList<ResourcePaintable>> resourcePaintableMap;

    public MonitorEventHandler(XBayaGUI xbayaGUI) {
        this.xbayaGUI = xbayaGUI;
        this.incorrectWorkflowIDs = Collections.synchronizedSet(new HashSet());
        this.triedWorkflowIDs = Collections.synchronizedSet(new HashSet());
        this.resourcePaintableMap = new HashMap<Node, LinkedList<ResourcePaintable>>();
    }

    @Override
    public void stateChanged(ChangeEvent event) {
        try {
            Object source = event.getSource();
            if (source instanceof EventDataRepository) {
                this.handleChange((EventDataRepository)source);
            }
        }
        catch (RuntimeException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    private void handleChange(EventDataRepository model) {
        int newValue = model.getValue();
        if (model.getEventSize() == 0) {
            this.resetAll();
        } else if (newValue > this.sliderValue) {
            for (int i = this.sliderValue; i < newValue; ++i) {
                this.handleEvent(model.getEvent(i), true);
            }
        } else if (newValue < this.sliderValue) {
            for (int i = this.sliderValue - 1; i >= newValue; --i) {
                this.handleEvent(model.getEvent(i), false);
            }
        }
        this.sliderValue = newValue;
        this.xbayaGUI.getGraphCanvas().repaint();
    }

    private void handleEvent(EventData event, boolean forward) {
        Workflow workflow;
        MonitorUtil.EventType type = event.getType();
        URI workflowID = event.getWorkflowID();
        List<GraphCanvas> graphCanvases = this.xbayaGUI.getGraphCanvases();
        boolean found = false;
        for (GraphCanvas graphCanvas : graphCanvases) {
            workflow = graphCanvas.getWorkflow();
            this.handleEvent(event, forward, (Graph)workflow.getGraph());
        }
        if (type == MonitorUtil.EventType.WORKFLOW_INITIALIZED && forward) {
            for (GraphCanvas graphCanvas : graphCanvases) {
                workflow = graphCanvas.getWorkflow();
                URI instanceID = workflow.getGPELInstanceID();
                if (!workflowID.equals(instanceID)) continue;
                return;
            }
            this.loadWorkflow(workflowID);
        }
        if (!found && workflowID != null) {
            this.loadWorkflow(workflowID);
        }
        if (type == MonitorUtil.EventType.RESOURCE_MAPPING && event.getMessage().contains("i-")) {
            String nodeID = event.getNodeID();
            for (GraphCanvas graphCanvas : graphCanvases) {
                Node fromNode;
                ControlPort control;
                NodeImpl node = graphCanvas.getWorkflow().getGraph().getNode(nodeID);
                if (node == null || (control = node.getControlInPort()) == null || !((fromNode = control.getFromNode()) instanceof InstanceNode)) continue;
                InstanceNode ec2Node = (InstanceNode)fromNode;
                int start = event.getMessage().indexOf("i-");
                String instanceId = event.getMessage().substring(start, start + 10);
                ec2Node.setOutputInstanceId(instanceId);
                ec2Node.setStartNewInstance(false);
                ec2Node.setInstanceId(instanceId);
                ec2Node.setAmiId(null);
            }
        }
    }

    private LinkedList<InputNode> getInputNodes(WSGraph graph) {
        List nodes = graph.getNodes();
        LinkedList<InputNode> inputNodes = new LinkedList<InputNode>();
        for (NodeImpl nodeImpl : nodes) {
            if (!(nodeImpl instanceof InputNode)) continue;
            inputNodes.add((InputNode)nodeImpl);
        }
        return inputNodes;
    }

    private LinkedList<OutputNode> getOutputNodes(WSGraph graph) {
        List nodes = graph.getNodes();
        LinkedList<OutputNode> outputNodes = new LinkedList<OutputNode>();
        for (NodeImpl nodeImpl : nodes) {
            if (!(nodeImpl instanceof OutputNode)) continue;
            outputNodes.add((OutputNode)nodeImpl);
        }
        return outputNodes;
    }

    private void handleEvent(EventData event, boolean forward, Graph graph) {
        MonitorUtil.EventType type = event.getType();
        String nodeID = event.getNodeID();
        Node node = graph.getNode(nodeID);
        System.out.println(type);
        if (type == MonitorUtil.EventType.WORKFLOW_INVOKED) {
            this.workflowStarted(graph, forward);
        } else if (type == MonitorUtil.EventType.WORKFLOW_TERMINATED) {
            this.workflowFinished(graph, forward);
        } else if (type == MonitorUtil.EventType.INVOKING_SERVICE || type == MonitorUtil.EventType.SERVICE_INVOKED) {
            if (node == null) {
                logger.warn("There is no node that has ID, " + nodeID);
            } else {
                this.nodeStarted(node, forward);
            }
        } else if (type == MonitorUtil.EventType.RECEIVED_RESULT || type == MonitorUtil.EventType.SENDING_RESULT) {
            if (node == null) {
                logger.warn("There is no node that has ID, " + nodeID);
            } else {
                this.nodeFinished(node, forward);
            }
        } else if (type == MonitorUtil.EventType.INVOKING_SERVICE_FAILED || type == MonitorUtil.EventType.RECEIVED_FAULT || type == MonitorUtil.EventType.SENDING_FAULT || type == MonitorUtil.EventType.SENDING_RESPONSE_FAILED) {
            if (node == null) {
                logger.warn("There is no node that has ID, " + nodeID);
            } else {
                this.nodeFailed(node, forward);
            }
        } else if (type == MonitorUtil.EventType.RESOURCE_MAPPING) {
            if (node == null) {
                logger.warn("There is no node that has ID, " + nodeID);
            } else {
                this.nodeResourceMapped(node, event.getEvent(), forward);
            }
        }
    }

    private void loadWorkflow(final URI workflowInstanceID) {
        if (this.triedWorkflowIDs.contains(workflowInstanceID)) {
            return;
        }
        this.triedWorkflowIDs.add(workflowInstanceID);
        new Thread(){

            @Override
            public void run() {
                MonitorEventHandler.this.loadWorkflowInThread(workflowInstanceID);
            }
        }.start();
    }

    private void loadWorkflowInThread(URI workflowInstanceID) {
        try {
            if (this.incorrectWorkflowIDs.contains(workflowInstanceID)) {
                return;
            }
        }
        catch (RuntimeException e) {
            this.incorrectWorkflowIDs.add(workflowInstanceID);
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    private void workflowStarted(Graph graph, boolean forward) {
        for (InputNode node : GraphUtil.getInputNodes((Graph)graph)) {
            if (forward) {
                this.finishNode((Node)node);
                continue;
            }
            this.resetNode((Node)node);
        }
    }

    private void workflowFinished(Graph graph, boolean forward) {
        for (OutputNode node : GraphUtil.getOutputNodes((Graph)graph)) {
            if (forward) {
                this.finishNode((Node)node);
                this.finishPredecessorNodes((Node)node);
                continue;
            }
            this.resetNode((Node)node);
        }
    }

    private void nodeStarted(Node node, boolean forward) {
        if (forward) {
            if (node.getState() != Node.NodeExecutionState.FINISHED) {
                this.executeNode(node);
                this.finishPredecessorNodes(node);
            }
        } else {
            this.resetNode(node);
        }
    }

    private void nodeFinished(Node node, boolean forward) {
        if (forward) {
            this.finishNode(node);
            this.finishPredecessorNodes(node);
        } else {
            this.executeNode(node);
        }
    }

    private void nodeFailed(Node node, boolean forward) {
        if (forward) {
            this.failNode(node);
            this.finishPredecessorNodes(node);
        } else {
            this.executeNode(node);
        }
    }

    private void nodeResourceMapped(Node node, XmlElement event, boolean forward) {
        String resource = MonitorUtil.getMappedResource((XmlElement)event);
        String retryCount = MonitorUtil.getRetryCount((XmlElement)event);
        NodeGUI nodeGUI = NodeController.getGUI(node);
        if (forward) {
            LinkedList<ResourcePaintable> paintables = this.resourcePaintableMap.get(node);
            if (paintables == null) {
                paintables = new LinkedList();
                this.resourcePaintableMap.put(node, paintables);
            }
            if (paintables.size() > 0) {
                ResourcePaintable previousPaintable = paintables.getLast();
                nodeGUI.removePaintable(previousPaintable);
            }
            ResourcePaintable paintable = new ResourcePaintable(resource, retryCount);
            paintables.addLast(paintable);
            nodeGUI.addPaintable(paintable);
        } else {
            LinkedList<ResourcePaintable> paintables = this.resourcePaintableMap.get(node);
            if (paintables == null) {
                paintables = new LinkedList();
                this.resourcePaintableMap.put(node, paintables);
            }
            if (paintables.size() > 0) {
                ResourcePaintable lastPaintable = paintables.removeLast();
                nodeGUI.removePaintable(lastPaintable);
            }
            if (paintables.size() > 0) {
                ResourcePaintable previousPaintable = paintables.getLast();
                nodeGUI.addPaintable(previousPaintable);
            }
        }
    }

    private void resetAll() {
        List<GraphCanvas> graphCanvases = this.xbayaGUI.getGraphCanvases();
        for (GraphCanvas graphCanvas : graphCanvases) {
            Graph graph = graphCanvas.getGraph();
            for (Node node : graph.getNodes()) {
                this.resetNode(node);
            }
        }
    }

    private void executeNode(Node node) {
        node.setState(Node.NodeExecutionState.EXECUTING);
    }

    private void finishNode(Node node) {
        node.setState(Node.NodeExecutionState.FINISHED);
    }

    private void failNode(Node node) {
        node.setState(Node.NodeExecutionState.FAILED);
    }

    private void resetNode(Node node) {
        node.setState(Node.NodeExecutionState.WAITING);
        NodeController.getGUI(node).resetTokens();
    }

    private void finishPredecessorNodes(Node node) {
        for (Port inputPort : node.getInputPorts()) {
            for (Edge edge : inputPort.getEdges()) {
                Port fromPort = edge.getFromPort();
                if (fromPort instanceof EPRPort) continue;
                Node fromNode = fromPort.getNode();
                this.finishNode(fromNode);
                this.finishPredecessorNodes(fromNode);
            }
        }
        ControlPort controlInPort = node.getControlInPort();
        if (controlInPort != null) {
            for (Node fromNode : controlInPort.getFromNodes()) {
                this.finishNode(fromNode);
                this.finishPredecessorNodes(fromNode);
            }
        }
    }

    public static enum NodeState {
        FINISHED(Color.GRAY),
        EXECUTING(Color.GREEN),
        FAILED(Color.RED),
        DEFAULT(NodeGUI.DEFAULT_BODY_COLOR);

        public final Color color;

        private NodeState(Color color) {
            this.color = color;
        }
    }
}

