/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.xbaya.ui.menues;

import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import javax.swing.AbstractAction;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import org.apache.airavata.xbaya.XBayaConfiguration;
import org.apache.airavata.xbaya.XBayaEngine;
import org.apache.airavata.xbaya.core.generators.BPELFiler;
import org.apache.airavata.xbaya.core.generators.ImageFiler;
import org.apache.airavata.xbaya.core.generators.JythonFiler;
import org.apache.airavata.xbaya.core.generators.ODEScriptFiler;
import org.apache.airavata.xbaya.core.generators.WorkflowFiler;
import org.apache.airavata.xbaya.core.ide.XBayaExecutionModeListener;
import org.apache.airavata.xbaya.registry.RegistryAccesser;
import org.apache.airavata.xbaya.ui.dialogs.component.URLRegistryWindow;
import org.apache.airavata.xbaya.ui.dialogs.descriptors.ApplicationDescriptionDialog;
import org.apache.airavata.xbaya.ui.dialogs.descriptors.DeploymentDescriptionDialog;
import org.apache.airavata.xbaya.ui.dialogs.descriptors.HostDescriptionDialog;
import org.apache.airavata.xbaya.ui.experiment.RegistryLoaderWindow;
import org.apache.airavata.xbaya.ui.graph.GraphCanvas;
import org.apache.airavata.xbaya.ui.menues.MenuIcons;
import org.apache.airavata.xbaya.ui.widgets.ToolbarButton;
import org.apache.airavata.xbaya.ui.widgets.XBayaToolBar;
import org.apache.airavata.xbaya.util.XBayaUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XBayaMenuItem
implements XBayaExecutionModeListener {
    private static final Logger logger = LoggerFactory.getLogger(XBayaMenuItem.class);
    private JMenu xbayaMenuItem;
    private WorkflowFiler graphFiler;
    private JythonFiler jythonFiler;
    private ImageFiler imageFiler;
    private BPELFiler bpelFiler;
    private JMenuItem urlItem;
    private JMenuItem openWorkflowItem;
    private JMenuItem saveWorkflowItem;
    private JMenuItem exportJythonItem;
    private JMenuItem exportBpelItem;
    private JMenuItem saveImageItem;
    private JMenuItem importWorkflowItemFromFileSystem;
    private JMenuItem exportODEScriptsItem;
    private JMenuItem clearWorkflowItem;
    private JMenuItem newWorkflowTabItem;
    private JMenuItem closeWorkflowItem;
    private JMenuItem nextWorkflowTabItem;
    private JMenuItem exitItem;
    private XBayaEngine engine;
    private JMenuItem registerServiceDesc;
    private JMenuItem registerApplicationDesc;
    private JMenuItem registerHostDesc;
    private JMenuItem closeAllWorkflowItem;
    private JMenuItem saveAsWorkflowItem;
    private JMenuItem saveAllWorkflowItem;
    private JMenuItem saveWorkflowtoRegistryItem;
    private JMenuItem importWorkflowItemFromRegistry;
    private RegistryAccesser registryAccesser;
    private XBayaToolBar toolBar;
    private ToolbarButton toolbarButtonSave;
    private ToolbarButton toolbarButtonOpen;
    private ToolbarButton toolbarButtonNew;
    private static final String FILE_ACTIONS = "file";

    public XBayaMenuItem(XBayaEngine engine, XBayaToolBar toolBar) {
        this.engine = engine;
        this.toolBar = toolBar;
        this.registryAccesser = new RegistryAccesser(engine);
        this.graphFiler = new WorkflowFiler(engine);
        this.jythonFiler = new JythonFiler(engine);
        this.imageFiler = new ImageFiler(engine);
        this.bpelFiler = new BPELFiler(engine);
        this.exitItem = this.createExitItem();
        this.createFileMenu();
        engine.getConfiguration().registerExecutionModeChangeListener(this);
        XBayaToolBar.setGroupOrder(FILE_ACTIONS, 1);
    }

    private void createFileMenu() {
        this.createOpenWorkflowMenuItem();
        this.createSaveWorkflowItem();
        this.createSaveAsWorkflowItem();
        this.createSaveAllWorkflowItem();
        this.createSaveWorkflowtoRegistryItem();
        this.createImportWorkflowItemFromFileSystem();
        this.createImportWorkflowItemFromRegistry();
        this.createExportJythonScriptItem();
        this.createExportBpelScriptItem();
        this.createSaveWorkflowImageItem();
        this.createExportODEScriptsItem();
        this.clearWorkflowItem = this.createClearWorkflowItem();
        this.newWorkflowTabItem = this.createNewWorkflowTabMenuItem();
        this.closeWorkflowItem = this.createCloseWorkflowTabItem();
        this.closeAllWorkflowItem = this.createCloseAllWorkflowTabItem();
        this.nextWorkflowTabItem = this.createNextWorkflowTabItem();
        this.urlItem = this.createURLRegistryItem();
        this.createRegisterHostDesc();
        this.createRegisterServiceDesc();
        this.createRegisterApplicationDesc();
        this.xbayaMenuItem = new JMenu("XBaya");
        this.xbayaMenuItem.setMnemonic(88);
        this.xbayaMenuItem.add(this.newWorkflowTabItem);
        this.xbayaMenuItem.add(this.registerHostDesc);
        this.xbayaMenuItem.add(this.registerServiceDesc);
        this.xbayaMenuItem.add(this.openWorkflowItem);
        this.xbayaMenuItem.addSeparator();
        this.xbayaMenuItem.add(this.clearWorkflowItem);
        this.xbayaMenuItem.add(this.closeWorkflowItem);
        this.xbayaMenuItem.add(this.closeAllWorkflowItem);
        this.xbayaMenuItem.addSeparator();
        this.xbayaMenuItem.add(this.saveWorkflowItem);
        this.xbayaMenuItem.add(this.saveAsWorkflowItem);
        this.xbayaMenuItem.add(this.saveAllWorkflowItem);
        this.xbayaMenuItem.addSeparator();
        JMenu importMenu = new JMenu("Import");
        importMenu.add(this.importWorkflowItemFromFileSystem);
        importMenu.add(this.importWorkflowItemFromRegistry);
        importMenu.addSeparator();
        importMenu.add(this.urlItem);
        JMenu exportMenu = new JMenu("Export");
        exportMenu.add(this.saveWorkflowtoRegistryItem);
        exportMenu.addSeparator();
        exportMenu.add(this.exportJythonItem);
        exportMenu.add(this.exportBpelItem);
        exportMenu.add(this.exportODEScriptsItem);
        exportMenu.addSeparator();
        exportMenu.add(this.saveImageItem);
        this.xbayaMenuItem.add(importMenu);
        this.xbayaMenuItem.add(exportMenu);
        this.xbayaMenuItem.addSeparator();
        this.xbayaMenuItem.add(this.exitItem);
        this.xbayaMenuItem.addMenuListener(new MenuListener(){

            @Override
            public void menuSelected(MenuEvent e) {
                GraphCanvas graphCanvas = XBayaMenuItem.this.engine.getGUI().getGraphCanvas();
                XBayaMenuItem.this.saveAsWorkflowItem.setEnabled(XBayaMenuItem.this.isWorkflowTabPresent() && graphCanvas.getWorkflowFile() != null);
                XBayaMenuItem.this.saveWorkflowItem.setEnabled(XBayaMenuItem.this.isSaveShouldBeActive());
                XBayaMenuItem.this.saveAllWorkflowItem.setEnabled(XBayaMenuItem.this.engine.getGUI().getGraphCanvases().size() > 0);
                XBayaMenuItem.this.saveWorkflowtoRegistryItem.setEnabled(XBayaMenuItem.this.isWorkflowTabPresent());
                XBayaMenuItem.this.exportJythonItem.setEnabled(XBayaMenuItem.this.isWorkflowTabPresent());
                XBayaMenuItem.this.exportBpelItem.setEnabled(XBayaMenuItem.this.isWorkflowTabPresent());
                XBayaMenuItem.this.exportODEScriptsItem.setEnabled(XBayaMenuItem.this.isWorkflowTabPresent());
                XBayaMenuItem.this.saveImageItem.setEnabled(XBayaMenuItem.this.isWorkflowTabPresent());
            }

            @Override
            public void menuDeselected(MenuEvent e) {
            }

            @Override
            public void menuCanceled(MenuEvent e) {
            }
        });
        this.executionModeChanged(this.engine.getConfiguration());
    }

    public JMenu getMenu() {
        return this.xbayaMenuItem;
    }

    private void createSaveWorkflowtoRegistryItem() {
        this.saveWorkflowtoRegistryItem = new JMenuItem("Workflow To Registry...");
        this.saveWorkflowtoRegistryItem.setMnemonic(67);
        this.saveWorkflowtoRegistryItem.addActionListener(new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                if (XBayaMenuItem.this.registryAccesser.saveWorkflow() && XBayaMenuItem.this.engine.getGUI().getGraphCanvas().getWorkflowFile() == null) {
                    XBayaMenuItem.this.engine.getGUI().getGraphCanvas().workflowSaved();
                }
            }
        });
    }

    private JMenuItem createURLRegistryItem() {
        JMenuItem item = new JMenuItem("WSDL From URL...");
        item.setMnemonic(85);
        item.addActionListener(new AbstractAction(){
            private static final long serialVersionUID = 1L;
            private URLRegistryWindow window;

            @Override
            public void actionPerformed(ActionEvent e) {
                if (this.window == null) {
                    this.window = new URLRegistryWindow(XBayaMenuItem.this.engine);
                }
                this.window.show();
            }
        });
        return item;
    }

    private void createRegisterServiceDesc() {
        this.registerServiceDesc = new JMenuItem("Register Application...");
        this.registerServiceDesc.addActionListener(new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                if (XBayaUtil.acquireJCRRegistry(XBayaMenuItem.this.engine)) {
                    try {
                        DeploymentDescriptionDialog serviceDescriptionDialog = new DeploymentDescriptionDialog(XBayaMenuItem.this.engine.getGUI().getFrame(), XBayaMenuItem.this.engine.getConfiguration().getAiravataAPI());
                        serviceDescriptionDialog.open();
                    }
                    catch (Exception e1) {
                        XBayaMenuItem.this.engine.getGUI().getErrorWindow().error(e1);
                    }
                }
            }
        });
    }

    private void createRegisterApplicationDesc() {
        this.registerApplicationDesc = new JMenuItem("Register Application...");
        this.registerApplicationDesc.addActionListener(new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                if (XBayaUtil.acquireJCRRegistry(XBayaMenuItem.this.engine)) {
                    try {
                        ApplicationDescriptionDialog applicationDescriptionDialog = new ApplicationDescriptionDialog(XBayaMenuItem.this.engine);
                        applicationDescriptionDialog.setLocationRelativeTo(XBayaMenuItem.this.engine.getGUI().getFrame());
                        applicationDescriptionDialog.open();
                    }
                    catch (Exception e1) {
                        XBayaMenuItem.this.engine.getGUI().getErrorWindow().error(e1);
                    }
                }
            }
        });
    }

    private void createRegisterHostDesc() {
        this.registerHostDesc = new JMenuItem("Add Host...");
        this.registerHostDesc.addActionListener(new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                if (XBayaUtil.acquireJCRRegistry(XBayaMenuItem.this.engine)) {
                    try {
                        HostDescriptionDialog hostDescriptionDialog = new HostDescriptionDialog(XBayaMenuItem.this.engine.getConfiguration().getAiravataAPI(), XBayaMenuItem.this.engine.getGUI().getFrame());
                        hostDescriptionDialog.open();
                    }
                    catch (Exception e1) {
                        XBayaMenuItem.this.engine.getGUI().getErrorWindow().error(e1);
                    }
                }
            }
        });
    }

    private JMenuItem createClearWorkflowItem() {
        JMenuItem menuItem = new JMenuItem("Clear Workflow");
        menuItem.addActionListener(new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                XBayaMenuItem.this.engine.getGUI().getGraphCanvas().newWorkflow();
            }
        });
        return menuItem;
    }

    private JMenuItem createNewWorkflowTabMenuItem() {
        JMenuItem menuItem = new JMenuItem("New Workflow", MenuIcons.NEW_ICON);
        menuItem.setAccelerator(KeyStroke.getKeyStroke(78, 2));
        AbstractAction action = new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                XBayaMenuItem.this.engine.getGUI().newGraphCanvas(true, true);
            }
        };
        menuItem.addActionListener(action);
        this.toolbarButtonNew = this.getToolBar().addToolbarButton(FILE_ACTIONS, menuItem.getText(), MenuIcons.NEW_ICON, "Create new workflow", action, 1);
        return menuItem;
    }

    private JMenuItem createCloseWorkflowTabItem() {
        JMenuItem menuItem = new JMenuItem("Close Tab");
        menuItem.setMnemonic(67);
        menuItem.setAccelerator(KeyStroke.getKeyStroke(115, 2));
        menuItem.addActionListener(new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                XBayaMenuItem.this.engine.getGUI().closeGraphCanvas();
            }
        });
        return menuItem;
    }

    private JMenuItem createCloseAllWorkflowTabItem() {
        JMenuItem menuItem = new JMenuItem("Close All Tabs");
        menuItem.addActionListener(new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                XBayaMenuItem.this.engine.getGUI().closeAllGraphCanvas();
            }
        });
        return menuItem;
    }

    private JMenuItem createNextWorkflowTabItem() {
        JMenuItem menuItem = new JMenuItem("Select Next Workflow Tab");
        menuItem.setMnemonic(83);
        menuItem.setAccelerator(KeyStroke.getKeyStroke(117, 2));
        menuItem.addActionListener(new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                XBayaMenuItem.this.engine.getGUI().selectNextGraphCanvas();
            }
        });
        return menuItem;
    }

    private void createOpenWorkflowMenuItem() {
        this.openWorkflowItem = new JMenuItem("Open Workflow...", MenuIcons.OPEN_ICON);
        this.openWorkflowItem.setMnemonic(79);
        this.openWorkflowItem.setAccelerator(KeyStroke.getKeyStroke(79, 2));
        AbstractAction action = new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent event) {
                XBayaMenuItem.this.graphFiler.openWorkflow();
            }
        };
        this.openWorkflowItem.addActionListener(action);
        this.toolbarButtonOpen = this.getToolBar().addToolbarButton(FILE_ACTIONS, this.openWorkflowItem.getText(), MenuIcons.OPEN_ICON, "Open workflow", action, 2);
    }

    private void createSaveWorkflowItem() {
        this.saveWorkflowItem = new JMenuItem("Save", MenuIcons.SAVE_ICON);
        this.saveWorkflowItem.setMnemonic(83);
        this.saveWorkflowItem.setAccelerator(KeyStroke.getKeyStroke(83, 2));
        AbstractAction action = new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                XBayaMenuItem.this.graphFiler.saveWorkflow();
                XBayaMenuItem.this.toolbarButtonSave.setEnabled(XBayaMenuItem.this.isSaveShouldBeActive());
            }
        };
        this.saveWorkflowItem.addActionListener(action);
        this.toolbarButtonSave = this.getToolBar().addToolbarButton(FILE_ACTIONS, this.saveWorkflowItem.getText(), MenuIcons.SAVE_ICON, "Save workflow", action, 3);
        this.toolbarButtonSave.setEnabled(false);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                while (XBayaMenuItem.this.engine.getGUI() == null) {
                    Thread.yield();
                }
                XBayaMenuItem.this.engine.getGUI().addWorkflowTabChangeListener(new ChangeListener(){

                    @Override
                    public void stateChanged(ChangeEvent event) {
                        XBayaMenuItem.this.toolbarButtonSave.setEnabled(XBayaMenuItem.this.isSaveShouldBeActive());
                    }
                });
            }
        });
    }

    private void createSaveAsWorkflowItem() {
        this.saveAsWorkflowItem = new JMenuItem("Save as...");
        this.saveAsWorkflowItem.addActionListener(new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                XBayaMenuItem.this.graphFiler.saveAsWorkflow();
            }
        });
    }

    private void createSaveAllWorkflowItem() {
        this.saveAllWorkflowItem = new JMenuItem("Save all");
        this.saveAllWorkflowItem.addActionListener(new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                XBayaMenuItem.this.graphFiler.saveAllWorkflows();
            }
        });
        this.saveAllWorkflowItem.setEnabled(false);
    }

    private void createImportWorkflowItemFromFileSystem() {
        this.importWorkflowItemFromFileSystem = new JMenuItem("Workflow From File System...");
        this.importWorkflowItemFromFileSystem.addActionListener(new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                XBayaMenuItem.this.graphFiler.importWorkflow();
            }
        });
    }

    private void createImportWorkflowItemFromRegistry() {
        this.importWorkflowItemFromRegistry = new JMenuItem("Workflow From Registry...");
        this.importWorkflowItemFromRegistry.addActionListener(new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                new RegistryLoaderWindow(XBayaMenuItem.this.engine).show();
            }
        });
    }

    private void createExportJythonScriptItem() {
        this.exportJythonItem = new JMenuItem("Workflow To Jython Script...");
        this.exportJythonItem.setMnemonic(74);
        this.exportJythonItem.addActionListener(new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                XBayaMenuItem.this.jythonFiler.exportJythonScript();
            }
        });
    }

    private void createExportBpelScriptItem() {
        this.exportBpelItem = new JMenuItem("Workflow To BPEL2 Script...");
        this.exportBpelItem.setMnemonic(66);
        this.exportBpelItem.addActionListener(new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                XBayaMenuItem.this.bpelFiler.exportBPEL();
            }
        });
    }

    private void createSaveWorkflowImageItem() {
        this.saveImageItem = new JMenuItem("Workflow To Image...");
        this.saveImageItem.setMnemonic(73);
        this.saveImageItem.addActionListener(new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                XBayaMenuItem.this.imageFiler.saveWorkflowImage();
            }
        });
    }

    private void createExportODEScriptsItem() {
        this.exportODEScriptsItem = new JMenuItem("Workflow To ODE Scripts...");
        this.exportODEScriptsItem.addActionListener(new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                new ODEScriptFiler(XBayaMenuItem.this.engine).save();
            }
        });
    }

    private JMenuItem createExitItem() {
        JMenuItem menuItem = new JMenuItem("Exit");
        menuItem.setMnemonic(88);
        menuItem.setAccelerator(KeyStroke.getKeyStroke(81, 2));
        menuItem.addActionListener(new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent event) {
                JFrame frame = XBayaMenuItem.this.engine.getGUI().getFrame();
                frame.dispatchEvent(new WindowEvent(frame, 201));
            }
        });
        return menuItem;
    }

    public XBayaToolBar getToolBar() {
        return this.toolBar;
    }

    public void setToolBar(XBayaToolBar toolBar) {
        this.toolBar = toolBar;
    }

    private boolean isSaveShouldBeActive() {
        GraphCanvas graphCanvas = this.engine.getGUI().getGraphCanvas();
        return this.isWorkflowTabPresent() && (graphCanvas.getWorkflowFile() == null || graphCanvas.isWorkflowChanged());
    }

    private boolean isWorkflowTabPresent() {
        return this.engine.getGUI().getGraphCanvas() != null;
    }

    @Override
    public void executionModeChanged(XBayaConfiguration config) {
        this.toolbarButtonNew.setVisible(config.getXbayaExecutionMode() == XBayaConfiguration.XBayaExecutionMode.IDE);
        this.toolbarButtonSave.setVisible(config.getXbayaExecutionMode() == XBayaConfiguration.XBayaExecutionMode.IDE);
        this.toolbarButtonOpen.setVisible(config.getXbayaExecutionMode() == XBayaConfiguration.XBayaExecutionMode.IDE);
    }
}

