/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.xbaya.ui.menues;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import org.apache.airavata.xbaya.XBayaConfiguration;
import org.apache.airavata.xbaya.XBayaEngine;
import org.apache.airavata.xbaya.core.ide.XBayaExecutionModeListener;
import org.apache.airavata.xbaya.menues.tools.ToolsMenuItem;
import org.apache.airavata.xbaya.ui.XBayaGUI;
import org.apache.airavata.xbaya.ui.dialogs.AboutWindow;
import org.apache.airavata.xbaya.ui.menues.AmazonEC2MenuItem;
import org.apache.airavata.xbaya.ui.menues.EditMenuItem;
import org.apache.airavata.xbaya.ui.menues.RegistryMenuItem;
import org.apache.airavata.xbaya.ui.menues.RunMenuItem;
import org.apache.airavata.xbaya.ui.menues.ViewMenuItem;
import org.apache.airavata.xbaya.ui.menues.XBayaMenuItem;
import org.apache.airavata.xbaya.ui.widgets.XBayaComponent;
import org.apache.airavata.xbaya.ui.widgets.XBayaToolBar;

public class XBayaMenu
implements XBayaComponent,
XBayaExecutionModeListener {
    private XBayaEngine engine;
    private JMenuBar menuBar;
    private XBayaMenuItem xBayaMenuItem;
    private EditMenuItem editMenuItem;
    private ViewMenuItem viewMenuItem;
    private RunMenuItem runMenuItem;
    private RegistryMenuItem registryMenuItem;
    private AmazonEC2MenuItem amazonEC2MenuItem;
    private ToolsMenuItem toolsMenuItem;
    private XBayaGUI gui;
    private XBayaToolBar toolBar;

    public XBayaMenu(XBayaEngine engine, XBayaToolBar toolBar) {
        this.setEngine(engine);
        this.setToolBar(toolBar);
        this.initMenu();
        engine.getConfiguration().registerExecutionModeChangeListener(this);
    }

    private void initMenu() {
        this.xBayaMenuItem = new XBayaMenuItem(this.getEngine(), this.getToolBar());
        this.editMenuItem = new EditMenuItem(this.getEngine());
        this.amazonEC2MenuItem = new AmazonEC2MenuItem(this.getEngine());
        this.viewMenuItem = new ViewMenuItem(this.getEngine());
        this.runMenuItem = new RunMenuItem(this.getEngine(), this.getToolBar());
        this.registryMenuItem = new RegistryMenuItem(this.getEngine(), this.getToolBar());
        this.toolsMenuItem = new ToolsMenuItem(this.getEngine());
        this.createMenuBar();
        this.executionModeChanged(this.getEngine().getConfiguration());
    }

    @Override
    public JMenuBar getSwingComponent() {
        return this.menuBar;
    }

    private void createMenuBar() {
        this.menuBar = new JMenuBar();
        this.menuBar.add(this.xBayaMenuItem.getMenu());
        this.menuBar.add(this.editMenuItem.getMenu());
        this.menuBar.add(this.viewMenuItem.getMenu());
        this.menuBar.add(this.runMenuItem.getMenu());
        this.menuBar.add(this.toolsMenuItem.getMenu());
        this.menuBar.add(this.registryMenuItem.getMenu());
        this.menuBar.add(this.amazonEC2MenuItem.getMenu());
        this.menuBar.add(Box.createHorizontalGlue());
        this.menuBar.add(this.createHelpMenu());
    }

    private JMenu createHelpMenu() {
        JMenu helpMenu = new JMenu("Help");
        helpMenu.setMnemonic(72);
        JMenuItem aboutItem = new JMenuItem("About XBaya");
        aboutItem.setMnemonic(65);
        aboutItem.addActionListener(new AbstractAction(){
            private AboutWindow window;

            @Override
            public void actionPerformed(ActionEvent event) {
                if (this.window == null) {
                    this.window = new AboutWindow(XBayaMenu.this.getEngine());
                }
                this.window.show();
            }
        });
        helpMenu.add(aboutItem);
        return helpMenu;
    }

    public XBayaEngine getEngine() {
        return this.engine;
    }

    public void setEngine(XBayaEngine engine) {
        this.engine = engine;
    }

    public XBayaToolBar getToolBar() {
        return this.toolBar;
    }

    public void setToolBar(XBayaToolBar toolBar) {
        this.toolBar = toolBar;
    }

    @Override
    public void executionModeChanged(XBayaConfiguration config) {
        this.menuBar.setVisible(config.getXbayaExecutionMode() == XBayaConfiguration.XBayaExecutionMode.IDE);
    }
}

