/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.xbaya.ui.menues;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import org.apache.airavata.xbaya.XBayaEngine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ViewMenuItem {
    private XBayaEngine engine;
    private JMenu viewMenu;
    private JMenuItem jcrRegistryView;
    private JMenuItem componentsView;
    private JMenuItem monitoringView;
    private JMenuItem parametersView;
    private static final Logger logger = LoggerFactory.getLogger(ViewMenuItem.class);

    public ViewMenuItem(XBayaEngine engine) {
        this.engine = engine;
        this.createWorkflowMenu();
    }

    public JMenu getMenu() {
        return this.viewMenu;
    }

    private void createWorkflowMenu() {
        this.jcrRegistryView = this.createShpwJCRRegistryView();
        this.componentsView = this.createShowComponentsView();
        this.monitoringView = this.createShowMonitoringView();
        this.parametersView = this.createShowParameterView();
        this.viewMenu = new JMenu("View");
        this.viewMenu.setMnemonic(86);
        this.viewMenu.add(this.jcrRegistryView);
        this.viewMenu.addSeparator();
        this.viewMenu.add(this.componentsView);
        this.viewMenu.addSeparator();
        this.viewMenu.add(this.monitoringView);
        this.viewMenu.add(this.parametersView);
    }

    private JMenuItem createShpwJCRRegistryView() {
        JMenuItem menuItem = new JMenuItem("Airavata Registry");
        menuItem.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ViewMenuItem.this.engine.getGUI().viewJCRBrowserPanel();
            }
        });
        return menuItem;
    }

    private JMenuItem createShowComponentsView() {
        JMenuItem menuItem = new JMenuItem("Components");
        menuItem.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ViewMenuItem.this.engine.getGUI().viewComponentTree();
            }
        });
        return menuItem;
    }

    private JMenuItem createShowMonitoringView() {
        JMenuItem menuItem = new JMenuItem("Monitoring");
        menuItem.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
            }
        });
        menuItem.setEnabled(false);
        return menuItem;
    }

    private JMenuItem createShowParameterView() {
        JMenuItem menuItem = new JMenuItem("Parameters");
        menuItem.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
            }
        });
        menuItem.setEnabled(false);
        return menuItem;
    }
}

