/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.xbaya.ui.menues;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import org.apache.airavata.workflow.model.exceptions.WorkflowRuntimeException;
import org.apache.airavata.workflow.model.wf.WorkflowExecutionState;
import org.apache.airavata.ws.monitor.Monitor;
import org.apache.airavata.ws.monitor.MonitorConfiguration;
import org.apache.airavata.ws.monitor.MonitorException;
import org.apache.airavata.ws.monitor.event.Event;
import org.apache.airavata.ws.monitor.event.EventListener;
import org.apache.airavata.xbaya.XBayaConfiguration;
import org.apache.airavata.xbaya.XBayaEngine;
import org.apache.airavata.xbaya.core.ide.XBayaExecutionModeListener;
import org.apache.airavata.xbaya.ui.dialogs.graph.dynamic.DynamicWorkflowRunnerWindow;
import org.apache.airavata.xbaya.ui.dialogs.monitor.MonitorConfigurationWindow;
import org.apache.airavata.xbaya.ui.experiment.WorkflowInterpreterLaunchWindow;
import org.apache.airavata.xbaya.ui.menues.MenuIcons;
import org.apache.airavata.xbaya.ui.monitor.MonitorStarter;
import org.apache.airavata.xbaya.ui.widgets.ToolbarButton;
import org.apache.airavata.xbaya.ui.widgets.XBayaToolBar;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RunMenuItem
implements EventListener,
XBayaExecutionModeListener {
    private XBayaEngine engine;
    private JMenu runMenu;
    private JMenuItem launchXBayaInterpreterItem;
    private JMenuItem configMonitorItem;
    private JMenuItem resumeMonitoringItem;
    private JMenuItem pauseMonitoringItem;
    private JMenuItem resetMonitoringItem;
    private static final Logger logger = LoggerFactory.getLogger(RunMenuItem.class);
    private static final String EXECUTE_ACTIONS = "run_actions";
    private static final String EXECUTE_MONITOR_ACTIONS = "monitor_actions";
    private XBayaToolBar toolBar;
    private ToolbarButton toolbarButtonRunWorkflow;
    private ToolbarButton toolbarButtonPauseMonitor;
    private ToolbarButton toolbarButtonResumeMonitor;
    private JMenuItem stopWorkflowItem;
    private ToolbarButton toolbarButtonStopWorkflow;

    public RunMenuItem(XBayaEngine engine, XBayaToolBar toolBar) {
        this.engine = engine;
        this.setToolBar(toolBar);
        this.createWorkflowMenu();
        Monitor monitor = this.engine.getMonitor();
        monitor.addEventListener((EventListener)this);
        monitor.getConfiguration().addEventListener((EventListener)this);
        engine.getConfiguration().registerExecutionModeChangeListener(this);
        XBayaToolBar.setGroupOrder(EXECUTE_ACTIONS, 5);
        XBayaToolBar.setGroupOrder(EXECUTE_MONITOR_ACTIONS, 6);
    }

    public JMenu getMenu() {
        return this.runMenu;
    }

    private void createWorkflowMenu() {
        this.createLaunchXBayaInterpreterItem();
        this.configMonitorItem = this.createConfigMonitoring();
        this.resumeMonitoringItem = this.createResumeMonitoring();
        this.pauseMonitoringItem = this.createPauseMonitoring();
        this.resetMonitoringItem = this.createResetMonitoring();
        this.stopWorkflowItem = this.createStopWorkflow();
        this.runMenu = new JMenu("Run");
        this.runMenu.setMnemonic(82);
        this.runMenu.add(this.launchXBayaInterpreterItem);
        this.runMenu.addSeparator();
        this.runMenu.add(this.stopWorkflowItem);
        this.runMenu.addSeparator();
        this.runMenu.add(this.resumeMonitoringItem);
        this.runMenu.add(this.pauseMonitoringItem);
        this.runMenu.add(this.resetMonitoringItem);
        this.runMenu.add(this.configMonitorItem);
        this.runMenu.addMenuListener(new MenuListener(){

            @Override
            public void menuCanceled(MenuEvent e) {
            }

            @Override
            public void menuDeselected(MenuEvent e) {
            }

            @Override
            public void menuSelected(MenuEvent e) {
                RunMenuItem.this.stopWorkflowItem.setEnabled(RunMenuItem.this.isWorkflowRunning());
            }
        });
        this.setupMonitors();
        this.startStopButtonStateUpdater();
        this.executionModeChanged(this.engine.getConfiguration());
    }

    private void setupMonitors() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                while (RunMenuItem.this.engine.getGUI() == null) {
                    Thread.yield();
                }
                RunMenuItem.this.engine.getGUI().addWorkflowTabChangeListener(new ChangeListener(){

                    @Override
                    public void stateChanged(ChangeEvent event) {
                        boolean runShouldBeActive = RunMenuItem.this.isRunShouldBeActive();
                        RunMenuItem.this.toolbarButtonRunWorkflow.setEnabled(runShouldBeActive);
                        RunMenuItem.this.launchXBayaInterpreterItem.setEnabled(runShouldBeActive);
                    }
                });
            }
        });
    }

    private JMenuItem createConfigMonitoring() {
        JMenuItem item = new JMenuItem("Configure Monitoring...");
        item.setMnemonic(67);
        item.addActionListener(new AbstractAction(){
            private MonitorConfigurationWindow window;

            @Override
            public void actionPerformed(ActionEvent e) {
                if (this.window == null) {
                    this.window = new MonitorConfigurationWindow(RunMenuItem.this.engine);
                }
                this.window.show();
            }
        });
        return item;
    }

    private JMenuItem createResumeMonitoring() {
        JMenuItem item = new JMenuItem("Resume monitoring", MenuIcons.MONITOR_RESUME_ICON);
        item.setMnemonic(83);
        AbstractAction action = new AbstractAction(){
            private MonitorStarter starter;

            @Override
            public void actionPerformed(ActionEvent event) {
                if (this.starter == null) {
                    this.starter = new MonitorStarter(RunMenuItem.this.engine);
                }
                this.starter.start();
            }
        };
        item.addActionListener(action);
        boolean valid = this.engine.getMonitor().getConfiguration().isValid();
        item.setVisible(valid);
        this.toolbarButtonResumeMonitor = this.getToolBar().addToolbarButton(EXECUTE_MONITOR_ACTIONS, item.getText(), MenuIcons.MONITOR_RESUME_ICON, "Resume monitoring", action, 4);
        this.toolbarButtonResumeMonitor.setEnabled(false);
        return item;
    }

    private JMenuItem createPauseMonitoring() {
        JMenuItem item = new JMenuItem("Pause monitoring", MenuIcons.MONITOR_PAUSE_ICON);
        item.setMnemonic(84);
        AbstractAction action = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent event) {
                try {
                    RunMenuItem.this.engine.getMonitor().stopMonitoring();
                }
                catch (RuntimeException e) {
                    RunMenuItem.this.engine.getGUI().getErrorWindow().error("Monitor error.", e);
                }
                catch (Error e) {
                    RunMenuItem.this.engine.getGUI().getErrorWindow().error("Unexpected error.", e);
                }
            }
        };
        item.addActionListener(action);
        item.setVisible(false);
        this.toolbarButtonPauseMonitor = this.getToolBar().addToolbarButton(EXECUTE_MONITOR_ACTIONS, item.getText(), MenuIcons.MONITOR_PAUSE_ICON, "Pause monitoring", action, 3);
        this.toolbarButtonPauseMonitor.setEnabled(false);
        return item;
    }

    private JMenuItem createResetMonitoring() {
        JMenuItem item = new JMenuItem("Reset monitoring");
        item.setMnemonic(82);
        item.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent event) {
                RunMenuItem.this.engine.getMonitor().resetEventData();
            }
        });
        item.setVisible(false);
        return item;
    }

    private JMenuItem createStopWorkflow() {
        JMenuItem item = new JMenuItem("Stop running workflow", MenuIcons.STOP_ICON);
        item.setMnemonic(83);
        AbstractAction action = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent event) {
                RunMenuItem.this.cleanup();
            }
        };
        item.addActionListener(action);
        item.setEnabled(false);
        this.toolbarButtonStopWorkflow = this.getToolBar().addToolbarButton(EXECUTE_ACTIONS, item.getText(), MenuIcons.STOP_ICON, "Stop workflow", action, 2);
        this.toolbarButtonStopWorkflow.setEnabled(item.isEnabled());
        return item;
    }

    private JMenuItem createLaunchDynamicWorkflowItem() {
        JMenuItem menuItem = new JMenuItem("Run workflow...");
        menuItem.setMnemonic(68);
        AbstractAction action = new AbstractAction(){
            private DynamicWorkflowRunnerWindow window;

            @Override
            public void actionPerformed(ActionEvent event) {
                if (RunMenuItem.this.isWorkflowRunning()) {
                    if (JOptionPane.showConfirmDialog(null, "A previous workflow excution data needs to be cleared before launching another workflow. Do you wish to continue?", "Run Dynamic Workflow", 0) == 0) {
                        RunMenuItem.this.cleanup();
                    } else {
                        return;
                    }
                }
                if (this.window == null) {
                    int count = 0;
                    while (RunMenuItem.this.engine.getGUI().getWorkflow().getExecutionState() != WorkflowExecutionState.NONE) {
                        try {
                            Thread.sleep(500L);
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                        if (++count <= 20) continue;
                        throw new WorkflowRuntimeException("Error stopping previous workflow Execution");
                    }
                }
                this.window = new DynamicWorkflowRunnerWindow(RunMenuItem.this.engine);
                this.window.show();
            }
        };
        menuItem.addActionListener(action);
        menuItem.setEnabled(false);
        return menuItem;
    }

    private boolean isRunShouldBeActive() {
        return this.engine.getGUI().getGraphCanvas() != null;
    }

    private void createLaunchXBayaInterpreterItem() {
        this.launchXBayaInterpreterItem = new JMenuItem("Run on Interpreter Server...", MenuIcons.RUN_ICON);
        AbstractAction action = new AbstractAction(){
            private WorkflowInterpreterLaunchWindow window;

            @Override
            public void actionPerformed(ActionEvent e) {
                if (RunMenuItem.this.engine.getMonitor().isMonitoring() && JOptionPane.showConfirmDialog(null, "A previous workflow execution data needs to be cleared before launching another workflow. Do you wish to continue?", "Run Workflow", 0) != 0) {
                    return;
                }
                this.window = new WorkflowInterpreterLaunchWindow(RunMenuItem.this.engine);
                try {
                    this.window.show();
                }
                catch (Exception e1) {
                    RunMenuItem.this.engine.getGUI().getErrorWindow().error(e1);
                }
            }
        };
        this.launchXBayaInterpreterItem.addActionListener(action);
        this.toolbarButtonRunWorkflow = this.getToolBar().addToolbarButton(EXECUTE_ACTIONS, this.launchXBayaInterpreterItem.getText(), MenuIcons.RUN_ICON, "Run workflow", action, 1);
        this.toolbarButtonRunWorkflow.setEnabled(this.launchXBayaInterpreterItem.isEnabled());
        this.launchXBayaInterpreterItem.setEnabled(false);
    }

    public void eventReceived(Event event) {
        Event.Type type = event.getType();
        if (type.equals((Object)Event.Type.MONITOR_CONFIGURATION_CHANGED)) {
            MonitorConfiguration configuration = this.engine.getMonitor().getConfiguration();
            boolean valid = configuration.isValid();
            this.resumeMonitoringItem.setVisible(valid);
            this.pauseMonitoringItem.setVisible(false);
            this.resetMonitoringItem.setVisible(false);
        } else if (type.equals((Object)Event.Type.MONITOR_STARTED)) {
            this.resumeMonitoringItem.setVisible(false);
            this.pauseMonitoringItem.setVisible(true);
            this.resetMonitoringItem.setVisible(true);
        } else if (type.equals((Object)Event.Type.MONITOR_STOPED)) {
            this.resumeMonitoringItem.setVisible(true);
            this.pauseMonitoringItem.setVisible(false);
            this.resetMonitoringItem.setVisible(false);
        }
        this.toolbarButtonPauseMonitor.setEnabled(this.pauseMonitoringItem.isVisible());
        this.toolbarButtonResumeMonitor.setEnabled(this.resumeMonitoringItem.isVisible());
    }

    public XBayaToolBar getToolBar() {
        return this.toolBar;
    }

    public void setToolBar(XBayaToolBar toolBar) {
        this.toolBar = toolBar;
    }

    private void cleanup() {
        try {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            this.engine.getWorkflowInterpreter().cleanup();
        }
        catch (MonitorException e) {
            this.engine.getGUI().getErrorWindow().error(e);
        }
    }

    private boolean isWorkflowRunning() {
        return this.engine.getWorkflowInterpreter() != null;
    }

    @Override
    public void executionModeChanged(XBayaConfiguration config) {
        this.toolbarButtonRunWorkflow.setVisible(config.getXbayaExecutionMode() == XBayaConfiguration.XBayaExecutionMode.IDE);
        this.toolbarButtonStopWorkflow.setVisible(config.getXbayaExecutionMode() == XBayaConfiguration.XBayaExecutionMode.IDE);
    }

    private void startStopButtonStateUpdater() {
        Thread t = new Thread(){

            @Override
            public void run() {
                while (true) {
                    RunMenuItem.this.toolbarButtonStopWorkflow.setEnabled(RunMenuItem.this.isWorkflowRunning());
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {
                    }
                }
            }
        };
        t.start();
    }
}

