/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.xbaya.ui.menues;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import org.apache.airavata.xbaya.XBayaConfiguration;
import org.apache.airavata.xbaya.XBayaEngine;
import org.apache.airavata.xbaya.core.ide.XBayaExecutionModeListener;
import org.apache.airavata.xbaya.ui.menues.MenuIcons;
import org.apache.airavata.xbaya.ui.widgets.ToolbarButton;
import org.apache.airavata.xbaya.ui.widgets.XBayaToolBar;
import org.apache.airavata.xbaya.util.XBayaUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegistryMenuItem
implements XBayaExecutionModeListener {
    private static final String REGISTRY_ACTIONS = "registry_actions";
    private XBayaEngine engine;
    private JMenu registryMenu;
    private JMenuItem jcrRegistryItem;
    private static final Logger logger = LoggerFactory.getLogger(RegistryMenuItem.class);
    private XBayaToolBar toolBar;
    private ToolbarButton toolbarButtonJCR;

    public RegistryMenuItem(XBayaEngine engine, XBayaToolBar toolBar) {
        this.engine = engine;
        this.setToolBar(toolBar);
        this.createWorkflowMenu();
        engine.getConfiguration().registerExecutionModeChangeListener(this);
    }

    public JMenu getMenu() {
        return this.registryMenu;
    }

    private void createWorkflowMenu() {
        this.jcrRegistryItem = this.createJCRRegistryItem();
        this.registryMenu = new JMenu("Registry");
        this.registryMenu.setMnemonic(71);
        this.registryMenu.add(this.jcrRegistryItem);
        this.executionModeChanged(this.engine.getConfiguration());
    }

    private JMenuItem createJCRRegistryItem() {
        JMenuItem item = new JMenuItem("Setup Airavata Registry...", MenuIcons.JCR_ICON);
        item.setMnemonic(74);
        AbstractAction action = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                XBayaEngine xbayaEngine = RegistryMenuItem.this.engine;
                XBayaUtil.updateJCRRegistryInfo(xbayaEngine);
            }
        };
        item.addActionListener(action);
        this.toolbarButtonJCR = this.getToolBar().addToolbarButton(REGISTRY_ACTIONS, item.getText(), MenuIcons.JCR_ICON, item.getText(), action, 1);
        return item;
    }

    public XBayaToolBar getToolBar() {
        return this.toolBar;
    }

    public void setToolBar(XBayaToolBar toolBar) {
        this.toolBar = toolBar;
    }

    @Override
    public void executionModeChanged(XBayaConfiguration config) {
        this.toolbarButtonJCR.setVisible(config.getXbayaExecutionMode() == XBayaConfiguration.XBayaExecutionMode.IDE);
    }
}

