/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.xbaya.ui.menues;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import org.apache.airavata.xbaya.XBayaEngine;
import org.apache.airavata.xbaya.ui.dialogs.descriptors.DescriptorEditorDialog;
import org.apache.airavata.xbaya.ui.dialogs.workflow.ParameterPropertyWindow;
import org.apache.airavata.xbaya.ui.dialogs.workflow.WorkflowPropertyWindow;
import org.apache.airavata.xbaya.util.XBayaUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EditMenuItem {
    private XBayaEngine engine;
    private JMenu editMenu;
    private JMenuItem workflowDescriptionItem;
    private JMenuItem parameterReorderingItem;
    private JMenuItem editHostDescription;
    private JMenuItem editServiceDescription;
    private JMenuItem editApplicationDescription;
    private static final Logger logger = LoggerFactory.getLogger(EditMenuItem.class);

    public EditMenuItem(XBayaEngine engine) {
        this.engine = engine;
        this.createWorkflowMenu();
    }

    public JMenu getMenu() {
        return this.editMenu;
    }

    private void createWorkflowMenu() {
        this.workflowDescriptionItem = this.createWorkflowDescriptionItem();
        this.parameterReorderingItem = this.createParameterReorderingItem();
        this.editHostDescription = this.createEditHostDescription();
        this.editServiceDescription = this.createEditServiceDescription();
        this.editApplicationDescription = this.createEditApplicationDescription();
        this.editMenu = new JMenu("Edit");
        this.editMenu.setMnemonic(69);
        this.editMenu.add(this.workflowDescriptionItem);
        this.editMenu.add(this.parameterReorderingItem);
        this.editMenu.addSeparator();
        this.editMenu.add(this.editHostDescription);
        this.editMenu.add(this.editServiceDescription);
    }

    private JMenuItem createWorkflowDescriptionItem() {
        JMenuItem menuItem = new JMenuItem("Workflow Properties...");
        menuItem.setMnemonic(87);
        menuItem.addActionListener(new AbstractAction(){
            private WorkflowPropertyWindow window;

            @Override
            public void actionPerformed(ActionEvent e) {
                if (this.window == null) {
                    this.window = EditMenuItem.this.engine.getGUI().getWorkflowPropertyWindow();
                }
                this.window.show();
            }
        });
        return menuItem;
    }

    private JMenuItem createParameterReorderingItem() {
        JMenuItem menuItem = new JMenuItem("Parameter Properties...");
        menuItem.setMnemonic(80);
        menuItem.addActionListener(new AbstractAction(){
            private ParameterPropertyWindow window;

            @Override
            public void actionPerformed(ActionEvent e) {
                if (this.window == null) {
                    this.window = new ParameterPropertyWindow(EditMenuItem.this.engine);
                }
                this.window.show();
            }
        });
        return menuItem;
    }

    private JMenuItem createEditHostDescription() {
        JMenuItem menuItem = new JMenuItem("Hosts...");
        menuItem.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (XBayaUtil.acquireJCRRegistry(EditMenuItem.this.engine)) {
                    DescriptorEditorDialog dialog = new DescriptorEditorDialog(EditMenuItem.this.engine, DescriptorEditorDialog.DescriptorType.HOST);
                    dialog.show();
                }
            }
        });
        return menuItem;
    }

    private JMenuItem createEditServiceDescription() {
        JMenuItem menuItem = new JMenuItem("Applications...");
        menuItem.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (XBayaUtil.acquireJCRRegistry(EditMenuItem.this.engine)) {
                    DescriptorEditorDialog dialog = new DescriptorEditorDialog(EditMenuItem.this.engine, DescriptorEditorDialog.DescriptorType.SERVICE);
                    dialog.show();
                }
            }
        });
        return menuItem;
    }

    private JMenuItem createEditApplicationDescription() {
        JMenuItem menuItem = new JMenuItem("Application Descriptions...");
        menuItem.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (XBayaUtil.acquireJCRRegistry(EditMenuItem.this.engine)) {
                    DescriptorEditorDialog dialog = new DescriptorEditorDialog(EditMenuItem.this.engine, DescriptorEditorDialog.DescriptorType.APPLICATION);
                    dialog.show();
                }
            }
        });
        return menuItem;
    }
}

