/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.xbaya.ui.graph.ws;

import java.awt.event.MouseEvent;
import org.apache.airavata.workflow.model.component.ComponentException;
import org.apache.airavata.workflow.model.graph.GraphException;
import org.apache.airavata.workflow.model.graph.Node;
import org.apache.airavata.workflow.model.graph.ws.WorkflowNode;
import org.apache.airavata.workflow.model.wf.Workflow;
import org.apache.airavata.xbaya.XBayaEngine;
import org.apache.airavata.xbaya.ui.graph.NodeGUI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkflowNodeGUI
extends NodeGUI {
    private static final Logger logger = LoggerFactory.getLogger(WorkflowNodeGUI.class);
    private WorkflowNode node;

    public WorkflowNodeGUI(WorkflowNode node) {
        super((Node)node);
        this.node = node;
    }

    @Override
    public void mouseClicked(MouseEvent event, XBayaEngine engine) {
        logger.debug(event.toString());
        if (event.getClickCount() >= 2) {
            this.openWorkflowTab(engine);
        }
    }

    public void openWorkflowTab(XBayaEngine engine) {
        try {
            Workflow workflow = this.node.getComponent().getWorkflow();
            engine.getGUI().selectOrCreateGraphCanvas(workflow);
        }
        catch (GraphException e) {
            engine.getGUI().getErrorWindow().error("The workflow file is in wrong format.", e);
        }
        catch (ComponentException e) {
            engine.getGUI().getErrorWindow().error("The component is in wrong format.", e);
        }
    }
}

