/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.xbaya.ui.graph.ws;

import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import org.apache.airavata.workflow.model.graph.Node;
import org.apache.airavata.workflow.model.graph.ws.WSNode;
import org.apache.airavata.ws.monitor.Monitor;
import org.apache.airavata.xbaya.XBayaEngine;
import org.apache.airavata.xbaya.ui.XBayaGUI;
import org.apache.airavata.xbaya.ui.dialogs.graph.ws.ServiceInteractionWindow;
import org.apache.airavata.xbaya.ui.dialogs.graph.ws.WSNodeWindow;
import org.apache.airavata.xbaya.ui.graph.NodeGUI;
import org.apache.airavata.xbaya.ui.monitor.MonitorEventHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WSNodeGUI
extends NodeGUI {
    private static final Logger logger = LoggerFactory.getLogger(WSNodeGUI.class);
    private WSNode node;
    private WSNodeWindow window;
    protected static final Color CONFIG_AREA_COLOR = new Color(220, 220, 220);
    protected static final String DEFAULT_CONFIG_AREA_TEXT = "Interact";
    protected static final int CONFIG_AREA_GAP_X = 20;
    protected String configurationText = "Interact";
    protected Rectangle configurationArea;
    private boolean interactiveMode;

    public WSNodeGUI(WSNode node) {
        super((Node)node);
        this.node = node;
        this.configurationArea = new Rectangle();
    }

    private void showWindow(XBayaEngine engine) {
        if (this.window == null) {
            this.window = new WSNodeWindow(engine, this.node);
        }
        this.window.show();
    }

    protected void showConfigurationDialog(XBayaGUI xbayaGUI, Monitor monitor) {
        new ServiceInteractionWindow(xbayaGUI, this.node.getID(), monitor).show();
    }

    @Override
    protected void calculatePositions(Graphics g) {
        super.calculatePositions(g);
        Point position = this.node.getPosition();
        FontMetrics fm = g.getFontMetrics();
        if (this.interactiveMode && this.isInteractable()) {
            this.configurationArea.height = fm.getHeight() + 4;
            this.configurationArea.width = 50;
            this.configurationArea.x = position.x + 20;
            this.configurationArea.y = position.y + this.headHeight + (this.dimension.height - this.headHeight - this.configurationArea.height) / 2;
        } else {
            this.configurationArea.height = 0;
            this.configurationArea.width = 0;
        }
    }

    @Override
    public void mouseClicked(MouseEvent event, XBayaEngine engine) {
        if (event.getClickCount() >= 2) {
            this.showWindow(engine);
        } else if (this.interactiveMode && this.isInteractable() && this.isInConfig(event.getPoint())) {
            this.showConfigurationDialog(engine.getGUI(), engine.getMonitor());
        }
    }

    private boolean isInteractable() {
        return this.bodyColor == MonitorEventHandler.NodeState.EXECUTING.color || this.bodyColor == MonitorEventHandler.NodeState.FAILED.color || this.bodyColor == MonitorEventHandler.NodeState.FINISHED.color;
    }

    @Override
    protected void paint(Graphics2D g) {
        super.paint(g);
        if (this.isInteractable()) {
            this.paintConfiguration(g);
        }
    }

    protected void paintConfiguration(Graphics2D g) {
        g.setColor(CONFIG_AREA_COLOR);
        g.fill(this.configurationArea);
        g.setColor(TEXT_COLOR);
        g.drawString(this.configurationText, this.configurationArea.x + 5, this.configurationArea.y + this.configurationArea.height - 2);
    }

    @Override
    protected boolean isInConfig(Point point) {
        return this.configurationArea.contains(point);
    }

    public void setInteractiveMode(boolean mode) {
        this.interactiveMode = mode;
    }
}

