/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.xbaya.ui.graph.system;

import java.awt.Color;
import org.apache.airavata.workflow.model.graph.impl.NodeImpl;
import org.apache.airavata.workflow.model.graph.system.StreamSourceNode;
import org.apache.airavata.xbaya.ui.XBayaGUI;
import org.apache.airavata.xbaya.ui.dialogs.graph.system.StreamSourceConfigurationDialog;
import org.apache.airavata.xbaya.ui.graph.system.ConfigurableNodeGUI;

public class StreamSourceNodeGUI
extends ConfigurableNodeGUI {
    private static Color HEAD_COLOR = Color.BLUE;
    private static final String CONFIG_AREA_STRING = "Config";
    private StreamSourceNode inputNode;
    private StreamSourceConfigurationDialog configurationWindow;

    public StreamSourceNodeGUI(StreamSourceNode node) {
        super((NodeImpl)node);
        this.inputNode = node;
        this.setConfigurationText(CONFIG_AREA_STRING);
        this.headColor = HEAD_COLOR;
    }

    @Override
    protected void showConfigurationDialog(XBayaGUI xbayaGUI) {
        if (this.configurationWindow == null) {
            this.configurationWindow = new StreamSourceConfigurationDialog(this.inputNode, xbayaGUI);
        }
        this.configurationWindow.show();
    }

    @Override
    protected void setSelectedFlag(boolean flag) {
        this.selected = flag;
        this.headColor = this.selected ? SELECTED_HEAD_COLOR : HEAD_COLOR;
    }
}

