/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.xbaya.ui.graph.system;

import java.awt.Color;
import org.apache.airavata.workflow.model.graph.impl.NodeImpl;
import org.apache.airavata.workflow.model.graph.system.S3InputNode;
import org.apache.airavata.xbaya.ui.XBayaGUI;
import org.apache.airavata.xbaya.ui.dialogs.graph.system.S3FileChooser;
import org.apache.airavata.xbaya.ui.graph.system.ConfigurableNodeGUI;

public class S3InputNodeGUI
extends ConfigurableNodeGUI {
    private static final String CONFIG_AREA_STRING = "Config";
    private static final Color HEAD_COLOR = new Color(153, 204, 255);
    private S3InputNode inputNode;
    private S3FileChooser s3FileChooser;

    public S3InputNodeGUI(S3InputNode node) {
        super((NodeImpl)node);
        this.inputNode = node;
        this.setConfigurationText(CONFIG_AREA_STRING);
        this.headColor = HEAD_COLOR;
    }

    @Override
    protected void showConfigurationDialog(XBayaGUI xbayaGUI) {
        if (!this.inputNode.isConnected()) {
            xbayaGUI.getErrorWindow().info("You need to connect the input to an input of a service first to configure.");
        } else {
            if (this.s3FileChooser == null) {
                this.s3FileChooser = new S3FileChooser(xbayaGUI, this.inputNode);
            }
            this.s3FileChooser.show();
        }
    }

    public S3InputNode getInputNode() {
        return this.inputNode;
    }

    @Override
    protected void setSelectedFlag(boolean flag) {
        this.selected = flag;
        this.headColor = this.selected ? SELECTED_HEAD_COLOR : HEAD_COLOR;
    }
}

