/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.xbaya.ui.graph.system;

import java.awt.Color;
import java.net.URL;
import org.apache.airavata.common.utils.BrowserLauncher;
import org.apache.airavata.workflow.model.graph.impl.NodeImpl;
import org.apache.airavata.workflow.model.graph.system.OutputNode;
import org.apache.airavata.xbaya.ui.XBayaGUI;
import org.apache.airavata.xbaya.ui.dialogs.graph.system.OutputConfigurationDialog;
import org.apache.airavata.xbaya.ui.graph.system.ConfigurableNodeGUI;

public class OutputNodeGUI
extends ConfigurableNodeGUI {
    private static final String CONFIG_AREA_STRING = "View";
    private static final Color HEAD_COLOR = new Color(35, 107, 142);
    private OutputNode outputNode;
    private OutputConfigurationDialog configurationWindow;

    public OutputNodeGUI(OutputNode node) {
        super((NodeImpl)node);
        this.outputNode = node;
        this.setConfigurationText(CONFIG_AREA_STRING);
        this.headColor = HEAD_COLOR;
    }

    @Override
    protected void showConfigurationDialog(XBayaGUI xbayaGUI) {
        String description;
        if (this.node instanceof OutputNode && null != (description = ((OutputNode)this.node).getDescription())) {
            try {
                description = description.trim();
                URL url = new URL(description);
                BrowserLauncher.openURL((URL)url);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.configurationWindow == null) {
            this.configurationWindow = new OutputConfigurationDialog(this.outputNode, xbayaGUI);
        }
        this.configurationWindow.show();
    }

    @Override
    protected void setSelectedFlag(boolean flag) {
        this.selected = flag;
        this.headColor = this.selected ? SELECTED_HEAD_COLOR : HEAD_COLOR;
    }
}

