/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.xbaya.ui.graph.system;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import javax.swing.JTextArea;
import javax.swing.border.EmptyBorder;
import org.apache.airavata.workflow.model.graph.Node;
import org.apache.airavata.workflow.model.graph.system.MemoNode;
import org.apache.airavata.xbaya.XBayaEngine;
import org.apache.airavata.xbaya.ui.dialogs.graph.system.MemoConfigurationDialog;
import org.apache.airavata.xbaya.ui.graph.NodeGUI;

public class MemoNodeGUI
extends NodeGUI {
    private static final int BORDER_SIZE = 5;
    private MemoNode node;
    private JTextArea textArea;
    private MemoConfigurationDialog window;

    public MemoNodeGUI(MemoNode node) {
        super((Node)node);
        this.node = node;
        this.textArea = new JTextArea();
        this.textArea.setBorder(new EmptyBorder(5, 5, 5, 5));
    }

    @Override
    public void mouseClicked(MouseEvent event, XBayaEngine engine) {
        if (event.getClickCount() >= 2) {
            this.showWindow(engine);
        }
    }

    @Override
    protected boolean isIn(Point point) {
        Point position = this.node.getPosition();
        Dimension preferredSize = this.textArea.getPreferredSize();
        Rectangle area = new Rectangle(position, preferredSize);
        return area.contains(point);
    }

    @Override
    protected void paint(Graphics2D g) {
        Point position = this.node.getPosition();
        this.textArea.setText(this.node.getMemo());
        Dimension preferredSize = this.textArea.getPreferredSize();
        Rectangle bounds = new Rectangle(position.x, position.y, preferredSize.width, preferredSize.height);
        this.textArea.setBounds(bounds);
        Graphics graphics = g.create(position.x, position.y, preferredSize.width, preferredSize.height);
        this.textArea.paint(graphics);
    }

    private void showWindow(XBayaEngine engine) {
        if (this.window == null) {
            this.window = new MemoConfigurationDialog(this.node, engine);
        }
        this.window.show();
    }
}

