/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.xbaya.ui.graph.system;

import java.awt.Color;
import org.apache.airavata.workflow.model.graph.impl.NodeImpl;
import org.apache.airavata.workflow.model.graph.system.InputNode;
import org.apache.airavata.xbaya.ui.XBayaGUI;
import org.apache.airavata.xbaya.ui.dialogs.graph.system.InputConfigurationDialog;
import org.apache.airavata.xbaya.ui.graph.system.ConfigurableNodeGUI;

public class InputNodeGUI
extends ConfigurableNodeGUI {
    private static final String CONFIG_AREA_STRING = "Config";
    private static final Color HEAD_COLOR = new Color(153, 204, 255);
    private InputNode inputNode;
    private InputConfigurationDialog configurationWindow;

    public InputNodeGUI(InputNode node) {
        super((NodeImpl)node);
        this.inputNode = node;
        this.setConfigurationText(CONFIG_AREA_STRING);
        this.headColor = HEAD_COLOR;
    }

    @Override
    protected void showConfigurationDialog(XBayaGUI xbayaGUI) {
        if (this.inputNode.isConnected()) {
            if (this.configurationWindow == null) {
                this.configurationWindow = new InputConfigurationDialog(this.inputNode, xbayaGUI);
            }
            this.configurationWindow.show();
        } else {
            xbayaGUI.getErrorWindow().info("You need to connect the input to an input of a service first to configure.");
        }
    }

    public InputNode getInputNode() {
        return this.inputNode;
    }

    @Override
    protected void setSelectedFlag(boolean flag) {
        this.selected = flag;
        this.headColor = this.selected ? SELECTED_HEAD_COLOR : HEAD_COLOR;
    }
}

