/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.xbaya.ui.graph.system;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.geom.GeneralPath;
import java.util.List;
import org.apache.airavata.workflow.model.graph.ControlPort;
import org.apache.airavata.workflow.model.graph.Node;
import org.apache.airavata.workflow.model.graph.Port;
import org.apache.airavata.workflow.model.graph.impl.NodeImpl;
import org.apache.airavata.workflow.model.graph.system.IfNode;
import org.apache.airavata.xbaya.graph.controller.NodeController;
import org.apache.airavata.xbaya.ui.XBayaGUI;
import org.apache.airavata.xbaya.ui.dialogs.graph.system.IfConfigurationDialog;
import org.apache.airavata.xbaya.ui.graph.PortGUI;
import org.apache.airavata.xbaya.ui.graph.system.ConfigurableNodeGUI;
import org.apache.airavata.xbaya.ui.utils.DrawUtils;

public class IfNodeGUI
extends ConfigurableNodeGUI {
    private static final String CONFIG_AREA_STRING = "Config";
    private IfNode node;
    private IfConfigurationDialog configurationWindow;
    private Polygon polygon;
    private GeneralPath generalPath;

    public IfNodeGUI(IfNode node) {
        super((NodeImpl)node);
        this.node = node;
        this.setConfigurationText(CONFIG_AREA_STRING);
        this.polygon = new Polygon();
        this.generalPath = new GeneralPath();
    }

    @Override
    protected void showConfigurationDialog(XBayaGUI xbayaGUI) {
        if (this.configurationWindow == null) {
            this.configurationWindow = new IfConfigurationDialog(this.node, xbayaGUI);
        }
        this.configurationWindow.show();
    }

    @Override
    protected void calculatePositions(Graphics g) {
        super.calculatePositions(g);
        this.calculatePositions();
        this.setPortPositions();
    }

    @Override
    protected Rectangle getBounds() {
        return this.getComponentShape().getBounds();
    }

    @Override
    protected boolean isIn(Point point) {
        return this.polygon.contains(point);
    }

    @Override
    protected Color getComponentHeaderColor() {
        return this.headColor;
    }

    @Override
    protected GeneralPath getComponentHeaderShape() {
        return DrawUtils.getRoundedShape(this.createHeadNode(this.getPosition()));
    }

    @Override
    protected String getComponentHeaderText() {
        return this.node.getName();
    }

    @Override
    protected GeneralPath getComponentShape() {
        return this.generalPath;
    }

    @Override
    protected Node getNode() {
        return this.node;
    }

    private Polygon createHeadNode(Point position) {
        Polygon head = new Polygon();
        head.addPoint(position.x, position.y + this.headHeight / 2);
        head.addPoint(position.x, position.y + this.headHeight);
        head.addPoint(position.x + this.dimension.width, position.y + this.headHeight);
        head.addPoint(position.x + this.dimension.width, position.y + this.headHeight / 2);
        head.addPoint(position.x + this.dimension.width / 2, position.y);
        return head;
    }

    @Override
    protected void setPortPositions() {
        List inputPorts = this.node.getInputPorts();
        for (int i = 0; i < inputPorts.size(); ++i) {
            Port port = (Port)inputPorts.get(i);
            Point offset = new Point(5, this.headHeight + 10 + 13 * i);
            NodeController.getGUI(port).setOffset(offset);
        }
        ControlPort controlInPort = this.node.getControlInPort();
        if (controlInPort != null) {
            Point offset = new Point(0, this.headHeight / 2);
            NodeController.getGUI((Port)controlInPort).setOffset(offset);
        }
        List controlOutPorts = this.node.getControlOutPorts();
        Port controlOutPort1 = (Port)controlOutPorts.get(0);
        Point offset = new Point(this.getBounds().width, this.headHeight / 2);
        PortGUI truePortGUI = NodeController.getGUI(controlOutPort1);
        truePortGUI.setOffset(offset);
        truePortGUI.setPortText("T");
        Port controlOutPort2 = (Port)controlOutPorts.get(1);
        offset = new Point(this.getBounds().width, this.getBounds().height - this.headHeight / 2);
        PortGUI falsePortGUI = NodeController.getGUI(controlOutPort2);
        falsePortGUI.setOffset(offset);
        falsePortGUI.setPortText("F");
    }

    private void calculatePositions() {
        this.polygon.reset();
        Point position = this.getPosition();
        this.polygon.addPoint(position.x, position.y + this.headHeight / 2);
        this.polygon.addPoint(position.x, position.y + this.dimension.height);
        this.polygon.addPoint(position.x + this.dimension.width / 2, position.y + this.dimension.height + this.headHeight / 2);
        this.polygon.addPoint(position.x + this.dimension.width, position.y + this.dimension.height);
        this.polygon.addPoint(position.x + this.dimension.width, position.y + this.headHeight / 2);
        this.polygon.addPoint(position.x + this.dimension.width / 2, position.y);
        DrawUtils.setupRoundedGeneralPath(this.polygon, this.getComponentShape());
    }
}

