/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.xbaya.ui.graph.system;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.geom.GeneralPath;
import org.apache.airavata.workflow.model.graph.ControlPort;
import org.apache.airavata.workflow.model.graph.Node;
import org.apache.airavata.workflow.model.graph.Port;
import org.apache.airavata.workflow.model.graph.impl.NodeImpl;
import org.apache.airavata.workflow.model.graph.system.ForEachNode;
import org.apache.airavata.xbaya.graph.controller.NodeController;
import org.apache.airavata.xbaya.ui.XBayaGUI;
import org.apache.airavata.xbaya.ui.dialogs.graph.system.ForEachConfigurationDialog;
import org.apache.airavata.xbaya.ui.graph.system.ConfigurableNodeGUI;
import org.apache.airavata.xbaya.ui.utils.DrawUtils;

public class ForEachNodeGUI
extends ConfigurableNodeGUI {
    private static final String CONFIG_AREA_STRING = "Config";
    private ForEachNode node;
    private ForEachConfigurationDialog configurationWindow;
    private Polygon polygon;
    private GeneralPath generalPath;

    public ForEachNodeGUI(ForEachNode node) {
        super((NodeImpl)node);
        this.node = node;
        this.setConfigurationText(CONFIG_AREA_STRING);
        this.polygon = new Polygon();
        this.generalPath = new GeneralPath();
    }

    @Override
    protected void showConfigurationDialog(XBayaGUI xbayaGUI) {
        if (this.configurationWindow == null) {
            this.configurationWindow = new ForEachConfigurationDialog(this.node, xbayaGUI);
        }
        this.configurationWindow.show();
    }

    @Override
    protected void calculatePositions(Graphics g) {
        super.calculatePositions(g);
        this.calculatePositions();
        this.setPortPositions();
    }

    @Override
    protected Rectangle getBounds() {
        return this.polygon.getBounds();
    }

    @Override
    protected boolean isIn(Point point) {
        return this.polygon.contains(point);
    }

    @Override
    protected Color getComponentHeaderColor() {
        return this.headColor;
    }

    @Override
    protected String getComponentHeaderText() {
        return this.node.getName();
    }

    @Override
    protected GeneralPath getComponentHeaderShape() {
        return DrawUtils.getRoundedShape(this.createHeader(this.getPosition()));
    }

    @Override
    protected GeneralPath getComponentShape() {
        return this.generalPath;
    }

    @Override
    protected Node getNode() {
        return this.node;
    }

    private Polygon createHeader(Point position) {
        Polygon head = new Polygon();
        head.addPoint(position.x, position.y + this.headHeight / 2);
        head.addPoint(position.x, position.y + this.headHeight);
        head.addPoint(position.x + this.dimension.width, position.y + this.headHeight);
        head.addPoint(position.x + this.dimension.width, position.y);
        return head;
    }

    private void calculatePositions() {
        this.polygon = new Polygon();
        Point position = this.getPosition();
        this.polygon.addPoint(position.x, position.y + this.headHeight / 2);
        this.polygon.addPoint(position.x, position.y + this.dimension.height);
        this.polygon.addPoint(position.x + this.dimension.width, position.y + this.dimension.height + this.headHeight - this.headHeight / 2);
        this.polygon.addPoint(position.x + this.dimension.width, position.y);
        DrawUtils.setupRoundedGeneralPath(this.polygon, this.getComponentShape());
    }

    @Override
    protected void setPortPositions() {
        super.setPortPositions();
        ControlPort controlInPort = this.node.getControlInPort();
        if (controlInPort != null) {
            Point off = new Point(0, this.headHeight / 2);
            NodeController.getGUI((Port)controlInPort).setOffset(off);
        }
    }
}

