/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.xbaya.ui.graph.system;

import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Shape;
import java.awt.geom.Ellipse2D;
import org.apache.airavata.workflow.model.graph.Node;
import org.apache.airavata.workflow.model.graph.system.ExitNode;
import org.apache.airavata.xbaya.ui.graph.NodeGUI;
import org.apache.airavata.xbaya.ui.graph.Paintable;

public class ExitNodeGUI
extends NodeGUI {
    public static final Color c_LIGHTER = new Color(255, 255, 255);
    public static final Color c_DARKER = new Color(251, 103, 87);

    public ExitNodeGUI(ExitNode node) {
        super((Node)node);
        node.setName(" Exit");
    }

    @Override
    protected void paint(Graphics2D g2) {
        Point position = this.node.getPosition();
        Graphics2D g = (Graphics2D)g2.create();
        GradientPaint gp = new GradientPaint(position.x, position.y, c_LIGHTER, position.x + this.dimension.height, position.y + this.dimension.height, c_DARKER);
        if (this.dragged) {
            g.setColor(DRAGGED_BODY_COLOR);
        } else {
            g.setColor(this.bodyColor);
        }
        Ellipse2D.Double bodyShape = new Ellipse2D.Double(position.x + 2, position.y, this.dimension.height, this.dimension.height);
        this.drawHeader(g, (Shape)bodyShape, this.node.getName(), c_DARKER, false);
        this.drawEdge(g, bodyShape.getBounds2D(), EDGE_COLOR.brighter());
        this.drawEdge(g, bodyShape, EDGE_COLOR);
        this.drawPorts(g, this.node);
        for (Paintable paintable : this.paintables) {
            paintable.paint(g, this.node.getPosition());
        }
    }
}

