/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.xbaya.ui.graph.system;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.geom.GeneralPath;
import java.util.Iterator;
import java.util.List;
import org.apache.airavata.workflow.model.graph.ControlPort;
import org.apache.airavata.workflow.model.graph.Node;
import org.apache.airavata.workflow.model.graph.Port;
import org.apache.airavata.workflow.model.graph.impl.NodeImpl;
import org.apache.airavata.workflow.model.graph.system.EndifNode;
import org.apache.airavata.xbaya.graph.controller.NodeController;
import org.apache.airavata.xbaya.ui.XBayaGUI;
import org.apache.airavata.xbaya.ui.dialogs.graph.system.EndifConfigurationDialog;
import org.apache.airavata.xbaya.ui.graph.system.ConfigurableNodeGUI;
import org.apache.airavata.xbaya.ui.utils.DrawUtils;

public class EndifNodeGUI
extends ConfigurableNodeGUI {
    private EndifConfigurationDialog configurationWindow;
    private EndifNode node;
    private Polygon polygon;
    private GeneralPath generalPath;

    public EndifNodeGUI(EndifNode node) {
        super((NodeImpl)node);
        this.node = node;
        this.polygon = new Polygon();
        this.generalPath = new GeneralPath();
    }

    @Override
    protected void showConfigurationDialog(XBayaGUI xbayaGUI) {
        if (this.configurationWindow == null) {
            this.configurationWindow = new EndifConfigurationDialog(this.node, xbayaGUI);
        }
        this.configurationWindow.show();
    }

    @Override
    protected void calculatePositions(Graphics g) {
        super.calculatePositions(g);
        this.calculatePositions();
        this.setPortPositions();
    }

    @Override
    protected Rectangle getBounds() {
        return this.polygon.getBounds();
    }

    @Override
    protected boolean isIn(Point point) {
        return this.polygon.contains(point);
    }

    @Override
    protected Color getComponentHeaderColor() {
        return this.headColor;
    }

    @Override
    protected String getComponentHeaderText() {
        return this.node.getName();
    }

    @Override
    protected GeneralPath getComponentHeaderShape() {
        return DrawUtils.getRoundedShape(this.createHeader(this.getPosition()));
    }

    @Override
    protected GeneralPath getComponentShape() {
        return this.generalPath;
    }

    @Override
    protected Node getNode() {
        return this.node;
    }

    private Polygon createHeader(Point position) {
        Polygon head = new Polygon();
        head.addPoint(position.x, position.y);
        head.addPoint(position.x, position.y + this.headHeight);
        head.addPoint(position.x + this.dimension.width, position.y + this.headHeight);
        head.addPoint(position.x + this.dimension.width, position.y + this.headHeight / 2);
        return head;
    }

    @Override
    protected void setPortPositions() {
        block3: {
            Iterator i$;
            List inputPorts = this.node.getInputPorts();
            for (int i = 0; i < inputPorts.size(); ++i) {
                Port port = (Port)inputPorts.get(i);
                Point offset = i < inputPorts.size() / 2 ? new Point(5, this.headHeight + 10 + 13 * i) : new Point(5, this.headHeight + 10 + 13 * (i + 1));
                NodeController.getGUI(port).setOffset(offset);
            }
            List outputPorts = this.node.getOutputPorts();
            for (int i = 0; i < outputPorts.size(); ++i) {
                Port port = (Port)outputPorts.get(i);
                Point offset = new Point(this.getBounds().width - 5, (int)((double)(this.headHeight + 10) + 13.0 * ((double)outputPorts.size() / 2.0 + (double)i)));
                NodeController.getGUI(port).setOffset(offset);
            }
            ControlPort controlInPort = this.node.getControlInPort();
            if (controlInPort != null) {
                NodeController.getGUI((Port)controlInPort).setOffset(new Point(0, 0));
            }
            if (!(i$ = this.node.getControlOutPorts().iterator()).hasNext()) break block3;
            Port controlOutPort = (Port)i$.next();
            NodeController.getGUI(controlOutPort).setOffset(new Point(this.getBounds().width, this.getBounds().height - this.headHeight / 2));
        }
    }

    private void calculatePositions() {
        this.polygon.reset();
        Point position = this.getPosition();
        this.polygon.addPoint(position.x, position.y);
        this.polygon.addPoint(position.x, position.y + this.dimension.height + this.headHeight / 2);
        this.polygon.addPoint(position.x + this.dimension.width, position.y + this.dimension.height);
        this.polygon.addPoint(position.x + this.dimension.width, position.y + this.headHeight / 2);
        DrawUtils.setupRoundedGeneralPath(this.polygon, this.getComponentShape());
    }
}

