/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.xbaya.ui.graph.system;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.geom.GeneralPath;
import java.util.Iterator;
import org.apache.airavata.workflow.model.graph.Node;
import org.apache.airavata.workflow.model.graph.Port;
import org.apache.airavata.workflow.model.graph.impl.NodeImpl;
import org.apache.airavata.workflow.model.graph.system.EndForEachNode;
import org.apache.airavata.xbaya.graph.controller.NodeController;
import org.apache.airavata.xbaya.ui.XBayaGUI;
import org.apache.airavata.xbaya.ui.dialogs.graph.system.EndForEachConfigurationDialog;
import org.apache.airavata.xbaya.ui.graph.system.ConfigurableNodeGUI;
import org.apache.airavata.xbaya.ui.utils.DrawUtils;

public class EndForEachNodeGUI
extends ConfigurableNodeGUI {
    private EndForEachNode node;
    private Polygon polygon;
    private EndForEachConfigurationDialog configurationWindow;
    private GeneralPath generalPath;

    @Override
    protected void showConfigurationDialog(XBayaGUI xbayaGUI) {
        if (this.configurationWindow == null) {
            this.configurationWindow = new EndForEachConfigurationDialog(this.node, xbayaGUI);
        }
        this.configurationWindow.show();
    }

    public EndForEachNodeGUI(EndForEachNode node) {
        super((NodeImpl)node);
        this.node = node;
        this.polygon = new Polygon();
        this.generalPath = new GeneralPath();
    }

    @Override
    protected void calculatePositions(Graphics g) {
        super.calculatePositions(g);
        this.calculatePositions();
        this.setPortPositions();
    }

    @Override
    protected Rectangle getBounds() {
        return this.polygon.getBounds();
    }

    @Override
    protected boolean isIn(Point point) {
        return this.polygon.contains(point);
    }

    protected Color getCompnentHeaderColor() {
        return this.headColor;
    }

    @Override
    protected String getComponentHeaderText() {
        return this.node.getName();
    }

    @Override
    protected GeneralPath getComponentHeaderShape() {
        return DrawUtils.getRoundedShape(this.createHeader(this.getPosition()));
    }

    @Override
    protected GeneralPath getComponentShape() {
        return this.generalPath;
    }

    @Override
    protected Node getNode() {
        return this.node;
    }

    private Polygon createHeader(Point position) {
        Polygon head = new Polygon();
        head.addPoint(position.x, position.y);
        head.addPoint(position.x, position.y + this.headHeight);
        head.addPoint(position.x + this.dimension.width, position.y + this.headHeight);
        head.addPoint(position.x + this.dimension.width, position.y + this.headHeight / 2);
        return head;
    }

    private void calculatePositions() {
        this.polygon = new Polygon();
        Point position = this.getPosition();
        this.polygon.addPoint(position.x, position.y);
        this.polygon.addPoint(position.x, position.y + this.dimension.height + this.headHeight / 2);
        this.polygon.addPoint(position.x + this.dimension.width, position.y + this.dimension.height);
        this.polygon.addPoint(position.x + this.dimension.width, position.y + this.headHeight / 2);
        DrawUtils.setupRoundedGeneralPath(this.polygon, this.getComponentShape());
    }

    @Override
    protected void setPortPositions() {
        block0: {
            super.setPortPositions();
            Iterator i$ = this.node.getControlOutPorts().iterator();
            if (!i$.hasNext()) break block0;
            Port controlOutPort = (Port)i$.next();
            NodeController.getGUI(controlOutPort).setOffset(new Point(this.getBounds().width, this.getBounds().height - this.headHeight / 2));
        }
    }
}

